<?php

function gerar_senha($tamanho = 6, $maiusculas = true, $minusculas = true, $numeros = true, $simbolos = false)
    {
        $ma = "ABCDEFGHIJKLMNOPQRSTUVYXWZ"; // $ma contem as letras maiúsculas
        $mi = "abcdefghijklmnopqrstuvyxwz"; // $mi contem as letras minusculas
        $nu = "0123456789"; // $nu contem os números
        $si = "!@#$%¨&*()_+="; // $si contem os símbolos
        
        $senha = '';
        
        if ($maiusculas){
            // se $maiusculas for "true", a variável $ma é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($ma);
        }
        
        if ($minusculas){
            // se $minusculas for "true", a variável $mi é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($mi);
        }
        
        if ($numeros){
            // se $numeros for "true", a variável $nu é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($nu);
        }
        
        if ($simbolos){
            // se $simbolos for "true", a variável $si é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($si);
        }
        
        // retorna a senha embaralhada com "str_shuffle" com o tamanho definido pela variável $tamanho
        return substr(str_shuffle($senha),0,$tamanho);
    }

function ordenar_result($grupo, $campo, $order = 'asc')
{
    if(is_array($grupo))
        return order($grupo, $campo, $order);
    else
        return (object)order((array)$grupo, $campo, $order);
}

function order($grupo, $campo, $order = 'asc')
{
   usort($grupo, function ($a, $b) use ($campo, $order){
        if(is_array($a))
        {
            if($order == 'desc')
                return $a[$campo] < $b[$campo]; 
            else
                return $a[$campo] > $b[$campo]; 
        }
        else
        {
            if($order == 'desc')
                return $a->$campo < $b->$campo; 
            else
                return $a->$campo > $b->$campo; 
        }
            
    }); 
    return $grupo;
};


function float_of_string($val)
{
    $dec = explode(',',$val);
    $mil = str_replace('.', '', $dec[0]);
    return (isset($dec[1]))? floatval($mil.'.'.$dec[1]) : floatval($mil);
}

function string_of_float($val)
{
    $dec = explode(',',$val);
    
    if(sizeof($dec) > 1)
    {
        if(strpos($dec[0], '.'))
        {
            $dec[0] = str_replace('.', '', $dec[0]);
        }
        
        $dec[0] = intval($dec[0]);
        
        if($dec[0] < 1000)
        {
            $val = str_replace(',', '.', $val);
        }
        else 
        {
            $val = floatval($dec[0].'.'.$dec[1]);
        }
        
    }
    else 
    {
        $val = $dec[0];
    }
    
    return number_format($val, 2, ',', '.');
}

//CONVERTE DADA PARA O FORMATO 02 de maio de 2014
function formata_data_extenso($data)
{
	$mesExten = array(1 => 'janeiro', 2 => 'fevereiro', 3 => 'março', 4 => 'abril', 5 => 'maio', 6 => 'junho', 7 => 'julho', 8 => 'agosto', 9 => 'setembro', 10 => 'outubro', 11 => 'novembro', 12 => 'dezembro');

	$mes = (int)date("m", strtotime($data));
	$dia = (int)date("d", strtotime($data));
	$ano = (int)date("Y", strtotime($data));
		
	return $dia.' de '.$mesExten[$mes].' de '.$ano;
}

//CONVERTE DADA PARA O FORMATO VALIDO DO BANCO DE DADOS 0000-00-00
function converte_data($data, $tipo)
{
  if ((($tipo==1) || ($tipo==2)) && ($data!="") && ($tipo!=""))
  {
    if ($tipo==1)
	{
      $data=explode("/",$data);
      $data=$data[2]."-".$data[1]."-".$data[0];
      return $data;
	}
	else
	{
	  $data=explode("-",$data);
      $data=$data[2]."/".$data[1]."/".$data[0];
      return $data;
	}
  }
}
function converte_datahora($datahora, $tipo)
{
  if ((($tipo==1) || ($tipo==2)) && ($datahora!="") && ($tipo!=""))
  {
    if ($tipo==1)
	{
	  $datahora =  date( "Y-m-d H:i:s", strtotime($datahora));
      $datahorax=explode(" ",$datahora);
	  $data=explode("-",$datahorax[0]);
	  $hora=$datahorax[1];
      $datahora=$data[2]."/".$data[1]."/".$data[0]." - ".$hora;
      return $datahora;
	}
	else
	{
	    $datahorax=explode(" ",$datahora);
	    $data=explode("/",$datahorax[0]);
	    $hora=$datahorax[1];
	    $datahora=$data[2]."-".$data[1]."-".$data[0]." ".$hora;
	    return $datahora;
	}
  }
}

// CONVERTE DATA DO FORMATO DO BANCO PARA FORMATO VÁLIDO
function formata_data($data, $separador)
{
    $dt = explode(" ",$data);
    if(isset($dt[1]))
    {
        $data = $dt[0];
    }
    
    $data = explode("-",$data);
    $newData = $data[2].$separador.$data[1].$separador.$data[0];
    return $newData;
}


//FUNC�O QUE CONVERTE A DATA E HORARIO PARA FORMATO V�LIDO


function pv($valor,$taxa,$numeroParcela)
{
    return $valor/ pow( (1+porCem($taxa)), $numeroParcela)  ;
}

function porCem($val)
{
    return $val/100;
}

function vezesCem($val)
{
    return $val*100;
}

function porcento($val)
{
    return ($val/100).'%';
}

function percent($val)
{
    return (number_format($val, 2)).'%';
}

function porcentagem($valorTotal, $parte)
{
    return 100/$valorTotal*$parte;
}





/*function gera_bloco_anunciante($anunciante)
{
    $CI =& get_instance();
    $data['anunciante'] = $anunciante;
    return $CI->load->view('qiclub/blocos/bloco_anunciante', $data, true);
}

function gera_bloco_campanha($campanha)
{
    $CI =& get_instance();
    $data['campanha'] = $campanha;
    return $CI->load->view('qiclub/blocos/bloco_campanha', $data, true);
}

function gera_bloco_resgate($resgate)
{
    $CI =& get_instance();
    $data['resgate'] = $resgate;
    return $CI->load->view('qiclub/blocos/bloco_resgate', $data, true);
}

function get_curtidas()
{
    $CII =& get_instance();
    $CII->load->model('qiclub/anunciante_model');
    
    return $CII->anunciante_model->get_campanhas_curtidas(4);
}*/


function dia($data)
{
    return date('d', strtotime(date($data)));
}

function diaMes($data)
{
    return date('d/m', strtotime(date($data)));
}

function diaMesAno($data)
{
    if($data == "")
        return "";
    return date('d/m/Y', strtotime(date($data)));
}

function primeiroDiaSemana($data)
{
    $data = new DateTime(date('Y-m-d', strtotime($data)));
    $diaN = date( "w", strtotime($data->format('Y-m-d')));
    $data->modify('-' . $diaN . ' day');
    
    return $data->format('d/m');
    
}

function UltimoDiaSemana($data)
{
    $data = new DateTime(date('Y-m-d', strtotime($data)));
    $diaN = date( "w", strtotime($data->format('Y-m-d')));
    
    
    $data->modify('+' . (6-$diaN) . ' day');
    
    return $data->format('d/m');
    
}

function diaDaSemana($data)
{
    $dia = [
            0 => "Domingo",
            1 => "Segunda",
            2 => "Terça",
            3 => "Quarta",
            4 => "Quinta",
            5 => "Sexta",
            6 => "Sábado",
        ];
    
    return $dia[date('w', strtotime(date($data)))];
}

function diaSemana($data)
{
    $dia = [0=>'segunda',1=>'terca',2=>'quarta',3=>'quinta',4=>'sexta',5=>'sabado',6=>'domingo'];
    return $dia[date('w', strtotime(date($data)))];
}

function mes($data)
{
    return date('m', strtotime(date($data)));
}

function ano($data)
{
    return date('Y', strtotime(date($data)));
}

function hora($data)
{
    return date('H:i', strtotime(date($data)));
}

function dataHora($data)
{
    return date('d/m/Y - H:i', strtotime(date($data)));
}

function mesExtenso($data)
{
    $mesExten = array(1 => 'janeiro', 2 => 'fevereiro', 3 => 'março', 4 => 'abril', 5 => 'maio', 6 => 'junho', 7 => 'julho', 8 => 'agosto', 9 => 'setembro', 10 => 'outubro', 11 => 'novembro', 12 => 'dezembro');
    return $mesExten[(int)date('m', strtotime(date($data)))];
}

function money($vf)
{
    return 'R$ '.number_format(floatval($vf),2,",",".");
}

function moneySemPrefix($vf)
{
    return number_format(floatval($vf),2,",",".");
}

function decimal($vf)
{
    return number_format(floatval($vf),2,".","");
}


function idade($data_nascimento)
{
    // Separa em dia, mês e ano
    list($dia, $mes, $ano) = explode('/', $data_nascimento);
    // Descobre que dia é hoje e retorna a unix timestamp
    $hoje = mktime(0, 0, 0, date('m'), date('d')+1, date('Y'));
    // Descobre a unix timestamp da data de nascimento do fulano
    $diadonascimento = mktime( 0, 0, 0, $mes, $dia, $ano);
    // Depois apenas fazemos o cálculo já citado :)
    return floor((((($hoje - $diadonascimento) / 60) / 60) / 24) / 365.25);
}




function get_notificacoes()
{
    $CI =& get_instance();
    return Toolbar::notificacoes();
}

function get_mensagens()
{
    //return null;
    $CI =& get_instance();
    return Toolbar::contato();
}

function get_emulate_data()
{
    //return null;
    $CI =& get_instance();
    $CI->load->model('notificacoes/toolbar_model');
    return $CI->toolbar_model->get_dados_usuario();
}

function get_api_location($ip) 
{
    // $ip = '192.185.210.233'; // error ip - test
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "http://ip-api.com/php/" . $ip);
    curl_setopt($ch, CURLOPT_INTERFACE, '0.0.0.0');
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    $response = curl_exec($ch);
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header = substr($response, 0, $header_size);
    $body = substr($response, $header_size);
    if ($response === FALSE) 
    {
        $error = array('status'=>'fail','message'=>'cUrl error (#%d): %s<br>\n', curl_errno($ch) , htmlspecialchars(curl_error($ch)));
        return $error;
    } 
    else
    {
        return unserialize($response);
    }
    curl_close($ch);
}
    
function get_tag($tag,$xml)
{
	preg_match_all('/<'.$tag.'>(.*)<\/'.$tag.'>$/imU',$xml,$match);
	return $match[1];
}

function trata_url_str($str){
	return trim(preg_replace('/[^a-z0-9]+/', '-', strtolower(remove_acento($str))));
}


function insert_log($user,$table,$tb_id,$action_id,$section,$subsection,$field_name,$field_val)
{
 $CI =& get_instance();
 $dados = array('user_id' => $user,'table_name' => $table,'table_id'=>$tb_id,'action_id'=>$action_id,'sect_id'=>$section,'subs_id'=>$subsection);
 $CI->load->model('Log_model');
 $id_rel = $CI->Log_model->insert_user_action($dados);
 $dados = array('id_log'=>$id_rel,'field_name'=>$field_name,'field_value'=>$field_val);
 $CI->Log_model->insert_log_backup($dados);
}


/**
 * @param string $str
 * @param string $uf
 * @param string $municipio
 * @return NULL|Ambigous <NULL, multitype:number string >
 */
function trata_telefones_str($str, $uf = NULL, $municipio = NULL)
{	
	$CI =& get_instance();
	$str = str_replace('"', '', $str); // remove todas as aspas
	$str = explode(';', $str);

	foreach ($str as $key=>$celular)
	{
		(int) $telefone_misturado = ltrim(preg_replace("/[^0-9]/", "", trim($celular)), "0");
		
		if((int) $telefone_misturado == 0 || empty($telefone_misturado))
		{
			$retorno = NULL;
			return $retorno;		
		}	
		
		if(strlen($telefone_misturado) >= 10)
		{
			// Easy case scenario, DDD is included.

			$DDD = substr($telefone_misturado,0,2); 
			$DDD = "(".$DDD.")"; 
			$telefone_misturado = substr($telefone_misturado, 2);
			$pdigito = substr($telefone_misturado,0,1);
			$telefone_misturado = $DDD.$telefone_misturado;		
		}
		else
		{
			//Hard case scenario, DDD is missing.
			$CI->load->model('diretorio_estadual_model');
			if(isset($uf))
			{
				$id = $CI->diretorio_estadual_model->consulta_estado($uf)->id;
				$DDD = $CI->diretorio_estadual_model->consulta_ddd($id,1)->ddd;
				$DDD =  "(" . $DDD . ")";
			}
			elseif(isset($municipio))
			{
				$DDD =  "(" . $CI->diretorio_estadual_model->consulta_ddd($municipio,2)->ddd . ")";
			}
			$pdigito = substr($telefone_misturado,0,1);
			$telefone_misturado = $DDD.$telefone_misturado;
		}
			
		$result0 = strpos($telefone_misturado, '000000');

		if(($pdigito == 7 || $pdigito == 8 || $pdigito == 9) && $result0 === FALSE )
		{
			$retorno = array('tipo'=>1,'numero'=>$telefone_misturado);
			return $retorno;
		}
		else
		{
			$retorno = array('tipo'=>2,'numero'=>$telefone_misturado);
			return $retorno;
		}		
	}
}

function separa_celular_telefone($numero)
{
	$celulares = array();
	$telfixos = array();
	
	if(strpos($numero, '/'))
	{
		$numero = explode('/', $numero);
		$numero = $numero[0];		
	}
	if(strpos($numero, ';'))
	{
		$numero = explode(';', $numero);
		$numero = $numero[0];
	}
	
	$numero = ltrim(preg_replace("/[^0-9]/", "", trim($numero)), "0");
	
	if (strlen($numero) < 10)
	{
		return array('type'=>NULL,'numero'=>'');
	}	
	
	
	$result0 = strpos($numero, '000000');

	if($result0 !== FALSE || strlen($numero) < 8 || strlen($numero) > 11)
	{
		return array('type'=>NULL,'numero'=>''); // return empty
	}
	
	if(strlen($numero) >= 10)
	{
		$pdigito = substr($numero,2,1); // get first digito
		
		return return_tratado_telefone_celular(return_type_telefone_celular($pdigito),$numero,$result0);
	}
	else 
	{
		$pdigito = substr($numero,0,1); // get first digito
		
		// tratar ddd
		
		return return_tratado_telefone_celular(return_type_telefone_celular($pdigito),$numero,$result0);
	}
}

function return_type_telefone_celular($digito)
{	
	if($digito == 7 || $digito == 8 || $digito == 9)
	{
		return 1;
	}
	else 
	{
		return 2;
	}
}

function return_tratado_telefone_celular($type,$numero,$result0)
{		
	return array('type'=>$type,'numero'=>$numero); // return celular
}


function number_format_drop_zero_decimals($n, $n_decimals)
{
    return ((floor($n) == round($n, $n_decimals)) ? number_format($n) : number_format($n, $n_decimals));
}

function remove_acento($string){

	$array1 = array(   "á", "à", "â", "ã", "ä", "é", "è", "ê", "ë", "í", "ì", "î", "ï", "ó", "ò", "ô", "õ", "ö", "ú", "ù", "û", "ü", "ç"
			, "Á", "À", "Â", "Ã", "Ä", "É", "È", "Ê", "Ë", "Í", "Ì", "Î", "Ï", "Ó", "Ò", "Ô", "Õ", "Ö", "Ú", "Ù", "Û", "Ü", "Ç", " " );
	$array2 = array(   "a", "a", "a", "a", "a", "e", "e", "e", "e", "i", "i", "i", "i", "o", "o", "o", "o", "o", "u", "u", "u", "u", "c"
			, "A", "A", "A", "A", "A", "E", "E", "E", "E", "I", "I", "I", "I", "O", "O", "O", "O", "O", "U", "U", "U", "U", "C", "-" );
	return str_replace( $array1, $array2, $string );

}


function convertAccentsAndSpecialToNormal($string, $espaco = "-") 
{
	$table = array(
			'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A', 'Å'=>'A', 'Ă'=>'A', 'Ā'=>'A', 'Ą'=>'A', 'Æ'=>'A', 'Ǽ'=>'A',
			'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a', 'å'=>'a', 'ă'=>'a', 'ā'=>'a', 'ą'=>'a', 'æ'=>'a', 'ǽ'=>'a',

			'Þ'=>'B', 'þ'=>'b', 'ß'=>'Ss',

			'Ç'=>'C', 'Č'=>'C', 'Ć'=>'C', 'Ĉ'=>'C', 'Ċ'=>'C',
			'ç'=>'c', 'č'=>'c', 'ć'=>'c', 'ĉ'=>'c', 'ċ'=>'c',

			'Đ'=>'Dj', 'Ď'=>'D', 'Đ'=>'D',
			'đ'=>'dj', 'ď'=>'d',

			'È'=>'E', 'É'=>'E', 'Ê'=>'E', 'Ë'=>'E', 'Ĕ'=>'E', 'Ē'=>'E', 'Ę'=>'E', 'Ė'=>'E',
			'è'=>'e', 'é'=>'e', 'ê'=>'e', 'ë'=>'e', 'ĕ'=>'e', 'ē'=>'e', 'ę'=>'e', 'ė'=>'e',

			'Ĝ'=>'G', 'Ğ'=>'G', 'Ġ'=>'G', 'Ģ'=>'G',
			'ĝ'=>'g', 'ğ'=>'g', 'ġ'=>'g', 'ģ'=>'g',

			'Ĥ'=>'H', 'Ħ'=>'H',
			'ĥ'=>'h', 'ħ'=>'h',

			'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ï'=>'I', 'İ'=>'I', 'Ĩ'=>'I', 'Ī'=>'I', 'Ĭ'=>'I', 'Į'=>'I',
			'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ï'=>'i', 'į'=>'i', 'ĩ'=>'i', 'ī'=>'i', 'ĭ'=>'i', 'ı'=>'i',

			'Ĵ'=>'J',
			'ĵ'=>'j',

			'Ķ'=>'K',
			'ķ'=>'k', 'ĸ'=>'k',

			'Ĺ'=>'L', 'Ļ'=>'L', 'Ľ'=>'L', 'Ŀ'=>'L', 'Ł'=>'L',
			'ĺ'=>'l', 'ļ'=>'l', 'ľ'=>'l', 'ŀ'=>'l', 'ł'=>'l',

			'Ñ'=>'N', 'Ń'=>'N', 'Ň'=>'N', 'Ņ'=>'N', 'Ŋ'=>'N',
			'ñ'=>'n', 'ń'=>'n', 'ň'=>'n', 'ņ'=>'n', 'ŋ'=>'n', 'ŉ'=>'n',

			'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ō'=>'O', 'Ŏ'=>'O', 'Ő'=>'O', 'Œ'=>'O',
			'ò'=>'o', 'ó'=>'o', 'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ø'=>'o', 'ō'=>'o', 'ŏ'=>'o', 'ő'=>'o', 'œ'=>'o', 'ð'=>'o',

			'Ŕ'=>'R', 'Ř'=>'R',
			'ŕ'=>'r', 'ř'=>'r', 'ŗ'=>'r',

			'Š'=>'S', 'Ŝ'=>'S', 'Ś'=>'S', 'Ş'=>'S',
			'š'=>'s', 'ŝ'=>'s', 'ś'=>'s', 'ş'=>'s',

			'Ŧ'=>'T', 'Ţ'=>'T', 'Ť'=>'T',
			'ŧ'=>'t', 'ţ'=>'t', 'ť'=>'t',

			'Ù'=>'U', 'Ú'=>'U', 'Û'=>'U', 'Ü'=>'U', 'Ũ'=>'U', 'Ū'=>'U', 'Ŭ'=>'U', 'Ů'=>'U', 'Ű'=>'U', 'Ų'=>'U',
			'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'ü'=>'u', 'ũ'=>'u', 'ū'=>'u', 'ŭ'=>'u', 'ů'=>'u', 'ű'=>'u', 'ų'=>'u',

			'Ŵ'=>'W', 'Ẁ'=>'W', 'Ẃ'=>'W', 'Ẅ'=>'W',
			'ŵ'=>'w', 'ẁ'=>'w', 'ẃ'=>'w', 'ẅ'=>'w',

			'Ý'=>'Y', 'Ÿ'=>'Y', 'Ŷ'=>'Y',
			'ý'=>'y', 'ÿ'=>'y', 'ŷ'=>'y',

			'Ž'=>'Z', 'Ź'=>'Z', 'Ż'=>'Z', 'Ž'=>'Z',
			'ž'=>'z', 'ź'=>'z', 'ż'=>'z', 'ž'=>'z',

			'“'=>'"', '”'=>'"', '‘'=>"'", '’'=>"'", '•'=>'-', '…'=>'...', '—'=>'-', '–'=>'-', '¿'=>'?', '¡'=>'!', '°'=>' degrees ',
			'¼'=>' 1/4 ', '½'=>' 1/2 ', '¾'=>' 3/4 ', '⅓'=>' 1/3 ', '⅔'=>' 2/3 ', '⅛'=>' 1/8 ', '⅜'=>' 3/8 ', '⅝'=>' 5/8 ', '⅞'=>' 7/8 ',
			'÷'=>' divided by ', '×'=>' times ', '±'=>' plus-minus ', '√'=>' square root ', '∞'=>' infinity ',
			'≈'=>' almost equal to ', '≠'=>' not equal to ', '≡'=>' identical to ', '≤'=>' less than or equal to ', '≥'=>' greater than or equal to ',
			'←'=>' left ', '→'=>' right ', '↑'=>' up ', '↓'=>' down ', '↔'=>' left and right ', '↕'=>' up and down ',
			'℅'=>' care of ', '℮' => ' estimated ',
			'Ω'=>' ohm ',
			'♀'=>' female ', '♂'=>' male ',
			'©'=>' Copyright ', '®'=>' Registered ', '™' =>' Trademark ','.' =>'',
	);

	$string = strtr($string, $table);
	// Currency symbols: £¤¥€  - we dont bother with them for now
	$string = preg_replace("/[^\x9\xA\xD\x20-\x7F]/u", "", $string);
    $replace = $espaco; 
    $trans = array(
				'/&\#\d+?;/i'       => '',
				'/&\S+?;/i'         => '',
				'/\.+/i'            => '',
				'/\s+/'             => $replace,
				'/\/+/'             => $replace,
				'/[^a-z0-9\-\._]/i' => '',
				'/'. $replace .'+/' => $replace,
				'/'. $replace .'$/' => $replace,
				'/^'. $replace .'/' => $replace,
				'/\.+$/'            => ''
		);

		$string = strip_tags($string);
		$string = preg_replace(array_keys($trans), array_values($trans), trim($string));
		$string = str_replace(" ",$espaco,trim($string));
	return $string;
}



function benchmark($function,$loop=3,$feedback=0)
{
	
	/* First parameter is the piece of code to be tested
	The second one is the number of times to run the code. The higher this value, higher the precision, though it'll take more time to run. 3 times for default.
	Set 0 for a basic feedback and 1 for a detailed one. Default: 0 */
	
	$CI =& get_instance();
	$counter = 1;
	$history = array();
	while($counter <= $loop)
	{
		$CI->benchmark->mark('start');
		$response =	Diretorio::$function();
		$CI->benchmark->mark('end');
	    $history[$counter] = $CI->benchmark->elapsed_time('start', 'end');
		$counter++;
	}
	
	if($feedback == 0)
	{
		$final = 0;
		foreach($history as $time)
		{
			$final = $final + $time;
		}
		return("approximately " . $final / $loop) . " Seconds";
	}
	else 
	{
		return(var_dump($history)) . var_dump($response);
		
	}	
}



if(base_url() == 'http://www.websiscred.com.br/')
{
    function connect_to_slave_database($db = NULL)
    {    
    	$CI =& get_instance();
    	
    	$id_instituicao = $CI->session->userdata('cod_instituicao');
    	
    	$CI->config->set_item('db_slave', 'viewb207_slave_'.$id_instituicao);
    	
    	if($db !== NULL) // só roda em tempo de execução vindo de uma chamada de model
    	{
            $db = $CI->load->database('slave',TRUE);
    	   
            /* ini_set('mysql.connect_timeout', 300);
            ini_set('default_socket_timeout', 300); */
            
            return $db;
    	   
    	}
    	else // vindo direto de uma controller ou outro arquivo que não model
    	{
    	    $CI->db = $CI->load->database('slave',TRUE);
    	    
    	    /* ini_set('mysql.connect_timeout', 300);
            ini_set('default_socket_timeout', 300); */
    	}
    } 
}
else 
{
    function connect_to_slave_database($db = NULL)
    {
        $CI =& get_instance();
    
        $id_instituicao = $CI->session->userdata('cod_instituicao');
    
        $CI->config->set_item('db_slave', 'slave_'.$id_instituicao);
    
        if($db !== NULL) // só roda em tempo de execução vindo de uma chamada de model
        {
            $db = $CI->load->database('slave',TRUE);
    
            ini_set('mysql.connect_timeout', 300);
            ini_set('default_socket_timeout', 300);
    
            return $db;
        }
        else // vindo direto de uma controller ou outro arquivo que não model
        {
            $CI->db = $CI->load->database('slave',TRUE);
             
            ini_set('mysql.connect_timeout', 300);
            ini_set('default_socket_timeout', 300);
        }
    } 
}


function close_slave_conection()
{
	$CI =& get_instance();
    $CI->db = $CI->load->database('master',TRUE);
    
    /* ini_set('mysql.connect_timeout', 300);
    ini_set('default_socket_timeout', 300); */
}



function convert_size($bytes)
{
    $unit=array('b','kb','mb','gb','tb','pb');
    return @round($bytes/pow(1024,($i=floor(log($bytes,1024)))),2).' '.$unit[$i];
}

/* 
 * mascara($val, $mask)
 * 
 * $cnpj = "11222333000199";
 * $cpf = "00100200300";
 * $cep = "08665110";
 * $data = "10102010";
 * 
 * echo mask($cnpj,'##.###.###/####-##');
 * echo mask($cpf,'###.###.###-##');
 * echo mask($cep,'#####-###');
 * echo mask($data,'##/##/####');
 * 
 *  */
function mascara($val, $mask)
{
    $maskared = '';
    $k = 0;
    for($i = 0; $i<=strlen($mask)-1; $i++)
    {
        if($mask[$i] == '#')
        {
            if(isset($val[$k]))
            $maskared .= $val[$k++];
        }
        else
        {
            if(isset($mask[$i]))
            $maskared .= $mask[$i];
        }
    }
    return $maskared;
}

function is_bot()
{
	/* This function will check whether the visitor is a search engine robot */
	
	$CI =& get_instance();  
	$CI->load->helper('excel_reader');
	$data1 = new Spreadsheet_Excel_Reader();
	$data1->setOutputEncoding("LATIN-1");
	$data1->read('assets/uploads/system/bot_name.xls');
		
	$sheet = 0;
	
	for ($i = 1; $i <= count($data1->sheets[$sheet]["cells"]); $i++)
	{
		$bot = $data1->val($data1,$i,1,$sheet);
		
		if(strpos($_SERVER['HTTP_USER_AGENT'],$bot) !== false)
		{
			return $bot.'-'.$i;	// Is a bot
		}
	}

	return false; 		// Not a bot
	
}

function generateRandomString($length = 10) {
    return substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length);
}

function remove_intervalo_datas($datas)
{
	
	if(count($datas) <= 2)
	{
		$str_data = '';
		foreach ($datas as $value)
		{
			$str_data .= converte_data($value->data_evento, 2).'; ';
		}
		return $str_data;
	}
	
	$data_ini = $datas[0]->data_evento;
	$data_fim = $datas[count($datas)-1]->data_evento;
	
	$intervalo = calcula_qtd_dias_entre_datas($data_ini,$data_fim);
	
	if($intervalo == count($datas)-1)
	{
		$str = converte_data($data_ini,2).' à '.converte_data($data_fim,2).';';
		return $str;
	}
	
	$controle = $data_ini;
	$dt_ini_iteracao = $data_ini;
	$str = '';
	for($i=1; $i < count($datas); $i++) {
		
		$intervalo = 0;
		$intervalo = calcula_qtd_dias_entre_datas($controle,$datas[$i]->data_evento);

		if($intervalo == 1 && $i < count($datas)-1)
		{
			$controle = $datas[$i]->data_evento;
		}
		elseif ($intervalo > 1){
			if(calcula_qtd_dias_entre_datas($dt_ini_iteracao,$controle) == 0){
				$str .= converte_data($dt_ini_iteracao,2).'; ';
			}
			else{
				$str .= converte_data($dt_ini_iteracao,2).' à '.converte_data($controle,2).'; ';
			}
			$controle = $datas[$i]->data_evento;
			$dt_ini_iteracao = $datas[$i]->data_evento;
		}
		elseif ($i == count($datas)-1)
		{			
			$controle = $datas[$i]->data_evento;
			$str .= converte_data($dt_ini_iteracao,2).' à '.converte_data($controle,2).'; ';
			$dt_ini_iteracao = $datas[$i]->data_evento;
		}
		else
		{
			$str .= converte_data($dt_ini_iteracao,2).' à '.converte_data($controle,2).'; ';			
			$controle = $datas[$i]->data_evento;
			$dt_ini_iteracao = $datas[$i]->data_evento;
		}
	}
	return $str;

}

function calcula_qtd_dias_entre_datas($dt_ini,$dt_fim)
{	
	// Usa a função criada e pega o timestamp das duas datas:
	$time_inicial = strtotime($dt_ini);
	$time_final = strtotime($dt_fim);
	
	// Calcula a diferença de segundos entre as duas datas:
	$diferenca = $time_final - $time_inicial; // 19522800 segundos
	
	// Calcula a diferença de dias
	$dias = floor( $diferenca / (60 * 60 * 24));
	
	return $dias;
}


function retiraAcento($frase){
  $frase = preg_replace("[^a-zA-Z0-9_]", "", strtr($frase, "�������������������������� ", "aaaaeeiooouucAAAAEEIOOOUUC_"));
  return $frase; 
}

function validaExtensao($extensao){
  if($extensao == "pdf" || $extensao == "zip" || $extensao == "rar" || $extensao == "doc" || $extensao == "docx" || $extensao == "odt" || $extensao == "wmv" || $extensao == "WMA" || $extensao == "MPEG" || $extensao == "MPG" || $extensao == "AVI"){
  	return true;  
  }
  else{
	print "<script> alert('N�o � poss�vel fazer upload de arquivos com essa extens�o');  window.history.go(-1);  </script> ";
	die;
  }
}

function valida_cpf($cpf){
    /**
     * isCpfValid
     *
     * Esta função testa se um cpf é valido ou não.
     *
     * @author	Raoni Botelho Sporteman <raonibs@gmail.com>
     * @version	1.0 Debugada em 26/09/2011 no PHP 5.3.8
     * @param	string		$cpf			Guarda o cpf como ele foi digitado pelo cliente
     * @param	array		$num			Guarda apenas os números do cpf
     * @param	boolean		$isCpfValid		Guarda o retorno da função
     * @param	int			$multiplica 	Auxilia no Calculo dos Dígitos verificadores
     * @param	int			$soma			Auxilia no Calculo dos Dígitos verificadores
     * @param	int			$resto			Auxilia no Calculo dos Dígitos verificadores
     * @param	int			$dg				Dígito verificador
     * @return	boolean						"true" se o cpf é válido ou "false" caso o contrário
     *
     */
    //Etapa 1: Cria um array com apenas os digitos numéricos, isso permite receber o cpf em diferentes formatos como "000.000.000-00", "00000000000", "000 000 000 00" etc...
    $cpf = str_pad(preg_replace('/[^0-9]/', '', $cpf), 11, '0', STR_PAD_LEFT);
    $j=0;
    $num = array();
    for($i=0; $i<(strlen($cpf)); $i++)
    {
        if(is_numeric($cpf[$i]))
        {
            $num[$j]=$cpf[$i];
            $j++;
        }
    }
    //Etapa 2: Conta os dígitos, um cpf válido possui 11 dígitos numéricos.
    if(count($num)!=11)
    {
        $isCpfValid=false;
    }
    //Etapa 3: Combinações como 00000000000 e 22222222222 embora não sejam cpfs reais resultariam em cpfs válidos após o calculo dos dígitos verificares e por isso precisam ser filtradas nesta parte.
    else
    {
        for($i=0; $i<10; $i++)
        {
            if ($num[0]==$i && $num[1]==$i && $num[2]==$i && $num[3]==$i && $num[4]==$i && $num[5]==$i && $num[6]==$i && $num[7]==$i && $num[8]==$i)
            {
                $isCpfValid=false;
                break;
            }
        }
    }
    //Etapa 4: Calcula e compara o primeiro dígito verificador.
    if(!isset($isCpfValid))
    {
        $j=10;
        for($i=0; $i<9; $i++)
        {
            $multiplica[$i]=$num[$i]*$j;
            $j--;
        }
        $soma = array_sum($multiplica);
        $resto = $soma%11;
        
        if($resto<2)
        {
            $dg=0;
        }
        else
        {
            $dg=11-$resto;
        }
        if($dg!=$num[9])
        {
            $isCpfValid=false;
        }
    }
    //Etapa 5: Calcula e compara o segundo dígito verificador.
    if(!isset($isCpfValid))
    {
        $j=11;
        for($i=0; $i<10; $i++)
        {
            $multiplica[$i]=$num[$i]*$j;
            $j--;
        }
        $soma = array_sum($multiplica);
        $resto = $soma%11;
        if($resto<2)
        {
            $dg=0;
        }
        else
        {
            $dg=11-$resto;
        }
        if($dg!=$num[10])
        {
            $isCpfValid=false;
        }
        else
        {
            $isCpfValid=true;
        }
    }
    //Trecho usado para depurar erros.
    /*
    if($isCpfValid==true)
        {
        echo "<font color=\"GREEN\">Cpf é Válido</font>";
        }
        if($isCpfValid==false)
        {
        $CI =& get_instance();
        $CI->form_validation->set_message('valida_cpf', 'O cpf '.$cpf.' não é válido.');
        return FALSE;
        }
    */
    //Etapa 6: Retorna o Resultado em um valor booleano.
    return $isCpfValid;

}


/**
 * Valida CNPJ
*
* @author Luiz Otávio Miranda <contato@tutsup.com>
* @param string $cnpj
* @return bool true para CNPJ correto
*
*/
function valida_cnpj ( $cnpj ) {
	// Deixa o CNPJ com apenas números
	$cnpj = preg_replace( '/[^0-9]/', '', $cnpj );

	if((int)$cnpj == 0) return FALSE;
	
	// Garante que o CNPJ é uma string
	$cnpj = (string)$cnpj;

	// O valor original
	$cnpj_original = $cnpj;

	// Captura os primeiros 12 números do CNPJ
	$primeiros_numeros_cnpj = substr( $cnpj, 0, 12 );

	/**
	 * Multiplicação do CNPJ
	 *
	 * @param string $cnpj Os digitos do CNPJ
	 * @param int $posicoes A posição que vai iniciar a regressão
	 * @return int O
	 *
	*/
	function multiplica_cnpj( $cnpj, $posicao = 5 ) {
		// Variável para o cálculo
		$calculo = 0;

		// Laço para percorrer os item do cnpj
		for ( $i = 0; $i < strlen( $cnpj ); $i++ ) {
			// Cálculo mais posição do CNPJ * a posição
			$calculo = $calculo + ( $cnpj[$i] * $posicao );
				
			// Decrementa a posição a cada volta do laço
			$posicao--;
				
			// Se a posição for menor que 2, ela se torna 9
			if ( $posicao < 2 ) {
				$posicao = 9;
			}
		}
		// Retorna o cálculo
		return $calculo;
	}

	// Faz o primeiro cálculo
	$primeiro_calculo = multiplica_cnpj( $primeiros_numeros_cnpj );

	// Se o resto da divisão entre o primeiro cálculo e 11 for menor que 2, o primeiro
	// Dígito é zero (0), caso contrário é 11 - o resto da divisão entre o cálculo e 11
	$primeiro_digito = ( $primeiro_calculo % 11 ) < 2 ? 0 :  11 - ( $primeiro_calculo % 11 );

	// Concatena o primeiro dígito nos 12 primeiros números do CNPJ
	// Agora temos 13 números aqui
	$primeiros_numeros_cnpj .= $primeiro_digito;

	// O segundo cálculo é a mesma coisa do primeiro, porém, começa na posição 6
	$segundo_calculo = multiplica_cnpj( $primeiros_numeros_cnpj, 6 );
	$segundo_digito = ( $segundo_calculo % 11 ) < 2 ? 0 :  11 - ( $segundo_calculo % 11 );

	// Concatena o segundo dígito ao CNPJ
	$cnpj = $primeiros_numeros_cnpj . $segundo_digito;

	// Verifica se o CNPJ gerado é idêntico ao enviado
	if ( $cnpj === $cnpj_original ) {
		return true;
	}
	else 
	{
		return FALSE;
	}
}

function validaEmail($email) 
{
    $array_invalidos = array(
        '@mailinator.com',
        '@harakirimail.com',
        '@test',
        );
    $syntaxe = '#^[\w.-]+@[\w.-]+\.[a-zA-Z]{2,6}$#';
    if (preg_match($syntaxe, $email))
    {
        foreach($array_invalidos as $invalido)
        {
            $result = strrpos($email, $invalido); //Resultado: 8
            if($result != null)
            {
               return false;
            }
        }
                
          return true;
    }
    else 
    {
        return false;
    }
}

//FUN��O PARA PEGAR IP
function ip()
{
   if (isset($_SERVER['REMOTE_ADDR'])) {
       return $_SERVER['REMOTE_ADDR'];
   } else if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
       return $_SERVER['HTTP_X_FORWARDED_FOR'];
   } else if(isset($_SERVER['HTTP_X_FORWARDED'])) {
       return $_SERVER['HTTP_X_FORWARDED'];
   } else if(isset($_SERVER['HTTP_FORWARDED_FOR'])) {
       return $_SERVER['HTTP_FORWARDED_FOR'];
   } else if(isset($_SERVER['HTTP_FORWARDED'])) {
       return $_SERVER['HTTP_FORWARDED'];
   } else if(isset($_SERVER['HTTP_X_COMING_FROM'])) {
       return $_SERVER['HTTP_X_COMING_FROM'];
   } else if(isset($_SERVER['HTTP_COMING_FROM'])) {
       return $_SERVER['HTTP_COMING_FROM'];
   } else if(isset($_SERVER['HTTP_CLIENT_IP'])) {
       return $_SERVER['HTTP_CLIENT_IP'];
   }
}




//VERIFICA A VELOCIDADE DE AUTUA��O
function velocidade_infracao($site)
{
  //SITES DE 40KM
  if (($site==501) || ($site==502) || ($site==505) || ($site==506) || ($site==520) || ($site==521) || ($site==527) || ($site==528) || ($site==535) || ($site==536))
    return 47;
  else
  //SITES DE 50KM
    return 57;
}

//FUN��O PARA LIMPAR UM DIRET�RIO
function limpa_diretorio($dir){
    if(is_dir($dir)) // verifica se realmente � uma pasta
    {
        if($handle = opendir($dir))
        {
            while(false !== ($file = readdir($handle))) // varre cada um dos arquivos da pasta
            {
                if(($file == ".") or ($file == ".."))
                {
                    continue;
                }
                if(is_dir($dir.$file)) // verifica se o arquivo atual � uma pasta
                {
                    // caso seja uma pasta, faz a chamada para a funcao novamente
                    apagar($dir.$file);
                } else
                {
                    // caso seja um arquivo, exclui ele
                    unlink($dir.$file);
                }
            }
        } else
        {
            print("nao foi possivel abrir o arquivo.");
            return false;
        }
        
        // fecha a pasta aberta
        closedir($handle);
    }
}

//FUN��O PARA PINGAR EM UM DETERMINADO IP DE ENTRADA
//RETORNA 1 PARA PING BEM SUCEDIDO
function ping($host)
{
   $aArquivo = popen("ping $host", "r");
   		for($c==0;$c < 10; $c++)
		{
			$aLinha   = fgets($aArquivo,1024);
			if ($c==9)
			{
			  $pc="Received = ";
			  $pos_received=strpos($aLinha,$pc);
		      $rec=(int)substr($aLinha,($pos_received+strlen($pc)),1);
			}
		}
		
		if ($rec>0)
		  return 1;
		else
		  return 0;
} 

//FUNCAO PARA COMPARAR DATA NO VERIFICADOR DOS SITES
function compara_hora($datahora, $tempo_atualizacao)
{
  if ($tempo_atualizacao>=60)
  {
    $thora=floor($tempo_atualizacao/60);
	$tmin=floor($tempo_atualizacao%60);
  }
  else
  {
    $thora=0;
	$tmin=$tempo_atualizacao;
  }
  
  $dataverif=strftime("%Y-%m-%d %H:%M:%S", strtotime("-{$thora} hours -{$tmin} minutes")); 
  
  //margem de erro
  if ((strtotime($dataverif))<(strtotime($datahora)))
    return 1;
  else
    return 0;
}

function validateDate($date)
{
	$d = DateTime::createFromFormat('d/m/Y', $date);
	return $d && $d->format('d/m/Y') == $date;
}

function nono_digito($celular)
{

	$nono_digito = array(11,12, 13, 14, 15, 16, 17, 18,19,21,22,24,27,28,91,93,94,92,97,95,96,98,99);
		
	$ddd = substr($celular, 0,2);
	if(in_array($ddd, $nono_digito))
	{
		if(strlen($celular) < 11 )
		{
			$numero = substr($celular,2);
			$numero = 9 . $numero;
			$numero = $ddd . $numero;

			return $numero;


		}
		else 
		{
			return $celular;
		}
	}
	else 
	{
		return $celular;
	}
	


}

function mascara_telefone($val)
{
	$mask = '(##)####-####';

	$maskared = '';
	$k = 0;
	for($i = 0; $i<=strlen($mask)-1; $i++)
	{
		if($mask[$i] == '#')
		{
			if(isset($val[$k]))
			{
			$maskared .= $val[$k++];
			}
		}
		else
		{
			if(isset($mask[$i]))
			{
				$maskared .= $mask[$i];
			}
		}
	}
		return $maskared;
}

function mascara_cep($val)
{
	$val = preg_replace("/[^0-9]/", "", trim($val));
	
	if (strlen($val) < 8 || strlen($val) > 8)
	{
		return '';
	}
	
	$mask = '#####-###';

	$maskared = '';
	$k = 0;
	for($i = 0; $i<=strlen($mask)-1; $i++)
	{
		if($mask[$i] == '#')
		{
			if(isset($val[$k]))
			{
				$maskared .= $val[$k++];
			}
		}
		else
		{
			if(isset($mask[$i]))
			{
				$maskared .= $mask[$i];
			}
		}
	}
	return $maskared;
}	

function formatBytes($bytes, $precision = 2) 
{ 
    $kilobyte = 1024;
    $megabyte = $kilobyte * 1024;
    $gigabyte = $megabyte * 1024;
    $terabyte = $gigabyte * 1024;
   
    if (($bytes >= 0) && ($bytes < $kilobyte)) {
        return $bytes . ' B';
 
    } elseif (($bytes >= $kilobyte) && ($bytes < $megabyte)) {
        return round($bytes / $kilobyte, $precision) . ' KB';
 
    } elseif (($bytes >= $megabyte) && ($bytes < $gigabyte)) {
        return round($bytes / $megabyte, $precision) . ' MB';
 
    } elseif (($bytes >= $gigabyte) && ($bytes < $terabyte)) {
        return round($bytes / $gigabyte, $precision) . ' GB';
 
    } elseif ($bytes >= $terabyte) {
        return round($bytes / $terabyte, $precision) . ' TB';
    } else {
        return $bytes . ' B';
    }
} 

function primeiroNome($nome){
    
    $primeiroNome = explode(" ", $nome);
    
    return current($primeiroNome);
}

function generate_uuid(){
    return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        // 32 bits for "time_low"
        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),

        // 16 bits for "time_mid"
        mt_rand( 0, 0xffff ),

        // 16 bits for "time_hi_and_version",
        // four most significant bits holds version number 4
        mt_rand( 0, 0x0fff ) | 0x4000,

        // 16 bits, 8 bits for "clk_seq_hi_res",
        // 8 bits for "clk_seq_low",
        // two most significant bits holds zero and one for variant DCE1.1
        mt_rand( 0, 0x3fff ) | 0x8000,

        // 48 bits for "node"
        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
    );
}

?>