<?php if (! defined ( 'BASEPATH' ))	exit ( 'No direct script access allowed' );

require_once BASEPATH . 'libraries/Session/Session.php';

class CI_MY_Session extends CI_Session {
    
    private $CI;

    function __construct()
    {        
        parent::__construct();
        
        $this->CI =& get_instance();
        
        $this->CI->session = $this;
        
        $timestamp = mktime(date("H"), date("i"), date("s"), date("m"), date("d"), date("Y"));
        
        $this->CI->load->helper('date');
        
        $this->set_userdata('timestamp',$timestamp);
		
		$this->sess_gc();
    }
    
    /**
     * sess_update()
     *
     * Do not update an existing session on ajax or xajax calls
     *
     * @access    public
     * @return    void
     */
    public function sess_update()
    {
    	if ( ! $this->$CI->input->is_ajax_request())
        {
            parent::sess_update();
        }
    }
	
	/**
     * Garbage collection
     *
     * This deletes expired session rows from database
     * if the probability percentage is met
     *
     * @access  public
     * @return  void
     */
    private function sess_gc()
    {
        if ($this->CI->config->item('sess_driver') !== 'database')
        {
            return;
        }
    
        $gc_probability = 5; // probability of enter in clean function
    
        srand(time());
        
        if ((rand() % 100) <= $gc_probability)
        {
            $expire = time() - $this->CI->config->item('sess_expiration');
            
    
            $this->CI->db->where("timestamp < {$expire}");
            $this->CI->db->delete($this->CI->config->item('sess_save_path'));
    
            log_message('debug', 'Session garbage collection performed.');
        }
    }
    
    /*private function update_users_online() {
    	$this->CI->load->library('user_online');
	    $users_online = $this->CI->user_online->gera_usuarios_online();
    }*/

}

// ------------------------------------------------------------------------
/* End of file MY_Session.php */
/* Location: ./application/libraries/MY_Session.php */