<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

//declare(strict_types=1);
//require __DIR__.'/../../../../application/libraries/vendor/autoload.php';
include_once APPPATH.'/libraries/vendor/sonata-project/google-authenticator/src/FixedBitNotation.php';
include_once APPPATH.'/libraries/vendor/sonata-project/google-authenticator/src/GoogleAuthenticatorInterface.php';
include_once APPPATH.'/libraries/vendor/sonata-project/google-authenticator/src/GoogleAuthenticator.php';
include_once APPPATH.'/libraries/vendor/sonata-project/google-authenticator/src/GoogleQrUrl.php';

class Autenticacao extends Admin_Controller
{
    
    public function index(){
        
        if($this->session->dois_fatores == TRUE){
            redirect('/painel');
        }
        
        if($this->session->secret_google != ''){
            
            $data['secret'] =  $this->session->secret_google;
            defined('TITLE_MODULE') OR define('TITLE_MODULE', 'Autenticação de Dois Fatores');
            defined('TITLE_SECTION') OR define('TITLE_SECTION', 'Confirme Seu codigo');
            Template::unset('sidebar');
            Assets::add_module_js('auth', ['google_auth']);
            Template::set($data);
            Template::set_view('dois_fatores_view');
            Template::render();
            
        }else{
            redirect('/auth/autenticacao/primeira_autenticacao');
        }
    }
    
    public function primeira_autenticacao(){
        
        if($this->session->secret_google == ''){
            
            $g = new \Google\Authenticator\GoogleAuthenticator();
            $secret =  $g->generateSecret();
            $name = $this->session->username == '' ? $this->remove_espaço($this->session->nome) : $this->session->username;
            defined('TITLE_MODULE') OR define('TITLE_MODULE', 'Autenticação de Dois Fatores');
            defined('TITLE_SECTION') OR define('TITLE_SECTION', 'Primeira Autenticação');
            
            $data['secret'] =  $secret;
            $data['url'] = '<img src="'.$g->getURL($name, 'comdono.com', $secret).'" />';
            

            Template::unset('sidebar');
            Assets::add_module_js('auth', ['google_auth']);
            Template::set($data);
            Template::set_view('autenticacao_view');
            Template::render();
            
        }else{
            
            redirect('/painel');
            
        }
    }
    
    public function remove_espaço($str){
        $nome = explode(" ",$str);
        $primeiro_nome = $nome[0];
        
        return $primeiro_nome;
    }
    
    public function save_key(){
        
        $secret = $_POST['secret_auth'];
        $code = $_POST['code_auth'];
        $user = $this->session->id_cadastro;
        
        if($user != NULL && $code != NULL){
            $g = new \Google\Authenticator\GoogleAuthenticator();
    
            if($g->checkCode($secret, $code)) {
                
                if($this->cad_model->updateUser($user, ['google_secret_key' => $secret])){
                    
                    $this->session->set_userdata('secret_google', $secret);
                    $this->session->set_userdata('dois_fatores', TRUE);
                    $msg = ['valid' => true];
                }else{
                    $msg = ['valid' => false, 'msg' => 'Falha de comunicação, Tente novamente mais tarde'];
                }    
                
            } else {
                $msg = ['valid' => false, 'msg' => 'Codigo incorreto, tente novamente', 'code' => '003'];
            }
        }else{
            $msg = ['valid' => false, 'msg' => 'O campo codigo é obrigatorio!'];
        }
        
        echo json_encode($msg);
    }
    
    public function verifica_key(){
        
        $secret = $_POST['secret_auth'];
        $code = $_POST['code_auth'];
        $user = $this->session->id_cadastro;
        
        if($user != NULL && $code != NULL){
            $g = new \Google\Authenticator\GoogleAuthenticator();
            
            if ($g->checkCode($secret, $code)) {
                
                $this->session->set_userdata('dois_fatores', TRUE);
                $msg = ['valid' => true, 'redirect' => $this->session->uri_destino??'dashboard'];
                $this->session->unset_userdata('uri_destino');
                
            } else {
                
                /*if($this->session->perfil == 1){
                    $code = $g->getCode($secret);
                    $msg = ['valid' => false, 'msg' => 'Codigo incorreto, tente novamente Codigo correto é: '.$code];
                }*/
                    $msg = ['valid' => false, 'msg' => 'Codigo incorreto, tente novamente'];
            }
        }else{
            $msg = ['valid' => false, 'msg' => 'O campo codigo é obrigatorio!'];
        }
        echo json_encode($msg);
        
    }

}