<?php
    Assets::add_css(array(
    		'plugins/bootstrap-4.2.1/css/bootstrap',
    ), 'external', true);
    
    Assets::add_module_css('grocery',array(
			//'themes/bootstrap/css/bootstrap/bootstrap.css',
			'themes/bootstrap/css/font-awesome/css/font-awesome.min.css',
			'themes/bootstrap/css/common.css',
			'themes/bootstrap/css/general.css',
			'themes/bootstrap/css/add-edit-form.css'
	));

    if ($this->config->environment == 'production') {
    	Assets::add_module_js('grocery',array(
			'themes/bootstrap/build/global-libs.min.js',
			'themes/bootstrap/js/form/edit.min.js'
    	));
    } else {
        Assets::add_module_js('grocery',array(
    		'themes/bootstrap/js/jquery-plugins/jquery.form.min.js',
    		'themes/bootstrap/js/common/common.min.js',
    		'themes/bootstrap/js/form/edit.js'
        ));
    }
    Assets::add_module_js('grocery','themes/bootstrap/js/form/th_abas.js');

include(__DIR__ . '/common_javascript_vars.php');
?>
<div class="crud-form mb-5" data-unique-hash="<?php echo $unique_hash; ?>">
    <div class="gc-container">
        <div class="row">
            <div class="col-md-12">
                <div class="table-label">
                    <div class="floatL l5">
                        <?php echo $this->l('form_edit'); ?> <?php echo $subject?>
                    </div>
                    <div class="floatR r5 minimize-maximize-container minimize-maximize">
                        <i class="fa fa-caret-up"></i>
                    </div>
                    <div class="floatR r5 gc-full-width">
                        <i class="fa fa-expand"></i>
                    </div>
                    <div class="clear"></div>
                </div>
                
                <div class="form-container table-container">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php echo form_open( $update_url, 'method="post" id="crudForm"  enctype="multipart/form-data" class="form-horizontal"'); ?>
                            	
                            <?php 
                            if (isset($fields_abas) && $fields_abas != NULL)
                            {	
                            	if ($theme_abas != NULL && $theme_abas == 'tabs') include(__DIR__."/th_tabs_edit.php"); else include(__DIR__."/th_panel_edit.php"); 

                            } else { foreach($fields as $field) { ?>
                                    
                            <div class="form-group <?php echo $field->field_name; ?>_form_group">
                                <label class="col-sm-3 control-label">
                                    <?php echo $input_fields[$field->field_name]->display_as; ?><?php echo ($input_fields[$field->field_name]->required) ? "<span class='required'>*</span> " : ""; ?>
                                </label>
                                <div class="col-sm-12">
                                    <?php echo $input_fields[$field->field_name]->input?>
                                </div>
                            </div>
                            
                            <?php }}?>
                            
                            
                            <?php if(!empty($hidden_fields)){?>
                                <!-- Start of hidden inputs -->
                                <?php
                                foreach($hidden_fields as $hidden_field){
                                    echo $hidden_field->input;
                                }
                                ?>
                                <!-- End of hidden inputs -->
                            <?php } ?>
                            <?php if ($is_ajax) { ?><input type="hidden" name="is_ajax" value="true" /><?php }?>
                            <div class="form-group box-result-form">
                                <div id='report-error' class='report-div error bg-danger' style="display:none"></div>
                                <div id='report-success' class='report-div success bg-success' style="display:none"></div>
                            </div>
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <button class="btn btn-default btn-success b10" type="submit" id="form-button-save">
                                        <i class="fa fa-check"></i>
                                        <?php echo $this->l('form_update_changes'); ?>
                                    </button>
                                    <?php 	if(!$this->unset_back_to_list) { ?>
                                        <button class="btn btn-info b10" type="button" id="save-and-go-back-button">
                                            <i class="fa fa-rotate-left"></i>
                                            <?php echo $this->l('form_update_and_go_back'); ?>
                                        </button>
                                        <button class="btn btn-default cancel-button b10" type="button" id="cancel-button">
                                            <i class="fa fa-warning"></i>
                                            <?php echo $this->l('form_cancel'); ?>
                                        </button>
                                    <?php } ?>
                                </div>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
	var validation_url = '<?php echo $validation_url?>';
	var list_url = '<?php echo $list_url?>';

	var message_alert_edit_form = "<?php echo $this->l('alert_edit_form')?>";
	var message_update_error = "<?php echo $this->l('update_error')?>";
</script>