<?php
    Assets::add_css(array(
    		'plugins/bootstrap-4.2.1/css/bootstrap',
    ), 'external', true);
    
    Assets::add_module_css('grocery',array(
    		//'themes/bootstrap/css/bootstrap/bootstrap.min.css',
    		'themes/bootstrap/css/common.css',
    		'themes/bootstrap/css/list.css',
    		'themes/bootstrap/css/general.css',
    		'themes/bootstrap/css/plugins/animate.min.css'
    ));

    if ($this->config->environment == 'production') {
        Assets::add_module_js('grocery',array(
            'themes/bootstrap/build/global-libs.min.js'
        ));
    } else {
        Assets::add_module_js('grocery',array(
    		'themes/bootstrap/js/jquery-plugins/jquery.form.js'.
    		'themes/bootstrap/js/common/cache-library.js',
    		'themes/bootstrap/js/common/common.js'
        ));
    }

    //section libs
    Assets::add_module_js('grocery',array(
    		'themes/bootstrap/js/jquery-plugins/gc-dropdown.min.js',
    		'themes/bootstrap/js/jquery-plugins/gc-modal.min.js',
    		'themes/bootstrap/js/jquery-plugins/bootstrap-growl.min.js',
    		'themes/bootstrap/js/jquery-plugins/jquery.print-this.js',
    		'themes/bootstrap/js/datagrid/gcrud.datagrid.js',
    		'themes/bootstrap/js/datagrid/list.js'
    ));
    
    /* ------------------------------------------------------------------------------------------------ */

    $colspans = (count($columns) + 2);

    //Start counting the buttons that we have:
    $buttons_counter = 0;

    if (!$unset_edit) {
        $buttons_counter++;
    }

    if (!$unset_read) {
        $buttons_counter++;
    }

    if (!$unset_delete) {
        $buttons_counter++;
    }

    if (!empty($list[0]) && !empty($list[0]->action_urls)) {
        $buttons_counter = $buttons_counter +  count($list[0]->action_urls);
    }

    //The search column string exists only in version 1.5.6 or higher
    $search_column_string =
        preg_match('/1\.(5\.[6-9]|[6-9]\.[0-9])/', Grocery_CRUD::VERSION)
            ? $this->l('list_search_column') : 'Pesquisar {column_name}';

    $hasAlerti18n = preg_match('/1\.(5\.[8-9]|[6-9]\.[0-9])/', Grocery_CRUD::VERSION);

    $alert_multiple_delete = $hasAlerti18n
        ? $this->l('alert_delete_multiple') : 'Você tem certeza que deseja excluir {items_amount} itens?';

    $alert_multiple_delete_one = $hasAlerti18n
        ? $this->l('alert_delete_multiple_one') : 'Você tem certeza que deseja excluir este item?';

    $list_displaying = str_replace(
        array(
            '{start}',
            '{end}',
            '{results}'
        ),
        array(
            '<span class="paging-starts">1</span>',
            '<span class="paging-ends">10</span>',
            '<span class="current-total-results">'. $this->get_total_results() . '</span>'
        ),
        $this->l('list_displaying'));

    include(__DIR__ . '/common_javascript_vars.php');
    
?>
<script type='text/javascript'>
    var base_url = '<?php echo base_url();?>';

    var subject = '<?php echo $subject?>';
    var ajax_list_info_url = '<?php echo $ajax_list_info_url; ?>';
    var ajax_list_url = '<?php echo $ajax_list_url;?>';
    var unique_hash = '<?php echo $unique_hash; ?>';

    var message_alert_delete = "<?php echo $this->l('alert_delete'); ?>";
    var THEME_VERSION = '1.3.7';
</script>

    <br/>
    <div class="gc-container">
        <div class="success-message hidden"><?php
        if($success_message !== null){?>
           <?php echo $success_message; ?> &nbsp; &nbsp;
        <?php }
        ?></div>

 		<div class="row">
 		    <div class="col-12 col-md-12">
 		        <div class="card card-accent-primary">
                <div class="card-header">
                    <!--<div class="col-md-12">
                       <h3 class="box-title" id="table-label-<?php echo $subject_plural; ?>">
                          <?php echo $subject_plural; ?>
                       </h3> 
                    </div>-->
                  
                  <div class="col-12 col-md-12">
                    <?php if(!$unset_add){?>
                    <div class="floatL t5" style="margin-left: -20px">
                        <a class="btn btn-success" href="<?php echo $add_url?>"><i class="fa fa-plus"></i> &nbsp; <?php echo $this->l('list_add'); ?> <?php echo $subject?></a>
                    </div>
                    <?php } ?>
                    <div class="floatR">
                        <?php if(!$unset_export) { ?>
                            <a class="btn btn-outline-secondary t5 gc-export" data-url="<?php echo $export_url; ?>">
                                <i class="fa fa-cloud-download floatL t3"></i>
                                <span class="hidden-xs floatL l5">
                                    <?php echo $this->l('list_export');?>
                                </span>
                                <div class="clear"></div>
                            </a>
                        <?php } ?>
                        <?php if(!$unset_print) { ?>
                            <a class="btn btn-outline-secondary t5 gc-print" data-url="<?php echo $print_url; ?>">
                                <i class="fa fa-print floatL t3"></i>
                                <span class="hidden-xs floatL l5">
                                    <?php echo $this->l('list_print');?>
                                </span>
                                <div class="clear"></div>
                            </a>
                        <?php }?>

                        <a class="btn btn-primary search-button t5">
                            <i class="fa fa-search  text-white"></i>
                            <input type="text" name="search" class="search-input" />
                        </a>
                    </div>
                    <div class="clear"></div>
                  </div>
                </div>
                
                <div class="card-body px-0">
            	    <div class="col-12 col-md-12 <!--table-section-->">
                    
                    <div class="table-container table-responsive">
                        <?php echo form_open("", 'method="post" autocomplete="off" id="gcrud-search-form"'); ?>
                            
            			    <table class="table table-bordered grocery-crud-table table-hover" style=" font-size: 12px;">
            					<thead>
            						<tr>
                                        <?php foreach($columns as $column){?>
                                            <th class="column-with-ordering" data-order-by="<?php echo $column->field_name; ?>"><?php echo $column->display_as; ?></th>
                                        <?php }?>
            							<th colspan="2">
                                            <?php echo $this->l('list_actions'); ?>
                                        </th>
            						</tr>
            						
            						<tr class="filter-row gc-search-row">
            						    <?php foreach($columns as $column){?>
                                            <td>
                                                <input type="text" class="form-control searchable-input floatL" placeholder="Pesquisar <?php echo $column->display_as; ?>" name="<?php echo $column->field_name; ?>" />
                                            </td>
                                        <?php }?>
            							<td style="border-right: none;">
                                            <?php if (!$unset_delete) { ?>
                							     <div class="floatL t5">
                							         <input type="checkbox" class="select-all-none" />
                							     </div>
                                             <?php } ?>
            							 </td>
            							<td style="border-left: none;">
                                            <div class="floatL">
                                                <a href="javascript:void(0);" title="<?php echo $this->l('list_delete')?>"
                                                   class="hidden btn btn-default delete-selected-button">
                                                    <i class="fa fa-trash-o text-danger"></i>
                                                    <span class="text-danger"><?php echo $this->l('list_delete')?></span>
                                                </a>
                                            </div>
                                            <div class="floatR">
                                                <a href="javascript:void(0);" class="btn btn-default gc-refresh">
                                                    <i class="fa fa-refresh"></i>
                                                </a>
                                            </div>
                                            <div class="clear"></div>
                                        </td>
            						</tr>
    
            					</thead>
            					<tbody>
                                    <?php include(__DIR__."/list_tbody.php"); ?>
            					</tbody>
    
                                <!-- Table Footer -->
            					<tfoot class="footer-list">
                                    <tr>
                                        <td colspan="<?php echo $colspans; ?>">
    
                                                <!-- "Show 10/25/50/100 entries" (dropdown per-page) -->
                                                <div class="floatL t20 l5">
                                                    <div class="floatL t10">
                                                        <?php list($show_lang_string, $entries_lang_string) = explode('{paging}', $this->l('list_show_entries')); ?>
                                                        <?php echo $show_lang_string; ?>
                                                    </div>
                                                    <div class="floatL r5 l5 t3">
                                                        <select name="per_page" class="per_page form-control">
                                                            <?php foreach($paging_options as $option){?>
                                                                <option value="<?php echo $option; ?>"
                                                                        <?php if($option == $default_per_page){?>selected="selected"<?php }?>>
                                                                            <?php echo $option; ?>&nbsp;&nbsp;
                                                                </option>
                                                            <?php }?>
                                                        </select>
                                                    </div>
                                                    <div class="floatL t10">
                                                        <?php echo $entries_lang_string; ?>
                                                    </div>
                                                    <div class="clear"></div>
                                                </div>
                                                <!-- End of "Show 10/25/50/100 entries" (dropdown per-page) -->
    
                                              
                                                      <div class="btn-group floatR t40 l10 settings-button-container">
                                                   
                                                            <a href="javascript:void(0)" class="dropdown-item clear-filtering">
                                                                <i class="fa fa-eraser"></i>Limpar Filtros
                                                            </a>
                                                     
                                                </div>
                                                <div class="clear"></div>
                                                  <!-- Buttons - First,Previous,Next,Last Page -->
                                                <div class="floatR r5">
    
                                                    <ul class="pagination">
                                                        <li class="disabled paging-first page-item"><a class="page-link" href="#"><i class="fa fa-step-backward"></i></a></li>
                                                        <li class="prev disabled paging-previous page-item"><a class="page-link" href="#"><i class="fa fa-chevron-left"></i></a></li>
                                                        <li class="page-item">
                                                            <span class="page-number-input-container page-link">
                                                                <input type="number" value="1" class="form-control page-number-input" />
                                                            </span>
                                                        </li>
                                                        <li class="next paging-next page-item"><a class="page-link" href="#"><i class="fa fa-chevron-right"></i></a></li>
                                                        <li class="paging-last page-item"><a class="page-link" href="#"><i class="fa fa-step-forward"></i></a></li>
                                                    </ul>
    
                                                    <input type="hidden" name="page_number" class="page-number-hidden" value="1" />
    
                                                </div>
                                                <!-- End of Buttons - First,Previous,Next,Last Page -->
                                                <!-- "Displaying 1 to 10 of 116 items" -->
                                                <div class="floatR r10 t30 mt-0">
                                                    <?php echo $list_displaying; ?>
                                                    <span class="full-total-container hidden">
                                                        <?php echo str_replace(
                                                                    "{total_results}",
                                                                    "<span class='full-total'>" . $this->get_total_results() . "</span>",
                                                                    $this->l('list_filtered_from'));
                                                        ?>
                                                    </span>
                                                </div>
                                                <!-- End of "Displaying 1 to 10 of 116 items" -->
                                        </td>
                                    </tr>
            					</tfoot>
                                <!-- End of: Table Footer -->
            			    </table>
                        <?php echo form_close(); ?>
                    </div>
            	</div>
            	</div>
        	</div><!-- End class box -->
        	</div>

            <!-- Delete confirmation dialog -->
            
            <div class="delete-confirmation modal fade">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" class="close"><?php echo $this->l('list_delete'); ?></h4>
                            <button type="button" class="close"  data-dismiss="modal" aria-hidden="true">&times;</button>

                        </div>
                        <div class="modal-body">
                            <p><?php echo $this->l('alert_delete'); ?></p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->l('form_cancel'); ?></button>
                            <button type="button" class="btn btn-danger delete-confirmation-button"><?php echo $this->l('list_delete'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End of Delete confirmation dialog -->

            <!-- Delete Multiple confirmation dialog -->
            <div class="delete-multiple-confirmation modal fade">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h4 class="modal-title"><?php echo $this->l('list_delete'); ?></h4>
                        </div>
                        <div class="modal-body">
                            <p><?php echo $this->l('alert_delete'); ?></p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">
                                <?php echo $this->l('form_cancel'); ?>
                            </button>
                            <button type="button" class="btn btn-danger delete-multiple-confirmation-button"
                                    data-target="<?php echo $delete_multiple_url; ?>">
                                <?php echo $this->l('list_delete'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End of Delete Multiple confirmation dialog -->

            </div>
        </div>