<?php
require_once '../builder/modules/grocery/libraries/Grocery_CRUD.php';

require_once APPPATH . 'libraries/Upload.php';
//require_once APPPATH . 'libraries/vendor/autoload.php';

//define('ACCESS_KEY', "AKIAXWSGWKL2LMYZ2XSV");
//define('SECRET_KEY', "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");
//use Aws\Credentials\Credentials;
//use Aws\S3\S3Client;
//use Aws\S3\Exception\S3Exception;

class custom_grocery_CRUD_Model_Driver extends Grocery_CRUD
{
    
    
	protected function set_default_Model() {
		$ci = &get_instance ();
		$ci->load->model ( 'grocery/Custom_crud_model' );
		
		$this->basic_model = new Custom_CRUD_Model();
		
	} 
	
	protected function get_total_results() 
	{
		if (! empty ( $this->where ))
			foreach ( $this->where as $where )
				$this->basic_model->where ( $where [0], $where [1], $where [2] );
		
		if (! empty ( $this->or_where ))
			foreach ( $this->or_where as $or_where )
				$this->basic_model->or_where ( $or_where [0], $or_where [1], $or_where [2] );
		
		if (! empty ( $this->like ))
			foreach ( $this->like as $like )
				$this->basic_model->like ( $like [0], $like [1], $like [2] );
		
		if (! empty ( $this->or_like ))
			foreach ( $this->or_like as $or_like )
				$this->basic_model->or_like ( $or_like [0], $or_like [1], $or_like [2] );
		
		if (! empty ( $this->having ))
			foreach ( $this->having as $having )
				$this->basic_model->having ( $having [0], $having [1], $having [2] );
		
		if (! empty ( $this->or_having ))
			foreach ( $this->or_having as $or_having )
				$this->basic_model->or_having ( $or_having [0], $or_having [1], $or_having [2] );
		
		if (! empty ( $this->relation ))
			foreach ( $this->relation as $relation )
				$this->basic_model->join_relation ( $relation [0], $relation [1], $relation [2] );
		
		if (! empty ( $this->relation_n_n )) {
			$columns = $this->get_columns ();
			foreach ( $columns as $column ) {
				// Use the relation_n_n ONLY if the column is called . The set_relation_n_n are slow and it will make the table slower without any reason as we don't need those queries.
				if (isset ( $this->relation_n_n [$column->field_name] )) {
					$this->basic_model->set_relation_n_n_field ( $this->relation_n_n [$column->field_name] );
				}
			}
		}
		
		if ($this->join_on) {
			$this->basic_model->set_join_on ();
		}
		
		return $this->basic_model->get_total_results ();
	}
	
	protected function db_insert($state_info) 
	{
	    
		$validation_result = $this->db_insert_validation ();
		
		if ($validation_result->success) {
			$post_data = $state_info->unwrapped_data;
			$add_fields = $this->get_add_fields ();
			
			if ($this->callback_insert === null) {
				if ($this->callback_before_insert !== null) {
					$callback_return = call_user_func ( $this->callback_before_insert, $post_data );
					
					if (! empty ( $callback_return ) && is_array ( $callback_return ))
						$post_data = $callback_return;
					elseif ($callback_return === false)
						return false;
				}
				
				$insert_data = array ();
				$types = $this->get_field_types ();
				
				//dd($add_fields);
				
				foreach ( $add_fields as $num_row => $field ) {
				    
					/* If the multiselect or the set is empty then the browser doesn't send an empty array. Instead it sends nothing */
					if (isset ( $types [$field->field_name]->crud_type ) && ($types [$field->field_name]->crud_type == 'set' || $types [$field->field_name]->crud_type == 'multiselect') && ! isset ( $post_data [$field->field_name] )) {
						$post_data [$field->field_name] = array ();
					}
					
					if (isset ( $post_data [$field->field_name] ) && ! isset ( $this->relation_n_n [$field->field_name] )) {
						if (isset ( $types [$field->field_name]->db_null ) && $types [$field->field_name]->db_null && is_array ( $post_data [$field->field_name] ) && empty ( $post_data [$field->field_name] )) {
							$insert_data [$field->field_name] = null;
						} elseif (isset ( $types [$field->field_name]->db_null ) && $types [$field->field_name]->db_null && $post_data [$field->field_name] === '') {
							$insert_data [$field->field_name] = null;
						} elseif (isset ( $types [$field->field_name]->crud_type ) && $types [$field->field_name]->crud_type == 'date') {
							$insert_data [$field->field_name] = $this->_convert_date_to_sql_date ( $post_data [$field->field_name] );
						} elseif (isset ( $types [$field->field_name]->crud_type ) && $types [$field->field_name]->crud_type == 'readonly') {
							// This empty if statement is to make sure that a readonly field will never inserted/updated
						} elseif (isset ( $types [$field->field_name]->crud_type ) && ($types [$field->field_name]->crud_type == 'set' || $types [$field->field_name]->crud_type == 'multiselect')) {
							$insert_data [$field->field_name] = ! empty ( $post_data [$field->field_name] ) ? implode ( ',', $post_data [$field->field_name] ) : '';
						} elseif (isset ( $types [$field->field_name]->crud_type ) && $types [$field->field_name]->crud_type == 'datetime') {
							$insert_data [$field->field_name] = $this->_convert_date_to_sql_date ( substr ( $post_data [$field->field_name], 0, 10 ) ) . substr ( $post_data [$field->field_name], 10 );
						}else {
							$insert_data [$field->field_name] = $post_data [$field->field_name];
						}
					}
				}
				
				//dd($insert_data);
				
				if ($this->join_on) {
					$insert_result = $this->basic_model->db_insert_join ( $insert_data );
				} else {
					$insert_result = $this->basic_model->db_insert ( $insert_data );
				}
				
				if ($insert_result !== false) {
					$insert_primary_key = $insert_result;
				} else {
					return false;
				}
				
				if (! empty ( $this->relation_n_n )) {
					foreach ( $this->relation_n_n as $field_name => $field_info ) {
						$relation_data = isset ( $post_data [$field_name] ) ? $post_data [$field_name] : array ();
						$this->db_relation_n_n_update ( $field_info, $relation_data, $insert_primary_key );
					}
				}
				
				if ($this->callback_after_insert !== null) {
					$callback_return = call_user_func ( $this->callback_after_insert, $post_data, $insert_primary_key );
					
					if ($callback_return === false) {
						return false;
					}
				}
			} else {
				$callback_return = call_user_func ( $this->callback_insert, $post_data );
				
				if ($callback_return === false) {
					return false;
				}
			}
			
			if (isset ( $insert_primary_key ))
				return $insert_primary_key;
			else
				return true;
		}
		
		return false;
	}
	
	protected function db_update($state_info) 
	{
		$validation_result = $this->db_update_validation ();
		
		$edit_fields = $this->get_edit_fields ();
		
		if ($validation_result->success) {
			$post_data = $state_info->unwrapped_data;
			
			$primary_key = $state_info->primary_key;
			
			if ($this->callback_update === null) {
				if ($this->callback_before_update !== null) {
					$callback_return = call_user_func ( $this->callback_before_update, $post_data, $primary_key );
					
					if (! empty ( $callback_return ) && is_array ( $callback_return )) {
						$post_data = $callback_return;
					} elseif ($callback_return === false) {
						return false;
					}
				}
				
				$update_data = array ();
				$types = $this->get_field_types ();
				foreach ( $edit_fields as $num_row => $field ) {
					/* If the multiselect or the set is empty then the browser doesn't send an empty array. Instead it sends nothing */
					if (isset ( $types [$field->field_name]->crud_type ) && ($types [$field->field_name]->crud_type == 'set' || $types [$field->field_name]->crud_type == 'multiselect') && ! isset ( $post_data [$field->field_name] )) {
						$post_data [$field->field_name] = array ();
					}
					
					if (isset ( $post_data [$field->field_name] ) && ! isset ( $this->relation_n_n [$field->field_name] )) {
						if (isset ( $types [$field->field_name]->db_null ) && $types [$field->field_name]->db_null && is_array ( $post_data [$field->field_name] ) && empty ( $post_data [$field->field_name] )) {
							$update_data [$field->field_name] = null;
						} elseif (isset ( $types [$field->field_name]->db_null ) && $types [$field->field_name]->db_null && $post_data [$field->field_name] === '') {
							$update_data [$field->field_name] = null;
						} elseif (isset ( $types [$field->field_name]->crud_type ) && $types [$field->field_name]->crud_type == 'date') {
							$update_data [$field->field_name] = $this->_convert_date_to_sql_date ( $post_data [$field->field_name] );
						} elseif (isset ( $types [$field->field_name]->crud_type ) && $types [$field->field_name]->crud_type == 'readonly') {
							// This empty if statement is to make sure that a readonly field will never inserted/updated
						} elseif (isset ( $types [$field->field_name]->crud_type ) && ($types [$field->field_name]->crud_type == 'set' || $types [$field->field_name]->crud_type == 'multiselect')) {
							$update_data [$field->field_name] = ! empty ( $post_data [$field->field_name] ) ? implode ( ',', $post_data [$field->field_name] ) : '';
						} elseif (isset ( $types [$field->field_name]->crud_type ) && $types [$field->field_name]->crud_type == 'datetime') {
							$update_data [$field->field_name] = $this->_convert_date_to_sql_date ( substr ( $post_data [$field->field_name], 0, 10 ) ) . substr ( $post_data [$field->field_name], 10 );
						} else {
							$update_data [$field->field_name] = $post_data [$field->field_name];
						}
					}
				}
				if ($this->join_on) {
					$qnt = count ( get_object_vars ( $this->basic_model->get_edit_values ( $primary_key ) ) );
					$cont = 1;
					
					$edit_values = $this->basic_model->get_edit_values ( $primary_key ); 
					
					dd($edit_values);
					
					foreach ( $update_data as $key => $ff ) {
						if ($cont >= $qnt) {
							$update_data_join [$key] = $update_data [$key];
							unset ( $update_data [$key] );
						}
						$cont ++;
					}
					
					dd($update_data);
					
					if ($this->basic_model->db_update ( $update_data, $primary_key )) {
						$id_join_name = $this->join_on_id_rel;
						$id_join_value = $update_data [$id_join_name];
						$this->basic_model->db_update_join ( $update_data_join, $id_join_name, $id_join_value );
					} else {
						return false;
					}
				} elseif ($this->basic_model->db_update ( $update_data, $primary_key ) === false) {
					return false;
				}
				
				if (! empty ( $this->relation_n_n )) {
					foreach ( $this->relation_n_n as $field_name => $field_info ) {
						if ($this->unset_edit_fields !== null && is_array ( $this->unset_edit_fields ) && in_array ( $field_name, $this->unset_edit_fields )) {
							continue;
						}
						
						$relation_data = isset ( $post_data [$field_name] ) ? $post_data [$field_name] : array ();
						$this->db_relation_n_n_update ( $field_info, $relation_data, $primary_key );
					}
				}
				
				if ($this->callback_after_update !== null) {
					$callback_return = call_user_func ( $this->callback_after_update, $post_data, $primary_key );
					
					if ($callback_return === false) {
						return false;
					}
				}
			} else {
				$callback_return = call_user_func ( $this->callback_update, $post_data, $primary_key );
				
				if ($callback_return === false) {
					return false;
				}
			}
			
			return true;
		} else {
			return false;
		}
	}
	
	protected function db_delete($state_info) 
	{
		$primary_key_value = $state_info->primary_key;
		
		if ($this->callback_delete === null) {
			if ($this->callback_before_delete !== null) {
				$callback_return = call_user_func ( $this->callback_before_delete, $primary_key_value );
				
				if ($callback_return === false) {
					return false;
				}
			}
			
			if (! empty ( $this->relation_n_n )) {
				foreach ( $this->relation_n_n as $field_name => $field_info ) {
					$this->db_relation_n_n_delete ( $field_info, $primary_key_value );
				}
			}
			
			if ($this->join_on) {
				$delete_result = $this->basic_model->db_delete_join ( $primary_key_value );
			} else {
				$delete_result = $this->basic_model->db_delete ( $primary_key_value );
			}
			
			if ($delete_result === false) {
				return false;
			}
			
			if ($this->callback_after_delete !== null) {
				$callback_return = call_user_func ( $this->callback_after_delete, $primary_key_value );
				
				if ($callback_return === false) {
					return false;
				}
			}
		} else {
			$callback_return = call_user_func ( $this->callback_delete, $primary_key_value );
			
			if ($callback_return === false) {
				return false;
			}
		}
		
		return true;
	}
	
	protected function get_list() 
	{
		if (! empty ( $this->order_by ))
			$this->basic_model->order_by ( $this->order_by [0], $this->order_by [1] );
		
		if (! empty ( $this->where ))
			foreach ( $this->where as $where )
				$this->basic_model->where ( $where [0], $where [1], $where [2] );
		
		if (! empty ( $this->or_where ))
			foreach ( $this->or_where as $or_where )
				$this->basic_model->or_where ( $or_where [0], $or_where [1], $or_where [2] );
		
		if (! empty ( $this->like ))
			foreach ( $this->like as $like )
				$this->basic_model->like ( $like [0], $like [1], $like [2] );
		
		if (! empty ( $this->or_like ))
			foreach ( $this->or_like as $or_like )
				$this->basic_model->or_like ( $or_like [0], $or_like [1], $or_like [2] );
		
		if (! empty ( $this->having ))
			foreach ( $this->having as $having )
				$this->basic_model->having ( $having [0], $having [1], $having [2] );
		
		if (! empty ( $this->or_having ))
			foreach ( $this->or_having as $or_having )
				$this->basic_model->or_having ( $or_having [0], $or_having [1], $or_having [2] );
		
		if (! empty ( $this->relation ))
			foreach ( $this->relation as $relation )
				$this->basic_model->join_relation ( $relation [0], $relation [1], $relation [2] );
		
		if (! empty ( $this->relation_n_n )) {
			$columns = $this->get_columns ();
			foreach ( $columns as $column ) {
				// Use the relation_n_n ONLY if the column is called . The set_relation_n_n are slow and it will make the table slower without any reason as we don't need those queries.
				if (isset ( $this->relation_n_n [$column->field_name] )) {
					$this->basic_model->set_relation_n_n_field ( $this->relation_n_n [$column->field_name] );
				}
			}
		}
		
		if ($this->theme_config ['crud_paging'] === true) {
			if ($this->limit === null) {
				$default_per_page = $this->config->default_per_page;
				if (is_numeric ( $default_per_page ) && $default_per_page > 1) {
					$this->basic_model->limit ( $default_per_page );
				} else {
					$this->basic_model->limit ( 10 );
				}
			} else {
				$this->basic_model->limit ( $this->limit [0], $this->limit [1] );
			}
		}
		
		if (! empty ( $this->join_on )) {
			$this->basic_model->set_join_on ();
		}
		
		$results = $this->basic_model->get_list ();
		
		return $results;
	}
	
	protected function get_edit_values($primary_key_value) 
	{
		$values = $this->basic_model->get_edit_values ( $primary_key_value );
		
		if ($this->join_on_table != null) {
			$id_rel_value = $this->join_on_id_rel;
			$values_join = $this->basic_model->get_edit_values_join ( $values->$id_rel_value );
			unset ( $values_join->id_pj );
			foreach ( $values_join as $key => $value ) {
				$values->$key = $value;
			}
		}
		if (! empty ( $this->relation_n_n )) {
			foreach ( $this->relation_n_n as $field_name => $field_info ) {
				$values->$field_name = $this->get_relation_n_n_selection_array ( $primary_key_value, $field_info );
			}
		}
		
		return $values;
	}
	
	protected function set_join_on_table($join_on_table = null, $id_rel = null,$id_rel_2 = null) 
	{
		$this->basic_model->set_basic_join_on_table ( $join_on_table, $id_rel, $id_rel_2 );
	}
}
class Custom_grocery_CRUD_Layout extends custom_grocery_CRUD_Model_Driver
{
	protected $css_files				= array();
	protected $js_files					= array();
	protected $js_lib_files				= array();
	protected $js_config_files			= array();
	protected $fields_abas		    	= array();
	protected $theme_abas               = NULL;
	protected $count_abas               = 0;
	
	public function set_fields_abas()
	{
	    $args = func_get_args();
	    
	    if(count($args) == 2)
	    {
	        $titulo = $args[0];
	        $fields = $args[1];
	        $this->set_theme_abas('tabs');
	    }
	    else
	    {
	        $titulo = NULL;
	        $fields = $args[0];
	    }
	    
	    if(empty($this->edit_fields))
        {
            $this->edit_fields = array();
        }
	    
		$array_fields_abas = $this->get_array_fields_abas();
		
        if($this->is_type_subs($fields))
	    {
	        foreach ($fields as $k1=>$array)
			{
				foreach ($array as $k2=>$field)
				{
					if (in_array($field, $array_fields_abas))
						unset($fields[$k1][$k2]);
					else
			        array_push($this->edit_fields,$field);
				}
				if($this->theme_abas === NULL)
				{
				    $this->fields_abas[] = array($k1,$array,'subs');
				}
			}
			if($this->theme_abas !== NULL)
			{
			    $this->fields_abas[] = array($titulo,$fields,'subs');
			}
			
	    }
		else 
		{
			foreach ($fields as $k1=>$field)
			{
				if (in_array($field, $array_fields_abas))
					unset($fields[$k1]);
			    else
			        array_push($this->edit_fields,$field);
			}
			$this->fields_abas[] = array($titulo,$fields,NULL);
		}
		
		//dd($this->fields_abas);
	}
	
	private function get_array_fields_abas()
	{
		$array = array();
		$abas = $this->get_fields_abas();
		foreach ($abas as $aba)
		{
			foreach ($aba[1] as $fieds)
			{
				 if (is_array($fieds))
				{
					foreach ($fieds as $fied)
					{
						
						$array[] = $fied;
					}
				}
				else 
				{
					$array[] = $fieds;
				} 
				
			}
		}
		return $array;
	}
	
	private function is_type_subs($fields)
	{
		foreach ($fields as $value)
		{
			if(is_array($value))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
	}
	
	public function get_fields_abas()
	{
		return $this->fields_abas;
	}
	
	public function set_theme_abas($theme_abas)
	{
		$this->theme_abas = $theme_abas;
	}
	
	public function get_theme_abas()
	{
		return $this->theme_abas;
	}
	
	protected function showAddForm()
	{
		$this->set_js_lib(grocery_CRUD::JQUERY);
		
		$data 				        = $this->get_common_data();
		$data->types 		        = $this->get_field_types();
		
		$data->list_url 		    = $this->getListUrl();
		$data->insert_url		    = $this->getInsertUrl();
		$data->validation_url	    = $this->getValidationInsertUrl();
		$data->input_fields 	    = $this->get_add_input_fields();
		
		$data->theme_abas			= $this->get_theme_abas();
		$data->fields_abas 			= $this->get_fields_abas();
		
		$data->fields 			    = $this->get_add_fields();
		$data->hidden_fields	    = $this->get_add_hidden_fields();
		$data->unset_back_to_list	= $this->unset_back_to_list;
		$data->unique_hash			= $this->get_method_hash();
		$data->is_ajax 			    = $this->_is_ajax();
		
		$this->_theme_view('add.php',$data);
		$this->_inline_js("var js_date_format = '".$this->js_date_format."';");
		
		$this->_get_ajax_results();
		
	}
	
	protected function showEditForm($state_info)
	{
		$this->set_js_lib(grocery_CRUD::JQUERY);
	
		$data 						= $this->get_common_data();
		$data->types 				= $this->get_field_types();
	
		$data->field_values	 		= $this->get_edit_values($state_info->primary_key);
	
		$data->add_url				= $this->getAddUrl();
	
		$data->list_url 			= $this->getListUrl();
		$data->update_url			= $this->getUpdateUrl($state_info);
		$data->delete_url			= $this->getDeleteUrl($state_info);
		$data->read_url				= $this->getReadUrl($state_info->primary_key);
		$data->input_fields 		= $this->get_edit_input_fields($data->field_values);
		$data->unique_hash			= $this->get_method_hash();
		
		$data->theme_abas			= $this->get_theme_abas();
		$data->fields_abas 			= $this->get_fields_abas();
		
		$data->fields 				= $this->get_edit_fields();
		$data->hidden_fields		= $this->get_edit_hidden_fields();
		$data->unset_back_to_list	= $this->unset_back_to_list;
	
		$data->validation_url	    = $this->getValidationUpdateUrl($state_info->primary_key);
		$data->is_ajax 				= $this->_is_ajax();
	
		$this->_theme_view('edit.php',$data);
		$this->_inline_js("var js_date_format = '".$this->js_date_format."';");
	
		$this->_get_ajax_results();
	}
	
}

class Custom_Grocery_CRUD extends Custom_grocery_CRUD_Layout
{
	protected $join_on  	 		= null;
	protected $join_on_id_rel  	 	= null;
	protected $join_on_id_rel_2  	= null;
	protected $join_on_table 		= null;
	protected $upload_S3            = false;
	
	protected function pre_render()
	{
		$this->_initialize_variables();
		$this->_initialize_helpers();
		$this->_load_language();
		$this->state_code = $this->getStateCode();
	
		if($this->basic_model === null)
			$this->set_default_Model();
	
		$this->set_basic_db_table($this->get_table());
	
		if ($this->join_on)
		{
			$this->set_join_on_table($this->get_join_on_table(),$this->get_join_on_id_rel(),$this->get_join_on_id_rel_2());
		}
	
		$this->_load_date_format();
		$this->_set_primary_keys_to_model();
	}
	
	public function join_table($join_on_table,$id_rel,$id_rel_2)
	{
		if(!empty($join_on_table) && $this->join_on_table === null)
		{
			$this->join_on_table = $join_on_table;
		}
		elseif(!empty($join_on_table))
		{
			throw new Exception('You have already insert a table name once...', 1);
		}
		else
		{
			throw new Exception('The table name cannot be empty.', 2);
			die();
		}
		$this->join_on = TRUE;
		$this->join_on_id_rel = $id_rel;
		$this->join_on_id_rel_2 = $id_rel_2;
		$this->field_type($id_rel, 'hidden','');
		$this->field_type($id_rel_2, 'hidden','');
		return $this;
	}
	
	public function get_join_on_table()
	{
		return $this->join_on_table;
	}
	
	public function get_join_on_id_rel()
	{
		return $this->join_on_id_rel;
	}
	public function get_join_on_id_rel_2()
	{
		return $this->join_on_id_rel_2;
	}
	
	/**
	 *
	 * Transform a field to an upload field
	 *
	 * @param string $field_name
	 * @param string $upload_path
     * @return Grocery_CRUD
	 */
	public function set_field_upload_S3($field_name, $upload_dir_s3, $allowed_file_types = '')
	{
		$this->upload_S3 = true;
		
        $upload_dir = 'assets/uploads';
        
		$this->upload_fields[$field_name] = (object) array(
				'field_name' => $field_name,
				'destino' => 's3',
				'upload_path' => $upload_dir,
				'upload_path_s3' => $upload_dir_s3,
				'allowed_file_types' => $allowed_file_types,
				'encrypted_field_name' => $this->_unique_field_name($field_name));
				
		//$this->callback_before_upload = [$this,'callback_before_upload_s3'];	
		$this->callback_after_upload = [$this,'callback_after_upload_s3'];
				
		return $this;
	}
	
	public function callback_after_upload_s3($uploader_response,$field_info, $files_to_upload)
    {
        ///UPLOAD MODELO ANTIGO
        //
        //$nameLocal = $uploader_response[0]->name;
        //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
        //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2','credentials' => $credentials]);
        //$tmp_name = $field_info->upload_path.'/'.$nameLocal;
        //$putImg = $this->getPutResize($tmp_name, $nameLocal, 900, $field_info->upload_path_s3);
        //$resImg = $s3->putObject($putImg);
        //$imgUrl = $resImg['ObjectURL'];
        //
        
        $nameLocal = $uploader_response[0]->name;
        $tmp_name = $field_info->upload_path.'/'.$nameLocal;
        $imgUrl = Upload::putObjectResize($tmp_name, $nameLocal, 900, $field_info->upload_path_s3);
        
        $uploader_response[0]->name = $imgUrl;
        $uploader_response[0]->url = $imgUrl;
        
        if(file_exists($tmp_name))
        {
            unlink($tmp_name);  
        }
        
        return true;
    }
}

/*class Custom_Grocery_CRUD extends Custom_grocery_CRUD_States
{
   
	 * Set Validation Rules
	 *
	 * Important note: If the $field is an array then no automated crud fields will take apart
	 *
	 * @access	public
	 * @param	mixed
	 * @param	string
	 * @return	void
	 
	function set_rules($field, $label = '', $rules = '')
	{
		if(is_string($field))
		{
			$this->validation_rules[$field] = array('field' => $field, 'label' => $label, 'rules' => $rules);
		}
		}elseif(is_array($field))
		{
			foreach($field as $num_field => $field_array)
			{
				$this->validation_rules[$field_array['field']] = $field_array;
			}
		}
		return $this;
	} 
}*/




?>