<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Acoes {

    private static $CI;
    public static $area;
    public static $dados;
    public static $orders = array();
    
    public static $notes = array(
        'num' => 0,
        'notes' => array()
    );
    
    public static $msgc = array(
        'num' => 0,
        'notes' => array()
    );
    
    public function __construct() {
        self::$CI =& get_instance();
    }
    
    public static function set_area($name)
    {
        self::$area = $name;
    }
    
    public static function add($id, $title, $msg, $link = null, $date = null, $button = null)
    {
        if(self::$area === 'mensagem')
        {
            $i = sizeof(self::$notes['notes']);
        
            self::$notes['notes'][$i] = array(
                'id'      => $id,
                'title'   => $title,
                'msg'     => $msg,
                'link'    => is_null($link) ? base_url('anunciante/conta') : $link,
                'button'  => is_null($button) ? 'ir' : $button
            );
            
            self::$notes['num'] = ++$i;
        } 
        else if(self::$area === 'contato')
        {
            $i = sizeof(self::$msgc['notes']);
        
            self::$msgc['notes'][$i] = array(
                'id'      => $id,
                'name'    => $title,
                'msg'     => $msg,
                'data'    => $date,
                'link'    => is_null($link) ? base_url('anunciante/conta/inbox') : $link,
            );
            
            self::$msgc['num'] = $i+1;
        }
    }
    
    public static function has_message()
    {
        if(self::$notes['num'] > 0)
        {
            return true;
        }
        
        return false;
    }
    
    public static function search($param ,$value)
    {
        $found = false;
        
        foreach(self::$notes['notes'] as $msg)
        {
            $search = array_search($value, $msg);
            
            if($search === $param)
            {
                $found = true;
            }
        }
        
        return $found;
    }
    
    public static function get_empty()
    {
        return self::$dados;
    }
    
    public static function get($id)
    {
        foreach(self::$notes['notes'] as $msg)
        {
            if($msg['id'] === $id)
            {
                return $msg;
            }
        }
        
        return null;
        
    }
    
    public static function set()
    {
        Template::set('messages', self::$notes);
        Template::set('contato', self::$msgc);
    }
    
    public static function get_all_notes()
    {
        return self::$notes;
    }
    
    public static function contato()
    {
        self::$CI->load->model('notificacoes/toolbar_model');
        self::$CI->load->config('notificacoes/notificacoes');
        
        $inbox = self::$CI->toolbar_model->get_novos_contatos();
        
        self::set_area('contato');
    	    
	    if($inbox['total'] > 0)
	    {
	        foreach($inbox['result'] as $msg)
            {
                $link  = base_url('anunciante/conta/mensagem').'/'.$msg->id;
                $date  = converte_datahora($msg->data, 1);
            
                self::add('contato_'.$msg->id, ucwords($msg->nome), ucfirst(strtolower($msg->assunto)), $link, $date);
            }
            
            return self::$msgc;
	    }
	    else 
        {
            return null;
        }
        
    }
    
    public static function notificacoes()
    {
        self::$CI->load->model('notificacoes/toolbar_model');
        self::$CI->load->config('notificacoes/notificacoes');
        
        self::set_area('mensagem');
        
        $perfilData = self::$CI->config->item('notes');
        $userPerfil = self::$CI->toolbar_model->get_perfil();
        $perfilID   = $userPerfil->id_perfil;
        $cadastro   = null;
        
        if($perfilID === '4')
        {
            $cadastro = self::$CI->toolbar_model->get_dados();
            
            // Dados obrigatórios
    	    $db_rows = array(
    	        'atividades' => 'principais atividades',
    	        'celular' => 'telefone celular', 
    	        'cpf' => 'CPF',
    	        'dt_nasc' => 'dt de nascimento',
    	        'email' => 'email', 
    	        'empresa' => 'nome da empresa',
    	        'rg' => 'RG', 
    	        'rg_uf' => 'estado do RG', 
    	        'sobrenome' => 'sobrenome',
    	        'chamada' => 'chamada de impácto',
    	        'cnpj' => 'cnpj',
    	        'descricao' => 'descrição da empresa',
    	        'idade_maxima' => 'idade máxima do público alvo',
    	        'idade_minima' => 'idade mínima do público alvo',
    	        'logo_src' => 'logotipo',
    	        'nome' => 'nome',
    	        'pa_cidade' => 'cidade do público alvo',
    	        'pa_estado' => 'estado do público alvo',
    	        'pa_sexo' => 'sexo do público alvo',
    	        'pj_bairro' => 'bairro',
    	        'pj_cep' => 'CEP',
    	        'pj_cidade' => 'cidade',
    	        'pj_estado' => 'estado',
    	        'pj_logradouro' => 'logradouro',
    	        'pj_numero' => 'número da localização',
    	        'segmento' => 'segmento da empresa',
    	        'telefone_empresa' => 'telefone da empresa'); 
    	   
    	   if(isset($cadastro) && $cadastro->check_promotor === '1')
    	   {
    	       // Se for promotor precisa do campo obrigatório do promotor
    	       $db_rows['insc_est'] = 'inscrição estadual';
    	   }
    	   
        }
        
        /*if($perfilID === '3')
        {
            // Dados obrigatórios ????????????????
    	    $db_rows = array(
    	        'nome', 'sobrenome', 'email', 'rg', 'rg_uf', 'cpf', 'celular', 'dt_nasc','sexo',
    	        'empresa','cnpj','telefone_empresa','pj_cep','pj_estado','pj_cidade','pj_bairro','pj_logradouro','pj_numero',
    	        'atividades','segmento','chamada','descricao','pa_estado','pa_cidade','pa_sexo','idade_minima','idade_maxima','logo_src'); 
    	   
    	   $cadastro = self::$CI->toolbar_model->get_dados();
    	   
        }
        
        if($perfilData[$perfilID]['cadastro'] && $perfilID === '3')
        {
            $title = 'Complete seus dados de cadastro!';
            $msg = 'É importante completar seus dados cadastrais para usufruir completamente de todos os serviços do <b>QI Club</b>.';
            $link = base_url('associado/painel/cadastro');
            $button = 'Ver Dados';
            
            if(!is_null($cadastro) && !empty($cadastro))
            {
                $hasNullRows = 0;
                
                foreach($cadastro as $key => $val)
                {
                    if(in_array($key, $db_rows))
                    {
                       $hasNullRows++;
                    }
                }
                
                if($hasNullRows > 0)
                {
                    self::add('cadastro', $title, $msg, $link, $button);
                }
            } else {
                self::add('cadastro', $title, $msg, $link, $button);
            }
        }*/
        
        if(!is_null($perfilData) && $perfilData[$perfilID]['cadastro'] && $perfilID === '4')
        {
            $title = 'Complete seus dados de cadastro!';
            $link = base_url('anunciante/painel/cadastro');
            $button = 'Ver Dados';
            
            if(!is_null($cadastro) && !empty($cadastro))
            {
                $hasNullRows = 0;
                
                foreach($cadastro as $key => $val)
                {
                    if(array_key_exists($key, $db_rows) && ($val === null || strlen($val) === 0 || (($key === 'anunciante_comercial' && $val === '0') && ($key !== 'anunciante_social' && $val === '0') )))
                    {
                       $hasNullRows++;
                       
                       if($hasNullRows === 1)
                        {
                           self::$dados = 'Campo: '.$db_rows[$key].'.'; 
                        }
                       
                        if($hasNullRows > 1 && $hasNullRows < 3)
                        {
                           self::$dados = 'Campos: '.substr(self::$dados, 7, -1).', '.$db_rows[$key].'.';
                        }
                        
                        if($hasNullRows === 3)
                        {
                           self::$dados = substr(self::$dados, 0, -1).' e '.$db_rows[$key].'.';
                        }
                       
                       if($hasNullRows === 4)
                       {
                           $so_far = explode(' e ', self::$dados);
                           
                           self::$dados = $so_far[0].', '.substr($so_far[1], 0, -1).' e outros.';
                       }
                    }
                }
                
                if($hasNullRows > 0)
                {
                    self::add('cadastro', $title, self::$dados, $link, $button);
                }
                
            } else {
                $msg = 'É importante completar seus dados cadastrais para usufruir completamente de todos os serviços do <b>QI Club</b>.';
                self::add('cadastro', $title, $msg, $link, $button);
            }
        }
        
        if($perfilData[$perfilID]['mercadopago'])
        {
            if(empty($cadastro->mp_public_key))
            {
                $title = 'Autorize sua conta do Mercado Pago!';
                $msg = 'Você somente poderá começar a utilizar os serviços do <b>QI Club</b> após conectar sua conta do Mercado Pago com o nosso servidor.';
                $link = base_url('painel/area_restrita');
                $button = 'Autorizar';
                self::add('mercadopago', $title, $msg, $link, $button);
            }
        }
        
        if($perfilData[$perfilID]['galeria'])
        {
            $galeria = self::$CI->toolbar_model->galeria_ok();
            
            if(!$galeria)
    	    {
                $title = 'Envie imagens para a sua página pública!';
                $msg = 'Sua página ficará muito mais interessante com imagens que você pode enviar através da aba "Dados Cadastrais" do painel de navegação.';
                $link = base_url('anunciante/painel/galeria');
                $button = 'Ir para Galeria';
                self::add('galeria', $title, $msg, $link, $button);
    	    }
        }
        
        return self::$notes;
    }
    
    
































}