<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Acao_model extends CI_Model
{
    private $estados  = 'qi_estados';
    private $cidades  = 'qi_cidades';
    private $msg      = 'qi_contato_anunciantes';
    
    // Anunciante
    private $cad      = 'qi_cadastro';
    private $sys      = 'sys_users';
    private $perfil   = 'sys_perfil';
    private $news     = 'nwl_emails';
    private $img      = 'img_anunciante';
    
    // Campanhas
    private $camp      = 'qi_campanhas';
    private $camp_cat  = 'qi_categorias';
    private $camp_sub  = 'qi_subcategoria';
    private $camp_tipo = 'qi_tipo_anuncio';
    private $img_camp  = 'img_campanhas';
    private $rel       = 'campanha_img_rel';
    private $itens     = 'qi_itens_campanha';
    
    // Notificacoes
    private $notes  = 'usr_notificacoes';
    private $config = 'usr_notificacoes_config';
    private $usr_on = 'usr_notificacoes_on';
    
    private $cadID  = null;
    private $sysID  = null;
    private $perfilID = null;
    
    public function __construct() 
    {
        parent::__construct();
        $this->ini_dados();
    }
    
    private function ini_dados()
    {
        if($this->session->emulate_user !== null)
        {
            $this->sysID = $this->session->emulate_user;
        }
        else
        {
            $this->sysID = $this->session->user_id;
        }
        
        $this->db->select('id_cadastro, perfil');
        $this->db->where('id', $this->sysID);
        $dados = $this->db->get($this->sys);
        
        if($dados->num_rows() === 1)
        {
            $this->perfilID = $dados->row()->perfil;
            $this->cadID = $dados->row()->id_cadastro;
        }
        
    }
    
    /* ---------- SELECT ---------- */
    
    public function return_perfil()
    {
        return $this->perfilID;
    }
    
    public function get_dados()
    {
        //$this->db->select($obrigatorios);
        $this->db->where('id_cadastro', $this->cadID);
        /*foreach($obrigatorios as $field)
        {
            $this->db->where($field.' is NOT ', NULL, FALSE);
            $this->db->where($field.' !=', 0);
        }*/
        $query = $this->db->get($this->cad);
        return $query->row();
    }
    
    public function get_perfil()
    {
        $this->db->where('id_perfil', $this->perfilID);
        $query = $this->db->get($this->perfil);
        return $query->row();
    }
    
    public function galeria_ok() 
    {
        $this->db->where('id_cadastro', $this->cadID);
        $query = $this->db->get($this->img);
        if($query->num_rows() > 0)
        {
            return true;
        }
        return false;
    }
    
    function get_novos_contatos($num = null)
    {
        $this->db->where('id_anunciante', $this->cadID);
        $this->db->where('trashed', 0);
        $this->db->where('status', 1);
        
        if(is_numeric($num))
        {
            $this->db->limit($num);
        }
        
        $query = $this->db->get($this->msg);
        return array('result' => $query->result(), 'total' =>$query->num_rows());
    }
    
    function get_perfis()
    {
        $query = $this->db->get($this->perfil);
        return $query->result();
    }
    
    function get_notificacoes()
    {
        $this->db->from($this->notes);
        $query = $this->db->get();
        if($query->result() !== null)
        {
            foreach($query->result() as $row)
            {
                $row->config = $this->get_config($row->id);
            }
        }
        return $query->result();
    }
    
    function get_notificacao_on($id_string)
    {
        $this->db->where('id_string', $id_string);
        $this->db->where('id_perfil', $this->perfilID);
        $this->db->where('on', 1);
        $this->db->join($this->config, $this->config.'.id_notificacao = '.$this->notes.'.id');
        $this->db->from($this->notes);
        $query = $this->db->get();
        return $query->row();
    }
    
    function get_usr()
    {
        $this->db->where($this->usr_on.'.id_usuario', $this->sysID);
        $this->db->where($this->config.'.id_perfil', $this->perfilID);
        $this->db->where('on', 1);
        $this->db->from($this->usr_on);
        $this->db->join($this->notes, $this->notes.'.id = '.$this->usr_on.'.id_notificacao');
        $this->db->join($this->config, $this->config.'.id_notificacao = '.$this->usr_on.'.id_notificacao');
        $query = $this->db->get();
        return $query->result();
    }
    
    function get_usr_on()
    {
        $this->db->select('id_string');
        $this->db->where($this->config.'.id_perfil', $this->perfilID);
        $this->db->where($this->usr_on.'.id_usuario', $this->sysID);
        $this->db->from($this->usr_on);
        $this->db->join($this->notes, $this->notes.'.id = '.$this->usr_on.'.id_notificacao');
        $this->db->join($this->config, $this->config.'.id_notificacao = '.$this->usr_on.'.id_notificacao');
        $query = $this->db->get();
        $current = array();
        
        foreach($query->result() as $val)
        {
          array_push($current, $val->id_string);
        }
        
        return $current;
        
    }
    
    function get_notificacoes_obrigatorias()
    {
        $this->db->where('id_perfil', $this->perfilID);
        $this->db->where('on', 1);
        $this->db->where('required', 1);
        $this->db->join($this->config, $this->config.'.id_notificacao = '.$this->notes.'.id');
        $this->db->from($this->notes);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    function get_id_notificacao($id_string)
    {
        $this->db->where('id_string', $id_string);
        $this->db->from($this->notes);
        $query = $this->db->get();
        return $query->row();
    }
    
    function get_config($noteID = null, $perfilID = null)
    {
        if(!is_null($noteID)){
            $this->db->where('id_notificacao', $noteID);
        }
        
        if(!is_null($perfilID)){
            $this->db->where('id_perfil', $perfilID);
        }
        
        $this->db->from($this->config);
        $query = $this->db->get();
        return $query->result();
    }
    
    function insert_notificacao($data) 
    {
        $this->db->insert($this->notes, $data);
        return $this->db->insert_id();
    }
    
    function insert_notificacao_on($data) 
    {
        $this->db->insert($this->usr_on, $data);
        return $this->db->insert_id();
    }
    
    function insert_perfis($noteID, $perfis)
    {
        foreach($perfis as $perfil)
        {
            $this->db->set('id_perfil', $perfil->id_perfil);
            $this->db->set('id_notificacao', $noteID);
            if(!$this->db->insert($this->config))
            {
                return false;
            }
        }
        
        return true;
    }
    
    public function update_notificacao($id_string, $data)
    {
        $this->db->where('id_string', $id_string);
        if($this->db->update($this->notes, $data))
        {
            return true;
        }
         
        return false;
    }
    
    public function update_config($noteID, $perfilID, $data)
    {
        $this->db->where('id_notificacao', $noteID);
        $this->db->where('id_perfil', $perfilID);
        
        if($this->db->update($this->config, $data))
        {
            return true;
        }
         
        return false;
    }
    
    public function remove_notificacao($noteID)
    {
        $this->db->where('id_notificacao', $noteID);
        $this->db->where('id_usuario', $this->sysID);
        
        if($this->db->delete($this->usr_on))
        {
            return true;
        }
        
        return false;
    }
    
    public function remove_from_all($id_string)
    {
        $id = $this->get_id_notificacao($id_string);
        
        if($id !== null)
        {
            $id = $id->id;
            
            $this->db->where('id_notificacao', $id);
            if($this->db->delete($this->usr_on))
            {
                $this->db->where('id_notificacao', $id);
                if($this->db->delete($this->config))
                {
                    $this->db->where('id', $id);
                    if($this->db->delete($this->notes))
                    {
                        return true;
                    }
                }
            }
        }
        
        
        
        return false;
    }
    
    
    
    
    
    
    
    
    
    
    
}