<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Toolbar_model extends CI_Model
{
    private $estados  = 'qi_estados';
    private $cidades  = 'qi_cidades';
    private $msg = 'qi_contato_anunciantes';
    
    // Anunciante
    private $cad      = 'qi_cadastro';
    private $sys      = 'sys_users';
    private $perfil   = 'sys_perfil';
    private $news     = 'nwl_emails';
    private $img      = 'img_anunciante';
    
    // Campanhas
    private $camp      = 'qi_campanhas';
    private $camp_cat  = 'qi_categorias';
    private $camp_sub  = 'qi_subcategoria';
    private $camp_tipo = 'qi_tipo_anuncio';
    private $img_camp  = 'img_campanhas';
    private $rel       = 'campanha_img_rel';
    private $itens     = 'qi_itens_campanha';
    
    private $cadID  = null;
    private $sysID  = null;
    private $perfilID = null;
    
    public function __construct() 
    {
        parent::__construct();
        $this->ini_dados();
    }
    
    private function ini_dados()
    {
        if($this->session->emulate_user !== null)
        {
            $this->sysID = $this->session->emulate_user;
        }
        else
        {
            $this->sysID = $this->session->user_id;
        }
        
        $this->db->select('id_cadastro, perfil');
        $this->db->where('id', $this->sysID);
        $dados = $this->db->get($this->sys);
        
        if($dados->num_rows() === 1)
        {
            $this->perfilID = $dados->row()->perfil;
            $this->cadID = $dados->row()->id_cadastro;
        }
        
    }
    
    /* ---------- SELECT ---------- */
    
    public function get_dados()
    {
        $this->db->where('id_cadastro', $this->cadID);
        $query = $this->db->get($this->cad);
        return $query->row();
    }
    
    public function get_dados_usuario()
    {
        $this->db->select('nome, sobrenome');
        $this->db->where('id_cadastro', $this->cadID);
        $query = $this->db->get($this->cad);
        
        $result = (array)$query->row();
        
        if($result !== null)
        {
            $this->db->where('id_perfil', $this->perfilID);
            $query = $this->db->get($this->perfil);
            
            $result['perfil'] = ($query->row() !== null) ? $query->row()->perfil : '???';
        }
        
        return (object)$result;
    }
    
    public function get_perfil()
    {
        $this->db->where('id_perfil', $this->perfilID);
        $query = $this->db->get($this->perfil);
        return $query->row();
    }
    
    public function galeria_ok() 
    {
        $this->db->where('id_cadastro', $this->cadID);
        $query = $this->db->get($this->img);
        if($query->num_rows() > 0)
        {
            return true;
        }
        return false;
    }
    
    function get_novos_contatos($num = null)
    {
        $this->db->where('id_anunciante', $this->cadID);
        $this->db->where('trashed', 0);
        $this->db->where('status', 1);
        
        if(is_numeric($num))
        {
            $this->db->limit($num);
        }
        
        $query = $this->db->get($this->msg);
        return array('result' => $query->result(), 'total' =>$query->num_rows());
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
}