<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Conta_model extends CI_Model
{
    // Contato
    private $msg = 'blg_contato';
    
    public function __construct() 
    {
        parent::__construct();
    }
    
    function get_contatos()
    {
        $this->db->where('trashed', 0);
        $this->db->order_by('data', 'DESC');
        $query = $this->db->get($this->msg);
        return array('result' => $query->result(), 'total' =>$query->num_rows());
    }
    
    function get_novos_contatos($num = null)
    {
        $this->db->where('trashed', 0);
        $this->db->where('status', 1);
        $this->db->order_by('data', 'DESC');
        if(is_numeric($num))
        {
            $this->db->limit($num);
        }
        $query = $this->db->get($this->msg);
        return array('result' => $query->result(), 'total' =>$query->num_rows());
    }
    
    function get_msgs_excluidas()
    {
        $this->db->where('trashed', 1);
        $this->db->order_by('data', 'DESC');
        $query = $this->db->get($this->msg);
        return $query->result();
    }
    
    function get_mensagem($msgID)
    {
        $this->db->where('id', $msgID);
	    $query = $this->db->get($this->msg);
	    if ($query->num_rows() === 1 )
	    {
	        return $query->row();
	    }
	    return null;
    }
	
	function buscar_campo_user($field, $value) 
	{
	    $this->db->where($field, $value);
	    $this->db->where('id_cadastro', $this->cadID);
	    $query = $this->db->get($this->sys);
	    
	    if ($query->num_rows() === 1 )
	    {
	        return true;
	    }
	    else
	    {   
	        return false;
	    }
	}
	
	function buscar_campo_cadastro($field, $value) 
	{
	    $this->db->where($field, $value);
	    $this->db->where('id_cadastro', $this->cadID);
	    $query = $this->db->get($this->cad);
	    
	    if ($query->num_rows() === 1 )
	    {
	        return true;
	    }
	    else
	    {   
	        return false;
	    }
	}
    
    /* ---------- INSERT ---------- */
    
    function insert_img_galeria($data) 
    {
        $this->db->insert($this->img, $data);
        return $this->db->insert_id();
    }
    
    /* ---------- UPDATE ---------- */
    
    function update_read($msgID)
    {
        $this->db->where('id', $msgID);
        //$this->db->where('id_anunciante', $this->cadID);
        if($this->db->update($this->msg, array('status' => 2)))
        {
            return true;
        }
        
        return false;
    }
    
    function trash_message($msgID)
    {
        $this->db->where('id', $msgID);
        //$this->db->where('id_anunciante', $this->cadID);
        if($this->db->update($this->msg, array('trashed' => 1)))
        {
            return $msgID;
        }
        
        return null;
    }
    
    function restore_message($msgID)
    {
        $this->db->where('id', $msgID);
        //$this->db->where('id_anunciante', $this->cadID);
        if($this->db->update($this->msg, array('trashed' => 0)))
        {
            return $msgID;
        }
        
        return null;
    }
    
    /* ---------- DELETE ---------- */
    
    function remove_message($msgID)
    {
        $this->db->where('id', $msgID);
        $this->db->where('trashed', 1);
        //$this->db->where('id_anunciante', $this->cadID);
        if($this->db->delete($this->msg))
        {
            return true;
        }
        return false;
    }
}