<?php

/**
 * Perfil Model
 *
 * @author     	Filipe F Freitas <filipe@viewbrasil.com.br>
 * @version     1.0
 * @since       2014-10-23
 * @link		http://www.viewbrasil.com.br
 */
class Menu_model extends CI_Model {
	
	private $tb_modules	 	= 'sys_modules';
	private $tb_sections 	= 'sys_sections';
	private $tb_acao	 	= 'sys_acao';	
	
	function list_all_modules() // retorna objeto
	{
		$this->db->order_by('priority','asc');
		$this->db->where('active',1);
		$query = $this->db->get($this->tb_modules);
		if ($query->num_rows() > 0 ) return $query->result();
		return NULL;
	}
	
	function get_sections_by_module_id($id_secao){
		$this->db->where ( 'id_secao', $id_secao );
		$this->db->order_by('priority','asc');
		$this->db->order_by('subsecao','asc');
		$query = $this->db->get ($this->tb_subsecao);
	
		if ($query->num_rows() > 0) return $query->result();
		return NULL;	
	}
	
	
	function listar_campos_evento()
	{		
		$this->db->order_by('priority','asc');
		$query = $this->db->get($this->tb_campos);
		if ($query->num_rows() > 0 ) return $query->result();
		return NULL;
	}
	
	function consultar_secao($id_secao){
		$this->db->where ( 'id_secao', $id_secao );
		$query = $this->db->get ($this->tb_modules);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_secao_by_name($secao){
		$this->db->where ( 'secao', $secao );
		$query = $this->db->get ($this->tb_modules);
		
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function get_module($module)
	{
		$this->db->where( 'module', $module );
		$query = $this->db->get ($this->tb_modules);
		
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	
	function consultar_secao_by_link($link){
		$this->db->where ( 'link', $link );
		$query = $this->db->get ($this->tb_subsecao);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_perfil($id_perfil){
		$this->db->where ( 'id_perfil', $id_perfil );
		$query = $this->db->get ($this->tb_perfil);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	
	
	function consultar_sub_secoes_by_link($link){
		$this->db->where ( 'link', $link );
		$query = $this->db->get ($this->tb_subsecao);
		
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	
	function consultar_title_section($id_secao,$id_subsecao){
        $this->db->select('subsecao');
	    $this->db->where ( 'id_secao', $id_secao );
	    $this->db->where ( 'id_subsecao', $id_subsecao );
	    $query = $this->db->get ($this->tb_subsecao);
	
	    if ($query->num_rows() == 1) return $query->row()->subsecao;
	    return NULL;
	}
	
	function consultar_subsecao($id_subsecao){
		$this->db->where ( 'id_subsecao', $id_subsecao );
		$query = $this->db->get ($this->tb_subsecao);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_acoes($id_subsecao){
		$this->db->select('b.id_acao,b.acao');
		$this->db->where('a.id_subsecao', $id_subsecao);
		$this->db->from($this->tb_sub_acao.' a');
		$this->db->join($this->tb_acao.' b', 'b.id_acao = a.id_acao');
		$query = $this->db->get();	
		
		if ($query->num_rows() > 0) return $query->result();
		return NULL;	
	}
	
	function consultar_acao($id_acao){
		$this->db->select('id_acao,acao');
		$this->db->where('id_acao', $id_acao);
		$this->db->from($this->tb_acao);
		$query = $this->db->get();
		if ($query->num_rows() == 1) return $query->row();
		return NULL;		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

}
