<?php

/**
 * Perfil Model
 *
 * @author     	Filipe F Freitas <filipe@viewbrasil.com.br>
 * @version     1.0
 * @since       2014-10-23
 * @link		http://www.viewbrasil.com.br
 */
class Perfil_model extends CI_Model {
	
	
	private $tb_acao	 	= 'sys_actions';	
	private $tb_perfil	 	= 'sys_perfil';
	private $tb_sec_action	= 'sys_section_action';
	private $tb_modules	 	= 'sys_modules';
	private $tb_section		= 'sys_module_sections';
	private $tb_rel_perfil	= 'sys_rel_perfil';	
	private $tb_campos 		= 'sys_evento_campos'; // tabela com todos os campos referentes ao evento
	private $tb_campos_res	= 'sys_rel_subsecao_campo'; // tabela que define se há restrição de campos de alguma ação
	private $tb_campos_rel	= 'sys_rel_perfil_campo'; // tabela onde são armazenados os campos permitidos por perfil->subsecao->acao
	
	function get_module($class,$method)
	{
		$this->db->where( 'class', $class );		
		if($method == 'index')
		{
			$this->db->where("(method = 'index' or method = '')");
		}
		else 
		{
			$this->db->where( 'method', $method );
		}			
		$this->db->from($this->tb_section.' a');		
		$this->db->join($this->tb_modules.' b', 'a.id_module = b.id_module');		
		$query = $this->db->get ();	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function get_section($class,$method)
	{
		$this->db->where( 'class', $class );		
		if($method == 'index')
		{
			$this->db->where("(method = 'index' or method = '')");
		}
		else 
		{
			$this->db->where( 'method', $method );
		}	
		$query = $this->db->get ($this->tb_section);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	} 
	
	function list_active_modules() // retorna objeto
	{
		$this->db->order_by('priority','asc');
		$this->db->where('active',1);
		$query = $this->db->get($this->tb_modules);
		if ($query->num_rows() > 0 ) return $query->result();
		return NULL;
	}
	
	function check_method_class_permission($id_perfil,$id_module,$id_section)
	{		
		$this->db->where('a.id_module', $id_module);
		$this->db->where('a.id_section', $id_section);
		$this->db->from($this->tb_section.' a');
		$this->db->join($this->tb_rel_perfil.' b', 'b.id_perfil = '.$id_perfil.' and a.id_module = b.id_module and a.id_section = b.id_section');
		$query = $this->db->get();		
		if ($query->num_rows() > 0) return TRUE;
		return FALSE;
	}
	
	function inserir_perfil($perfil,$tipo_menu) 
	{
		$data['perfil'] = $perfil;
		$data['tipo_menu'] = $tipo_menu;
		
		if ($this->db->insert ( $this->tb_perfil, $data ))
		{
			return $this->db->insert_id();
		}
		else 
		{
			return false;
		}
	}
	
	function inserir_perfil_rel($data)
	{
		if ($this->db->insert ( $this->tb_rel_perfil, $data )){
			return true;
		}
		else {
			return false;
		}
	}
	
	function inserir_campos_rel($data)
	{
		$result = true;
		$insert['id_perfil'] 	= $data['id_perfil'];
		$insert['id_section'] 	= $data['id_section'];
		$insert['id_action']	 	= $data['id_action'];
		
		foreach ($data['campos'] as $campo)
		{
			$insert['id_campo'] = $campo;
			if (!$this->db->insert ( $this->tb_campos_rel, $insert )){
				$result = false;
			}
		}
		return $result;		
	}
	
	function update_perfil($id_perfil,$data) 
	{
		$this->db->where('id_perfil',$id_perfil);
		
		if ($this->db->update ( $this->tb_perfil, $data ))
			return true;
		else
			return false;
	}
	
	function get_sections_by_module_id($id_module){
		$this->db->where ( 'id_module', $id_module );
		$this->db->order_by('priority','asc');
		$this->db->order_by('name','asc');
		$query = $this->db->get ($this->tb_section);
	
		if ($query->num_rows() > 0) return $query->result();
		return NULL;	
	}
	
	function get_perfil_rel($id_perfil)
	{
		$this->db->where ( 'id_perfil', $id_perfil );
		$query = $this->db->get ($this->tb_rel_perfil);
	
		if ($query->num_rows() > 0) return $query->result();
		return NULL;
	}
	
	
	function listar_campos_evento()
	{		
		$this->db->order_by('priority','asc');
		$query = $this->db->get($this->tb_campos);
		if ($query->num_rows() > 0 ) return $query->result();
		return NULL;
	}
	
	function consultar_secao($id_module){
		$this->db->where ( 'id_module', $id_module );
		$query = $this->db->get ($this->tb_modules);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_secao_by_name($secao){
		$this->db->where ( 'secao', $secao );
		$query = $this->db->get ($this->tb_modules);
		
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_secao_by_link($link){
		$this->db->where ( 'link', $link );
		$query = $this->db->get ($this->tb_section);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_perfil($id_perfil){
		$this->db->where ( 'id_perfil', $id_perfil );
		$query = $this->db->get ($this->tb_perfil);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	
	
	function consultar_sub_secoes_by_link($link){
		$this->db->where ( 'link', $link );
		$query = $this->db->get ($this->tb_section);
		
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	
	function consultar_title_section($id_module,$id_section){
        $this->db->select('subsecao');
	    $this->db->where ( 'id_module', $id_module );
	    $this->db->where ( 'id_section', $id_section );
	    $query = $this->db->get ($this->tb_section);
	
	    if ($query->num_rows() == 1) return $query->row()->subsecao;
	    return NULL;
	}
	
	function consultar_subsecao($id_section){
		$this->db->where ( 'id_section', $id_section );
		$query = $this->db->get ($this->tb_section);
	
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_acoes($id_section){
		$this->db->select('b.id_action,b.action');
		$this->db->where('a.id_section', $id_section);
		$this->db->from($this->tb_sec_action.' a');
		$this->db->join($this->tb_acao.' b', 'b.id_action = a.id_action');
		$query = $this->db->get();	
		
		if ($query->num_rows() > 0) return $query->result();
		return NULL;	
	}
	
	function consultar_acao($id_action){
		$this->db->select('id_action,action');
		$this->db->where('id_action', $id_action);
		$this->db->from($this->tb_acao);
		$query = $this->db->get();
		if ($query->num_rows() == 1) return $query->row();
		return NULL;		
	}
	
	/**
	 * Função para consultar as secoes de um determinado perfil e retornar um objeto
	 * @access public
	 * @param $id_perfil
	 * @return objetc id_module
	 * @
	 */
	function consultar_secoes_rel($id_perfil)
	{
		$this->db->distinct();
		$this->db->select('id_module');
		$this->db->where ( 'id_perfil', $id_perfil );
		$this->db->order_by( 'id_module','asc' );
		$query = $this->db->get ($this->tb_rel_perfil);
		
		if ($query->num_rows() > 0) return $query->result();
		return NULL;
	}	
	
	function consultar_sub_secoes_rel($id_perfil,$id_module)
	{
		$this->db->distinct();
		$this->db->select('id_section');
		$this->db->where ( 'id_perfil', $id_perfil );
		$this->db->where ( 'id_module', $id_module );
		$query = $this->db->get ($this->tb_rel_perfil);
		
		if ($query->num_rows() > 0) return $query->result();
		return NULL;
	}
	
	function consultar_acoes_rel($id_perfil,$id_section)
	{
		$this->db->distinct();
		$this->db->select('id_action');
		$this->db->where ( 'id_perfil', $id_perfil );
		$this->db->where ( 'id_section', $id_section );
		$this->db->order_by('id_action','asc');
		$query = $this->db->get ($this->tb_rel_perfil);
		
		if ($query->num_rows() > 0) return $query->result();
		return NULL;
	}
	
	function excluir_prefil_rel($id_perfil)
	{
		$this->db->where('id_perfil',$id_perfil);		
		
		if($this->db->delete($this->tb_rel_perfil))
			return true;
		else
			return false;		
		
	}
	
	function delete_perfil_rel_perfil($primary_key)
    {
        $this->db->where('id_perfil',$primary_key);
        
        return $this->db->delete($this->tb_rel_perfil);
    }
	
	function consulta_acesso_modulo($id_perfil,$id_module){
		$this->db->select('a.id_perfil,a.id_module,a.id_section,a.id_action');
		$this->db->where('a.id_perfil', $id_perfil);
		$this->db->where('a.id_module', $id_module);
		$this->db->from($this->tb_rel_perfil.' a');
		$this->db->join($this->tb_perfil.' b', 'b.id_perfil = a.id_perfil');
		$this->db->order_by('id_module asc, id_section asc, id_action asc');
		$query = $this->db->get();
		if ($query->num_rows() > 0) return $query->result();
		return NULL;
	}
	
	function consultar_restricao_campos($subSecao,$acao){
		$this->db->where('id_section', $subSecao);
		$this->db->where('id_action', $acao);
		$query = $this->db->get($this->tb_campos_res);
		if ($query->num_rows() == 1) return $query->row();
		return false;
	}
	
	function consultar_campos_rel($id_perfil,$id_action){
		$this->db->where('id_perfil', $id_perfil);
		$this->db->where('id_action', $id_action);	
		$query = $this->db->get($this->tb_campos_rel);
		if ($query->num_rows() > 0) return $query->result();
		return NULL;
	}
	
	function consultar_campo_evento($id_campo)
	{
		$this->db->where('id_campo', $id_campo);
		$query = $this->db->get($this->tb_campos);
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function excluir_subsecao_relacional($id_section)
	{
	    $error = FALSE;
		
		//check if id_section exists on table tb_sub_acao
		$query2 = $this->db->get_where($this->tb_sec_action, array('id_section'=>$id_section))->num_rows();
		 
		if($query2 > 0)
		{
		    // This function deletes all items from the Active Record cache.
		    $this->db->flush_cache();
			// delete from tb_subsecao
			$this->db->where('id_section',$id_section);
			$this->db->delete($this->tb_sec_action);
			if($this->db->affected_rows() == 0) $error = TRUE;
		}
	
		// This function deletes all items from the Active Record cache.
		$this->db->flush_cache();
		
	   //check if id_section exists on table tb_rel_perfil
		$query3 = $this->db->get_where($this->tb_rel_perfil, array('id_section'=>$id_section))->num_rows();
		 
		if($query3 > 0)
		{
		    // This function deletes all items from the Active Record cache.
		    $this->db->flush_cache();
			// delete from tb_subsecao
			$this->db->where('id_section',$id_section);
			$this->db->delete($this->tb_rel_perfil);
			if($this->db->affected_rows() == 0) $error = TRUE;
		}
		
		if($error == FALSE)
		{
			return TRUE;
		}
		else 
		{
		  return FALSE;  
		}
	
	}

}