<?php

class Usuario_model extends CI_Model {
	
	private $table = 'sys_users';
	private $tb_perfil = 'sys_perfil'; // revisar!
	
	private $access = 'sys_access';
	
	
	function get_perfil($user_id)
	{
		$this->db->select('perfil');
		$this->db->where ( 'id', $user_id );
		$query = $this->db->get( $this->table );
		if ($query->num_rows() == 1)
		{
			return $query->row();
		}
		else
		{
			return NULL;
		}
	}
	
	function listar_perfis()
	{
		$query = $this->db->get( $this->tb_perfil );
		
		
		if ($query->num_rows() > 0) 
		{
			return $query->result();
		}
		else 
		{
			return NULL;
		}
		
	}
	
	function get_perfil_name_by_id($id)
	{
	    $this->db->select('perfil');
		$this->db->where ( 'id_perfil', $id );
		$query = $this->db->get( $this->tb_perfil );
		
		if ($query->num_rows() > 0)
		{
		    $perfil = $query->result();
		    return $perfil[0]->perfil;
		}
		else
		{
		    return '';
		}
	}
	
	# VALIDA USUÁRIO
	function valida_username($username, $pk = NULL) {
		
		$this->db->select('username,id');
			
		$this->db->where ( 'username', $username ); // COMPARA A VARIÁVEL USERNAME
		
		$query = $this->db->get( $this->table ); // FAZ O SELECT COM OS PARAMETROS ACIMA
			
		if ($query->num_rows() == 1) { // VERIFICA SE TEM APENAS UMA LINHA NA CONSULTA

			if($pk === NULL)
			{
				return FALSE;
			}
			else 
			{
				$res = $query->row();
					
				$id = $res->id;
					
				if($pk == $id){
					return TRUE;
				}else{
					return FALSE;
				}
			}			
					
		}
		else
		{
			return TRUE;
		}
	}
	
	function consulta_email($email){
		$this->db->where ( 'email', $email );
		$query = $this->db->get ($this->table);
	
		if ($query->num_rows() != 1) { // VERIFICA SE TEM APENAS UMA LINHA NA CONSULTA
			return FALSE;
		}else{
			return $query->row()->email;
		}
	}
	
	function validar_alteracao_email($user_id,$email){	
		$this->db->where ( 'email', $email );
		$this->db->where ( 'id !=', $user_id ); // COMPARA A VARIÁVEL id se é diferente do atual
		$query = $this->db->get ( $this->table );	
		if ($query->num_rows() == 1){
			return false;
		}else{
			return true;
		}	
	}
	
	function alterar_senha($data,$email){
	
		$this->db->where ( 'email', $email );
	
		if ($this->db->update ( $this->table, $data ))
			return TRUE;
		else
			return FALSE;	
	}
	
	function insert_new_login($email, $datahora, $ip, $perfil)
	{
		$this->login   	= $email;
		$this->datahora = $datahora;
		$this->ip    	= $ip;
		$this->perfil 	= $perfil;
	
		$this->db->insert($this->access, $this);
	}
	
	function get_usuario_by_email($email)
	{
	    $this->db->or_where('LOWER(email)=', strtolower($email));
	
	    $query = $this->db->get($this->table);
	    if ($query->num_rows() == 1) return $query->row();
	    return NULL;
	}
	
	function get_usuario_by_email_2($email)
	{
	    $this->db->where('email', $email);
	
	    $query = $this->db->get($this->table);
	    if ($query->num_rows() == 1) return $query->row();
	    return NULL;
	}
	
	function update_new_password_key($email, $new_password_key)
	{
		$this->db->set('new_password_key', $new_password_key);
		$this->db->where('email', $email);
		$this->db->update($this->table);
	    return TRUE;
	}
	
	function get_user_by_key($key_concat)
	{
		$this->db->where('CONCAT(`id_cadastro`,`new_password_key`)', $key_concat);
		$query = $this->db->get( $this->table );
		if ($query->num_rows() == 1)
		{
			return $query->row();
		}
		else
		{
			return NULL;
		}
	}
	
	function definir_nova_senha($password, $key)
	{
		$data = array(
        'password' => $password,
        'new_password_key' => NULL,
        );

        $this->db->where('CONCAT(`id_cadastro`,`new_password_key`)', $key);
        $this->db->update($this->table, $data);
        
        if($this->db->affected_rows() === 1){
            //echo $this->db->last_query();
            return TRUE;   
        } else {
            return FALSE;
        }
	}
	
	function get_user_by_id($user_id)
	{
		$this->db->where ( 'id', $user_id );
		$query = $this->db->get ( $this->table );
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consulta_ultimo_login($login)
	{
		$this->db->where('login', $login );
		$this->db->limit(1);
		$this->db->order_by('datahora','desc');
		$query = $this->db->get ( $this->access );
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}
	
	function consultar_usuario($usuario)
	{	
	   $this->db->where ( 'email', $usuario );
	   $query = $this->db->get($this->table);
	
	    if ($query->num_rows() == 1) return $query->row();
	    return NULL;
	}
	
	/*function validar_email($email){
		$this->db->where ( 'email', $email );
		$query = $this->db->get ($this->tb_usuarios);	
	
		if ($query->num_rows > 0) { // VERIFICA SE TEM APENAS UMA LINHA NA CONSULTA				
			return FALSE;
		}else{
			return TRUE;
		}	
	}*/
	
	
	/*function insere_usuario($data) {
		if ($this->db->insert ( $this->tb_usuarios, $data ))
			return $this->db->insert_id();
		else
			return 0;
	}*/
	
	/*function activate_user($user_id, $activation_key)
	{
		$this->db->select('activated');
		$this->db->where('id', $user_id);
		$query = $this->db->get( $this->tb_usuarios );
		
		if($query->num_rows() == 1 && $query->row()->activated == 1)
			return TRUE;		
		
		$this->db->select('1', FALSE);
		$this->db->where('id', $user_id);
		$this->db->where('new_email_key', $activation_key);
		$this->db->where('activated', 0);
		$query1 = $this->db->get( $this->tb_usuarios );
	
		if ($query1->num_rows() == 1) {
	
			$this->db->set('activated', 1);
			$this->db->set('new_email_key', NULL);
			$this->db->where('id', $user_id);
			$this->db->update( $this->tb_usuarios );
	
			return TRUE;
		}
		return FALSE;
	}*/
	
	/*function consulta_dados_email($email){
		$this->db->where ( 'email', $email );
		$query = $this->db->get ($this->tb_usuarios);	
	
		if ($query->num_rows >= 1) { // VERIFICA SE TEM APENAS UMA LINHA NA CONSULTA
				
			return $query->row();
		}else{
			return 0;
		}
	
	}*/
	
	/*function alterar_cadastro($data) {
	
		$this->db->where('id',$data['id']);
		unset($data['id']);
	
		if ($this->db->update ( $this->tb_usuarios, $data ))
			return 1;
		else
			return 0;
	}*/
	
	/*function get_instituicao_array_by_id($id)
	{
	    $this->db->where ( 'id_instituicao', $id );
	    $this->db->where ( 'perfil', 3 );
	    $query = $this->db->get ('users' ); 
	    return $query->result();
	}*/
	
	
	/*function update_login_info($user_id, $record_ip, $record_time, $acessos_sistema)
	{
		$this->db->set('last_login', date('Y-m-d H:i:s'));
		if(isset($record_ip))		 $this->db->set('last_ip', $record_ip);
		if(isset($acessos_sistema))  $this->db->set('acessos_sistema', $acessos_sistema+1);
	
		$this->db->where('id', $user_id);
		$this->db->update($this->tb_usuarios);
	}*/
	
	/*function get_user_by_email($email)
	{
		$this->db->or_where('LOWER(email)=', strtolower($email));
	
		$query = $this->db->get($this->tb_usuarios);
		if ($query->num_rows() == 1) return $query->row();
		return NULL;
	}*/
	
	/*function lista_ids_usuarios_instituicao($id_instituicao){
	    
	    $this->db->select('id');
	    $this->db->where('id_instituicao',$id_instituicao);
	    $query = $this->db->get($this->table);
	    
	    if($query->num_rows() >=1 ) return $query->result();
	    return NULL;    
	}
	
	function consulta_instituicao_por_usuario($id_usuario){
	    
	    $this->db->select('*');
	    $this->db->where('id',$id_usuario);
	    $query = $this->db->get($this->table);
	    
	    if ($query->num_rows() == 1) return $query->row();
	    return NULL;
	}*/
	
    /*function consulta_financeira_por_user($id)
    {
        $this->db->select('id_instituicao');
        $this->db->where('id',$id);
        $query = $this->db->get('users');
        if($query->num_rows() == 1)
        {
            $id_instituicao = $query->row()->id_instituicao;
        }
        $this->db->select('*');
        $this->db->where('id_instituicao',$id_instituicao);
        $query = $this->db->get('tb_instituicao');
        if ($query->num_rows() ==1) return $query->row();
        else return FALSE;
    }*/
	
	/*function get_financeira($id_instituicao)
	{
	    $this->db->select('*');
	    $this->db->where('id_instituicao',$id_instituicao);
	    $this->db->where('perfil = 1 OR perfil = 2');
	    $this->db->limit(1);
	    $query = $this->db->get($this->table);
	     
	    if ($query->num_rows() == 1) return $query->row();
	    return NULL;
	}
	
	function update_usuario($id,$data)
	{
	    $this->db->where('id_user',$id);
	    $this->db->update('tb_limites_bradesco',$data);
	}*/
	
	/*function update_plano($id,$data)
	{
	    $this->db->where('id_instituicao',$id);
	    $this->db->update('tb_planos_bradesco',$data);
	}*/
	
	/*function update_temp_plano($id,$data)
	{
	    $this->db->where('id_instituicao',$id);
	    $this->db->update('tb_planos_temp',$data);
	}*/
	
	/*function insert_new_instituicao_user($dados)
	{
	    $this->db->insert ( 'users', $dados );
	    if ($last_id = $this -> db -> insert_id ()) return $last_id;
	
	    return FALSE;
	}*/
	
	/*function overwrite_instituicao_user($email)
	{
	    $this->db->where ('email', $email );
	    if($query = $this->db->delete ('users'))
	
	        return TRUE;
	    return FALSE;
	}*/
	
	/*function check_instituicao_user_key($key)//check_master_user_key
	{
	    $this->db->where ( 'new_email_key', $key );
	    $query = $this->db->get ('users');
	
	    if ($query->num_rows() == 1) return $query->row();
	    return NULL;
	}*/
	
	/*function activate_instituicao_user($id,$data)//activate_master_user
	{
	    $this->db->where ( 'id', $id );
	    if($query = $this->db->update ('users',$data)) return TRUE;
	
	     
	    return FALSE;
	}*/
	
	/*function update_user($id,$data)
	{
	    $this->db->where ( 'id', $id );
	    if($query = $this->db->update ('users',$data)) return TRUE;
	
	
	    return FALSE;
	}*/

	/*function listar_usuarios_consultas($id_instituicao){

	    $this->db->select('*');	    
	    $this->db->where('id_instituicao',$id_instituicao);
	    $this->db->where('perfil','3');
	    $query = $this->db->get($this->table);
	    
	    if($query->num_rows() >=1 ) return $query->result();
	     
	    return NULL;
	        
	}*/
	
	
	/*function listar_usuarios_financeira($id)
	{
	    
	    $this->db->select('*');
	    $this->db->where('tb_limites_bradesco.id_instituicao',$id);
	    $this->db->join('users', 'users.id = tb_limites_bradesco.id_user');
	    $query = $this->db->get('tb_limites_bradesco');
	     
	    if($query->num_rows() >=1 ) return $query->result();
	    
	    return NULL;
	    
	}*/
	
	/*function insert_new_user_financeira($dados)
	{
	    $this->db->insert ( 'tb_limites_bradesco', $dados );
	    if ($last_id = $this -> db -> insert_id ()) return $last_id;
	
	    return FALSE;
	}*/
	
	/*function delete_user_financeira($id)
	{
	    $this->db->where('id_user',$id);
	    $this->db->delete('tb_limites_bradesco');
	    
	}*/
	
	/*function delete_temp_plano($id)
	{
	    $this->db->where('id_plano',$id);
	    $this->db->delete('tb_planos_temp');
	     
	}*/
	
	/*function delete_plano($id)
	{
	    $this->db->where('id_plano',$id);
	    $this->db->delete('tb_planos_bradesco');
	
	}*/
	
	/*function select_plano($id_instituicao)
	{
	    $this->db->select('*');
	    $this->db->where('id_instituicao',$id_instituicao);
	    $query = $this->db->get('tb_planos_bradesco');
	    
	    if($query->num_rows() ==1 ) return $query->row();
	     
	    return NULL;
	}*/
	
	/*function select_plano_by_id($id)
	{
	    $this->db->select('*');
	    $this->db->where('id_plano',$id);
	    $query = $this->db->get('tb_planos_bradesco');
	     
	    if($query->num_rows() ==1 ) return $query->row();
	
	    return NULL;
	}*/
	
	/*function select_temp_plano($id_instituicao)
	{
	    $this->db->select('*');
	    $this->db->where('id_instituicao',$id_instituicao);
	    $query = $this->db->get('tb_planos_temp');
	     
	    if($query->num_rows() ==1 ) return $query->row();
	
	    return NULL;
	}*/
	
	
	/*function select_temp_plano_by_id($id)
	{
	    $this->db->select('*');
	    $this->db->where('id_plano',$id);
	    $query = $this->db->get('tb_planos_temp');
	
	    if($query->num_rows() ==1 ) return $query->row();
	
	    return NULL;
	}*/
	
	
	
	
	/*function insert_plano($dados)
	{
	    $this->db->insert('tb_planos_bradesco', $dados);
	}*/
	
	/*function insert_plano_historico($dados)
	{
	    $this->db->insert('tb_historico_planos', $dados);
	}*/
	
	
	
	/*function listar_qtd_usuarios_financeira($id)
	{	     
	    $this->db->select('count(*) as total ');
	    $this->db->where('id_instituicao',$id);
	    $this->db->where('perfil',3);
	    $query = $this->db->get($this->table);
	
	    if($query->num_rows() == 1 ) return $query->row();
	     
	    return NULL;	     
	}*/
	
	/*function select_usuario($id)
	{
	    $this->db->select('*');
	    $this->db->where('id_user',$id);
	    $query = $this->db->get('tb_limites_bradesco');
	     
	    if($query->num_rows() ==1 ) return $query->row();
	    
	    return NULL;
	}*/
	
	/*function user_perfil($user_id)
	{
        $this->db->select('perfil');
        $this->db->where('id',$user_id);
        $query = $this->db->get('users');
        if($query->num_rows() == 1) return $query->row();
        else return FALSE;    
	}*/
	
	
	
	/*function bane_usuarios_instituicao($id,$data)
	{
	    $this->db->where ( 'id_instituicao', $id );
	    $this->db->where('perfil',3);
	    if ($this->db->update ( $this->table, $data ))
	        return TRUE;
	    else
	        return FALSE;
	}*/
	
	
	/* $str = $this->db->last_query();
	
	var_dump($str);break; */
		
	/* function exclui_login($id) {	
		$this->db->where('id', $id);
		$this->db->delete( $this->table );
	} 
	
	# VALIDA USUÁRIO
	function valida_login($username) {
		
		$this->db->select('username,estado');
			
		$this->db->where ( 'username', $username ); // COMPARA A VARIÁVEL USERNAME
		
		$query = $this->db->get( $this->table ); // FAZ O SELECT COM OS PARAMETROS ACIMA
		
	
		if ($query->num_rows == 1) { // VERIFICA SE TEM APENAS UMA LINHA NA CONSULTA
			return $query;
		}else{
			return FALSE;
		}
	} 
	
	# retorna nome usuario
	function consulta_usuario($id_usuario)
	{
		$this->db->select('nome');
		$this->db->where ( 'id', $id_usuario );
		$query = $this->db->get ( $this->table );
		return $query;
	}
	
	# retorna cadastro completo
	function consulta_dados_usuario($id_usuario)
	{
		$this->db->where ( 'id', $id_usuario );
		$query = $this->db->get ( $this->table );
		return $query->row();
	}
	
	# retorna login
	function consulta_login($id_usuario)
	{
		$this->db->select('username');
		$this->db->where ( 'id', $id_usuario );
		$query = $this->db->get ( $this->table );
		return $query->row();
	}
	
	function consulta_dados_admin($id_admin)
	{
		$this->db->where ( 'id_admin', $id_admin );
		$query = $this->db->get ( 'tb_cadastro_admin' );
		return $query;
	}
	
	
	
	function update_cad_acesso($data, $id) {
		$this->db->where('id', $id);
		if ($this->db->update( $this->table , $data ))
			return 1;
		else
			return 0;
	}
	function consultar_todos_particulares()
	{
		$this->db->where ( 'perfil', '3' );
		$query = $this->db->get ($this->table);
		return $query->result();
	}
	
	function alterar_senha($data,$login){
		
		$this->db->where ( 'username', $login );
		
		if ($this->db->update ( $this->table, $data ))
			return TRUE;
		else
			return FALSE;

	}
	
	function consulta_email($login){
		$this->db->where ( 'username', $login );
		$query = $this->db->get ($this->table);
		
		
	if ($query->num_rows >= 1) { // VERIFICA SE TEM APENAS UMA LINHA NA CONSULTA
			
		return $query->row()->email;
		}else{
			return 0;
		}		
		
	} */
	
	
}