/**
 * @license Copyright (c) 2003-2017, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

$('textarea.texteditor').ckeditor({
    entities_latin: false,
    skin: 'office2013',
    filebrowserImageBrowseUrl : base_url+'browse/type/image',
    removeDialogTabs: 'link:browser,info:preview'
});

CKEDITOR.editorConfig = function( config )
{
	config.toolbar = 'MyToolbar';
 
	config.toolbar_MyToolbar =
	[
		{ name: 'document', items : [ 'NewPage' ] },
		{ name: 'clipboard', items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
		{ name: 'editing', items : [ 'Find','Replace','-','SelectAll','-','Scayt' ] },
		{ name: 'insert', items : [ 'Image','Youtube','Flash','Table','HorizontalRule','Smiley','SpecialChar','PageBreak','Iframe' ] },
                '/',
		{ name: 'styles', items : [ 'Styles','Format', 'Font','FontSize','TextColor','BGColor','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock' ] },
		{ name: 'basicstyles', items : [ 'Bold','Italic','Underline', 'Strike', 'Subscript', 'Superscript','-','RemoveFormat' ] },
		{ name: 'paragraph', items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote' ] },
		{ name: 'links', items : [ 'Link','Unlink','Anchor' ] },
		{ name: 'tools', items : [ 'Maximize','Source' ] }
	];
	
	config.extraPlugins = "image2,youtube,oembed";
	config.youtube_width = '710';
	config.youtube_responsive = true;
	config.youtube_controls = false;
	config.allowedContent = true;
	config.removePlugins = 'iframe';
	
};


$('textarea.mini-texteditor').ckeditor(
{
    toolbar: 'Basic',
    width: 700
});

/*---------------------------------------------------------
 CKEditor init example
 ---------------------------------------------------------*/
CKEDITOR.on('dialogDefinition', function (event)
{
    var editor = event.editor;
    var dialogDefinition = event.data.definition;
    var dialogName = event.data.name;

    var cleanUpFuncRef = CKEDITOR.tools.addFunction(function ()
    {
        // Do the clean-up of filemanager here (called when an image was selected or cancel was clicked)
        $('#fm-iframe').remove();
        $("body").css("overflow-y", "scroll");
    });

    var tabCount = dialogDefinition.contents.length;
    for (var i = 0; i < tabCount; i++) {
        var browseButton = dialogDefinition.contents[i].get('browse');

        if (browseButton !== null) {
            browseButton.hidden = false;
            browseButton.onClick = function (dialog, i)
            {
                editor._.filebrowserSe = this;
                open_modal()
            }
        }
    }
    
     if ( dialogName == 'image' )
      {
       var linkTab = dialogDefinition.getContents( 'Link' );
         linkTab.remove( 'browse' );

         // Get a reference to the 'Image Info' tab.
        // var infoTab = dialogDefinition.getContents( 'info' );

         // Remove unnecessary widgets from the 'Image Info' tab.         
         //infoTab.remove( 'txtHeight');         
         //infoTab.remove( 'txtWidth' );         
         //infoTab.remove( 'btnLockSizes');      // not working!!!
         //infoTab.remove( 'btnResetSize');      // not working!!!
        // infoTab.remove( 'txtBorder');
        // infoTab.remove( 'txtHSpace');
        // infoTab.remove( 'txtVSpace');
         //infoTab.remove( 'cmbAlign' );
         //infoTab.remove( 'previewImage');
         //infoTab.remove( 'ImagePreviewLoader');   // not working!!!
         //infoTab.remove( 'ImagePreviewBox');      // not working!!!
      }
});
  

function open_modal(){
    var modal = '<div id="fm-bs-modal" class="modal fade">';
	modal += '<div class="modal-dialog">';
	modal += '<div class="modal-content">';
	/*modal += '<div class="close-button">';
	modal += '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
    modal += '</div>';*/
	modal += '<div class="modal-body" style="width: 100%; height: 600px">';
	modal += '<iframe width="100%" height="100%" src="'+base_url+'filemanager/filemanager/browser" frameborder="0" id="fm-iframe" class="fm-modal embed-responsive-item"></iframe>';
	modal += '</div>';
	modal += '</div>';
	modal += '</div>';
    modal += '</div>';
    $("body").append(modal);
    $('#fm-bs-modal').modal('show');
    
    function handlePostMessage(e) {
        var data = e.originalEvent.data;
        if (data.source === 'richfilemanager') {
            var url = data.preview_url.replace(base_url, "");
            url = url.split("?");
            url = '/'+url[0];
            $('.cke_dialog_image_url').find('input').val(url);
            
            $("<img/>").load(function(){
                if(this.width > 710)
                    $('.cke_browser_webkit').find('input:eq(2)').val(710);
                    $('.cke_browser_webkit').find('input:eq(3)').val('');
            }).attr("src", data.preview_url);
            
            $('#fm-bs-modal').modal('hide');
            // remove an event handler
            $(window).off('message', handlePostMessage);
        }
    }
    $(window).on('message', handlePostMessage);
}