<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

$route['default_controller'] = 'auth/login';

/* CONVERSAO */
//Route::any('pagina/(.+)', 'pagina/captura/index/$1');
Route::any('pagina/resultado', 'pagina/captura/resultado/');
Route::any('pagina/(.+)', 'pagina/captura/index/$1');
Route::any('pagina/modelo/resultado', 'pagina/modelo/resultado/');
Route::any('pagina/modelo/(.+)', 'pagina/modelo/index/$1');

//Route::any('apresentacao', 'comdono/sobre');
//Route::any('apresentacao', 'sobre');




Route::any('sobre', 'comdono/sobre');

Route::any('apresentacao/(.+)', 'comdono/apresentacao/index/$1');
Route::any('apresentacao', 'comdono/apresentacao');
Route::any('anunciar', 'comdono/apresentacao/anunciar');
Route::any('comprar', 'comdono/apresentacao/comprar');

/*Route::any('avaliacao/quanto-vale-meu-imovel', 'comdono/avaliacao/index');
Route::any('avaliacao', 'comdono/avaliacao/index');
Route::any('avaliacao/confirmacao/(.+)', 'comdono/avaliacao/confirmacao/$1');
Route::any('avaliacao/resultado/(.+)', 'comdono/avaliacao/resultado/$1');*/

Route::any('avaliacao/quanto-vale-meu-imovel', 'landingpage/avaliacao/index');
Route::any('avaliacao', 'landingpage/avaliacao/index');
Route::any('avaliacao/confirmacao/(.+)', 'landingpage/avaliacao/confirmacao/$1');
Route::any('avaliacao/resultado/(.+)', 'landingpage/avaliacao/resultado/$1');
Route::any('links', 'landingpage/links');
/*Route::any('lp/chega-de-imobiliaria', 'landingpage/imobiliaria');
Route::any('lp/chega-de-imobiliaria/participar', 'landingpage/imobiliaria/participar');
Route::any('lp/chega-de-imobiliaria/resultado', 'landingpage/imobiliaria/resultado');*/

Route::any('lp/financiamento', 'landingpage/financiamento');

Route::any('landingpage/elleven/(.+)', 'landingpage/elleven/index/$1');

Route::any('landingpage/convite/corretor/(.+)', 'landingpage/convite/corretor/$1');
Route::any('landingpage/convite/(.+)', 'landingpage/convite/index/$1');
Route::any('landingpage/convite/resultado/(.+)', 'landingpage/convite/resultado/$1');

Route::any('lp/mae-de-7', 'landingpage/maedesete');

Route::any('landingpage/vendainteligente/(.+)', 'landingpage/vendainteligente/index/$1');
Route::any('lp/venda-inteligente/(.+)', 'landingpage/vendainteligente/index/$1');
Route::any('lp/venda-inteligente', 'landingpage/vendainteligente/index');

Route::any('landingpage/aluguel_inteligente/(.+)', 'landingpage/aluguel_inteligente/index/$1');
Route::any('lp/aluguel-inteligente/(.+)', 'landingpage/aluguel_inteligente/index/$1');
Route::any('lp/aluguel-inteligente', 'landingpage/aluguel_inteligente/index');

Route::any('venda-inteligente/(.+)', 'landingpage/vendainteligente/index/$1');
Route::any('venda-inteligente', 'landingpage/vendainteligente/index/');

Route::any('proposta-inteligente/(.+)', 'landingpage/vendainteligente/index/$1');
Route::any('proposta-inteligente', 'landingpage/vendainteligente/index/');
Route::any('proposta/(.+)', 'landingpage/vendainteligente/proposta/$1');
Route::any('minha_conta/proposta/(.+)', 'landingpage/vendainteligente/proposta/$1');

/*Route::any('incorporadora/empreendimento/(.+)', 'incorporadora/empreendimento/index/$1');*/

/* COMPREI */

Route::any('comprei', 'comprei/landingpage/index/');
Route::any('comprei/resultado', 'comprei/landingpage/resulgado/');



/* EMPRENDIMENTOS */

Route::any('empreendimento/le-premier-residence', 'empreendimento/le_premier/index/');
//Route::any('empreendimento/viva-park-sul', 'empreendimento/viva_park_sul/index');

Route::any('empreendimento/viva-park-sul', 'empreendimento/viva_park_sul/index');
Route::any('empreendimento/viva-park-sul/resultado', 'empreendimento/viva_park_sul/resultado/');

Route::any('lancamento/viva-no-park-sul', 'empreendimento/viva_lancamento/index');
Route::any('lancamento/viva-no-park-sul/resultado', 'empreendimento/viva_lancamento/resultado/');
Route::any('lancamento/viva-no-park-sul/(.+)', 'empreendimento/viva_lancamento/index/$1');

/* FIM EMPRENDIMENTOS */

Route::any('login', 'comdono/login');
Route::any('logout', 'comdono/login/logout');
Route::any('recuperar-senha', 'comdono/login/recuperar_senha');
Route::any('nova-senha', 'comdono/login/nova_senha');

Route::any('ajuda', 'comdono/ajuda');
Route::any('ajuda/(.+)', 'comdono/ajuda/index/$1');
Route::any('termos-de-uso', 'comdono/ajuda/termos');
Route::any('politica-de-privacidade', 'comdono/ajuda/politica');

Route::any('design_system', 'comdono/design_system');
Route::any('design_system/(.+)', 'comdono/design_system/index/$1');

Route::any('trovit', 'marketing/Gerador_xml/trovit');
Route::any('facebook_xml', 'marketing/Gerador_xml/facebook');
Route::any('grupozap', 'marketing/Gerador_xml/grupozap');

Route::any('cadastro', 'comdono/cadastro');
Route::any('precadastro', 'comdono/precadastro');
Route::any('cadastro/imovel', 'comdono/cadastro/imovel');
Route::any('cadastro/imovel/(.+)', 'comdono/cadastro/imovel/$1');
Route::any('cadastro/preview', 'comdono/cadastro/preview');
//Route::any('cadastro/condicoes_comerciais', 'comdono/cadastro/condicoes_comerciais');


Route::any('cadastro/imovel/resultado', 'comdono/cadastro/imovel/resultado');
Route::any('cadastro/imovel_resultado', 'comdono/cadastro/imovel_resultado');
Route::any('cadastro/resultado', 'comdono/cadastro/resultado');
Route::any('cadastro/resultado-imovel', 'comdono/cadastro/resultado_imovel');

Route::any('busca', 'comdono/busca');
Route::any('busca/(.+)', 'comdono/busca');


Route::any('imoveis', 'comdono/imoveis');

Route::any('imovel/(.+)', 'comdono/imovel/index/$1');
Route::any('lancamento/(.+)', 'comdono/busca/lancamento/$1');

Route::any('financiamento/simulacao/(.+)', 'comdono/financiamento/simulacao/$1');
Route::any('financiamento/simulacao_financiamento', 'comdono/financiamento/simulacao_financiamento');
Route::any('financiamento/cadastro/(.+)', 'comdono/financiamento/cadastro/$1');

Route::any('minha_conta', 'minha_conta/resumo/index');
Route::any('minha-conta', 'minha_conta/resumo/index');

Route::any('minha-conta/minhas-vendas/anuncios', 'minha_conta/minhas_vendas/anuncios');
Route::any('minha-conta/minhas-vendas/negociacoes', 'minha_conta/minhas_vendas/negociacoes');
Route::any('minha-conta/minhas-vendas/financiamento', 'minha_conta/minhas_vendas/financiamento');

Route::any('minha-conta/minhas-compras/pesquisas', 'minha_conta/minhas_compras/pesquisas');
Route::any('minha-conta/minhas-compras/negociacoes', 'minha_conta/minhas_compras/negociacoes');
Route::any('minha-conta/minhas-compras/financiamento', 'minha_conta/minhas_compras/financiamento');
Route::any('minha-conta/minhas-compras/simulacao', 'minha_conta/minhas_compras/simulacao');
Route::any('minha-conta/minhas-compras/comparacao', 'minha_conta/minhas_compras/comparacao');

Route::any('minha-conta/favoritos', 'minha_conta/favoritos/index');
Route::any('minha-conta/meus-dados', 'minha_conta/meus_dados/index');
Route::any('minha-conta/dinheiro-na-mao', 'minha_conta/dinheiro_na_mao/index');
Route::any('minha-conta/braco-direito', 'minha_conta/braco_direito/index');

Route::any('links', 'landingpage/links');

Route::any('pesquisa/casa_ou_apartamento', 'pesquisa/index');
Route::any('pesquisa/casa-ou-apartamento', 'pesquisa/index');
Route::any('pesquisa/casa-ou-apartamento/resultado/(.+)', 'pesquisa/pesquisa/resultado/$1');

Route::any('questionario/(.+)', 'pesquisa/questionario/index/$1');
Route::any('questionario-resultado/(.+)', 'pesquisa/questionario/resultado/$1');

Route::any('questionario-resultado-b/(.+)', 'pesquisa/questionario/resultado_ab/$1');
Route::any('questionario-b/(.+)', 'pesquisa/questionario/pesquisa_ab/$1');

/*painel*/
Route::any('painel', 'auth/login');
Route::any('painel/logout', 'auth/logout');
Route::any('dashboard', 'conversao/dashboard');
Route::any('painel/usuarios', 'sistema/usuarios/index');
Route::any('painel/acesso_restrito', 'auth/acesso_restrito');

Route::any('develbarprofiler/(.+)', 'sistema/develbarprofiler/$1');


$route['404_override'] = 'comdono/error_404';
//$route['404_override'] = '';
$route['translate_uri_dashes'] = TRUE;

$route = Route::map($route);