<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Access_Control extends Painel_Controller {
	
	private $perfil;
	protected $module;
	private $class;
	private $method;
	protected $uriModuleClass;
	
	function __construct()
	{
		parent::__construct();
		
		$instance = parent::get_instance();
		
		$this->perfil = $this->session->userdata('perfil');	
		
		$this->module = $instance->router->fetch_module();
		
		$this->class = $instance->router->fetch_class();
		
		$this->method = $instance->router->fetch_method();
		
		$this->uriModuleClass = $this->module.'/'.$this->class.'/';
		
		$this->load->model('sistema/modulos_model');
		
		//Template::set($data);
	}
	
	protected function set_method($method)
	{
		$this->method = $method;
	}
	
	protected function check_permission_method($id_module,$id_section,$id_subsection)
	{
		return $this->modulos_model->get_perfil_access_by_all($this->perfil,$id_module,$id_section,$id_subsection);
	}
	
	protected function get_module()
	{				
		return $this->modulos_model->get_module_by_nickname($this->module);
	}
	
	protected function get_section($id_module)
	{				
		return $this->modulos_model->get_section($id_module,$this->class,$this->method);
	}
	
	protected function get_subsection($id_module)
	{	
		return $this->modulos_model->get_subsection($id_module,$this->class,$this->method);
	}
	
	protected function get_active_modules()
	{
		$secoes = $this->modulos_model->list_active_modules();	
		return $secoes;
	}
	
	protected function consulta_permissoes()
	{		
		$modules = $this->get_active_modules();
		
		$acessos = array();
		
		if($modules!==NULL)
		{
			foreach ($modules as $key=>$module)
			{
				$acessos0[$module->id_module] = $this->modulos_model->list_module_access($module->id_module,$this->perfil);
			}
			
			foreach ($acessos0 as $key=>$modules)
			{
				if($modules != null)
				{
					foreach ($modules as $secao)
					{
						if($secao->id_subsection === NULL)
						{
							$acessos[$key][$secao->id_section][] = $secao->id_action;
						}
						else
						{
							$acessos[$key][$secao->id_section][$secao->id_subsection][] = $secao->id_action;
						}
					}
				}
			}
		}						
		return $acessos;
	}
	
	protected function get_section_permissions($module)
	{
		$section = $this->get_section($module->id_module);
		 
		if ($section !== NULL && $section->active == 1)
		{
			define('TITLE_SECTION', $section->name);
			$permission = $this->check_permission_method($module->id_module,$section->id_section,NULL);
	
			if ($permission === NULL)
			{
				return FALSE;
			}
			else
			{
				$data = array();
				$data['result'] = $section;
				$data['permissions'] = $permission;
				return $data;
			}
		}
		else
		{
			return NULL;
		}
	}
	
	protected function get_subsection_permissions($module)
	{
		$subsection = $this->get_subsection($module->id_module);
	
		if ($subsection !== NULL && $subsection->active == 1)
		{
			$permission = $this->check_permission_method($module->id_module,$subsection->id_section,$subsection->id_subsection);
			 
			if ($permission === NULL)
			{
				return FALSE;
			}
			else
			{
				define('TITLE_SECTION', $subsection->name);
				
				$data = array();
				$data['result'] = $subsection;
				$data['permissions'] = $permission;
				return $data;
			}
		}
		else
		{
			return FALSE;
		}
	}
	
	protected function valida_acesso_boolean($secao,$subSecao)
	{
		if(!isset($this->permissoes[$secao]) || !array_key_exists($subSecao, $this->permissoes[$secao]))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
	 * valida sessão se logado
	 *
	 * @return void
	 */
	protected function valida_sessao()
	{
		$this->load->library('auth/Tank_auth');		
		$tank_auth = new Tank_auth();		
		if($this->perfil == 0 || $this->perfil == 3)
		{
		    redirect(base_url());
		}
		if($tank_auth->is_logged_in() == FALSE){
		    
		    $this->session->set_userdata('uri_destino', $this->uri->uri_string());
			redirect('painel');
		}
		else 
		{ 
			$permissoes = $this->consulta_permissoes();

			Template::set('permissoes',$permissoes);
		}
	}
}









/* End of file Access_Control.php */