<?php (defined('BASEPATH')) OR exit('No direct script access allowed');

class Incorporadora_Controller extends CI_Controller
{
    protected $meuCadastro;
    protected $perfil;
    protected $module;
    protected $class;
    protected $method;

    private $incorporadora;
    private $empreendimentos;
    private $empreendimentosParceiros;
    
    public function __construct() 
    {
        
        
        
        parent::__construct();
        
        /*var_dump($this->db->get('ci_sessions')->result());
        dd($this->session->all_userdata());*/
        
        
        
        redirect(getenv('BASE_CRM'));
        
        
        $this->load->library('template');
        
        $this->load->library('form_validation');
        
        $this->load->library('assets');
        $this->load->library('events');
        $this->load->library('auth/Tank_auth');
        $this->load->library('newsletter/newsletter');
        $this->load->helper('incorporadora/incorporadora');
        
        $IDCADASTRO = $this->session->id_cadastro??0;
        if($this->session->id_simulado != null)
            $IDCADASTRO = $this->session->id_simulado;
        
        define("ID_CADASTRO",$IDCADASTRO);
        
        $instance = parent::get_instance(); 
        $this->module = $instance->router->fetch_module();
        $this->class = $instance->router->fetch_class();
        $this->method = $instance->router->fetch_method();
        
        $this->load->model('administrativo/admin_model');
        
        $this->set_theme('incorporadora');
        
        Template::set_html_custom([], 'incorporadora/theme/breadcrumb', 'breadcrumb');
        
        if(!$this->logado() && ($this->class != "incorporadora" || $this->method != "index" )) 
	       redirect('incorporadora');
        
        if($this->logado()){
            
            Assets::add_module_js('comdono', ['wsConection']);
            Assets::add_module_js('incorporadora', ['push_notification']);
            
            $this->setIncorporadora();
            
            $this->load->library('comdono/notification');
            
            Template::set('notificacoes', $this->cad_model->getNotificacoes([['tipo', 'incorporadora'],['ntf_status <', 2],['id_cadastro', ID_CADASTRO]]));
            Template::set('notificacoesAnteriores', $this->cad_model->getNotificacoes([['tipo', 'incorporadora'],['ntf_status', 2],['id_cadastro', ID_CADASTRO]]));
        }
        
        Assets::add_module_js('incorporadora', array(
            'incorporadora'
        ));
        
    }
    
    //SOMENTE PARA AJAX
    //valida se tem acesso ao empreendimento, deve conter 'id_empreendimento' no POST
    public function validaEmpreendimento()
    {
        $id_empreendimento = $this->input->post('id_empreendimento');
        if($id_empreendimento == null)
                throw new Exception("Acesso Negado");
        $empreendimento = $this->getEmpreendimento($id_empreendimento);
            if($empreendimento == null)
                throw new Exception("Acesso Negado");
    }
    
    public function logado()
    {
        return $this->tank_auth->is_logged_in();
    }
    
    private $arrayBreadcrumb = [];
    
    protected function breadcrumb($nome = null, $uri = null) 
    {
        if($nome == null){
            $uris = $this->uri->segment_array();
            $nome = end($uris);
        }
        
        $nome = ucfirst($nome);
        
        if($uri == null)
            $this->arrayBreadcrumb[] = [$this->uri->uri_string(), $nome];
            //Menu_lib::setBreadcrumb([$this->uri->uri_string(), $nome]);
        else
            $this->arrayBreadcrumb[] = [$uri, $nome];
            //Menu_lib::setBreadcrumb([$this->uriModuleClass.$uri, $nome]);
        
        
        Template::set_html_custom(['arrayBreadcrumb' => $this->arrayBreadcrumb], 'incorporadora/theme/breadcrumb', 'breadcrumb');
        
        return $this;
    }
    
    protected function ini_method($method = NULL) 
    {
        $MEMBRO = $this->getMembro();
        $PERFIL = $MEMBRO->id_funcao;
        if ($method != NULL){
            $this->method = $method;
        }
        
        $acesso = HAcesso::get($this->class, $this->method);
        
        if($acesso != null)
        {
            if(in_array($PERFIL, $acesso->perfis)){
                //TEM ACESSO
            }
            else{
                redirect('incorporadora/acesso_negado');
            }
        }
        
        
        return $this;
    }
    
    protected function set_method($method)
	{
		$this->method = $method;
	}
    
    protected function set_theme($theme = 'painel')
    {
        Template::set_theme($theme,'painel');
        
        $this->load->config('../../../html/themes/'.$theme.'/config.php');
        
        $this->config->item('theme.module');
        $css = $this->config->item('theme.css');
        $js = $this->config->item('theme.js');
        
        $data['header']  = $this->config->item('theme.header');
        $data['topnav']  = $this->config->item('theme.topnav');
        $data['sidebar'] = $this->config->item('theme.sidebar');
        $data['footer']  = $this->config->item('theme.footer');
        $data['footer_scripts']  = $this->config->item('theme.footer_scripts');
        
        if(!empty($css))
        {
            Assets::add_css($css);
        }
        
        if(!empty($js))
        {
            Assets::add_js( $js, 'external', false);
        }
        
        Template::set($data);
    }
    
    protected function getIncorporadora()
	{
	    return $this->incorporadora;
	}
    
    protected function getEmpreendimento($id_empreendimento)
	{
	    $whereEmp[] = ['inc_parceiro_rel_empreendimento.id_incorporadora',$this->getIncorporadora()->id_incorporadora];    
        $whereEmp[] = ['inc_empreendimento.id_empreendimento',$id_empreendimento]; 
        return $this->admin_model->getEmpreendimentoParceiro($whereEmp);
	}
	
    protected function getEmpreendimentos()
	{
	    return $this->empreendimentos;
	}
	
    protected function getMembro()
	{
	    return $this->meuCadastro;
	}
	
	
    protected function getEmpreendimentosParceiros()
    {
        return $this->empreendimentosParceiros;
    }
    protected function setEmpreendimentosParceiros()
    {
        $empreendimentos = $this->admin_model->empreendimentosParceirosDaIncorporadora($this->incorporadora->id_incorporadora??0);
        $meuCadastro = $this->meuCadastro;
        if($meuCadastro->id_funcao > 1){
	        $id_empreendimentos = $meuCadastro->id_empreendimentos;
	        foreach ($empreendimentos as $key=>$empreendimento){
	            $this->setActions($empreendimento);
	            
	            if(!in_array($empreendimento->id_empreendimento,$id_empreendimentos))
                    unset($empreendimentos[$key]);
	        }
	    }
    	    
        $this->empreendimentosParceiros = $empreendimentos;
        Template::set(['empreendimentosParceiros' => $empreendimentos]);
    }
	
	protected function getCliente($whereAgendas = [])
    {
        $MEMBRO = $this->getMembro();
        //foreach ($MEMBRO->id_empreendimentos as $ID)
        //    $whereAgendas['empreendimentos'][] = ['id_destino', $ID];
            
        $empreendimentos = $this->getEmpreendimentos();
        $empreendimentosParceiros = $this->getEmpreendimentosParceiros(); 
        
        if($MEMBRO->id_funcao == 5){
            foreach ($MEMBRO->id_empreendimentos as $ID)
                $whereAgendas['empreendimentos'][] = ['id_destino', $ID];
        }
        else
        {
            foreach ($empreendimentos as $emp){
                $whereAgendas['groupDestino'][] = [['id_destino', $emp->id_empreendimento],['id_parceiro', $emp->id_parceiro]];
                $whereAgendas['groupDestino'][] = [['id_destino', $emp->id_empreendimento],['id_parceiro', 0]];
            }    
            foreach ($empreendimentosParceiros as $emp)  
                $whereAgendas['groupDestino'][] = [['id_destino', $emp->id_empreendimento],['id_parceiro', $emp->id_parceiro]];
        }    
            
            
        if($MEMBRO->id_funcao == 3){
            $extract = ['participantes', 'id_responsavel', ID_CADASTRO];
            $agenda = $this->cad_model->JSON($extract)->getCapAgenda($whereAgendas);
        }
        else
        {
            $agenda = $this->cad_model->getCapAgenda($whereAgendas??[]);
        }
        
        if($agenda == null)
            return null;
        
        $ID        = $agenda->participantes->id_interessado;
        $cliente   = $this->cad_model->getCadastro(['id_cadastro', $ID]);
        
        if($cliente == null)
            return null;
        
        $cliente->empreendimento = $this->cad_model->getEmpreendimento([['id_empreendimento',$agenda->id_destino]]);
        $cliente->responsavel    = $this->cad_model->getMembro(['inc_membros.id_cadastro',$agenda->participantes->id_responsavel]);;
        $agenda->status          = HAgenda::status($agenda->status_agenda);
        $cliente->agenda         = $agenda;
        
        return $cliente;
    }
	
    protected function getClientes()
    {
        $MEMBRO = $this->getMembro();
        
        $empreendimentos = $this->getEmpreendimentos();
        $empreendimentosParceiros = $this->getEmpreendimentosParceiros();
        
        
        if($MEMBRO->id_funcao == 5){
            foreach ($MEMBRO->id_empreendimentos as $ID)
                $whereAgendas['empreendimentos'][] = ['id_destino', $ID];
        }
        else
        {
            foreach ($empreendimentos as $emp){
            $whereAgendas['groupDestino'][] = [['id_destino', $emp->id_empreendimento],['id_parceiro', $emp->id_parceiro]];
            $whereAgendas['groupDestino'][] = [['id_destino', $emp->id_empreendimento],['id_parceiro', 0]];
            }    
            foreach ($empreendimentosParceiros as $emp){
                $whereAgendas['groupDestino'][] = [['id_destino', $emp->id_empreendimento],['id_parceiro', $emp->id_parceiro]];    
            }
        }
        
        
        if($MEMBRO->id_funcao == 3){
            $extract = ['participantes', 'id_responsavel', ID_CADASTRO];
            $agendas = $this->cad_model->JSON($extract)->getCapAgendas($whereAgendas);
        }
        else
        {
            $agendas = $this->cad_model->getCapAgendas($whereAgendas??[]);
        }
        
        $clientes = [];
        foreach ($agendas as $k=>$agenda){
            $ID               = $agenda->participantes->id_interessado;
            
            $clientes[$ID]                 = $this->cad_model->getCadastro(['id_cadastro', $ID]);
            
            if($clientes[$ID] == null){unset($clientes[$ID]); continue;}
            
            $clientes[$ID]->empreendimento = $this->cad_model->getEmpreendimento([['id_empreendimento',$agenda->id_destino]]);
            $clientes[$ID]->responsavel    = $this->cad_model->getMembro(['inc_membros.id_cadastro',$agenda->participantes->id_responsavel]);;
            $agenda->status = HAgenda::status($agenda->status_agenda);
            $clientes[$ID]->agenda         = $agenda;
            $clientes[$ID]->parceiro       = $this->cad_model->getParceiro(['id_parceiro', $agenda->id_parceiro]);
            
        }
        
        return $clientes;
    }
    
	
	protected function setIncorporadora()
	{
	    $incorporadora = $this->cad_model->getIncorporadora([['id_responsavel',ID_CADASTRO]]);
	    
	    
	    if($incorporadora != null){
	        
	        $where[] = ['inc_parceiro_rel_empreendimento.id_incorporadora',$incorporadora->id_incorporadora];    
            $where[] = ['inc_empreendimento.id_incorporadora',$incorporadora->id_incorporadora];    
            $this->db->join('inc_parceiro_rel_empreendimento', 'inc_empreendimento.id_empreendimento = inc_parceiro_rel_empreendimento.id_empreendimento','left');
	        $empreendimentos = $this->cad_model->getEmpreendimentos($where);
	        
	        if(empty($empreendimentos))
	        {
	            $empreendimentos = $this->cad_model->getEmpreendimentos([['id_incorporadora',$incorporadora->id_incorporadora]]);
	            foreach ($empreendimentos as $emp)
	                $emp->id_parceiro = 0;
	        }
	        
	        
	        $empreendimentosAtivos = $this->cad_model->getEmpreendimentos([['id_incorporadora',$incorporadora->id_incorporadora],['emp_status',4],['status_empreendimento',0]]);
	        
	        $meuCadastro = $this->cad_model->getCadUser(['a.id_cadastro',ID_CADASTRO]);
	        $meuCadastro->id_membro = 0;
	        $meuCadastro->id_incorporadora = $incorporadora->id_incorporadora;
	        
	        $meuCadastro->id_empreendimentos = [];
	        foreach ($empreendimentos as $emp)
    	        $meuCadastro->id_empreendimentos[] = $emp->id_empreendimento;
    	        
	        $meuCadastro->id_funcao = 1;
	        $meuCadastro->funcao = HMembro::funcao(1);
	        $meuCadastro->ativo = 1;
	        
	    }
	    else
	    {
	        $incorporadora = $this->cad_model->getIncorporadoraByMembro([['inc_membros.id_cadastro',ID_CADASTRO]]);
	        $meuCadastro   = $this->cad_model->getMembro(['inc_membros.id_cadastro',ID_CADASTRO]);
	        
	        if($incorporadora != null){
	            
	            if($meuCadastro->id_funcao == 5)//Secretaria Geral
	            {
	                foreach ($meuCadastro->id_empreendimentos as $ID)
                        $whereEmpreendimento['empreendimentos'][] = ['inc_empreendimento.id_empreendimento', $ID];
                    $this->db->group_by('inc_empreendimento.id_empreendimento');
                    $this->db->join('inc_parceiro_rel_empreendimento', 'inc_empreendimento.id_empreendimento = inc_parceiro_rel_empreendimento.id_empreendimento','left');
	                $empreendimentos = $this->cad_model->getEmpreendimentos($whereEmpreendimento);
	            }
	            else
	            {
	                $where[] = ['inc_parceiro_rel_empreendimento.id_incorporadora',$incorporadora->id_incorporadora];    
                    $where[] = ['inc_empreendimento.id_incorporadora',$incorporadora->id_incorporadora];    
                    $this->db->join('inc_parceiro_rel_empreendimento', 'inc_empreendimento.id_empreendimento = inc_parceiro_rel_empreendimento.id_empreendimento','left');
        	        $empreendimentos = $this->cad_model->getEmpreendimentos($where);
	            }
	            
    	        
    	        //$empreendimentos = $this->cad_model->getEmpreendimentos([['id_incorporadora',$incorporadora->id_incorporadora??0]]);
    	        $empreendimentosAtivos = $this->cad_model->getEmpreendimentos([['id_incorporadora',$incorporadora->id_incorporadora??0],['emp_status',4],['status_empreendimento',0]]);
	        
	        }
	        
	    }
	    
	    //PARCEIRO
	    
	    
	    
	    /*if($incorporadora == null && $this->class != "acesso_negado"){
            redirect('incorporadora/acesso_negado');
	    }*/
	    
	    if($incorporadora == null)
	    {
	        //$parceiro = $this->cad_model->getParceiroByMembro([['inc_membros.id_cadastro',ID_CADASTRO]]);
	        
	        //if($parceiro == null && $this->class != "acesso_negado")
	        //redirect('incorporadora/acesso_negado/menu');
	      
	            if($this->logado() && ($this->class != "acesso_negado" || $this->method != "index" )) 
	                redirect('incorporadora/acesso_negado');
	        
	        
	        /*Template::set(['tipoAcesso' => 2]);
	        
	        Template::set(['parceiro' => $parceiro]);
	        
	        $incorporadoras = $this->cad_model->getIncorporadorasByMembro([['inc_membros.id_cadastro',ID_CADASTRO]]);
	        if(count($incorporadoras) > 1){
	            
	            // Criar controller/view para escolher a incorporadora onde o corretor vai mexer
	            
	            dd('funcionalidade de multiplas incorporadoras por parceiro');
	            redirect('incorporadora/acesso_negado');
	        }
	        else
	        {
	            
	            $incorporadora = $incorporadoras[0];
	            $empreendimentos = $this->cad_model->getEmpreendimentos([['id_incorporadora',$incorporadora->id_incorporadora??0]]);
    	        $empreendimentosAtivos = $this->cad_model->getEmpreendimentos([['id_incorporadora',$incorporadora->id_incorporadora??0],['emp_status',4],['status_empreendimento',0]]);
    	        $meuCadastro   = $this->cad_model->getMembro(['inc_membros.id_cadastro',ID_CADASTRO]); 
	        }*/
	    }
	    else
	    {
	        define("ID_INCORPORADORA",$incorporadora->id_incorporadora);
	        
	        //Template::set(['tipoAcesso' => 1]);
    	    Template::set(['incorporadora' => $incorporadora]);
    	    Template::set(['membro'        => $meuCadastro]);
    	    
    	    $this->incorporadora = $incorporadora;
    	    $this->meuCadastro = $meuCadastro;
    	    $this->setDadosUsuario();
    	    $this->setEmpreendimentosParceiros();
    	    
    	    if($meuCadastro->id_funcao > 1){
    	        //$id_empreendimentos = json_decode($meuCadastro->id_empreendimentos,true);
    	        $id_empreendimentos = $meuCadastro->id_empreendimentos;
    	        foreach ($empreendimentos as $key=>$empreendimento){
    	            $this->setActions($empreendimento);
    	            
    	            if(!in_array($empreendimento->id_empreendimento,$id_empreendimentos))
                        unset($empreendimentos[$key]);
    	        }
    	    }
    	    
    	    $itemsMenu = false;
    	    if(count($empreendimentosAtivos) > 0){
    	        $itemsMenu = true;
    	    }
    	    
    	    $this->empreendimentos = $empreendimentos;
    	    
    	    Template::set(['empreendimentos' => $empreendimentos]);
    	    Template::set(['empreendimentosAtivos' => $empreendimentosAtivos]);
    	    Template::set(['itemsMenu' => $itemsMenu]);
	    }
	    
	    
	}
	
	private function setActions(&$empreendimento)
    {
        $ID = $empreendimento->id_empreendimento;
        $MEMBRO = $this->getMembro();
        
        //$empreendimento->sub_menu[] = (object)['href' => base_url("incorporadora/empreendimento/estoque/$ID"), 'name'=>'Estoque'];
        
        //if(in_array($MEMBRO->id_funcao, [1,2]))
            //$empreendimento->sub_menu[] = (object)['href' => base_url("incorporadora/empreendimento/marketing/$ID"), 'name'=>'Marketing'];  
            
        $empreendimento->sub_menu[] = (object)['href' => base_url("incorporadora/empreendimento/$ID"), 'name'=>'Detalhes'];
        $empreendimento->sub_menu[] = (object)['href' => base_url("incorporadora/estoque/unidades/$ID"), 'name'=>'Estoque'];
        $empreendimento->sub_menu[] = (object)['href' => base_url("incorporadora/empreendimento/visitas/$ID"), 'name'=>'Visitas'];
        
        
    }
	
	protected function setDadosUsuario()
	{
        if($this->meuCadastro !== NULL)
        {
            $cadastro_user = $this->meuCadastro;
    	    $str = explode(" ", $this->meuCadastro->nome)[0]; 
            if(strlen($str) >= 12){
                $cadastro_user->first_name = substr($str,0,12).'...';
            }
            else{
                $cadastro_user->first_name = explode(" ", $this->meuCadastro->nome)[0]; 
            }
            $urlImgPerfil = $this->meuCadastro->img_perfil_uri.$this->meuCadastro->img_perfil;
            $noImg = base_url("themes/comdono/img/no-img-perfil.png");
            $cadastro_user->urlImgPerfil = ($this->meuCadastro->img_perfil == '')?$noImg:$urlImgPerfil;
            Template::set(['cadastro_user' => $cadastro_user]);
            //Template::setModal('incorporadora/modal/menu_view');
        }
	}
 }