<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cad_model extends CI_Model
{
    
    public static $db;
    public static $CI;
    private static $admins = [1,2,3,4,203];
    private static $perfisAdmins = [1,2];
    
    static protected $model = null;
    
    static function cad_model()
    {
        self::$model = new Cad_model(); 
        return self::$model; 
    }
    function __construct() {
        
        parent::__construct();
        self::$db = &get_instance()->db;
        self::$CI = &get_instance();
        
        $this->load->helper('simple_crypt');
    }
    
    //COMFING GERAL
    static $camposCadastro = [
    	    //'id_cadastro',
    	    'nome', 'telefone', 'telefone_residencial','email', 'cpf','rg','orgao_exp','creci','nacionalidade','naturalidade','estado_civil', 'data_nascimento', 'profissao', 'img_perfil_uri', 'img_perfil', 'end_cep','end_endereco','end_numero','end_complemento','end_bairro','end_cidade','end_estado', 'vendedor', 'comprador','incorporadora', 'termo_uso', 'etapa', 'tipo_contato', 'bd_comdono', 'agendamento', 'melhor_dia', 'melhor_hora', 'qnt_imovel', 'email_activated', 'celular_activated', 'aviso_curtir', 'img_pj', 'img_pj_uri', 'cnpj', 'nome_fantasia', 'descricao_pj','facebook','instagram','data_hora_cadastro','timestamp_cadastro'
        ];
    static $camposUser = [
    	    //'id',
            'id_cadastro',
            'perfil',
            'username',
            'nome',
            'password',
            'email',
            'activated',
            'banned',
            'ban_reason',
            'new_password_key',
            'new_password_requested',
            'new_email',
            'new_email_key',
            'google_secret_key',
            'last_ip',
            'last_login',
            'acessos_sistema',
            'created',
            'modified',
            'activation_key',
        ];
    static $camposImg = [
            'id_img', 'id_img_rel', 'id_cadastro', 'id_imovel', 'uri', 'imagem', 'alt', 'size', 'descricao', 'priority'
        ];
    static $camposSimulacao = [
        'id_simulacao', 'id_imovel', 'id_cad_dono', 'id_cad_interessado', 'status', 'step', 'val_imovel', 'val_entrada', 'val_parcelas', 'val_total', 'meses_financiado', 'taxa', 'tipo_pessoa', 'cpf', 'cnpj', 'servidor_publico', 'imovel_cidade', 'data_nascimento', 'renda_familiar', 'recaptcha', 'comprador_dependente', 'possui_fgts', 'valor_fgts', 'data_simulacao', 'bairro', 'origem_financiamento', 'email_propostas', 'historico_email'
        
        ];
    static $camposImovel = [
            'id_imovel',
            'id_imovel_rel',
            'id_cadastro',
            'contrato_prestacao',
            'key_anuncio',
            'unidade',
            'id_localizacao',
            'step',
            'status',
            'status_lancamento',
            'tipo_empreendimento',
            'lixeira',
            'status_hipoteca',
            'doc_perfil',
            'dados_perfil',
            'dn_nome_nomefantasia',
            'dn_razao_social',
            'dn_telefone',
            'dn_email',
            'dn_cpf_cnpj',
            'dn_img',
            'dn_img_uri',
            'tipo_imovel',
            'lancamento',
            'previsao_entrega',
            'data_lancamento',
            'imovel_novo',
            'importar_planilha',
            'cep',
            'endereco',
            'numero',
            'complemento',
            'bairro',
            'cidade',
            'estado',
            'area_privativa',
            'area_total',
            'longitude',
            'latitude',
            'bairro_lat',
            'bairro_long',
            'quadra_lat',
            'quadra_long',
            'conjunto_lat',
            'conjunto_long',
            'quartos',
            'suites',
            'banheiros',
            'andar',
            'vaga',
            'posicao_sol',
            'num_matricula',
            'chk_termo',
            'imovel_canto',
            'doc_propriedade',
            'doc_planilha',
            'cobertura_privativa',
            'armarios_planejados',
            'armarios_cozinha',
            'box_blindex',
            'quarto_extra_reversivel',
            'ar_condicionado',
            'armarios_embutidos_quarto',
            'armarios_banheiro',
            'quarto_servico',
            'varanda',
            'dce',
            'caracteristicas',
            'academia',
            'elevador',
            'lavanderia',
            'playground',
            'salao_festa',
            'churrasqueira',
            'espaco_gourmet',
            'piscina',
            'quadra_esportiva',
            'sauna',
            'cobertura',
            'estacionamento_rotativo',
            'wifi',
            'porteiro_24h',
            'acessibilidade',
            'val_pretendido',
            'val_public_total',
            'val_public_total_metro',
            'val_condominio',
            'val_iptu',
            'fotos_profissionais',
            'melhor_horario',
            'tour_virtual',
            'visualizacoes',
            'data_hora_imovel',
            'timestamp_imovel'
        ];
    static $camposChat = [
            'id_chat',
            'id_imovel',
            'id_dono',
            'id_interessado',
            'id_cartorio',
            'etapa',
            'chat_status',
            'opcao_recusado'
        ];
    static $campoMsg = [
        'id_msg',
        'id_chat',
        'id_cadastro',
        'tipo',
        'mensagem',
        'lido',
        'dt_msg',
        'dt_lido',
        'status_msg',
        ];
    static $camposBanco = [
        'id_banco', 'banco', 'status_banco', 'logo_ativa', 'logo_inativa', 'entrada_min', 'entrada_max', 'meses_min', 'meses_max'
        ];
    static $camposBancoRelSimulacao = [
        'id_bc_rel', 'id_banco', 'id_simulacao', 'id_cadastro', 'banco_chec', 'agencia', 'conta', 'primeira_parcela', 'ultima_parcela', 'prazo_total', 'valor_total', 'taxa_efetiva', 'cet', 'contatado', 'file_url', 'status_bcrel'
        ];
    static $camposContato = [
            'nome',
            'email',
            'telefone',
            'assunto',
            'mensagem',
            'data_hora'
        ];
    static $camposProposta = [
            'id_proposta', 
            'incorporadora', 
            'logo', 
            'responsavel', 
            'login', 
            'senha', 
            'status', 
            'data_hora_atualizacao', 
            'data_cadastro', 
            'acessos',
            'ultimo_acesso'
        ];
    static $camposPropostaHistorico = [
           'id_hist_proposta',
           'id_proposta',
           'status',
           'data_hora_atualizacao',
           'id_cadastro'
        ];
        
    // monta Para setar no banco ----------------------------------------
    static function montaCadastro($post)    {
        return self::criaArray(self::$camposCadastro,$post);
    }
    static function montaUser($post)    {
        return self::criaArray(self::$camposUser,$post);
    }
    static function montaSimulacao($post)    {
        return self::criaArray(self::$camposSimulacao,$post);
    }
    static function montaBancoRelSimulacao($post)    {
        return self::criaArray(self::$camposBancoRelSimulacao,$post);
    }
    static function montaImovel($post)    {
        $camposImovel = self::$camposImovel;
        unset($camposImovel[0]);
        return self::criaArray($camposImovel,$post);
    }
    static function montaContato($post)    {
        return self::criaArray(self::$camposContato,$post);
    }
    static function montaImg($post)    {
        return self::criaArray(self::$camposImg,$post);
    }
    static function montaProposta($post)    {
        return self::criaArray(self::$camposProposta,$post);
    }
    static function montaPropostaRelHistorico($post)    {
        return self::criaArray(self::$camposPropostaHistorico,$post);
    }
    // mGet para pegar do bando----------------------------------------
    static function mGetImagem($post)    {
        return self::criaObject(self::$camposImg,$post);
    }
    static function mGetImovel($row)    {
       //return self::criaObject(self::$camposImovel,$post);
       return self::cad_model()->getFields('cad_imovel',$row);
    }
    static function mGetChat($post)    {
        $obj = self::criaObject(self::$camposChat,$post);
        $to = array_merge([$obj->id_dono,$obj->id_interessado,$obj->id_cartorio], self::$admins);
        $obj->sessid = simple_crypt( json_encode(['to'=>$to]), 'e' );
        return $obj;
    }
    static function mGetMsg($post)    {
        return self::criaObject(self::$campoMsg,$post);
    }
    static function mGetSimulacao($post)    {
        return self::criaObject(self::$camposSimulacao,$post);
    }
    static function mGetBancoRelSimulacao($post)    {
        return self::criaObject(array_merge(self::$camposBancoRelSimulacao, self::$camposBanco),$post);
    }
    static function mGetProposta($post)    {
        return self::criaObject(self::$camposProposta,$post);
    }
    static function mGetPropostaRelHistorico($post)    {
        return self::criaObject(array_merge(self::$camposPropostaHistorico, self::$camposProposta),$post);
    }
    // ---------------------------------------------------------------------
	static function criaArray($arrayCampos,$post)	{
	    $res = [];
        foreach ($arrayCampos as $key)
        {
            if(isset($post[$key]))
                $res[$key] = trim($post[$key]);
        }
        return $res;
	}
	static function criaObject($arrayCampos,$post)	{
	    $res = [];
        foreach ($arrayCampos as $key)
        {
            if(isset($post->$key))
                $res[$key] = trim($post->$key);
        }
        return (object)$res;
	}
	
	//---------- E S T O Q U E ---------------------------
	//---------- E S T O Q U E ---------------------------
	//---------- E S T O Q U E ---------------------------
	//---------- E S T O Q U E ---------------------------
        //---G E T----------------
            function getEstoqueConfig($where = []){
                return $this->getRow('est_config', $where);
            }
            function getEstoqueConfigs($where = []){
                return $this->getResult('est_config', $where);
            }
            function getEstoqueUnidade($where = []){
                $this->db->select('*, areaPrivativa*precoM2 as valor_venda', FALSE);
                return $this->getRow('est_unidade', $where);
            }
            function getEstoqueUnidades($where = []){
                $this->db->select('*, areaPrivativa*precoM2 as valor_venda', FALSE);
                return $this->getResult('est_unidade', $where);
            }
            function getEstoqueNegociacao($where = []){
                return $this->getRow('est_negociacao', $where);
            }
            function verificaTbVenda($where = []){
                return $this->getRow('est_tabela_vendas', $where);
            }
            function getTbVenda($where = []){
                $data = $this->getRow('est_tabela_vendas', $where);
                
                $this->decodeCampos($data, [
                                        'plantas',
                                        'series_pagamento',
                                        'prazo_financiamento',
                                        'captacao_vista',
                                        'captacao_habitese',
                                        'diferenca_pv',
                                        'minimo_prestacao',
                                        'maximo_intercalacao',
                                        'recursos_proprios_entrega',
                                        'recursos_proprios_pos_entrega',
                                        'recursos_proprios_totais',
                                        'equivalencia_fluxo',]);
                
                return $data;
                
                
            }
            function getTbVendas($where = []){
                return $this->getResult('est_tabela_vendas', $where);
            }
            function getPlantas($where = []){
                $data = $this->getResult('est_planta', $where);
                foreach($data as $d)
                    $this->decodeCampos($d, ['imagens']);
                
                return $data;
            }
            
            function getPlanta($where = []){
                $data = $this->getRow('est_planta', $where);
                $this->decodeCampos($data, ['imagens']);
                
                return $data;
            }
            
            function getHistoricosUnidade($where = []){
                $this->db->order_by('data_acao','DESC');
                return $this->getResult('est_historico_unidade', $where);
            }
            
        //---I N S E R T----------
            public function insertEstoqueUnidade($data){
                return $this->insert('est_unidade', $data);
            }
            public function insertEstoquePlanta($data){
                return $this->insert('est_planta', $data);
            }
            public function insertEstoqueConfig($data){
                return $this->insert('est_config', $data);
            }
            public function insertEstoqueNegociacao($data){
                return $this->insert('est_negociacao', $data);
            }
            public function insertTbVenda($data){
                return $this->insert('est_tabela_vendas', $data);
            }
            public function insertHistoricoUnidade($data){
                return $this->insert('est_historico_unidade', $data);
            }
            
        //---U P D A T E----------
            public function updateEstoqueUnidade($id, $data){
                $this->db->where('id_unidade', $id);
                return $this->update('est_unidade', $data);
            }
            public function updateEstoqueConfig($id, $data){
                $this->db->where('id_config', $id);
                return $this->update('est_config', $data);
            }
            public function updateTbVenda($id, $data){
                $this->db->where('id_tabela_venda', $id);
                return $this->update('est_tabela_vendas', $data);
            }
            public function updateEstoqueNegociacao($id, $data){
                $this->db->where('id_negociacao ', $id);
                return $this->update('est_negociacao', $data);
            }
            public function updateHistoricoUnidade($id, $data){
                $this->db->where('id_historico_unidade  ', $id);
                return $this->update('est_historico_unidade', $data);
            }
    //---FIM---- A G E N D A ---------------------------
    //---FIM---- A G E N D A ---------------------------
    //---FIM---- A G E N D A ---------------------------
    //---FIM---- A G E N D A ---------------------------
	
	function decodeCampos(&$data, $campos)
    {
        foreach ($campos  as $campo){
            if(($data->$campo??'') != '')
                $data->$campo = json_decode($data->$campo);
        }
    }
	
	
    
	//---------- A G E N D A ---------------------------
	//---------- A G E N D A ---------------------------
	//---------- A G E N D A ---------------------------
	//---------- A G E N D A ---------------------------
        //---G E T----------------
            function getVisita($where = []){
                //$this->db->join('age_agenda', 'age_agenda.id_agenda = age_visita.id_agenda');
                return $this->getRow('age_visita', $where);
            }
            function getVisitas($where = []){
                $this->db->join('age_agenda', 'age_agenda.id_agenda = age_visita.id_agenda');
                return $this->getResult('age_visita', $where);
            }
            function getCapVisitas($where = []){
                $where[] = ['age_agenda.origem', 4];
                $this->db->join('age_agenda', 'age_agenda.id_agenda = age_visita.id_agenda');
                $this->db->join('cad_captura', 'cad_captura.id_captura = age_agenda.id_origem');
                $return = $this->getResult('age_visita', $where);
                foreach ($return as $row)
                    $row->participantes = json_decode($row->participantes);
                return $return;
                
                
            }
            /*function getAgenda($where = []){
                $return = $this->getRow('age_agenda', $where);
                $return->participantes = json_decode($return->participantes);
                return $return;
        	}*/
        	function getAgenda($where = []){
                $return = $this->getRow('age_agenda', $where);
                if($return != NULL)
                    $return->participantes = json_decode($return->participantes);
                return $return;
        	}
        	function getCapAgenda($where = []){
                
                $where[] = ['origem', 4];
                $this->db->order_by('data_hora_agendamento','asc');
                $this->db->join('cad_captura', 'cad_captura.id_captura = age_agenda.id_origem');
                $return = $this->getRow('age_agenda', $where);
                if($return != NULL)
                    $return->participantes = json_decode($return->participantes);
                return $return;
    	    }
            function getCapAgendas($where = []){
                
                $where[] = ['origem', 4];
                $this->db->order_by('data_hora_agendamento','asc');
                $this->db->join('cad_captura', 'cad_captura.id_captura = age_agenda.id_origem');
                $return = $this->getResult('age_agenda', $where);
                foreach ($return as $row)
                    $row->participantes = json_decode($row->participantes);
                return $return;
    	    }
            function getAgendas($where = []){
                $this->db->order_by('data_hora_agendamento','asc');
                $return = $this->getResult('age_agenda', $where);
                foreach ($return as $row)
                    $row->participantes = json_decode($row->participantes);
                return $return;
    	    }
            function getAgendaHistorico($where = []){
                $this->db->order_by('datetime','desc');
                return $this->getResult('age_agenda_historico', $where);
    	    }
        //---I N S E R T----------
            public function insertAgenda($data){
                
                $id_agenda = $this->insert('age_agenda', $data);
                $this->insertAgendaHistorico($id_agenda);
                return $id_agenda;
            }
            public function insertAgendaHistorico($id_agenda){
                
                $agenda = $this->getRow('age_agenda',['id_agenda', $id_agenda]);
                $data = (array)$agenda;
                $data['id_agenda'] = $id_agenda;
                $data['id_cadastro'] = $this->session->id_cadastro??0;
                return $this->insert('age_agenda_historico', $data);
            }
            public function insertVisita($data){
            return $this->insert('age_visita', $data);
        }
        //---U P D A T E----------
            public function updateAgenda($id_agenda, $post){
                $this->db->where('id_agenda', $id_agenda);
                $res = $this->update('age_agenda', $post);
                $this->insertAgendaHistorico($id_agenda);
                return $res;
            }
            public function updateVisita($id_visita, $post){
            $this->db->where('id_visita', $id_visita);
            return $this->update('age_visita', $post);
        }
    //---FIM---- A G E N D A ---------------------------
    //---FIM---- A G E N D A ---------------------------
    //---FIM---- A G E N D A ---------------------------
    //---FIM---- A G E N D A ---------------------------
    
    
    function getArquivo($where = []){
	    return $this->getRow('nwl_arquivo', $where);
	}

    public function insertArquivo($data){
        return $this->insert('nwl_arquivo', $data);
    }
    //---------- I N C O R P O R A C A O ---------------------------
    //---------- I N C O R P O R A C A O ---------------------------
    //---------- I N C O R P O R A C A O ---------------------------
    //---------- I N C O R P O R A C A O ---------------------------
        //---G E T--------------
            
            function getParceirosRelIncorporadora($where = []){
                $this->db->join('inc_parceiro', 'inc_parceiro.id_parceiro = inc_parceiro_rel_incorporadora.id_parceiro');
                return $this->getResult('inc_parceiro_rel_incorporadora', $where);
            }
        
            function getParceirosRelEmpreendimento($where = []){
                $this->db->join('inc_parceiro', 'inc_parceiro.id_parceiro = inc_parceiro_rel_empreendimento.id_parceiro');
                return $this->getResult('inc_parceiro_rel_empreendimento', $where);
            }
            function getEmpreendimentosRelParceiro($where = []){
                $this->db->join('inc_empreendimento', 'inc_empreendimento.id_empreendimento = inc_parceiro_rel_empreendimento.id_empreendimento');
                return $this->getResult('inc_parceiro_rel_empreendimento', $where);
            }
        
            function getSumValoresImovel($where = []){
                $this->db->select('SUM(val_pretendido) as valor');
        	    return $this->getRow('cad_imovel as a', $where);
        	}
            function getSumValoresMidia($where = []){
                $this->db->select('midia, SUM(valor) as valor');
                $this->db->group_by('midia');
        	    return $this->getResult('inc_investimento_midias', $where);
        	}
            function getIncorporadora($where = []){
        	    return $this->getRow('inc_incorporadora', $where);
        	}
        	function getIncorporadoras($where = []){
        	    return $this->getResult('inc_incorporadora', $where);
        	}
        	function getIncorporadoraByMembro($where = []){
        	    
        	    $this->db->join('inc_membros', 'inc_membros.id_incorporadora = inc_incorporadora.id_incorporadora');
        	    return $this->getRow('inc_incorporadora', $where);
        	}
        	
        	function getIncorporadorasByMembro($where = [])
        	{
        	    $membro = $this->getMembro($where);
        	    $incorporadoras = [];
        	    if(is_array($membro->id_incorporadoras))
        	    {
        	        foreach ($membro->id_incorporadoras as $ID)
        	        {
        	            $incorporadoras[] = $this->getIncorporadora(['id_incorporadora',$ID]);
        	        }
        	    }
        	    return $incorporadoras;
        	}
        	
        	function getParceiroByMembro($where = []){
        	    $this->db->join('inc_membros', 'inc_membros.id_parceiro = inc_parceiro.id_parceiro');
        	    return $this->getRow('inc_parceiro', $where);
        	}
        	
            function getEmpreendimento($where = []){
        	    return $this->getRow('inc_empreendimento', $where);
        	}
        	function getEmpreendimentos($where = []){
        	    return $this->getResult('inc_empreendimento', $where);
        	}
        	function getLpConfig($where = []){
        	    return $this->getRow('lp_config', $where);
        	}
        	function getInvestimentos($where = []){
        	    return $this->getResult('inc_investimento_midias', $where);
        	}
        	function getDiferenciais($where = []){
        	    $this->db->order_by("ordem","ASC");
        	    return $this->getResult('lp_diferenciais', $where);
        	}
        	function getUnidades($where = []){
        	    $this->db->order_by("ordem","ASC");
        	    return $this->getResult('lp_unidades', $where);
        	}
        	function getComodidades($where = []){
        	    $this->db->order_by("ordem","ASC");
        	    return $this->getResult('lp_comodidades', $where);
        	}
        	function getPlano($where = []){
        	    return $this->getRow('inc_planos', $where);
        	}
        	function getPlanos($where = []){
        	    return $this->getResult('inc_planos', $where);
        	}
        	function getProposta($where = []){
        	    return $this->getRow('inc_propostas', $where);
        	}
        	function getPropostas($where = []){
        	    return $this->getResult('inc_propostas', $where);
            }
            function getPropostaSinal($where = []){
                return $this->getRow('ngc_proposta', $where);
            }
            function getPagamentoSinal($where = []){
        	    return $this->getRow('ngc_proposta_recibo', $where);
            }
            function getSociosNegociacaoPF($where = []){
                $this->db->join('ngc_ficha_pfisica as pf', 'ngc_ficha_socios.id_ficha_pf = pf.id_ficha_pf');
                $this->db->join('cad_cadastro as c', 'pf.id_cadastro = c.id_cadastro');
        	    return $this->getResult('ngc_ficha_socios', $where);
            }
            
            function getMembro($where = []){
                $this->db->join('sys_users', 'sys_users.id_cadastro = inc_membro_rel_acesso.id_cadastro');
                $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = inc_membro_rel_acesso.id_cadastro');
        	    $result = $this->getRow('inc_membro_rel_acesso', $where);
        	    if($result != null){
        	        $this->decodeCampos($result, [
                                        'id_empreendimentos',
                                        'id_incorporadoras',
                                        'id_parceiros']
                                        );
                                        
        	        $result->id_funcao = $result->id_perfil;
        	        $result->funcao = HMembro::funcao($result->id_perfil);
        	    }
        	    return $result;
            }
            function getMembros($where = []){
                $this->db->join('sys_users', 'sys_users.id_cadastro = inc_membro_rel_acesso.id_cadastro');
                $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = inc_membro_rel_acesso.id_cadastro');
                
                
                $membros = $this->getResult('inc_membro_rel_acesso', $where);
                
                foreach ($membros as $membro){
                    
                    $this->decodeCampos($membro, [
                                        'id_empreendimentos',
                                        'id_incorporadoras',
                                        'id_parceiros']
                                        );
                    //$wEmp['emps'] = [];
                    //foreach ($membro->id_empreendimentos as $IDEMP)
                    //    $wEmp['emps'][] = ['id_empreendimento', $IDEMP];
                    //$membro->empreendimentos = $this->getEmpreendimentos($wEmp);
                    
                    $membro->id_funcao = $membro->id_perfil;
                    $membro->funcao = HMembro::funcao($membro->id_funcao);
                }
        	    return $membros;
            }
            function getEquipes($where = []){
        	    $equipes = $this->getResult('inc_equipe', $where);
        	    
        	    foreach ($equipes as $equipe){
                    
                    $this->decodeCampos($equipe, [
                                        'id_empreendimentos',
                                        'id_cadastros']
                                        );
                }
                return $equipes;
            }
            function getEquipe($where = []){
        	    $equipe = $this->getRow('inc_equipe', $where);
        	    
                $this->decodeCampos($equipe, [
                                    'id_empreendimentos',
                                    'id_cadastros']
                                    );
                
                return $equipe;
            }
            function getNegociacao($where = []){
        	    return $this->getRow('ngc_negociacoes', $where);
            }
            function getCapNegociacoes($where = []){
                $where[] = ['age_agenda.origem', 4];
                $this->db->join('age_visita', 'ngc_negociacoes.id_visita = age_visita.id_visita');
                $this->db->join('age_agenda', 'age_agenda.id_agenda = age_visita.id_agenda');
                $this->db->join('cad_captura', 'cad_captura.id_captura = age_agenda.id_origem');
                //$this->db->join('age_agenda', 'age_agenda.id_agenda = ngc_negociacoes.id_agenda');
        	    return $this->getResult('ngc_negociacoes', $where);
            }
            function getNegociacoes($where = []){
                //$this->db->join('age_agenda', 'age_agenda.id_agenda = ngc_negociacoes.id_agenda');
        	    return $this->getResult('ngc_negociacoes', $where);
            }
            function getPreReserva($where = []){
                return $this->getRow('ngc_pre_reserva', $where);
            }
            function getPreReservas($where = []){
                return $this->getResult('ngc_pre_reserva', $where);
            }
            function getFichaPF($where = []){
                return $this->getRow('ngc_ficha_pfisica', $where);
            }
            function getFichaPJ($where = []){
                return $this->getRow('ngc_ficha_pjuridica',$where);
            }
            function getParceiro($where = []){
        	    return $this->getRow('inc_parceiro', $where);
        	}
        	function getParceiros($where = []){
        	    return $this->getResult('inc_parceiro', $where);
        	}
        	function getEvento($where = []){
        	    return $this->getRow('inc_evento', $where);
        	}
        	function getEventos($where = []){
        	    $this->db->join('inc_empreendimento', 'inc_empreendimento.id_empreendimento = inc_evento.id_empreendimento');
        	    return $this->getResult('inc_evento', $where);
        	}
        	public function getLogsWhatsapp($where = []){
                return $this->getResult('log_whatsapp', $where);
            }
            public function getLogWhatsapp($where = []){
                return $this->getRow('log_whatsapp', $where);
            }
            public function getLogsWhatsappConfig($where = []){
                return $this->getResult('log_whatsapp_config', $where);
            }
            public function getLogWhatsappConfig($where = []){
                return $this->getRow('log_whatsapp_config', $where);
            }
            
            function getMembroAcesso($where = []){
        	    return $this->getRow('inc_membro_rel_acesso', $where);
        	}
            function getMembroAcessos($where = []){
        	    return $this->getResult('inc_membro_rel_acesso', $where);
        	}
        	
        	
        //---I N S E R T--------------
            public function insertEmpreendimento($data){
                return $this->insert('inc_empreendimento', $data);
            }
            public function insertConfigLp($data){
                return $this->insert('lp_config', $data);
            }
            public function insertInvestimento($data){
                return $this->insert('inc_investimento_midias', $data);
            }
            public function insertUnidade($data){
                return $this->insert('lp_unidades', $data);
            }
            public function insertDiferencial($data){
                return $this->insert('lp_diferenciais', $data);
            }
            public function insertComodidade($data){
                return $this->insert('lp_comodidades', $data);
            }
            public function insertMembro($data){
                //$data['id_empreendimentos'] = is_array($data['id_empreendimentos'])? json_encode($data['id_empreendimentos']):$data['id_empreendimentos'];
                return $this->insert('inc_membro_rel_acesso', $data);
            }
            public function insertEquipe($data){
                return $this->insert('inc_equipe', $data);
            }
            public function insertNegociacao($data){
                return $this->insert('ngc_negociacoes', $data);
            }
            public function insertPreReserva($data){
                return $this->insert('ngc_pre_reserva', $data);
        	}
        	public function insertFichaPF($data){
        	    return $this->insert('ngc_ficha_pfisica', $data);
        	}
        	public function insertFichaPJ($data){
        	    return $this->insert('ngc_ficha_pjuridica', $data);
        	}
        	public function insere_proposta($data){
        	    return $this->insert('ngc_proposta', $data);
        	}
        	public function insere_recibo($data){
        	    return $this->insert('ngc_proposta_recibo', $data);
        	}
        	public function insertSocio($data){
        	    return $this->insert('ngc_ficha_socios', $data);
        	}
        	public function insertParceiro($data){
        	    return $this->insert('inc_parceiro', $data);
        	}
        	public function insertEvento($data){
        	    return $this->insert('inc_evento', $data);
        	}
        	public function insertLogWhatsapp($data){
                return $this->insert('log_whatsapp', $data);
            }
            public function insertLogWhatsappConfig($data){
                return $this->insert('log_whatsapp_config', $data);
            }
        	
        //---U P D A T E----------------
            public function updateIncorporadora($id_incorporadora, $data){
                $this->db->where('id_incorporadora', $id_incorporadora);
                return $this->update('inc_incorporadora', $data);
            }
            public function updateEmpreendimento($id_empreendimento, $data){
                $this->db->where('id_empreendimento', $id_empreendimento);
                return $this->update('inc_empreendimento', $data);
            }
            public function updateConfigLp($id_config, $post){
                $this->db->where('id_config', $id_config);
                return $this->update('lp_config', $post);
            }
            public function updateInvestimento($id_empreendimento, $post){
                $this->db->where('id_empreendimento', $id_empreendimento);
                return $this->update('inc_investimento_midias', $post);
            }
            public function updateUnidade($id_unidade, $post){
                $this->db->where('id_unidade', $id_unidade);
                return $this->update('lp_unidades', $post);
            }
            public function updateDiferencial($id_diferencial, $post){
                $this->db->where('id_diferencial', $id_diferencial);
                return $this->update('lp_diferenciais', $post);
            }
            public function updateComodidade($id_comodidade, $post){
                $this->db->where('id_comodidade', $id_comodidade);
                return $this->update('lp_comodidades', $post);
            }
            function updatePreReserva($id,$post){
        	    $this->db->where('id_pre_reserva', $id);
        	    return $this->update('ngc_pre_reserva', $post);
        	}
            public function updateNegociacao($id_negociacao, $post){
                $this->db->where('id_negociacao', $id_negociacao);
                return $this->update('ngc_negociacoes', $post);
            }
            public function updateMembro($where = [], $data){
                if(!is_array($where))
                    return null;
                $this->where($where);
                //$data['id_empreendimentos'] = is_array($data['id_empreendimentos'])? json_encode($data['id_empreendimentos']):$data['id_empreendimentos'];
                return $this->update('inc_membro_rel_acesso', $data);
            }
            public function updateEquipe($id_equipe , $data){
                $this->db->where('id_equipe ', $id_equipe);
                return $this->update('inc_equipe', $data);
            }
            public function updateParceiro($id_parceiro, $data){
                $this->db->where('id_parceiro', $id_parceiro);
                return $this->update('inc_parceiro', $data);
            }
            public function updateEvento($id_evento, $data){
                $this->db->where('id_evento', $id_evento);
                return $this->update('inc_evento', $data);
            }
            
            public function updateLogWhatsappConfig($id_config, $post){
                $this->db->where('id_config', $id_config);
                return $this->update('log_whatsapp_config', $post);
            }
        //--- D E L E T E ----------------
            public function deleteMembro($where){
                return $this->delete('inc_membro_rel_acesso', $where);
            }
            public function deleteEquipe($where){
                return $this->delete('inc_equipe', $where);
            }
    //---FIM---- I N C O R P O R A C A O ---------------------------
    //---FIM---- I N C O R P O R A C A O ---------------------------
    //---FIM---- I N C O R P O R A C A O ---------------------------
    //---FIM---- I N C O R P O R A C A O ---------------------------
    
	
	
	//---------- N O T I F I C A C A O ---------------------------
	//---------- N O T I F I C A C A O ---------------------------
	//---------- N O T I F I C A C A O ---------------------------
	//---------- N O T I F I C A C A O ---------------------------
        //---G E T----------------
            function getMsgNtf($where = []){
                return $this->getRow('ntf_msg', $where);
            }
            function getNotificacao($where = []){
                return $this->getRow('ntf_notificacao', $where);
            }
            function getNotificacoes($where = []){
                return $this->getResult('ntf_notificacao', $where);
            }
        //---I N S E R T----------
            public function insertNotificacao($data){
                return $this->insert('ntf_notificacao', $data);
            }
        //---U P D A T E----------
            public function updateNotificacao($id_notificacao, $post){
                $this->db->where('id_notificacao', $id_notificacao);
                return $this->update('ntf_notificacao', $post);
            }
    //---FIM---- N O T I F I C A C A O ---------------------------
    //---FIM---- N O T I F I C A C A O ---------------------------
    //---FIM---- N O T I F I C A C A O ---------------------------
    //---FIM---- N O T I F I C A C A O ---------------------------
	
	
	//---------- A T E N D I M E N T O ---------------------------
	//---------- A T E N D I M E N T O ---------------------------
	//---------- A T E N D I M E N T O ---------------------------
	
    //---I N S E R T----------
    public function insertInteresse($data){
        return $this->insert('cad_interesse', $data);
    }
    public function insertBairroInteresse($data){
        return $this->insert('cad_interesse_bairros', $data);
    }
    public function insertReclamacao($data){
        return $this->insert('cad_atendimento_reclamacao', $data);
    }
    public function insertSugestao($data){
        return $this->insert('cad_atendimento_feedback', $data);
    }
    public function insertAtendDescricao($data){
        return $this->insert('cad_atendimento_descricao', $data);
    }
    public function insertTipoEmpInteresse($data){
        return $this->insert('cad_interesse_tipo_emp', $data);
    }
    
    //---G E T----------------
    public function getBairrosInteresse($where = []){
        return $this->getResult('cad_interesse_bairros', $where);
    }
    
    public function getInteresse($where = []){
        return $this->getRow('cad_interesse', $where);
    }
    
    public function getInteresses($where = []){
        return $this->getResult('cad_interesse', $where);
    }
    public function getAtendDescricao($where = []){
        return $this->getRow('cad_atendimento_descricao', $where);
    }
    public function getAtendDescricoes($where = []){
        return $this->getResult('cad_atendimento_descricao', $where);
    }
	public function getTiposEmpInteresse($where = []){
        return $this->getResult('cad_interesse_tipo_emp', $where);
    }
	
	//---U P D A T E ---------
    public function updateInteresse($id_evento, $data){
        $this->db->where('id_interesse', $id_evento);
        return $this->update('cad_interesse', $data);
    }
	public function updateAtendDescricao($id_descricao, $data){
        $this->db->where('id_descricao', $id_descricao);
        return $this->update('cad_atendimento_descricao', $data);
    }
    //---D E L E T E ----------
    public function deleteInteresseBairros($where){
        return $this->delete('cad_interesse_bairros', $where);
    }
    public function deleteTipoEmpInteresse($where){
        return $this->delete('cad_interesse_tipo_emp', $where);
    }
	
	//---FIM---- A T E N D I M E N T O ---------------------------
	//---FIM---- A T E N D I M E N T O ---------------------------
	//---FIM---- A T E N D I M E N T O ---------------------------
	
	
	// modelo antigo NOTIFICATION------------------------------------------------------
	    
    function getNotifications()
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('ntf_status <', 2);
	    $query = $this->db->get('ntf_notificacao');
	    if ($query->num_rows() > 0)
			return $query->result();
		return [];
	}
    function insertNotification($data)
	{
	    $this->db->insert('ntf_notificacao', $data);
	    return  $this->db->insert_id();
	}
    function updateNotification($arrayWhere,$data)
	{
	    foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
	    
	    
	    return $this->db->update('ntf_notificacao', $data);
	}
    
	// FIM modelo antigo NOTIFICATION------------------------------------------------------
	
	
	
	
	
	// G E T -----------------------------------------------------
	
	function getContatos($where = []){
	    return $this->getResult('cad_contato', $where);
	}
	
	//static
	
	
	static function idAdmin($id)
	{
	    $r = false;     
	    if(in_array($id,self::$admins))
	        $r = true;
	    return $r;
	}
	static function perfilAdmin($id)
	{
	    $r = false;     
	    if(in_array($id,self::$perfisAdmins))
	        $r = true;
	    return $r;
	    
	}
	static function _getCadastro($arrayWhere = [])
	{
	    foreach ($arrayWhere as $key=>$val)
	        self::$db->where($key, $val);
	    $query = self::$db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return [];
	}
	static function getCadastroByEmail($email, $diferente = null)
	{
	    if($diferente != null)
	        self::$db->where('id_cadastro !=', $diferente);
	    
	    
	    self::$db->where('LOWER(email)=', strtolower($email));
	    $query = self::$db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return [];
	}
	static function getSysUserByEmail($email)
	{
	    self::$db->where('LOWER(email)=', strtolower($email));
	    $query = self::$db->get('sys_users');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	//no static
	function getSelectBusca() 
    {
    
        $this->db->select('bairro, cidade, estado, COUNT(*) as qnt_bairro');
        $this->db->where('bairro !=', '');
        
        $this->db->where('status', 3);
        $this->db->where('lixeira', 0);
        //$this->db->where('lixeira <', 2);
        $this->db->group_by('bairro'); 
        //$this->db->order_by('qnt_bairro', 'desc'); 
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows()) {
            $result = $query->result();
            $select = [];
            
            return $result;
        }
        return [];
    }
    function get_cadastro($arrayWhere = [], $id_cadastro = null) 
    {
        if($id_cadastro === null)
            $id_cadastro = $this->session->id_cadastro;
        
        if($id_cadastro !== false)
            $this->db->where('id_cadastro', $id_cadastro);
            
	    foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
	        
	    $query = $this->db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	function get_user_cad()
	{
        $id_cadastro = $this->session->id_cadastro;
        $this->db->where('id_cadastro', $id_cadastro);
            
	    $query = $this->db->get('sys_users');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	
	function getCadUser($where = [])
	{
	    $this->db->join('cad_cadastro as b', 'b.id_cadastro = a.id_cadastro');
	    return $this->getRow('sys_users as a', $where);
	}
	
	function getCadUsers($where = [])
	{
	    //$this->db->select('*, b.nome as nome');
	    $this->where($where, []);
	    $this->db->join('cad_cadastro as b', 'b.id_cadastro = a.id_cadastro');
	    $query = $this->db->get('sys_users as a');
	    if ($query->num_rows() > 0)
			return $query->result();
		return [];
	}
	function getImovel($arrayWhere = []) 
    {
        foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
    
            //$this->db->join('cad_localizacao', 'cad_localizacao.id_localizacao = cad_imovel.id_localizacao','left');
            //$this->db->join('cad_img', 'cad_img.id_imovel = cad_imovel.id_imovel','left');
        
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows()) return $query->row();
        return null;
    }
    function getImgsImovel($id_imovel) 
    {
        $this->db->where('id_imovel', $id_imovel);
        $this->db->order_by('priority'); 
        $query = $this->db->get('cad_img');
        
        if ($query->num_rows()) return $query->result();
        return [];
    }
    function getImovelCad($arrayWhere = [], $id_cadastro = null) 
    {
        if($id_cadastro == null)
            $id_cadastro = $this->session->id_cadastro;
        
        $this->db->where('cad_imovel.id_cadastro', $id_cadastro);
        
        foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
        
        //$this->db->join('cad_localizacao', 'cad_localizacao.id_localizacao = cad_imovel.id_localizacao','left');
        //$this->db->join('cad_img', 'cad_img.id_imovel = cad_imovel.id_imovel','left');
        
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows()) return $query->row();
        return null;
    }
	function getImoveis($arrayWhere = []) 
    {
        foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
        
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows() > 0) 
            return $query->result();
        return [];
    }
    
    function get_imoveis($where = []) 
    {
        return $this->getResult('cad_imovel', $where);
    }
    
    function getImoveisImg($where = [], $or_where = []) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        foreach ($or_where as $key=>$val)
            $this->db->or_where($key, $val);
            
        $this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        $query = $this->db->get('cad_imovel as a');
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imoveis = [];
            $imagens = [];
            foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                $imoveis[$id] = self::mGetImovel($obj);
                if( $obj->id_img == '')
                    $imagens[$id] = [];
                else 
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imoveis[$id]->imagens = $imagens[$id];
            }
            return $imoveis;
        }
        return [];
    }
    function getSimulacaoFinanciamento($where = [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $this->db->select('*, a.id_simulacao as id_simulacao');
        $this->db->join('fnc_banco_rel_simulacao as b', 'b.id_simulacao = a.id_simulacao','left');
        $this->db->join('fnc_bancos as c', 'c.id_banco = b.id_banco','left');
        
        $query = $this->db->get('fnc_simulacao as a');
        
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            
            $simulacao = [];
            $bancos = [];
            foreach($result as $obj)
            {
                $id = $obj->id_simulacao;
                $simulacao = self::mGetSimulacao($obj);
                
                if( $obj->id_banco == '')
                    $bancos[$id] = [];
                else 
                     $bancos[$id][] = self::mGetBancoRelSimulacao($obj);
                
                $simulacao->bancos = $bancos[$id];
            }
            return $simulacao;
        }
        return null;
    }
    function getSimulacoesFinanciamento($where = [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $this->db->select('*, a.id_simulacao as id_simulacao');
        $this->db->join('fnc_banco_rel_simulacao as b', 'b.id_simulacao = a.id_simulacao','left');
        $this->db->join('fnc_bancos as c', 'c.id_banco = b.id_banco','left');
        
        
        $query = $this->db->get('fnc_simulacao as a');
        
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            
            $simulacao = [];
            $bancos = [];
            foreach($result as $obj)
            {
                $id = $obj->id_simulacao;
                $simulacao[$id] = self::mGetSimulacao($obj);
                
                if( $obj->id_banco == '')
                    $bancos[$id] = [];
                else 
                     $bancos[$id][] = self::mGetBancoRelSimulacao($obj);
                
                $simulacao[$id]->bancos = $bancos[$id];
            }
            return $simulacao;
        }
        return[];
    }
    function getBancoFinanciamento($where= [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $query = $this->db->get('fnc_bancos');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
    }
    function getBancosFinanciamento($where = [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $query = $this->db->get('fnc_bancos');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
        
    }
    function getEndereco($cep)
    {
        $this->db->where('l.cep', $cep);
        
        $this->db->join('cep_bairro as b', 'b.id_bairro = l.id_bairro');
        $this->db->join('cep_cidade as c', 'c.id_cidade = l.id_cidade');
        $this->db->join('cep_bairro_geo as d', 'b.id_bairro = d.id_bairro', 'left');
        
        
        $query = $this->db->get('cep_log as l');
        
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
    }
    function countImovesStatus($id_cadastro = true)
    {
        $this->db->select("COUNT(*) as cont, status");
        
        if($id_cadastro)
            $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->group_by('status');
        $query = $this->db->get('cad_imovel');
        if ($query->num_rows() > 0)
        {
            $return = [];
            $total = 0;
            foreach($query->result() as $obj){
                $return[$obj->status] = $obj;
                $return[$obj->status]->total = $total += $obj->cont;
            }
            return $return;
        }
        return[];
    }
    function countNegocDono()
    {
        $this->db->select("COUNT(*) as cont, chat_status");
        $this->db->where('id_dono', $this->session->id_cadastro);
        $this->db->group_by('chat_status');
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->chat_status] = $obj;
            return $return;
        }
        return[];
    }
    function countNegocInteressado()
    {
        $this->db->select("COUNT(*) as cont, chat_status");
        $this->db->where('id_interessado', $this->session->id_cadastro);
        $this->db->group_by('chat_status');
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->chat_status] = $obj;
            return $return;
        }
        return[];
    }
    function getNegocDono()
    {
        
        $this->db->where('id_dono', $this->session->id_cadastro);
        $this->db->where('chat_status < ', 4);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getNegocInteressado()
    {
        $this->db->where('id_interessado', $this->session->id_cadastro);
        $this->db->where('chat_status < ', 4);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
	function countPropostasDono()
    {
        $this->db->select("COUNT(*) as cont, status");
        $this->db->where('id_cad_dono', $this->session->id_cadastro);
        $this->db->group_by('status');
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->status] = $obj;
            return $return;
        }
        return[];
    }
    function countPropostasInteressado()
    {
        $this->db->select("COUNT(*) as cont, status");
        $this->db->where('id_cad_interessado', $this->session->id_cadastro);
        $this->db->group_by('status');
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->status] = $obj;
            return $return;
        }
        return[];
    }
	function countFavoritos()
    {
        $this->db->select("COUNT(*) as cont");
        $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->group_by('id_cadastro');
        $query = $this->db->get('cad_favoritos');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getNegoviacoesImovel($id_imovel)
    {
        $this->db->where('id_imovel', $id_imovel);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getNegoviacoes($where)
    {
        $this->where($where);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getFavoritos($where)
    {
        $this->where($where);
        $query = $this->db->get('cad_favoritos');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getSimulacoes($where)
    {
        $this->where($where);
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
	function getBracoDireito($id_cad_principal)
	{
	    $this->db->where('id_cad_principal', $id_cad_principal);
	    $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = cad_rel_braco.id_cad_braco');
        $query = $this->db->get('cad_rel_braco');
        if ($query->num_rows() > 0)
            return $query->row();
        return NULL;
	}
	function getVendFinanciamento($id_simulacao)
	{
	    $this->db->where('id_simulacao', $id_simulacao);
	    $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = fnc_simulacao.id_cad_dono');
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
            return $query->row();
        return NULL;
	}
	function getImoveCadastro($id_imovel)
	{
	    $this->db->where('id_imovel', $id_imovel);
	    $this->db->join('cad_imovel', 'cad_imovel.id_cadastro = cad_cadastro.id_cadastro');
        $query = $this->db->get('cad_cadastro');
        if ($query->num_rows() > 0)
            return $query->row();
        return NULL;
	}
	function getGeoBairro($where = [])
	{
	    $this->db->select('*, b.id_bairro as id_bairro');
	    $this->where($where,[]);
	    
        $this->db->join('cep_bairro_geo as a', 'a.id_bairro = b.id_bairro', 'left');
	    
	    
	    $query = $this->db->get('cep_bairro as b');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	//NEWSLETTER
	function getEmail($where)
	{
	    $this->where($where,[]);
	    
	    $query = $this->db->get('nwl_emails');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	function insertEmail($data)
	{
	    $this->db->insert('nwl_emails', $data);
	    return  $this->db->insert_id();
	}
    function getViewLancamento($where)
    {
        if(empty($where))
            return null;
            
        $this->where($where,[]);
	    
	    $query = $this->db->get('cad_view_lancamento');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
    }
    public function getNewsletterLista($where = []){
        return $this->getRow('nwl_lista_custom', $where);
    }
    //INTENCAO
    function setIntencaoBusca($data)
	{
	    $this->db->insert('cad_intencao_busca', $data);
	    return  $this->db->insert_id();
	}
    function getIntencoesBusca($where = [])
	{
	    $this->where($where,[]);
	    
	    $query = $this->db->get('cad_intencao_busca as a');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
    //CAPTURA
    function getCaptura($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura');
	    
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	function getCapturas($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	function getCapturasOrigem($where = []){
        $this->db->join('cad_captura_origem', 'cad_captura_origem.id_result = cad_captura.id_captura','left');
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
    }
	function getCadastro($where = [])
	{
	    $this->where($where);
	    $query = $this->db->get('cad_cadastro');
	    
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	function getCadastros($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_cadastro');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	function getAtendimento($where = [])
	{
	    $this->where($where,[]);
	    
	    $query = $this->db->get('cad_atendimento as a');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	function setAtendimento($data)
	{
	    return $this->insert('cad_atendimento', $data);
	}
	function setAtendimentoHistorico($data)
	{
	    return $this->insert('cad_atendimento_historico', $data);
	}
	function updateAtendimento($id,$data)
	{
	    $this->db->where('id_atendimento', $id);
	    return $this->update('cad_atendimento', $data);
	}
	function updateAtendimentoHistorico($id, $data)
	{
	    $this->db->where('id_hist_atend', $id);
	    return $this->update('cad_atendimento_historico', $data);
	}
	function getAtendimentoHistorico($where = [])
	{
	    $this->where($where,[]);
	      
	    $this->db->join('cad_atendimento_historico as b', 'a.id_atendimento = b.id_atendimento'); 
	    $this->db->order_by('data_hora', 'desc');
	    $query = $this->db->get('cad_atendimento as a');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	// CAPTURA ORIGEM------------------------------------------------------
    function insertCapturaOrigem($data)
	{
	    return $this->insert('cad_captura_origem', $data);
	}
	function getCapturaOrigem($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura_origem');
	    
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	// I N S E R T  ------------------------------------------------------
	//static
	static function setCadUser($data)
	{
	    $cadastro = self::montaCadastro($data);
	    self::$db->insert('cad_cadastro', $cadastro);
	    $data['id_cadastro'] = self::$db->insert_id();
	    
	    $user = self::montaUser($data);
	    self::$db->insert('sys_users', $user);
	    $data['id_user'] = self::$db->insert_id();
	    
	    return ['id_cadastro' => $data['id_cadastro'], 'id_user' =>$data['id_user']];
	}
	//no static
	function insertCadastro($data)
	{
	    return $this->insert('cad_cadastro', $data);
	}
    function insertImovel($data)
	{
	    return $this->insert('cad_imovel', $data);
	}
	function insertUser($data)
	{
	    return $this->insert('sys_users', $data);
	}
	function insertRelBraco($data)
	{
	    $this->db->insert('cad_rel_braco', $data);
	    return  $this->db->insert_id();
	}
	function insertSimulacao($data)
	{
	    $this->db->insert('fnc_simulacao', $data);
	    return  $this->db->insert_id();
	}
	function insertHistoricoSimulacao($data)
	{
	    $this->db->insert('fnc_historico_simulacao', $data);
	    return  $this->db->insert_id();
	}
	function insertBancoRelSimulacao($data)
	{
	    $this->db->insert('fnc_banco_rel_simulacao', $data);
	    return  $this->db->insert_id();
	}
	function insertContato($data)
	{
	    $data = self::montaContato($data);
	    $this->db->insert('cad_contato', $data);
	    return  $this->db->insert_id();
	}
	function insertGeoBairro($data)
	{
	    $this->db->insert('cep_bairro_geo', $data);
	    return  $this->db->insert_id();
	}
	//CAPTURA
	function insertCaptura($data)
	{
	    //$data = self::montaCaptura($data);
	    if(!isset($data['id_cadastro'])  ||  !($data['id_cadastro'] > 0) )
	    {
	        if(isset($data['email'])){
    	        $cadastro = self::getCadastroByEmail($data['email']);
    	        if(empty($cadastro))
                    $data['id_cadastro'] = $this->cad_model->insertCadastro($data);
                else
                    $data['id_cadastro'] = $cadastro->id_cadastro;
	        }
	    }
	    
	    $this->insert('cad_captura', $data);
	    return  $this->db->insert_id();
	}
   // U P D A T E ------------------------------------------------------
   //static
	static function updateCadUser($id_cadastro, $data)
	{
	    $cadastro = self::montaCadastro($data);
	    self::$db->where('id_cadastro', $id_cadastro);
	    $r1 = self::$db->update('cad_cadastro', $cadastro);
	    
	    $user = self::montaUser($data);
	    self::$db->where('id_cadastro', $id_cadastro);
	    $r2 = self::$db->update('sys_users', $user);
	    
	    if($r1 && $r2)
	        return true;
	    return false;
	}
	static function updateUser($id_cadastro, $data)
	{
	    $user = self::montaUser($data);
	    self::$db->where('id_cadastro', $id_cadastro);
	    return self::$db->update('sys_users', $user);
	}
    function updateImovel($id,$data)
	{
	    /*$data = self::montaImovel($data);

	    $this->db->where('id_imovel', $id);	
	    return $this->db->update('cad_imovel', $data);*/
	    
	    
	    //$data = self::montaImovel($data);
	    
	    $this->db->where('id_imovel', $id);
	    return $this->update('cad_imovel', $data);
	    
	}
	function updateImoveis($where,$data)
	{
	   if(!empty($where))
	   {
	       $data = self::montaImovel($data);
    	   $this->where($where,[]);
    	   return $this->db->update('cad_imovel', $data);
	   }
	   return false;
	}
	function updateImovelRel($id_imovel_rel,$data)
	{
	    $data = self::montaImovel($data);
	    $this->db->where('id_imovel_rel', $id_imovel_rel);
	    return $this->db->update('cad_imovel', $data);
	    
	}
	function updateCadastro($id,$data)
	{
	    $this->db->where('id_cadastro', $id);
	    return $this->update('cad_cadastro', $data);
	    
	}
    public function update_galeria($data)
    {
        $data['id_cadastro'] = $this->session->id_cadastro;
        $data = self::montaImg($data);
        if($this->db->insert('cad_img', $data)){
            return $this->db->insert_id();
        }
        return false;
    }
    function update_image_galery($data)
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->where('imagem', $data['imagem']);
	    return $this->db->update('cad_img', $data);
	}
    function update_galery_by_id($data)
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('id_img', $data['id_img']);
	    unset($data['id_img']);
	    return $this->db->update('cad_img', $data);
	}
	function update_galery_rel_by_id($data)
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('id_img_rel', $data['id_img']);
	    unset($data['id_img']);
	    return $this->db->update('cad_img', $data);
	}
	function updateSimulacao($id,$data)
	{
	    $data = self::montaSimulacao($data);
	    $this->db->where('id_simulacao', $id);
	    return $this->db->update('fnc_simulacao', $data);
	    	}
    function updateBancoRelSimulacao($id,$data)
	{
	    $data = self::montaBancoRelSimulacao($data);
	    $this->db->where('id_bc_rel', $id);
	    return $this->db->update('fnc_banco_rel_simulacao', $data);
	}
    function updateCaptura($id,$data)
	{
	    $this->db->where('id_captura', $id);
	    return $this->update('cad_captura', $data);
	}
    // D E L E T E ------------------------------------------------------
    public function delete_galeria($imgName)
    {
        $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->where('imagem', $imgName);
        if($this->db->delete('cad_img'))
        {
            if($this->db->affected_rows() > 0)
            {
                return true;    
            }
        }
        return false;
    }
    public function delete_galeria_admin($imgName, $id_imovel)
    {
        $this->db->where('id_imovel', $id_imovel);
        $this->db->where('imagem', $imgName);
        if($this->db->delete('cad_img'))
        {
            if($this->db->affected_rows() > 0)
            {
                return true;    
            }
        }
        return false;
    }
    
    public function deletaImgsImovel($id_imovel)
    {
        $this->db->where('id_imovel', $id_imovel);
        if($this->db->delete('cad_img'))
        {
            if($this->db->affected_rows() > 0)
            {
                return true;    
            }
        }
        return false;
    }
    
    function deleteImovel($id_imovel)
	{
	    $this->db->where('id_imovel', $id_imovel);
	    return $this->db->delete('cad_imovel');
	}
    function deleteImovelRel($id_imovel_rel)
	{
	    $this->db->where('id_imovel_rel', $id_imovel_rel);
	    return $this->db->delete('cad_imovel');
	}
	function deleteBancoRelSimulacao($id_simulacao)
	{
        $this->db->where('id_simulacao',$id_simulacao);
	    if ($this->db->delete('fnc_banco_rel_simulacao'))
			return true;
		else
			return FALSE;
	}
	function deleteBracoRel($id_cad_principal)
	{
        $this->db->where('id_cad_principal',$id_cad_principal);
	    if ($this->db->delete('cad_rel_braco'))
			return true;
		else
			return FALSE;
	}
    // CURTIR FAVORITOS
    function insert_curtir($dados) 
    {
		if ($this->db->insert ('cad_favoritos', $dados))
			return $this->db->insert_id();
		else
			return FALSE;
	}
	function select_curtir($id_cadastro, $id_imovel)
    {
        $this->db->where('id_cadastro',$id_cadastro);
        $this->db->where('id_imovel',$id_imovel);
	    $query = $this->db->get('cad_favoritos');
	    if ($query->num_rows() > 0)
	       return $query->row();
	    return NULL;
    }
    function delete_curtir($id_cadastro, $id_imovel)
    {
        $this->db->where('id_cadastro',$id_cadastro);
        $this->db->where('id_imovel',$id_imovel);
	    if ($this->db->delete('cad_favoritos'))
			return true;
		else
			return FALSE;
	    
    }
    // PUSH ALERT FUNCTIONS
    function get_push_key($id_cadastro)
    {
        $this->db->select('push_alertjson'); 
        $this->db->where('id_cadastro', $id_cadastro);
        
        $query = $this->db->get('cad_cadastro');
        
        if($query->num_rows() > 0){
            return $query->row()->push_alertjson;
        }else{
            return NULL;
        }
    }
    function insere_push_key($id_cadastro, $json)
    {
        
        $this->db->set('push_alertjson', $json);
        $this->db->where('id_cadastro', $id_cadastro);
        
        return  $this->db->update('cad_cadastro');
        
    }
    
    function get_push($tag){
        
        $this->db->where('tag_push', $tag);
        
        $query = $this->db->get('mkt_push_alerts');
        
        if($query->num_rows() > 0){
            return $query->row();
        }else{
            return NULL;
        }
    }
    
    //PROPOSTAS
	function insertPropostaHistorico($dados)
	{
		if ($this->db->insert ('cad_proposta_historico', $dados))
			return $this->db->insert_id();
		else
			return FALSE;
	}
    function updateProposta($id,$data)
	{
	    $data = self::montaProposta($data);
	    $this->db->where('id_proposta', $id);
	    return $this->db->update('cad_proposta', $data);
	    
	}
    //############  funcoes suporte ##########
    
    
    //---------- J S O N ---------------------------
    //---------- J S O N ---------------------------
    //---------- J S O N ---------------------------
    //---------- J S O N ---------------------------
    function JSON($dado)
    {
        if(is_array($dado[0]))
        {
            foreach($dado as $dado_n)
            {
                $field   = $dado[0];
                $keyJson = $dado[1];
                $value   = $dado[2];
                $this->db->where("JSON_EXTRACT($field, '$.$keyJson') =", $value);
            }
        }
        else
        {
            $field   = $dado[0];
            $keyJson = $dado[1];
            $value   = $dado[2];
            $this->db->where("JSON_EXTRACT($field, '$.$keyJson') =", $value);
        }
        return $this;
    }
    function inArrayJson($field, $value){
        $this->roda_like([[$field, '"'.$value.'"']]);
        return $this;
    }
    //----fim--- J S O N ---------------------------
    //----fim--- J S O N ---------------------------
    //----fim--- J S O N ---------------------------
    //----fim--- J S O N ---------------------------
    
    //----------M O D E L---------------------------
	//----------M O D E L---------------------------
	//----------M O D E L---------------------------
	//----------M O D E L---------------------------
	
	protected $colSum = null;
	function soma($col){
	    $this->colSum = $col;
        $this->db->select('SUM('.$col.') as '.$col, FALSE);
	    return $this;
    }
    
    function somaValorVendaUnides($where){
        
	    $this->colSum = 'valor_venda';
        $this->db->select('SUM(areaPrivativa * precoM2) as valor_venda', FALSE);
	    return $this->getResult('est_unidade', $where);;
    }
    
    function in($key, $array)
    {
        $this->db->where_in($key, $array);
        return $this;
    }
    
    
	//----------------------------------------------
	function getResult($tb, $where = []){
        $this->where($where);
        $query = $this->db->get($tb);
        
        //----------NOVO ITEM--------------
        if($this->colSum != null){
            
            $col = $this->colSum;
            $this->colSum = null; 
            
            if ($query->num_rows() > 0) 
                return $query->row()->$col;
            return 0;
        }
        //---------------------------------
        
        if ($query->num_rows() > 0) 
            return $query->result();
        return [];
    }
    function getRow($tb, $where = []){
        $this->where($where);
        $query = $this->db->get($tb);
        
        if ($query->num_rows() > 0) 
            return $query->row();
        return null;
    }
    function insert($tb, $data){
        //$data = self::criaArray($this->db->list_fields($tb),$data);
        $data = $this->getFieldsNotPrimaryKey($tb,$data);
        
        if(empty($data)){
            $this->db->reset_query();
            return false;
        }
        
        
        //---------NOVA IDEIA
        foreach ($data as $field=>$value)
        {
            if(is_array($value) || is_object($value)){
                
                
                
                $stringSet = '';
                $arrayJson = [];
                $cont = 0;
                foreach ($value as $keyJson => $valJson){
                    
                    
                    if(is_array($valJson) || is_object($valJson)){
                        if(is_numeric($keyJson))
                            //$this->db->set($field, json_encode($value));
                            //$encode[$field] = json_encode($value);
                            $arrayJson[] = ($valJson);
                            //$stringSet .= "JSON_ARRAY(".json_encode($valJson).")";//$this->db->set($field, "JSON_SET(`$field` ,'$.$keyJson' ,".json_encode($valJson).")", FALSE);
                        else
                        {
                            $stringSet .=  (($cont++)>=1?', ':'').'"'.$keyJson.'"';
                            $stringSet .=  ", JSON_ARRAY(".implode(",", $valJson).")";
                        }
                    }else{
                        
                        if(is_numeric($keyJson)){
                            $arrayJson[] = ($valJson);
                        }else{
                            $stringSet .=  (($cont++)>=1?', ':'').'"'.$keyJson.'"';
                            $stringSet .=  ', "'.$valJson.'"';
                        }
                        
                        
                    }
                    ///////////////////antigo
                    //if(is_array($valJson)){
                    //    $stringSet .=  (($cont++)>=1?', ':'').'"'.$keyJson.'"';
                    //    $stringSet .=  ", JSON_ARRAY(".implode(",", $valJson).")";
                    //}else{
                    //    $stringSet .=  (($cont++)>=1?', ':'').'"'.$keyJson.'"';
                    //    $stringSet .=  ', "'.$valJson.'"';
                    //}
                    /////////////////////
                    
                }
                if(!empty($arrayJson)){
                    $this->db->set($field, json_encode($arrayJson));
                }
                if($stringSet != '')
                    $this->db->set($field, "JSON_OBJECT($stringSet)", FALSE);
                
                
            }else{
                $this->db->set($field, $value);
            }
        }
        
        if($this->db->insert($tb))
            return $this->db->insert_id();
        return false;
        
        //---fim---NOVA IDEIA
        
        //MODELO ANTIGO
        //if($this->db->insert($tb, $data))
        //    return $this->db->insert_id();
        //return false;
    }
    function update($tb,  $data){
        //$data = self::criaArray($this->db->list_fields($tb),$data);
        $data = $this->getFieldsNotPrimaryKey($tb,$data);
        
        if(empty($data)){
            $this->db->reset_query();
            return false;
        }
        
        
        //$encode = [];
        foreach ($data as $field=>$value)
        {
            if(is_array($value) || is_object($value)){
                $stringSet = '';
                $arrayJson = [];
                foreach ($value as $keyJson => $valJson){
                    if(is_array($valJson) || is_object($valJson)){
                        if(is_numeric($keyJson))
                            //$this->db->set($field, json_encode($value));
                            //$encode[$field] = json_encode($value);
                            $arrayJson[] = ($valJson);
                            //$stringSet .= "JSON_ARRAY(".json_encode($valJson).")";//$this->db->set($field, "JSON_SET(`$field` ,'$.$keyJson' ,".json_encode($valJson).")", FALSE);
                        else
                            $stringSet .= ",'$.$keyJson' ,".json_encode($valJson);
                        //$stringSet .= ",'$.".$keyJson."' ,JSON_ARRAY(".implode(",", $valJson).")";//$this->db->set($field, "JSON_SET(`$field` ,'$.$keyJson' ,".json_encode($valJson).")", FALSE);
                    
                        
                    }else{
                        if(is_numeric($keyJson))
                            $arrayJson[] = ($valJson);
                            //$stringSet .= ",'$.$keyJson' ,$valJson";
                        else
                            $stringSet .= ",'$.$keyJson' ,'$valJson'";//$this->db->set($field, "JSON_SET(`$field` ,'$.$keyJson' ,$valJson)", FALSE);
                    }
                }
                
                if(!empty($arrayJson))
                    $this->db->set($field, json_encode($arrayJson));
                
                if($stringSet != '')
                    $this->db->set($field, "JSON_SET(`$field` $stringSet)", FALSE);
                    
            }else{
                $this->db->set($field, $value);
            }
        }
        //foreach ($encode as $field=>$value)
        //{
        //    $this->db->set($field, $value);
        //}
        
        
        return $this->db->update($tb);
    }
    function delete($tb, $where = [])
	{
	    if(empty($where))
            return FALSE;
        $this->where($where);
	    return $this->db->delete($tb);
	}
    
    function getPrimaryKey($tb){
        foreach ($this->db->field_data($tb) as $field)
        {
            if($field->primary_key)
               return $field->name;
        }
    }
    function getFieldsNotPrimaryKey($tb,$data, $object = false){
        $campos = [];
        foreach ($this->db->field_data($tb) as $field){
            
            if($object)
                $data = (array)$data;
                
            if(!is_array($data)) {
                log_message('error', json_encode($this->db->field_data($tb)));
            }
            
             if($field->primary_key == 0 && isset($data[$field->name])) 
               $campos[$field->name] = $data[$field->name];
        }
        if($object)       
            return (object)$campos;
        return $campos;
    }
    function getFields($tb,$data, $object = true){
        $campos = [];
        foreach ($this->db->field_data($tb) as $field){
            
            if($object)
                $data = (array)$data;
            
             if(isset($data[$field->name])) 
               $campos[$field->name] = $data[$field->name];
        }
        if($object)       
            return (object)$campos;
        return $campos;
    }
    function order_by($order_by){
        foreach($order_by as $key=>$dado)
        {
            $this->db->order_by($key, $dado);
        }
        return $this;
    }
    function like($like = [], $or_like = []){
        $this->roda_like($like);
        $this->roda_or_like($or_like);
        return $this;
    }
    function roda_like($like){
        foreach($like as $dado)
        {
            $this->db->like($dado[0], $dado[1]);
        }
    }
    function roda_or_like($like){
       if(!empty($like))
        {
            $this->db->group_start();
            foreach($like as $dado)
            {
                $this->db->or_like($dado[0], $dado[1]);
            }
            $this->db->group_end();
        }
    }
    function where($where, $or_where = []){
        $this->roda_where($where);
        
        $this->roda_or_where($or_where);
    }
    function roda_where($where){
        foreach($where as $ky=>$dado)
        {
            if(is_array($dado[0]))
            {
                $this->db->group_start();
                foreach($dado as $dado_n)
                {
                    if(is_array($dado_n[0]))
                    {
                        $this->db->or_group_start();
                        foreach($dado_n as $dado_y)
                        {
                            $this->db->where($dado_y[0], $dado_y[1]);
                        }
                        $this->db->group_end();
                    }
                    else
                    {
                        $this->db->or_where($dado_n[0], $dado_n[1]);
                    }
                }
                $this->db->group_end();
            }
            else
            {
                if(is_array($dado))
                    $this->db->where($dado[0], $dado[1]);
                else
                    $this->db->where($where[0], $where[1]);
            }
        }
    }
    function roda_or_where($where){
       if(!empty($where))
        {
            $this->db->group_start();
            foreach($where as $dado)
            {
                $this->db->or_where($dado[0], $dado[1]);
            }
            $this->db->group_end();
        }
    }
    //---fim----M O D E L---------------------------
    //---fim----M O D E L---------------------------
    //---fim----M O D E L---------------------------
    //---fim----M O D E L---------------------------
    
    
    
    
    
}