<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Administrativo extends Admin_Controller {

    function __construct() 
    {
        parent::__construct();
        
        Assets::add_css(array(
            '../comdono/plugins/fancyBox-v3.5.7/css/jquery.fancybox.min',
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/fancyBox-v3.5.7/js/jquery.fancybox.min',
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
        
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		$this->load->model('administrativo/fluxo_model');
		$this->load->model('minha_conta/conta_model');
    }
    
    function index()
    {
        $data['module'] = $module = Menu_lib::getModuleByNickname($this->module);
        $this->breadcrumb("<i class='nav-icon $module->icon'></i> $module->name");
        Template::set($data);
        Template::set_view('atendimento/dashboard_module_view');
        Template::render();
    }
	
    function testemodel()
    {
        
    }
    
    
    
    function set_cadastro_captura()
    {
        $capturas = $this->cad_model->getCapturas(['id_cadastro', 0]);
        foreach ($capturas  as $cap){
            if($cap->email != ''){
                $cadastro = $this->admin_model->getCadastro(['email',$cap->email]);
                if($cadastro == null)
                {
                    
                     $id_cadastro = $this->admin_model->insertCadastro((array)$cap);
                     echo("<br> novo cadastro - $id_cadastro <br> <br>");
                }
                else
                {
                    $id_cadastro = $cadastro->id_cadastro;
                    echo("$id_cadastro, ");
                }
                $this->admin_model->updateCaptura($cap->id_captura, ['id_cadastro' => $id_cadastro]);
            }
            else
            {
                 echo("<br> email vazio ID_CAPTURA $cap->id_captura, origem_captura $cap->origem_captura <br> <br>");
            }
        }
        
    }
    
    function set_cadastro_interesse()
    {
        $capsemcadastro = 0;
        $notCap = 0;
        $updates = 0;
        
        $capvazio = 0;
        $cadvazio = 0;
        
        $interesses = $this->cad_model->getInteresses();
        foreach ($interesses  as $interesse){
            
            
            if($interesse->id_captura == 0)
                $capvazio++;
            if($interesse->id_cadastro == 0)
                $cadvazio++;
                
            
            if($interesse->id_captura > 0 && $interesse->id_cadastro == 0){
                $cap = $this->admin_model->getCaptura(['id_captura',$interesse->id_captura]);
                if($cap != null)
                {
                    if($cap->id_cadastro == 0)
                    {
                        $capsemcadastro++;
                        
                    }
                    else
                    {
                        $this->cad_model->updateInteresse($interesse->id_interesse, ['id_cadastro'=>$cap->id_cadastro]);
                        echo("novo update - $interesse->id_interesse <br>");
                    }
                }
                else
                {
                    $notCap++;
                    
                }
            }
        }
        
        echo("<br> $capvazio -- INTERESSE COM Capturas id 0 <br>");
        echo("<br> $cadvazio -- INTERESSE COM Cadastros id 0  <br>");
        
        echo("<br> $capsemcadastro -- Captura com id Cadastro 0 <br>");
        echo("<br> $notCap -- Captura nao encontrada <br>");
        
    }
    
    function atualiza_interesses()
    {
        $campos = [
            'faixa_preco_inicio',
            'faixa_preco_fim',
            'tipo_imovel',
            'quartos',
            'suites',
            'banheiro',
            'vagas',
            'sobre_anuncio',
            'detalhes_imovel',
            'motivo',
            'descricao',
        ];
        
        $interesses = $this->cad_model->getInteresses([['interesse_painel_cs', 0],['id_cadastro >',0]]);
        
        $agrupados = [];
        
        foreach ($interesses as $int){
            $id_cadastro = $int->id_cadastro;
            $agrupados[$id_cadastro][] = $int;
        }
        
        $agrupadosEmOrdem = [];
        foreach ($agrupados as $id=>$ints){
            foreach ($ints as $int){
                $contVazios = 0;
                foreach ($campos as $key)
                    if($int->$key == 0 || $int->$key == '')
                        $contVazios++;
                $agrupadosEmOrdem[$id][$contVazios][] = $int;
            }
            ksort($agrupadosEmOrdem[$id]);
        }
        
        foreach ($agrupadosEmOrdem as $k1=>$cadastros)
        {
            $primeiro = true;
            foreach ($cadastros as $k2=>$numerosVazios)
            {
                foreach ($numerosVazios as $k=>$interesse)
                {
                    if($primeiro && $k2 < count($campos))
                    {
                        $primeiro = false;
                        echo("$interesse->id_interesse -- INTERESSE principal <br>");
                        $this->cad_model->updateInteresse($interesse->id_interesse,['principal'=>1]);
                        //$agrupadosEmOrdem[$k1][$k2][$k] = 1;
                    }
                    else
                    {
                        $this->cad_model->updateInteresse($interesse->id_interesse,['principal'=>0]);
                        //$agrupadosEmOrdem[$k1][$k2][$k] = 2;
                    }
                }
            }
        }
    }
    
    
    
    function assets()
    {
        Assets::add_css(array(
            '../comdono/plugins/blueimp/css/jquery.fileupload',
            '../comdono/plugins/blueimp/css/jquery.fileupload-ui',
            '../comdono/plugins/blueimp/css/blueimp-gallery.min',
            //'../comdono/plugins/blueimp/css/custom',
            '../comdono/plugins/unitegallery/css/unite-gallery',
            '../comdono/plugins/unitegallery/css/ug-theme-default',
            
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/blueimp/js/jquery.ui.widget',
            '../comdono/plugins/blueimp/js/tmpl.min',
            '../comdono/plugins/blueimp/js/load-image.all.min',
            '../comdono/plugins/blueimp/js/canvas-to-blob.min',
            '../comdono/plugins/blueimp/js/blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.iframe-transport',
            '../comdono/plugins/blueimp/js/jquery.fileupload',
            '../comdono/plugins/blueimp/js/jquery.fileupload-process',
            '../comdono/plugins/blueimp/js/jquery.fileupload-image',
            '../comdono/plugins/blueimp/js/jquery.fileupload-validate',
            '../comdono/plugins/blueimp/js/jquery.fileupload-ui',
            '../comdono/plugins/unitegallery/js/unitegallery.min',
            '../comdono/plugins/unitegallery/js/ug-theme-default',
            '../comdono/plugins/unitegallery/js/imovel',
            
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
        
        Assets::add_module_js('administrativo', [
            'perfil',
            'dashboard_imovel'
        ]);
    }
    
}