<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Ajuda extends Grocery {

    function __construct() 
    {
        parent::__construct();
		$this->load->model('administrativo/admin_model');
    }
    
    public function perguntas() 
    {
        
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('faq_perguntas_respostas');
			$crud->set_subject('Perguntas'); 
			
			$crud->set_relation('id_cat','faq_categorias','categoria');
			
			$crud->columns(['id_perg','id_cat','pergunta']);
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
        
    }
    public function categorias() 
    {
        
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('faq_categorias');
			$crud->set_subject('Categorias'); 
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }   
    
}