<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Braco_direito extends Comdono_Controller {

	function __construct()
	{
		parent::__construct();
		
		if(!(($this->session->perfil??0) > 0) )
            redirect();
		
		$this->load->model('administrativo/admin_model');
		
        /*$module = 'comdono';
        $header = "header";
        $footer = "footer";*/

        /*
        $css = array(
            'plugins/jquery-ui-1.12.1/css/jquery-ui',
            'plugins/bootstrap-4.1.3/css/bootstrap.min',
            'plugins/growl-alert/css/growl',
            'plugins/select2/css/select2.min',
            'plugins/select2/css/select2-bootstrap4.min',
            'fonts/font-awesome-4.7.0/css/font-awesome.min.css',
            'plugins/material-design/style',
            'theme',
            'responsive-style',
        );
        
        $js = array(
            'plugins/jquery-3.3.1/jquery-3.3.1.min',
            'plugins/jquery-ui-1.12.1/js/jquery-ui',
            'plugins/bootstrap-4.1.3/js/bootstrap.bundle.min',
            'plugins/tether-1.4.0/tether.min',
            'plugins/inputmask/inputmask',
            'plugins/growl-alert/js/growl',
            'plugins/notify/notify.min',
            'plugins/select2/js/theme',
            'mascaras',
            'theme',
        );*/
        
        $this->set_theme('comdono');
        /*Assets::add_css($css);
        
        if(!empty($js))
        {
            Assets::add_js( $js, 'external', false);
        }
        
        if(!empty($header))
        {
            $data["menu_cad_imovel"] = false; 
            
            $data['header'] = '';
            //Template::load_view($module.'/theme/'.$header, $data, '', '', $data['header']);
        }
        
        if(!empty($footer))
        {
            $data['footer'] = '';
            //Template::load_view($module.'/theme/'.$footer, $data, '', '', $data['footer']);
        }*/
        $data["menu_cad_imovel"] = false;
        
        Template::set_modal($data,[
            'comdono/modal/login_site_view'
        ]);

        Template::set($data);
        
	}
	
	public function index()
    {
        $data['dashboard'] = TRUE;
        Template::set($data);
        Template::set_view('anuncios_vendas_view');
        Template::render();
    }
	
	public function chat()
    {
        $this->load->model("comdono/busca_model");
        $this->load->model("minha_conta/chat_model");
        
        Assets::add_js(array(
            'plugins/jquery.ns-autogrow/jquery.ns-autogrow.min',
            'plugins/autosize/autosize.min'
        ));
        Assets::add_module_js('minha_conta', array(
            'chat_front',
            'chat',
        ));
        //$data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_negociacoes'] = TRUE;
        $data['step'] = 6;
        $data['chat_comprador'] = FALSE;
        
        $data['sessid'] = simple_crypt( json_encode(array('from'=>$this->session->id_cadastro)), 'e' );
        
        $data["imoveis"] = $this->chat_model->getChat();
        $data['id_cadastro'] = $this->session->id_cadastro;
        $bairros = [];
        
        $data['checkIdBairro'] = '';
        $data['checkIdImovel'] = $this->uri->segment(4);
        $data['checkIdChat'] = $this->uri->segment(5);
        
        foreach($data["imoveis"] as $id_imovel=>$imovel)
        {
            $bairros[$imovel->bairro][$id_imovel] = $imovel;
            if($id_imovel == $data['checkIdImovel'])
                $data['checkIdBairro'] = $imovel->bairro;
        } 
        
        $data["bairros"] = $bairros;
        $data['usuarios_chat'] = $this->chat_model->getUsuariosChat();
        
        Template::load_view('minha_conta/chat_view', $data, '', '', $data['chat_view']);
        
        //var_dump($data['usuarios_chat']);
        
        Template::set($data); 
        Template::set_view('minha_conta/chat_braco_direito_view');
        Template::render();
    }
    
    public function negociacoes()
    {
        
        $this->load->model("comdono/busca_model");
        $this->load->model("chat_model");
        
        Assets::add_js(array(
            'plugins/jquery.ns-autogrow/jquery.ns-autogrow.min',
            'plugins/autosize/autosize.min'
        ));
        Assets::add_module_js('minha_conta', array(
            'chat_front',
            'chat',
        ));
        
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_negociacoes'] = TRUE;
        $data['step'] = 6;
        $data['chat_comprador'] = FALSE;
        $data['sessid'] = simple_crypt( json_encode(array('from'=>$this->session->id_cadastro)), 'e' );
        
        $data["imoveis"] = $this->chat_model->getChat([['a.id_cadastro',$this->session->id_cadastro],['chat_status',3]]);
        $data['id_cadastro'] = $this->session->id_cadastro;
        $bairros = [];
        
        $data['checkIdBairro'] = '';
        $data['checkIdImovel'] = $this->uri->segment(4);
        $data['checkIdChat'] = $this->uri->segment(5);
        
        foreach($data["imoveis"] as $id_imovel=>$imovel)
        {
            $bairros[$imovel->bairro][$id_imovel] = $imovel;
            if($id_imovel == $data['checkIdImovel'])
                $data['checkIdBairro'] = $imovel->bairro;
        }
        
        $data["bairros"] = $bairros;
        $data['usuarios_chat'] = $this->chat_model->getUsuariosChat();
        
        //var_dump($data['usuarios_chat']);
        
        Template::set($data); 
        Template::set_view('chat_view');
        Template::render();
    }
    
    public function anuncios()
    {
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_anuncios'] = TRUE;
        
        
        $where[] = ['status >', 1];
        $where[] = ['id_imovel_rel', 0];
        $where[] = [['a.lixeira <', 2],[['a.lancamento','Sim'],['a.lixeira <', 3]]];
        //$where[] = ['a.lixeira <', 3];
        
    //['status >' => 1, ]
    
        $data['imoveis'] = $this->conta_model->getImoveis($where);
         
        foreach($data['imoveis'] as $imovel)
        {
            //echo ($imovel->id_imovel.' - <br>');
            //foreach($imovel->imagens as $img) echo ('<br>'.$imovel->id_imovel.' - '.@$img->id_img.'<br>');
        }
        
        Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'actions'
        ));
        
        Assets::add_module_js('minha_conta', array(
            'pagination',
            'anuncios'
        ));
        
        $data['favoritos'] = $this->busca_model->get_favoritos();
        
        Template::set($data);
        Template::set_view('anuncios_vendas_view');
        Template::render();
    }
    
    public function lancamento()
    {
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_anuncios'] = TRUE;
        $data['pgLancamento'] = TRUE;
        
        $id_imovel = $this->uri->slash_segment(4);
        
        $w[] = ['status >', 1];
        $w[] = ['a.id_imovel',$id_imovel];
        $lancamento = $this->conta_model->getImovel($w); 
        
        if($lancamento == null)            redirect('minha_conta/minhas_vendas/anuncios');
            
        if($lancamento->id_imovel_rel != 0)    redirect('minha_conta/minhas_vendas/lancamento/'.$lancamento->id_imovel_rel);
        
        
        $where[] = ['status >', 1];
        $where[] = ['a.lixeira <', 2];
        $where[] = [['a.id_imovel', $id_imovel],['a.id_imovel_rel', $id_imovel]];
        
        $data['imoveis'] = $this->conta_model->getImoveis($where);
        $data['lancamento'] = $lancamento;
            
        Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
            'plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'plugins/dataTables/js/jquery.dataTables.min',
            'plugins/dataTables/js/dataTables.bootstrap4.min'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'actions'
        ));
        
        Assets::add_module_js('minha_conta', array(
            /*'pagination',*/
            'anuncios',
            'dataTables'
            
        ));
        
        $data['favoritos'] = $this->busca_model->get_favoritos();
        
        Template::set($data);
        //Template::set_view('anuncios_vendas_view');
        Template::set_view('anuncios_vendas_lancamento_view');
        Template::render();
    }
    
    function atualiza_galeria_unidades($id_imovel = null)
	{
	    $this->admin_model->deleteImgImovel([['id_img_rel >',0]]);
	    
	    $imoveis = $this->admin_model->getImoveis([['id_imovel_rel',0]]);
	    foreach ($imoveis as $imovel)
	    {
	        if(!empty($imovel->imagens)){
	            $unidades = $this->admin_model->getImoveis([['id_imovel_rel',$imovel->id_imovel]]);
	           
	            foreach ($unidades as $unidade)
	            {
	                foreach ($imovel->imagens as $img)
        	        {
        	            $insertImg = (array)$img;
        	            $insertImg["id_img_rel"] = $img->id_img;
                        $insertImg['id_imovel'] = $unidade->id_imovel;
                        $this->admin_model->insertImgImovel($insertImg);
                        
        	        }
	            }
	        }
	    }
	    
	}
    
    public function edit()
    {
        if(!$this->tank_auth->is_logged_in())
        {
            redirect('login');
        }
        
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('administrativo/imoveis/ativos');
            
        $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$id_imovel]]);
        
        if($data['imovel'] == null)
            redirect('administrativo/imoveis/ativos');
        
        $data['step'] = 1;
            if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
                $data['step'] = $uri[5];
            }
            
        //$data['meuCadastro'] = json_encode(['id_cadastro' => $data['imovel']->id_cadastro]);
        $getCadastro = $this->cad_model->getCadastro([['id_cadastro', $data['imovel']->id_cadastro]]);
        $data['meuCadastro'] = json_encode($getCadastro); 
        $data['donoCadastro'] = $getCadastro; 
        
        if(end($uri) == 'preview'){
        
            redirect(base_url('administrativo/imoveis/ativos'));
            
        }else{
            //$this->session->set_userdata(['id_imovel' => $data['imovel']->id_imovel]);
            
            //if(!is_dir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel))
                //mkdir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel, 0774, true);
            
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            /*if(!empty($data['imagens']) && $data['imagens'] !== null){ 
                $data['img_base'] = base_url('modules/anunciante/'.$data['imovel']->id_cadastro.'/'.$data['imovel']->id_imovel.'/galeria/');
            }*/
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'config_uri_ajax',
                'initGoogleMaps',
                'config-ckeditor',
                'cadastro_imovel',
                'cadastro_imovel_front',
                'upload_fotos_sortable',
                'width-dynamic'
            ));
            
            $data['step_preview'] = 11;
            
            $data['doc_juridico'] = true;
            
            Template::load_view('comdono/doc_contrato_prestacao_servico_view', $data, '', '', $data['doc_contrato']);
            Template::load_view('comdono/doc_minuta_view', $data, '', '', $data['doc_minuta']);
            
            $data['edit'] = true;
            $data['admin'] = true;
            $data['textTitulo'] = 'Editar Imóvel';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        }
    }
    
    // CARD FLUXO DO IMOVEL
    public function edit_imovel()
    {
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('administrativo/operacao/quadro/1');
            
        $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$id_imovel]]);
        
        
        $this->load->model('administrativo/fluxo_model');
        
        $card = $this->fluxo_model->getCardPerfil([['id_imovel',$id_imovel]]);
        
        if($card == null)
            redirect('administrativo/operacao/quadro/1');
        
        if($data['imovel'] == null)
            redirect('administrativo/operacao/quadro/1');
        
        $data['step'] = 1;
        if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
            $data['step'] = $uri[5];
        }
            
        //$data['meuCadastro'] = json_encode(['id_cadastro' => $data['imovel']->id_cadastro]);
        $getCadastro = $this->cad_model->getCadastro([['id_cadastro', $data['imovel']->id_cadastro]]);
        $data['meuCadastro'] = json_encode($getCadastro); 
        $data['donoCadastro'] = $getCadastro; 
        
        if(end($uri) == 'preview'){
            redirect(base_url('administrativo/operacao/quadro/1'));
            
        }else{
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'config_uri_ajax',
                'initGoogleMaps',
                'config-ckeditor',
                'edit_imovel_perfil',
                'cadastro_imovel_front',
                'upload_fotos_sortable',
            ));
            
            $data['step_preview'] = 11;
            
            $data['doc_juridico'] = true;
            
            Template::load_view('comdono/doc_contrato_prestacao_servico_view', $data, '', '', $data['doc_contrato']);
            Template::load_view('comdono/doc_minuta_view', $data, '', '', $data['doc_minuta']);
            
            $data['edit'] = true;
            $data['admin'] = true;
            
            /* --- S T E P S ---                      --- P E R F I L ---
            1 : 'Perfil',                            1	Administrador Master
            2 : 'Tipo de anúncio',                   2	Administrador
            3 : 'Endereço',                          3	Usuário
            4 : 'Confirmação da localização',        4	Atendimento
            5 : 'Documento do imóvel',               5	Comunicação
            6 : 'Informações do imóvel',             6	Fotografo
            7 : 'Proposta COMDONO',                  
            8 : 'Detalhes do imóvel e condomínio',   
            9 : 'Descrição do imóvel',               
            10: 'Galeria',                           
            */
            
            $PerfilRelSteps = [
                1 => [1,2,3,4,5,6,7,8,9,10],
                2 => [1,2,3,4,5,6,7,8,9,10],
                3 => [],
                4 => [3,4],
                5 => [],
                6 => [10],
                ];
            
            $data['steps_permitidos'] = json_encode($PerfilRelSteps[$this->session->perfil]??[]);
            
            $data['textTitulo'] = 'Editar Imóvel';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        }
    }
    
    public function edit_unidade()
    {
        if(!$this->tank_auth->is_logged_in())
        {
            $referer = base_url('cadastro/imovel');
            $this->session->set_userdata('http_referer', $referer);
            $this->session->set_userdata(['botaoCadImovel' => true]);
            redirect('login');
        }
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('minha_conta/minhas_vendas/anuncios');
            
        $data['imovel'] = $this->cad_model->getImovelCad(['id_imovel' => $id_imovel]); 
        if($data['imovel'] == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        $data['step'] = 1;
            if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
                $data['step'] = $uri[5];
            }
            
        //$data['meuCadastro'] = json_encode($this->cad_model->get_cadastro());
        $getCadastro = $this->cad_model->getCadastro([['id_cadastro', $data['imovel']->id_cadastro]]);
        $data['meuCadastro'] = json_encode($getCadastro); 
        $data['donoCadastro'] = $getCadastro; 
        
        if(end($uri) == 'preview'){
        
            redirect(base_url('minha_conta/minhas_vendas/preview/1066'));
            
        }else{
        
            //$this->session->set_userdata(['id_imovel' => $data['imovel']->id_imovel]);
            
            if(!is_dir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel))
                mkdir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel, 0774, true);
            
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            if(!empty($data['imagens']) && $data['imagens'] !== null){ 
                $data['img_base'] = base_url('modules/anunciante/'.$data['imovel']->id_cadastro.'/'.$data['imovel']->id_imovel.'/galeria/');
            }
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];//$this->cad_model->getImoveis(['id_imovel_rel' => $data['imovel']->id_imovel ]);
            
            //$data['arrayImovel'] = HImovel::getDetalhesImovel($data['imovel']);
            //$data['arrayCondominio'] = HImovel::getDetalhesComdominio($data['imovel']);
            
            //Template::load_view('comdono/termos_view', '', '', '', $data['termos']);
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'upload_fotos_sortable',
                'initGoogleMaps',
                'config-ckeditor',
                'edit_unidade',
                'cadastro_imovel_front',
            ));
            
            $data['edit'] = true;
            $data['edit_unidade'] = true;
            $data['textTitulo'] = 'Editar Unidade';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        }
    }
    
    public function edit_lancamento()
    {
        
        if(!$this->tank_auth->is_logged_in())
        {
            $referer = base_url('cadastro/imovel');
            $this->session->set_userdata('http_referer', $referer);
            $this->session->set_userdata(['botaoCadImovel' => true]);
            redirect('login');
        }
        
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('administrativo/imoveis/ativos');
        
        $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$id_imovel]]);
        if($data['imovel'] == null)
            redirect('administrativo/imoveis/ativos');
        
        $data['step'] = 1;
            if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
                $data['step'] = $uri[5];
            }
        
        
        //$data['meuCadastro'] = json_encode($this->admin_model->([],$data['imovel']->id_cadastro));
        $getCadastro = $this->cad_model->getCadastro([['id_cadastro', $data['imovel']->id_cadastro]]);
        $data['meuCadastro'] = json_encode($getCadastro); 
        $data['donoCadastro'] = $getCadastro; 
        
        
        if(end($uri) == 'preview'){
        
            redirect(base_url('minha_conta/minhas_vendas/preview/1066'));
            
        }else{
            
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            
            /*if(!empty($data['imagens']) && $data['imagens'] !== null){ 
                $data['img_base'] = base_url('modules/anunciante/'.$data['imovel']->id_cadastro.'/'.$data['imovel']->id_imovel.'/galeria/');
            }*/
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];
            
            //Template::load_view('comdono/termos_view', '', '', '', $data['termos']);
             
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                
                'initGoogleMaps',
                'config-ckeditor',
                'edit_lancamento',
                'config_uri_ajax',
                'cadastro_imovel_front',
                'upload_fotos_sortable',
                
            ));
            
            $data['step_preview'] = 11;
            $data['edit'] = true;
            $data['edit_lancamento'] = true;
            $data['admin'] = true;
            
            $data['textTitulo'] = 'Modo Administrativo<br>Editar Empreendimento';
            
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            
            Template::render();
        }
    }
    
    // CARD FLUXO DO IMOVEL DIRECIONADO DO PAINEL CS
    public function edit_imovel_cs()
    {
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('atendimento/incorporadoras');
            
        $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$id_imovel]]);
        
        
        $this->load->model('administrativo/fluxo_model');
        
        //$card = $this->fluxo_model->getCardPerfil([['id_imovel',$id_imovel]]);
        
        
        $data['step'] = 1;
        if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
            $data['step'] = $uri[5];
        }
            
        //$data['meuCadastro'] = json_encode(['id_cadastro' => $data['imovel']->id_cadastro]);
        $getCadastro = $this->cad_model->getCadastro([['id_cadastro', $data['imovel']->id_cadastro]]);
        $data['meuCadastro'] = json_encode($getCadastro); 
        $data['donoCadastro'] = $getCadastro; 
        
        if(end($uri) == 'preview'){
            redirect(base_url('atendimento/incorporadoras'));
            
        }else{
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'config_uri_ajax',
                'initGoogleMaps',
                'config-ckeditor',
                'edit_imovel_perfil',
                'cadastro_imovel_front',
                'upload_fotos_sortable',
            ));
            
            $data['step_preview'] = 11;
            
            $data['doc_juridico'] = true;
            
            Template::load_view('comdono/doc_contrato_prestacao_servico_view', $data, '', '', $data['doc_contrato']);
            Template::load_view('comdono/doc_minuta_view', $data, '', '', $data['doc_minuta']);
            
            $data['edit'] = true;
            $data['admin'] = true;
            $data['cs'] = true;
            
            
            /* --- S T E P S ---                      --- P E R F I L ---
            1 : 'Perfil',                            1	Administrador Master
            2 : 'Tipo de anúncio',                   2	Administrador
            3 : 'Endereço',                          3	Usuário
            4 : 'Confirmação da localização',        4	Atendimento
            5 : 'Documento do imóvel',               5	Comunicação
            6 : 'Informações do imóvel',             6	Fotografo
            7 : 'Proposta COMDONO',                  
            8 : 'Detalhes do imóvel e condomínio',   
            9 : 'Descrição do imóvel',               
            10: 'Galeria',                           
            */
            
            $PerfilRelSteps = [
                1 => [1,2,3,4,5,6,7,8,9,10],
                2 => [1,2,3,4,5,6,7,8,9,10],
                3 => [],
                4 => [3,4],
                5 => [],
                6 => [10],
                ];
            
            $data['steps_permitidos'] = json_encode($PerfilRelSteps[$this->session->perfil]??[]);
            
            $data['textTitulo'] = 'Editar Imóvel';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        }
    }
    
    
    public function preview()
    {
        if(!$this->tank_auth->is_logged_in())
        {
            $referer = base_url('cadastro/imovel');
            $this->session->set_userdata('http_referer', $referer);
            $this->session->set_userdata(['botaoCadImovel' => true]);
            redirect('login');
        }
        
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        
        $imovel = $this->cad_model->getImovelCad(['id_imovel' => $id_imovel]); 
        $data['imovel'] = $imovel; 
        if($data['imovel'] == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
            'plugins/unitegallery/css/unite-gallery',
            'plugins/unitegallery/css/ug-theme-default'
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'plugins/unitegallery/js/unitegallery.min',
            'plugins/unitegallery/js/ug-theme-default',
            'plugins/unitegallery/js/imovel'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'carousel_imovel',
            'carousel_busca',
            'imovel',
            'cadastro_imovel'
        ));
        
        $imovel->imagens = $this->cad_model->getImgsImovel($imovel->id_imovel);
        if($imovel != null)
        {
            $data['arrayImovel'] = HImovel::getDetalhesImovel($imovel);
            $data['arrayCondominio'] = HImovel::getDetalhesComdominio($imovel);
            
        }
        
        $data['edit'] = true;
        $data['preview'] = true;
        $data['step'] = 9;
        
        Template::set($data);
        Template::set_view('comdono/imovel_view');
        Template::render();
    }
    
    private function set_imovel_css_js()
    {
        Assets::add_css(array(
            'plugins/blueimp/css/jquery.fileupload',
            'plugins/blueimp/css/jquery.fileupload-ui',
            'plugins/blueimp/css/blueimp-gallery.min',
            'plugins/blueimp/css/custom',
            'plugins/unitegallery/css/unite-gallery',
            'plugins/unitegallery/css/ug-theme-default',
            'plugins/fancyBox-v3.5.7/css/jquery.fancybox.min'
        ));
        
        Assets::add_module_css('comdono', array(
            'cad_maps'
        ));
        
        Assets::add_js(array(
            'plugins/blueimp/js/jquery.ui.widget',
            'plugins/blueimp/js/tmpl.min',
            'plugins/blueimp/js/load-image.all.min',
            'plugins/blueimp/js/canvas-to-blob.min',
            'plugins/blueimp/js/blueimp-gallery.min',
            'plugins/blueimp/js/jquery.blueimp-gallery.min',
            'plugins/blueimp/js/jquery.iframe-transport',
            'plugins/blueimp/js/jquery.fileupload',
            'plugins/blueimp/js/jquery.fileupload-process',
            'plugins/blueimp/js/jquery.fileupload-image',
            'plugins/blueimp/js/jquery.fileupload-validate',
            'plugins/blueimp/js/jquery.fileupload-ui',
            'plugins/unitegallery/js/unitegallery.min',
            'plugins/unitegallery/js/ug-theme-default',
            'plugins/sortable/jquery-sortable.min',
            'plugins/unitegallery/js/imovel',
            'plugins/fancyBox-v3.5.7/js/jquery.fancybox.min',
            '../painel/plugins/ckeditor-4.6.2/ckeditor',
            '../painel/plugins/ckeditor-4.6.2/samples/js/sample',
            '../painel/plugins/ckeditor-4.6.2/adapters/jquery'
        ));
        
        
    }
    
    /*private function set_imovel_css_js()
    {
        Assets::add_css(array(
            'plugins/blueimp/css/jquery.fileupload',
            'plugins/blueimp/css/jquery.fileupload-ui',
            'plugins/blueimp/css/blueimp-gallery.min',
            'plugins/blueimp/css/custom',
            'plugins/unitegallery/css/unite-gallery',
            'plugins/unitegallery/css/ug-theme-default'
        ));
        
        Assets::add_module_css('comdono', array(
            'cad_maps'
        ));
        
        Assets::add_js(array(
            'plugins/blueimp/js/jquery.ui.widget',
            'plugins/blueimp/js/tmpl.min',
            'plugins/blueimp/js/load-image.all.min',
            'plugins/blueimp/js/canvas-to-blob.min',
            'plugins/blueimp/js/blueimp-gallery.min',
            'plugins/blueimp/js/jquery.blueimp-gallery.min',
            'plugins/blueimp/js/jquery.iframe-transport',
            'plugins/blueimp/js/jquery.fileupload',
            'plugins/blueimp/js/jquery.fileupload-process',
            'plugins/blueimp/js/jquery.fileupload-image',
            'plugins/blueimp/js/jquery.fileupload-validate',
            'plugins/blueimp/js/jquery.fileupload-ui',
            'plugins/unitegallery/js/unitegallery.min',
            'plugins/unitegallery/js/ug-theme-default',
            'plugins/unitegallery/js/imovel',
            '../painel/plugins/ckeditor-4.6.2/ckeditor',
            '../painel/plugins/ckeditor-4.6.2/samples/js/sample',
            '../painel/plugins/ckeditor-4.6.2/adapters/jquery'
        ));
        
        Assets::add_module_js('comdono', array(
            'upload_fotos',
            'initGoogleMaps',
            'cadastro_imovel_front',
            'config-ckeditor',
            'cadastro_imovel',
        ));
    }*/
    
    public function financiamento()
    {
        /*Assets::add_module_css('comdono', array(
            'home'
        ));*/
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_financiamento'] = TRUE;
        
        Template::set($data);
        Template::set_view('financiamento_vendas_view');
        Template::render();
    }
    
}