<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends Admin_Controller {

    function __construct() 
    {
        parent::__construct();
        
        Assets::add_css(array(
            '../comdono/plugins/fancyBox-v3.5.7/css/jquery.fancybox.min',
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/fancyBox-v3.5.7/js/jquery.fancybox.min',
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
        
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		$this->load->model('administrativo/fluxo_model');
		//$this->load->model('minha_conta/conta_model');
    }
    
    public function index() 
    {
        Assets::add_css(array(
            '../comdono/plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            '../comdono/plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'js/Chart.min',
        ));
        
        Assets::add_module_js('administrativo', [
            'dashboard'
        ]);
        
        /*$data['contFace']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook']]));
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','']]));
        $data['contFaceAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook'],['status_captura',3]]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem',''],['status_captura',3]]));*/

    //1)-Valor total de imóveis captados
        $data['valor_total'] = $this->dash_model->select('SUM(`val_pretendido`) as val')->getImoveis([['status', 3],['lixeira', 0],['doc_perfil','cpf']])[0]->val??0;
    
    //2)- Valor médio de imóveis captado
        $data['imoveis_publicados'] =  count($this->dash_model->getImoveis([['status', 3],['lixeira', 0],['doc_perfil','cpf']]));
        $data['valor_medio'] = $data['valor_total'] / $data['imoveis_publicados'];
        
    //4)-Valor de imóveis captado por áreas
        $data['valor_por_area'] =  $this->dash_model->getImoveis_sum_group([['status', 3],['lixeira', 0],['doc_perfil','cpf']]);
        //qnt val_medio
    //5)-Número total de cadastro compra e venda
    
    
    //6)- Churn
    
    
    //7)-NPS (por quinzena-Enviar uma Lp de avaliação do serviço de 0-10)
    
    
    //8)-Ticket médio
        $data['ticket_medio']     = $this->dash_model->select('SUM(`val_public_total`) as val')->getImoveis([['status', 3],['lixeira', 0],['doc_perfil','cpf']] )[0]->val??0;
        
    //9)-Cac (valor gasto por mês-( marketing+ atendimento) /por novos clientes de cadastro - vendas&compra) dividir pelo marketing atendimento
    
    //10 -LTV ( TICKET MEDIO X NUMERO DE SERVIÇOS ADQUIRIDOS )
    
    //11- Índice de esforço (Posteriormente a cada ação adicionar uma avaliação- ex: fez a simulação » taxa de esforço» de muito fácil,fácil ,médio ; difícil e muito difícil)
    
    //12- ideal de cac
    
    //13-curn negativo

        
        
        $naoAguardandoRetorno = [];
        $naoAtendidas = [];
        
        //===============================RESUMO ATENDIMENTO================================================
        $whereCadsImovel = [['status', 3],['doc_perfil', 'cpf']];
        $whereSimulacoes = [['id_imovel >',0]];//,['step >=', 4]
        
        //$tb_origem, $name_id, $function_get, $where, $tipo_interesse(cad_atendimento_historico), $origem_captura(so se for da cad_captura), $name(titulo), $link
        $configAtendimento = [
                ['fnc_simulacao', 'id_simulacao', 'getSimulacoes', $whereSimulacoes, 'Financiamento',    'xxx', 'Simulações',  'administrativo/atendimento/financiamento_imovel'],
                ['cad_captura', 'email', 'getCapturas', [], 'Financiamento', 'financiamento',         'LP Financiamento', 'administrativo/atendimento/financiamento'],
                ['cad_captura', 'email', 'getCapturas', [], 'Elleven',       'interessado_elleven',   'LP Elleven', 'administrativo/atendimento/elleven'],
                /*['cad_captura', 'email', 'getCapturas', [], 'Liberty',       'interessado_liberty',   'LP Liberty', 'administrativo/atendimento/liberty'],
                ['cad_captura', 'email', 'getCapturas', [], 'Signature',       'interessado_signature',   'LP Signature', 'administrativo/atendimento/signature'],
                ['cad_captura', 'email', 'getCapturas', [], 'Exclusive',     'interessado_exclusive', 'LP Exclusive', 'administrativo/atendimento/exclusive'],*/
                
                ['cad_captura', 'email', 'getCapturas', [], 'Avaliação',     'avaliacao',             'LP Avaliação', 'atendimento/atendimento/avaliacao'],
                ['cad_contato', 'id', 'getContatos', [], 'Contato',    'xxx', 'Contatos',  'atendimento/atendimento/contatos'],
                /*['cad_cadastro',  'id_cadastro',  'getCadsImovel', $whereCadsImovel, 'Anunciante ativo', 'xxx', 'Anunciantes', 'atendimento/atendimento/anunciantes'],*/
        ];
        
        foreach ($configAtendimento as $dt)
        {
            $tb_origem      = $dt[0];
            $name_id        = $dt[1];
            $function_get   = $dt[2];
            $where          = $dt[3];
            $tipo_interesse = $dt[4];
            $origem_captura = $dt[5];
            $name           = $dt[6];
            $link           = $dt[7];
            
            $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            if(!empty($CapturasNaoAtendidas)){
            $naoAtendidas[] = (object)[
                    'key'      => $tb_origem,
                    'name'     => $name,
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => $link,
                ];
            }
             
            $CapturasAtendidas = $this->admin_model->getAguardandoRetorno($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            if(!empty($CapturasAtendidas)){
                $naoAguardandoRetorno[] = (object)[
                        'key'      => $tb_origem,
                        'name'     => $name,
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => $link,
                    ];
            }
        }
        
        
        //================I N C O R P O R A D O R A S====================================================================================
        $empreendimentos = $this->admin_model->getEmpreendimentos([['contrato > ',0]]);
        foreach ($empreendimentos as $emp)
            $origens['origens'][] = ['origem_captura', $emp->uuid_empreendimento];
        $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas('cad_captura', 'id_captura', 'getCapturas', $origens);
        $naoAtendidas[] = (object)[
                    'name'     => 'Incorporadoras',
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => 'atendimento/atendimento/incorporadoras',
                ];
        $CapturasAtendidas = $this->admin_model->getAguardandoRetorno('cad_captura', 'id_captura', 'getCapturas', $origens);
        if(!empty($CapturasAtendidas)){
            $naoAguardandoRetorno[] = (object)[
                        'name'     => 'Incorporadoras',
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => 'atendimento/atendimento/incorporadoras',
                ];
        }
        //=======FIM======I N C O R P O R A D O R A S====================================================================================
        
        $data['naoAtendidas'] = $naoAtendidas;
        $data['naoAguardandoRetorno'] = $naoAguardandoRetorno;
        
        $data['informativos'] =  $this->dash_model->getInformativos();
        
        
	    Template::set($data);
		Template::set_view('administrativo/dashboard_view');
		Template::render();
    }
	
	function imovel($id_imovel) 
    {
        //$this->ini_method('cadastros');
        $imovel = $this->admin_model->getImovel([['a.id_imovel',$id_imovel]]);
        if($imovel != null)
        {
            $id_cadastro = $imovel->id_cadastro;
            $cadastro = $this->admin_model->get_cadastro([], $id_cadastro);
            $historico = $this->fluxo_model->getHistorico([['id_imovel', $id_imovel],['tipo_log','imovel']]);
            
            $w[] = ['id_imovel', $id_imovel];
            $favoritos = $this->admin_model->getFavoritos($w);
            $negociacoes = $this->admin_model->getNegoviacoes($w);
            $financiamentos = $this->admin_model->getSimulacoes($w);
        }
        
        //--C O N F I G -----
        $totalSteps      = 11;
        $totalRequesitos = 4;
        //--C O N F I G -----
        
        $data['numeroRequesitos'] = $totalRequesitos;
        $data['contCompletos'] = 
                ($imovel->dn_img==''?0:1) + 
                ($imovel->doc_propriedade==''?0:1) + 
                ($imovel->caracteristicas==''?0:1) + 
                (empty($imovel->imagens)?0:1);
                
        $data['porcentoCompleto'] = $porcentoCompleto = (int)((100/($totalSteps+$totalRequesitos))*($imovel->step+$data['contCompletos']));
        
        if ($imovel->lixeira == 1)
        {
            $statusLixeira = 'Ocutado pelo usuário';
            $bgLixeira = 'bg-warning';
        }elseif($imovel->lixeira > 1){
            $statusLixeira = 'Removido pelo usuário';
            $bgLixeira = 'bg-danger';
        }
            
        if($imovel->status > 1){
            $situacaImovel = $porcentoCompleto==100?'Cadastro completo':'Cadastro incompleto';
            $bgSituacao = $porcentoCompleto==100?'bg-success':'bg-primary';
        }else{
            $situacaImovel = 'Cadastro incompleto';
            $bgSituacao = $porcentoCompleto>50?'bg-primary':'bg-secondary';
        }
        
        $data['statusLixeira']       = $statusLixeira??'';
        $data['bgLixeira']           = $bgLixeira??'';
        $data['situacaImovel']       = $situacaImovel;
        $data['bgSituacao']          = $bgSituacao;
        $data['imovel']              = $imovel;
        $data['historico']           = $historico??[];
        $data['cadastro']            = $cadastro??null;
        $data['favoritos']           = $favoritos??[];
        $data['visualizacoes']       = $imovel->visualizacoes;
        $data['financiamentos']      = $financiamentos??[];
        $data['negociacoes']         = $negociacoes??[];
        
        $this->assets();
        
	    Template::set($data);
		Template::set_view('administrativo/dashboard_imovel_view');
		Template::render();
    }
    
    function assets()
    {
        Assets::add_css(array(
            '../comdono/plugins/blueimp/css/jquery.fileupload',
            '../comdono/plugins/blueimp/css/jquery.fileupload-ui',
            '../comdono/plugins/blueimp/css/blueimp-gallery.min',
            //'../comdono/plugins/blueimp/css/custom',
            '../comdono/plugins/unitegallery/css/unite-gallery',
            '../comdono/plugins/unitegallery/css/ug-theme-default',
            
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/blueimp/js/jquery.ui.widget',
            '../comdono/plugins/blueimp/js/tmpl.min',
            '../comdono/plugins/blueimp/js/load-image.all.min',
            '../comdono/plugins/blueimp/js/canvas-to-blob.min',
            '../comdono/plugins/blueimp/js/blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.iframe-transport',
            '../comdono/plugins/blueimp/js/jquery.fileupload',
            '../comdono/plugins/blueimp/js/jquery.fileupload-process',
            '../comdono/plugins/blueimp/js/jquery.fileupload-image',
            '../comdono/plugins/blueimp/js/jquery.fileupload-validate',
            '../comdono/plugins/blueimp/js/jquery.fileupload-ui',
            '../comdono/plugins/unitegallery/js/unitegallery.min',
            '../comdono/plugins/unitegallery/js/ug-theme-default',
            '../comdono/plugins/unitegallery/js/imovel',
            
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
        
        Assets::add_module_js('administrativo', [
            'perfil',
            'dashboard_imovel'
        ]);
        
    }
    
	function cadastros()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_cadastro');
			$crud->set_subject('Usuário do Painel');
			
			//`id_cadastro`, `nome`, `telefone`, `email`, `cpf`, `data_nascimento`, `img_perfil_uri`, `img_perfil`, `depoimento_file`, `depoimento_video`, `depoimento_text`, `cep`, `cidade`, `estado`, `vendedor`, `comprador`, `termo_uso`, `etapa`, `tipo_contato`, `bd_comdono`, `agendamento`, `melhor_dia`, `melhor_hora`, `qnt_imovel`, `email_activated`, `celular_activated`, `aviso_curtir`, `img_pj`, `img_pj_uri`, `cnpj`, `nome_fantasia`, `descricao_pj`, `data_hora_cadastro`, `timestamp_cadastro` FROM `cad_cadastro` 
			
			$crud->display_as('timestamp_cadastro','Ultima edição');
			$crud->columns(['id_cadastro','nome','telefone','email','cpf','etapa','data_hora_cadastro','timestamp_cadastro']);
			
			$crud->add_action('Perfil', '', 'administrativo/usuarios/perfil', 'icon-people');
			$crud->unset_read();
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
    
    
    /*public function index() 
    {
        //$data['contImoveis'] = $this->cad_model->countImovesStatus(false);
        //$data['countNegocDono'] = $this->cad_model->countNegocDono();
        //$data['countNegocInteressado'] = $this->cad_model->countNegocInteressado();
        //$data['countFavoritos'] = $this->cad_model->countFavoritos();
        //$data['countPropostasDono'] = $this->cad_model->countPropostasDono();
        //$data['countPropostasInteressado'] = $this->cad_model->countPropostasInteressado();
        
        
        
        //$res = $this->dash_model->getImoveis([['MONTH(data_hora_imovel)',12]]);
        
        //YEAR(data)
        //MONTH(data)
        //DAY(data)
        //$nova_data_hora = mktime(date("H"), date("i"), date("s"), date("m") , date("d") - 1, date("Y")); 
		//$datetime = date('Y-m-d H:i:s', $nova_data_hora);
        
        Assets::add_js(array(
            'js/Chart.min'
        ));
        
        Assets::add_module_js('administrativo', [
            'dashboard'
        ]);
        
        
	    //Template::set($data);
		Template::set_view('administrativo/dashboard_view');
		Template::render();
    }*/
    
}