<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
include_once GROCERY_CRUD;

class Financiamentos extends Grocery{
	
	protected $crud;
	function __construct()
	{
		parent::__construct();
		$this->load->model('administrativo/admin_model');
		
		Assets::add_module_css('administrativo', array(
            'admin',
        ));
	}
	
	
	function solicitacoes()
	{			
		try{
		    $this->ini_method();
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('fnc_simulacao');
			$crud->set_subject('Solicitações de Financiamento');
			
			$crud->where('fnc_simulacao.step >=', 4);
			//$crud->where('fnc_simulacao.id_imovel >', 0);
			
			
			$crud->set_relation('id_imovel','cad_imovel','endereco');
			$crud->set_relation('id_cad_dono','cad_cadastro','nome');
			$crud->set_relation('id_cad_interessado','cad_cadastro','nome');
			
			//`id_simulacao`, `id_imovel`, `id_cad_dono`, `id_cad_interessado`, `status`, `step`, `val_imovel`, `val_entrada`, `val_parcelas`, `val_total`, `meses_financiado`, `taxa`, `tipo_pessoa`, `cpf`, `cnpj`, `imovel_cidade`, `data_nascimento`, `renda_familiar`, `recaptcha`, `possui_fgts`, `comprador_dependente`, `beneficiado`, `data_beneficio` 
			
			//$crud->display_as('timestamp_imovel','Ultima edição');
			$crud->columns(['id_simulacao','id_imovel','id_cad_dono','id_cad_interessado','val_imovel','val_entrada','val_parcelas','meses_financiado','data_simulacao']);
			
			$crud->add_action('Bancos', '','administrativo/financiamentos/bancos','fa fa-credit-card verBancos');
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 
	
	function relatorio()
	{			
		try{
		    //$this->ini_method();
			$crud = new grocery_CRUD();
			//$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('fnc_simulacao');
			//$crud->set_relation('id_imovel','cad_imovel','dn_nome_nomefantasia');
			$crud->set_relation('id_imovel','cad_imovel','bairro');
			$crud->set_relation('id_cad_dono','cad_cadastro','nome');
			//$crud->set_relation('id_cad_interessado','cad_cadastro','nome');
			$crud->set_subject('Relatório de Simulção de Financiamento');
			
			
			//`id_simulacao`, `id_imovel`, `id_cad_dono`, `id_cad_interessado`, `status`, `step`, `val_imovel`, `val_entrada`, `val_parcelas`, `val_total`, `meses_financiado`, `taxa`, `tipo_pessoa`, `cpf`, `cnpj`, `imovel_cidade`, `data_nascimento`, `renda_familiar`, `recaptcha`, `possui_fgts`, `comprador_dependente`, `beneficiado`, `data_beneficio` 
			
			//$crud->display_as('timestamp_imovel','Ultima edição');
			//$crud->columns(['id_simulacao','id_imovel','id_cad_dono','id_cad_interessado','status','step']);
			
			//$crud->columns(['id_simulacao','id_imovel','id_cad_dono','id_cad_interessado','status','step']);
			
			$crud->add_action('Bancos', '','administrativo/financiamentos/bancos','fa fa-credit-card verBancos');
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	
	function bancos()
	{
		try{
		    //$this->ini_method('solicitacoes');
		    $this->ini_method();
			$crud = new Custom_Grocery_Crud();
			$this->valida_acoes($crud);
			
			$id_simulacao = $this->uri->segment(4);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('fnc_banco_rel_simulacao');
			$crud->where('id_simulacao', $id_simulacao);
			
			$crud->set_relation('id_banco','fnc_bancos','Banco');
			
			$state = $crud->getState();
            $state_info = $crud->getStateInfo();
            $this->load->model('administrativo/admin_model');
            $simulacao = $this->admin_model->getSimulacaoFinanciamento(['a.id_simulacao'=>$id_simulacao]);
            $interessado = $this->admin_model->getCadastro([['id_cadastro',$simulacao->id_cad_interessado]]);
            
            $crud->field_type('id_cadastro','hidden',$interessado->id_cadastro);
            $crud->field_type('id_simulacao', 'hidden', $id_simulacao);
			
			if($state == 'edit')
    		{
    		    /*$crud->field_type('id_simulacao','readonly');
    			$crud->field_type('id_cadastro','readonly');*/
    		}
			
    		$this->setViewBancos([
    		    'id_simulacao' => $id_simulacao,
                'state' => $state,
                'state_info' => $state_info,
		    ]);
			
			$crud->set_subject('Solicitações de Financiamento');
			
			$crud->unset_fields('banco_chec','agencia', 'conta');
			
			//$crud->display_as('id_simulacao', 'Nº Simulação');
			$crud->display_as('id_banco', 'Banco');
			$crud->display_as('id_cadastro', 'Nome');
			$crud->display_as('file_url', 'Proposta');
			$crud->display_as('status_bcrel', 'Status');
			
			//$crud->field_type('status_bcrel','dropdown', array('0' => 'Aguardando análise', '1' => 'Em análise', '2' => 'Aprovada', '3' => 'Negada'));
			$crud->field_type('status_bcrel','dropdown', array('0' => 'Em andamento', '1' => 'Enviado'));
			
			$crud->columns('id_banco', 'id_cadastro', 'status_bcrel', 'primeira_parcela', 'ultima_parcela', 'prazo_total', 'valor_total', 'taxa_efetiva', 'cet', 'file_url');
			
			// Callbacks
			$crud->callback_field('primeira_parcela',array($this,'_callback_field_primeira_parcela'));
			$crud->callback_field('ultima_parcela',array($this,'_callback_field_ultima_parcela'));
			$crud->callback_field('prazo_total',array($this,'_callback_field_prazo_total'));
			$crud->callback_field('valor_total',array($this,'_callback_field_valor_total'));
			$crud->callback_field('contatado',array($this,'_callback_field_contatado'));
			$crud->callback_column('status_bcrel',array($this,'_callback_status_bcrel'));
			$crud->callback_column('id_banco',array($this,'_callback_logo_banco'));
			$crud->callback_column('file_url',array($this,'_callback_icon_file'));
			
			//required_fields
			$crud->required_fields('id_banco','status_bcrel','status','contatado','file_url');
    		
		    $this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf');
		    $crud->set_field_upload_S3('file_url','financiamento/'.$id_simulacao.'/pdf');
		    
			/*$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();*/
			
			Assets::add_module_js('administrativo',['financiamento']);
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function _callback_field_primeira_parcela()
    {
      return '<input class="form-control moneyMask" name="primeira_parcela" type="text" maxlength="50">';
    }
    function _callback_field_ultima_parcela()
    {
      return '<input class="form-control moneyMask" name="ultima_parcela" type="text" maxlength="50">';
    }
    function _callback_field_prazo_total()
    {
      return '<input class="form-control moneyMask" name="prazo_total" type="number" min="12" max="420">';
    }
    function _callback_field_valor_total()
    {
      return '<input class="form-control moneyMask" name="valor_total" type="text" maxlength="50">';
    }
    
    function _callback_field_contatado()
    {
    	return ' <input type="radio" name="contatado" value="1" /> Sim  <input type="radio" name="contatado" value="0" /> Não';
    }
	
	public function _callback_status_bcrel($value, $row)
    {
      return '<div class="m-0 alert '.HProposta::getStatus($value)->bg.'">'. HProposta::getStatus($value)->text . '</div>';
    }
    
    public function _callback_logo_banco($value, $row)
    {
        $banco = $this->admin_model->getBancoFinanciamento(['id_banco'=>$value]);
        
        //var_dump($banco);
        
        return '<img src='.(base_url($banco->logo_ativa)).'>';
    }
	
	public function _callback_icon_file($value, $row){
	    if($value == ''){
	        $div = '';
	    }else{
	        $div = '<div class="text-center" style="font-size:15px"><a href="'.$value.'" target="_blank"><i class="fa fa-file-code-o" aria-hidden="true"></i></a></div>';
	    }
	    return $div;
	}
	
	function setViewBancos($data)
	{
	    $data['simulacao'] = $this->admin_model->getSimulacao([['id_simulacao',$data['id_simulacao']]]);
	    
	    if(isset($data['simulacao']->id_cad_interessado)) 
	    {
    	    $data['interessado'] = $this->admin_model->getCadastro([['id_cadastro', $data['simulacao']->id_cad_interessado]]); 
    	    
    	    $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$data['simulacao']->id_imovel]]);
    	    
            //$teste = ['status','lixeira','dn_nome_nomefantasia','dn_telefone','dn_email','dn_cpf_cnpj','dn_img','dn_img_uri','tipo_imovel','lancamento','previsao_entrega','cep','endereco','numero','complemento','bairro','cidade','estado'];
            
    	    Template::set_html_custom($data,'financiamento_view');
	    }
	}
	
	function enviadas()
	{			
		try{
		    $this->ini_method();
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('fnc_simulacao');
			$crud->set_subject('Solicitações de Financiamento');
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function finalizadas()
	{			
		try{
		    $this->ini_method();
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('fnc_simulacao');
			$crud->set_subject('Solicitações de Financiamento');
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function arquivadas()
	{			
		try{
		    $this->ini_method();
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('fnc_simulacao');
			$crud->set_subject('Solicitações de Financiamento');
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
}