<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Imovel extends Comdono_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('minha_conta/conta_model');
		$this->load->model('comdono/busca_model');
	}
	
	public function index()
    {
        $data['dashboard'] = TRUE;
        Template::set($data);
        Template::set_view('anuncios_vendas_view');
        Template::render();
    }
    
    public function negociacoes()
    {
        $this->load->model("comdono/busca_model");
        $this->load->model("chat_model");
        
        Assets::add_js(array(
            'plugins/jquery.ns-autogrow/jquery.ns-autogrow.min',
            'plugins/autosize/autosize.min'
        ));
        Assets::add_module_js('minha_conta', array(
            'chat_front',
            'chat',
        ));
        
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_negociacoes'] = TRUE;
        $data['step'] = 6;
        $data['chat_comprador'] = FALSE;
        $data['sessid'] = simple_crypt( json_encode(array('from'=>$this->session->id_cadastro)), 'e' );
        
        $data["imoveis"] = $this->chat_model->getChat([['a.id_cadastro',$this->session->id_cadastro],['chat_status',3]]);
        $data['id_cadastro'] = $this->session->id_cadastro;
        $bairros = [];
        
        $data['checkIdBairro'] = '';
        $data['checkIdImovel'] = $this->uri->segment(4);
        $data['checkIdChat'] = $this->uri->segment(5);
        
        foreach($data["imoveis"] as $id_imovel=>$imovel)
        {
            $bairros[$imovel->bairro][$id_imovel] = $imovel;
            if($id_imovel == $data['checkIdImovel'])
                $data['checkIdBairro'] = $imovel->bairro;
        }
        
        $data["bairros"] = $bairros;
        $data['usuarios_chat'] = $this->chat_model->getUsuariosChat();
        
        Template::set($data); 
        Template::set_view('chat_view');
        Template::render();
    }
    
    public function anuncios()
    {
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_anuncios'] = TRUE;
        
        
        $where[] = ['status >', 1];
        $where[] = ['id_imovel_rel', 0];
        $where[] = [['a.lixeira <', 2],[['a.lancamento','Sim'],['a.lixeira <', 3]]];
        //$where[] = ['a.lixeira <', 3];
        
    //['status >' => 1, ]
    
        $data['imoveis'] = $this->conta_model->getImoveis($where);
         
        foreach($data['imoveis'] as $imovel)
        {
            //echo ($imovel->id_imovel.' - <br>');
            //foreach($imovel->imagens as $img) echo ('<br>'.$imovel->id_imovel.' - '.@$img->id_img.'<br>');
        }
        
        Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'actions'
        ));
        
        Assets::add_module_js('minha_conta', array(
            'pagination',
            'anuncios'
        ));
        
        $data['favoritos'] = $this->busca_model->get_favoritos();
        
        Template::set($data);
        Template::set_view('anuncios_vendas_view');
        Template::render();
    }
    
    public function lancamento()
    {
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_anuncios'] = TRUE;
        $data['pgLancamento'] = TRUE;
        
        $id_imovel = $this->uri->slash_segment(4);
        
        $w[] = ['status >', 1];
        $w[] = ['a.id_imovel',$id_imovel];
        $lancamento = $this->conta_model->getImovel($w); 
        
        if($lancamento == null)            redirect('minha_conta/minhas_vendas/anuncios');
            
        if($lancamento->id_imovel_rel != 0)    redirect('minha_conta/minhas_vendas/lancamento/'.$lancamento->id_imovel_rel);
        
        
        $where[] = ['status >', 1];
        $where[] = ['a.lixeira <', 2];
        $where[] = [['a.id_imovel', $id_imovel],['a.id_imovel_rel', $id_imovel]];
        
        $data['imoveis'] = $this->conta_model->getImoveis($where);
        $data['lancamento'] = $lancamento;
            
        Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
            'plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'plugins/dataTables/js/jquery.dataTables.min',
            'plugins/dataTables/js/dataTables.bootstrap4.min'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'actions'
        ));
        
        Assets::add_module_js('minha_conta', array(
            /*'pagination',*/
            'anuncios',
            'dataTables'
            
        ));
        
        $data['favoritos'] = $this->busca_model->get_favoritos();
        
        Template::set($data);
        //Template::set_view('anuncios_vendas_view');
        Template::set_view('anuncios_vendas_lancamento_view');
        Template::render();
    }
    
    public function edit()
    {
        if(!$this->tank_auth->is_logged_in())
        {
            $referer = base_url('cadastro/imovel');
            $this->session->set_userdata('http_referer', $referer);
            $this->session->set_userdata(['botaoCadImovel' => true]);
            redirect('login');
        }
        
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        
            
        $data['imovel'] = $this->cad_model->getImovelCad(['id_imovel' => $id_imovel]); 
        if($data['imovel'] == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        $data['step'] = 1;
            if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
                $data['step'] = $uri[5];
            }
            
        $data['meuCadastro'] = json_encode($this->cad_model->get_cadastro());
        
        if(end($uri) == 'preview'){
        
            redirect(base_url('minha_conta/minhas_vendas/preview/1066'));
            
        }else{
        
            //$this->session->set_userdata(['id_imovel' => $data['imovel']->id_imovel]);
            
            if(!is_dir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel))
                mkdir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel, 0774, true);
            
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            if(!empty($data['imagens']) && $data['imagens'] !== null){ 
                $data['img_base'] = base_url('modules/anunciante/'.$data['imovel']->id_cadastro.'/'.$data['imovel']->id_imovel.'/galeria/');
            }
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];//$this->cad_model->getImoveis(['id_imovel_rel' => $data['imovel']->id_imovel ]); 
            
            //$data['arrayImovel'] = HImovel::getDetalhesImovel($data['imovel']);
            //$data['arrayCondominio'] = HImovel::getDetalhesComdominio($data['imovel']);
            
            Template::load_view('comdono/termos_view', '', '', '', $data['termos']);
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'upload_fotos_sortable',
                'initGoogleMaps',
                'config-ckeditor',
                'cadastro_imovel',
                'cadastro_imovel_front',
            ));
            
            $data['edit'] = true;
            $data['textTitulo'] = 'Editar Imóvel';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        }
    }
    
    public function edit_unidade()
    {
        if(!$this->tank_auth->is_logged_in())
        {
            $referer = base_url('cadastro/imovel');
            $this->session->set_userdata('http_referer', $referer);
            $this->session->set_userdata(['botaoCadImovel' => true]);
            redirect('login');
        }
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('minha_conta/minhas_vendas/anuncios');
            
        $data['imovel'] = $this->cad_model->getImovelCad(['id_imovel' => $id_imovel]); 
        if($data['imovel'] == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        $data['step'] = 1;
            if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
                $data['step'] = $uri[5];
            }
            
        $data['meuCadastro'] = json_encode($this->cad_model->get_cadastro());
        
        if(end($uri) == 'preview'){
        
            redirect(base_url('minha_conta/minhas_vendas/preview/1066'));
            
        }else{
        
            //$this->session->set_userdata(['id_imovel' => $data['imovel']->id_imovel]);
            
            if(!is_dir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel))
                mkdir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel, 0774, true);
            
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            if(!empty($data['imagens']) && $data['imagens'] !== null){ 
                $data['img_base'] = base_url('modules/anunciante/'.$data['imovel']->id_cadastro.'/'.$data['imovel']->id_imovel.'/galeria/');
            }
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];//$this->cad_model->getImoveis(['id_imovel_rel' => $data['imovel']->id_imovel ]);
            
            //$data['arrayImovel'] = HImovel::getDetalhesImovel($data['imovel']);
            //$data['arrayCondominio'] = HImovel::getDetalhesComdominio($data['imovel']);
            
            Template::load_view('comdono/termos_view', '', '', '', $data['termos']);
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'upload_fotos_sortable',
                'initGoogleMaps',
                'config-ckeditor',
                'edit_unidade',
                'cadastro_imovel_front',
            ));
            
            $data['edit'] = true;
            $data['edit_unidade'] = true;
            $data['textTitulo'] = 'Editar Unidade';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        }
    }
    
    public function edit_lancamento()
    {
        if(!$this->tank_auth->is_logged_in())
        {
            $referer = base_url('cadastro/imovel');
            $this->session->set_userdata('http_referer', $referer);
            $this->session->set_userdata(['botaoCadImovel' => true]);
            redirect('login');
        }
        
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('minha_conta/minhas_vendas/anuncios');
            
        $data['imovel'] = $this->cad_model->getImovelCad(['id_imovel' => $id_imovel]); 
        if($data['imovel'] == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        $data['step'] = 1;
            if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
                $data['step'] = $uri[5];
            }
            
        $data['meuCadastro'] = json_encode($this->cad_model->get_cadastro());
        
        if(end($uri) == 'preview'){
        
            redirect(base_url('minha_conta/minhas_vendas/preview/1066'));
            
        }else{
        
            //$this->session->set_userdata(['id_imovel' => $data['imovel']->id_imovel]);
            
            if(!is_dir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel))
                mkdir('./modules/anunciante/' . $this->session->id_cadastro .'/'.$data['imovel']->id_imovel, 0774, true);
            
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            if(!empty($data['imagens']) && $data['imagens'] !== null){ 
                $data['img_base'] = base_url('modules/anunciante/'.$data['imovel']->id_cadastro.'/'.$data['imovel']->id_imovel.'/galeria/');
            }
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];
            
            Template::load_view('comdono/termos_view', '', '', '', $data['termos']);
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'upload_fotos_sortable',
                'initGoogleMaps',
                'config-ckeditor',
                'edit_lancamento',
                'cadastro_imovel_front',
            ));
            
            $data['edit'] = true;
            $data['edit_lancamento'] = true;//$textTitulo
            $data['textTitulo'] = 'Editar Lançamento';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        }
    }
    
    public function preview()
    {
        if(!$this->tank_auth->is_logged_in())
        {
            $referer = base_url('cadastro/imovel');
            $this->session->set_userdata('http_referer', $referer);
            $this->session->set_userdata(['botaoCadImovel' => true]);
            redirect('login');
        }
        
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        
        $imovel = $this->cad_model->getImovelCad(['id_imovel' => $id_imovel]); 
        $data['imovel'] = $imovel; 
        if($data['imovel'] == null)
            redirect('minha_conta/minhas_vendas/anuncios');
        
        Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
            'plugins/unitegallery/css/unite-gallery',
            'plugins/unitegallery/css/ug-theme-default'
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'plugins/unitegallery/js/unitegallery.min',
            'plugins/unitegallery/js/ug-theme-default',
            'plugins/unitegallery/js/imovel'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'carousel_imovel',
            'carousel_busca',
            'imovel',
            'cadastro_imovel'
        ));
        
        $imovel->imagens = $this->cad_model->getImgsImovel($imovel->id_imovel);
        if($imovel != null)
        {
            $data['arrayImovel'] = HImovel::getDetalhesImovel($imovel);
            $data['arrayCondominio'] = HImovel::getDetalhesComdominio($imovel);
            
        }
        
        $data['edit'] = true;
        $data['preview'] = true;
        $data['step'] = 9;
        
        Template::set($data);
        Template::set_view('comdono/imovel_view');
        Template::render();
    }
    
    private function set_imovel_css_js()
    {
        Assets::add_css(array(
            'plugins/blueimp/css/jquery.fileupload',
            'plugins/blueimp/css/jquery.fileupload-ui',
            'plugins/blueimp/css/blueimp-gallery.min',
            'plugins/blueimp/css/custom',
            'plugins/unitegallery/css/unite-gallery',
            'plugins/unitegallery/css/ug-theme-default',
            'plugins/fancyBox-v3.5.7/css/jquery.fancybox.min'
        ));
        
        Assets::add_module_css('comdono', array(
            'cad_maps'
        ));
        
        Assets::add_js(array(
            'plugins/blueimp/js/jquery.ui.widget',
            'plugins/blueimp/js/tmpl.min',
            'plugins/blueimp/js/load-image.all.min',
            'plugins/blueimp/js/canvas-to-blob.min',
            'plugins/blueimp/js/blueimp-gallery.min',
            'plugins/blueimp/js/jquery.blueimp-gallery.min',
            'plugins/blueimp/js/jquery.iframe-transport',
            'plugins/blueimp/js/jquery.fileupload',
            'plugins/blueimp/js/jquery.fileupload-process',
            'plugins/blueimp/js/jquery.fileupload-image',
            'plugins/blueimp/js/jquery.fileupload-validate',
            'plugins/blueimp/js/jquery.fileupload-ui',
            'plugins/unitegallery/js/unitegallery.min',
            'plugins/unitegallery/js/ug-theme-default',
            'plugins/sortable/jquery-sortable.min',
            'plugins/unitegallery/js/imovel',
            'plugins/fancyBox-v3.5.7/js/jquery.fancybox.min',
            '../painel/plugins/ckeditor-4.6.2/ckeditor',
            '../painel/plugins/ckeditor-4.6.2/samples/js/sample',
            '../painel/plugins/ckeditor-4.6.2/adapters/jquery'
        ));
        
        
    } 
    
    /*private function set_imovel_css_js()
    {
        Assets::add_css(array(
            'plugins/blueimp/css/jquery.fileupload',
            'plugins/blueimp/css/jquery.fileupload-ui',
            'plugins/blueimp/css/blueimp-gallery.min',
            'plugins/blueimp/css/custom',
            'plugins/unitegallery/css/unite-gallery',
            'plugins/unitegallery/css/ug-theme-default'
        ));
        
        Assets::add_module_css('comdono', array(
            'cad_maps'
        ));
        
        Assets::add_js(array(
            'plugins/blueimp/js/jquery.ui.widget',
            'plugins/blueimp/js/tmpl.min',
            'plugins/blueimp/js/load-image.all.min',
            'plugins/blueimp/js/canvas-to-blob.min',
            'plugins/blueimp/js/blueimp-gallery.min',
            'plugins/blueimp/js/jquery.blueimp-gallery.min',
            'plugins/blueimp/js/jquery.iframe-transport',
            'plugins/blueimp/js/jquery.fileupload',
            'plugins/blueimp/js/jquery.fileupload-process',
            'plugins/blueimp/js/jquery.fileupload-image',
            'plugins/blueimp/js/jquery.fileupload-validate',
            'plugins/blueimp/js/jquery.fileupload-ui',
            'plugins/unitegallery/js/unitegallery.min',
            'plugins/unitegallery/js/ug-theme-default',
            'plugins/unitegallery/js/imovel',
            '../painel/plugins/ckeditor-4.6.2/ckeditor',
            '../painel/plugins/ckeditor-4.6.2/samples/js/sample',
            '../painel/plugins/ckeditor-4.6.2/adapters/jquery'
        ));
        
        Assets::add_module_js('comdono', array(
            'upload_fotos',
            'initGoogleMaps',
            'cadastro_imovel_front',
            'config-ckeditor',
            'cadastro_imovel',
        ));
    }*/
    
    public function financiamento()
    {
        /*Assets::add_module_css('comdono', array(
            'home'
        ));*/
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_financiamento'] = TRUE;
        
        Template::set($data);
        Template::set_view('financiamento_vendas_view');
        Template::render();
    }
    
    
}