<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Incorporadora extends Grocery{
    
    function __construct() 
    {
        parent::__construct();
		$this->load->model('administrativo/admin_model');
		$this->load->model('newsletter/painel_model');
		Assets::add_js(array(
            '../painel/plugins/maskedinput/mascaras'
        ));
    }
    
    
	function simula_dono_incorporadora($id_incorporadora)
	{
	    $this->ini_method('incorporadoras');
	    
	    $incorporadora = $this->admin_model->getIncorporadora([['id_incorporadora',$id_incorporadora]]);
        if($incorporadora == null)
            echo('Incorporadora não encontrada!');
        else{
            
            // `id_cadastro`, `tipo`, `id_rel`, `id_perfil`
            $membro = $this->cad_model->getMembro([
                    ['cad_cadastro.id_cadastro', $incorporadora->id_responsavel],
                    ['tipo', 1],
                    ['id_rel', $incorporadora->id_incorporadora],
                    ['id_perfil', 1],
                ]);
            
            
            if($membro == null)
            {
                $this->cad_model->insertMembro([
                    'id_cadastro' =>  $incorporadora->id_responsavel,
                    'tipo' =>                      1,
                    'id_rel' =>                    $incorporadora->id_incorporadora,
                    'id_perfil' =>                 1,
                    ]);
            }
            
	        $chave = gerar_senha(20, false);
	        $this->cad_model->updateIncorporadora($incorporadora->id_incorporadora, ['chave_simulacao' => $chave]);
	        
	        redirect(getenv('BASE_CRM')."incorporadora/login/simulacao/".$chave);
        }
        
	}
	
    
    
    public function atualiza_galeria($id_empreendimento)
    {
        
        $empreendimento = $this->cad_model->getEmpreendimento(['id_empreendimento',$id_empreendimento]);
        
        if (($empreendimento->id_imovel??0) == 0) 
            throw new Exception("ID_IMOVEL NULL");
        
        $imovel = $this->cad_model->getImovel(['id_imovel'=> $empreendimento->id_imovel]);
        
        $imagens = $this->cad_model->getImgsImovel($imovel->id_imovel);
        
        
        foreach( $this->cad_model->getImoveis(['id_imovel_rel'=>$imovel->id_imovel]) as $imovelRel ){
            $this->cad_model->deletaImgsImovel($imovelRel->id_imovel);
            echo("<br><br> Imovel $imovelRel->id_imovel <br> Fotos: ");
            
            foreach ($imagens as $imagem)
            {
                $img = (array)$imagem;
                $img['id_img_rel'] = $img['id_img'];
                $img['id_imovel'] = $imovelRel->id_imovel;
                unset($img['id_img']);
                
                $this->cad_model->update_galeria($img);//insert<-----------------------
                
                echo($img['id_img_rel']." - ");
                   
                
            }
            
                
        }
        echo("<br><br> -------------- FIM ----------------- <br><br><br><br><br><br>");
        
    }
    
    
    public function migra_atendimento()
    {
        $this->ini_method('incorporadoras');
        //1 origem_captura, 2 tipo_interesse, 3 UUID
       $chaves = [
           //['interessado_liberty','Liberty','liber_attos_ab5'],
           //['interessado_signature','Signature','UUID'],
           //['interessado_elleven','elleven','ellev_attos_urg91m'],//uuid_emp
           //['ellev_attos_urg91m','ellev_attos_urg91m','uuid_emp'],//
           ];
           
        foreach ($chaves as $chave)
        {
            $origem_captura = $chave[0];
            $tipo_interesse = $chave[1];
            $UUID           = $chave[2];
            $capturasGeral = $this->admin_model->getCapturasOrderBy([['origem_captura',$origem_captura]]);
            $capturas = [];
            foreach ($capturasGeral as $cap){
                $cap->atendimentos = $this->admin_model->getAtendimentoHistoricoDesc( [['email',$cap->email],['tipo_interesse',$tipo_interesse]   ]);
                $capturas[$cap->email] = $cap;
            }
            foreach ($capturas as $cap)
            {
                $tb_rel = 'cad_captura';
                $id_rel = $cap->id_captura;
                if(!empty($cap->atendimentos))
                {
                    $atend = $this->cad_model->getAtendimento([['id_rel',$id_rel],['tb_origem',$tb_rel]])[0]??null;
                    if($atend == null)
                        $id_atendimento = $this->cad_model->setAtendimento(['id_rel' => $id_rel, 'tb_origem' => $tb_rel]);
                    else
                        $id_atendimento = $atend->id_atendimento;
                        
                    foreach ($cap->atendimentos as $historico)
                    {
                        $historico->id_atendimento = $id_atendimento;
                        $historico->tipo_interesse = $UUID;
                        $this->cad_model->updateAtendimentoHistorico($historico->id_hist_atend, (array)$historico);
                    }
                }
                $this->cad_model->updateCaptura($id_rel, ['origem_captura' => $UUID]);
            }
        }
    }
	
    public function resumo($id_incorporadora = null) 
    {
        $this->ini_method('incorporadoras')->breadcrumb('Empreendimentos');
        
        $data['incorporadora'] = $incorporadora = $this->admin_model->getIncorporadora([['id_incorporadora',$id_incorporadora]]);
        if($incorporadora == null)
            redirect('administrativo/incorporadora/');
        
        $data['responsavel']     = $responsavel     = $this->admin_model->getCadastro([['id_cadastro',$incorporadora->id_responsavel]]);
        $data['empreendimentos'] = $empreendimentos = $this->admin_model->getEmpreendimentos([['id_incorporadora',$incorporadora->id_incorporadora]]);
        $data['parceiros']       = $parceiros       = $this->admin_model->getParceiros();
        $data['meusParceiros']    = $meusParceiros   = $this->admin_model->getParceirosIncorporadora(['inc_incorporadora.id_incorporadora',$incorporadora->id_incorporadora]);
        
        
        //$data['lpConfig'] = $this->admin_model->getLpConfig([['id_imovel',$empreendimento->id_imovel]]);
        $data['propostas'] = $this->cad_model->getPropostas();
        
        $this->pluginsAssets();
        
        $this->dataTables();
        
        Assets::add_module_css('administrativo', array(
            'incorporadora'
        ));
        
        Assets::add_module_js('administrativo', array(
            'incorporadora/incorporadora',
        ));
        
        
        
        Template::set($data);
		Template::set_view('incorporadora/resumo_view');
		Template::render();
    }
    
    public function empreendimento($id_empreendimento = null) 
    {
        $this->ini_method('incorporadoras');
        $data['empreendimento'] = $empreendimento = $this->admin_model->getEmpreendimento(['id_empreendimento',$id_empreendimento]);
        $this->breadcrumb('Empreendimentos',"resumo/".$empreendimento->id_incorporadora)->breadcrumb($empreendimento->emp_razao_social);
        
        $data['incorporadora'] = $this->admin_model->getIncorporadora([['id_incorporadora',$empreendimento->id_incorporadora]]);
        
        $parceiros = $this->admin_model->getParceirosIncorporadora();
        
        $parceirosSelecionados = $this->admin_model->getParceirosEmpreendimento(['id_empreendimento',$id_empreendimento]);
        
        foreach ($parceiros as $par){
            $par->selected = '';
            foreach ($parceirosSelecionados as $parSected)
                if($par->id_parceiro == $parSected->id_parceiro && $par->id_incorporadora == $parSected->id_incorporadora)
                    $par->selected = 'selected="selected"';
        }
        //dd($parceiros);
        
        $data['parceiros'] = $parceiros;
        
        $data['proposta'] = $proposta = $this->cad_model->getProposta(['id_proposta',$empreendimento->id_proposta]);
        $planos_rel = json_decode($proposta->planos_rel);
        $planos = [];
        foreach ($planos_rel as $id_plano)
        {
            $planos[] = $this->cad_model->getPlano(['id_plano',$id_plano]);
        }
        $data['planos'] = $planos;
        
        //dd($data['proposta']);
        
        $data['tiposImovel'] = HBusca::getSelectTiposImovel();
        $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$empreendimento->id_imovel]]);
        $data['unidades'] = [];
        if($data['imovel'] != null)
        {
            $data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            $data['unidades'][0] = $data['imovel'];
            $data['unidades'] = array_merge(($data['unidades']), $this->cad_model->getImoveis(['id_imovel_rel' => $empreendimento->id_imovel ])); 
            
            
            //---------STATUS MODERACAO-------------
            $imovel = $data['imovel'];
            if ($imovel->lixeira == 1)
            {
                $statusLixeira = 'Ocutado pelo usuário';
                $bgLixeira = 'bg-warning';
            }elseif($imovel->lixeira > 1){
                $statusLixeira = 'Removido pelo usuário';
                $bgLixeira = 'bg-danger';
            }
            $data['statusLixeira']       = $statusLixeira??'';
            $data['bgLixeira']           = $bgLixeira??'';
            //---FIM---STATUS MODERACAO-------------
            
        }
        
        $data['lpConfig'] = $lpConfig =  $this->admin_model->getLpConfig([['id_imovel',$empreendimento->id_imovel]]);
        
        if($lpConfig != null){
            $data['unidadesLp'] = $this->admin_model->getUnidades([['id_config',$lpConfig->id_config]]);
            $data['diferenciais'] = $this->admin_model->getDiferenciais([['id_config',$lpConfig->id_config]]);
            $data['comodidadesLp'] = $this->admin_model->getComodidades([['id_config',$lpConfig->id_config]]);
        }
        //ASSETS-----------
        
        $data['valoresMidia'] = $valoresMidia = $this->admin_model->getSumValoresMidia([['id_empreendimento',$empreendimento->id_empreendimento]]);
        //dd($data['valoresMidia']);
        
        $getSumValoresImovel[] = [['id_imovel', $empreendimento->id_imovel],['id_imovel_rel', $empreendimento->id_imovel]];
        $sumValoresImovel = $this->admin_model->getSumValoresImovel($getSumValoresImovel)->valor??0;
        $data['valorInvestimento'] = $valorInvestimento = ($sumValoresImovel>0)?$sumValoresImovel/100:0;
        
        $data['midiasMensal'] = 0;
        $data['remuneracaoTotal'] = 0;
        $data['plano'] = $plano = $this->admin_model->getPlano([['id_plano',$empreendimento->id_plano]]);
        if($plano != null){
            $data['remuneracaoTotal'] = $valorInvestimento*$plano->comissao;
            $data['midiasMensal'] = $valorInvestimento/$plano->meses;
        }
        //$data['investimento'] = $this->admin_model->getInvestimentos([['id_empreendimento',$empreendimento->id_empreendimento],['midia',$valoresMidia->midia]]);
        $data['investimentos'] = $this->admin_model->getInvestimentos([['id_empreendimento',$empreendimento->id_empreendimento]]);
        
       
        
        
        
        
        
        
        
        //dd($data['investimento']);
        $this->pluginsAssets();
        
        Assets::add_css(array(
            '../painel/plugins/select2-4.1.0-beta.1/select2.min'
        ));
        
        Assets::add_js(array(
            '../painel/plugins/select2-4.1.0-beta.1/select2.min'
        ));
        
        Assets::add_module_js('comdono', array(
                'config_uri_ajax',
                'initGoogleMaps',
                'upload_fotos_sortable',
                //'config-ckeditor',
            ));
        
        Assets::add_module_css('administrativo', array(
            'incorporadora'
        ));
        Assets::add_module_js('administrativo', array(
            'incorporadora/incorporadora',
            'incorporadora/empreendimento'
        ));
        
        Template::load_view('administrativo/incorporadora/ac_empreendimento_view.php', $data, '', '', $data['ac_empreendimento']);
        Template::load_view('administrativo/incorporadora/ac_administrativo_view.php', $data, '', '', $data['ac_administrativo']);
        Template::load_view('administrativo/incorporadora/ac_imovel_view.php',         $data, '', '', $data['ac_imovel']);
        Template::load_view('administrativo/incorporadora/ac_investimento_view.php',   $data, '', '', $data['ac_investimento']);
        Template::load_view('administrativo/incorporadora/ac_landingpage_view.php',    $data, '', '', $data['ac_landingpage']);
        //ASSETS-----------
        Template::set($data);
		Template::set_view('incorporadora/empreendimento_view');
		Template::render();
    }
    
    function incorporadoras()
	{
		try{
		    $this->ini_method();
			$crud = new Custom_Grocery_Crud();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('inc_incorporadora');
			$crud->set_subject('Incorporadora');
            $crud->field_type('id_responsavel', 'hidden');
			$crud->columns('id_incorporadora','incorporadora', 'logo', 'responsavel', 'login', 'senha');
			$this->config->set_item('grocery_crud_file_upload_allow_file_types','logo');
		    $crud->set_field_upload_S3('logo','comdono/lp/venda-inteligente/images/logos');
			$crud->required_fields('incorporadora', 'logo', 'responsavel', 'login', 'senha','status');
			$crud->field_type('data_cadastro', 'hidden', date("Y-m-d H:i:s"));
			$crud->field_type('data_hora_atualizacao', 'hidden', date("Y-m-d H:i:s"));
			$crud->unset_fields('acessos','ultimo_acesso');
			$crud->add_action('Resumo', '', 'administrativo/incorporadora/resumo','fa-pencil');
			$crud->add_action('SIMULAR', '', 'administrativo/incorporadora/simula_dono_incorporadora','fa-user');
			$crud->unset_read()->unset_delete()->unset_edit();
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
            if($state == 'edit')
    		    $crud->unset_fields('data_cadastro','acessos','ultimo_acesso');
    		    
			$crud->set_rules('email', 'Email',[['email_callable',function($email){
                if($email != '' && !empty(Cad_model::getCadastroByEmail($email))){
                    $this->form_validation->set_message('email_callable', 'Email já tem cadastro no sistema');
                    return false;
                }else{
                    return true; 
            }}]]);
            
			$crud->callback_after_insert(function($post_array,$primary_key){
			    $hasher = new PasswordHash($this->config->item('phpass_hash_strength', 'tank_auth') , $this->config->item('phpass_hash_portable', 'tank_auth'));
                $post_array['nome'] = $post_array['responsavel'];
                $post_array['username'] = $post_array['login'];
                $post_array['email'] = $post_array['email'];
                $post_array['password'] = $hasher->HashPassword($post_array['senha']);
                $post_array['etapa'] = 8;
                $post_array['incorporadora'] = 1;
                $post_array['data_hora_cadastro'] = date("Y-m-d H:i:s");
                $result = Cad_model::setCadUser($post_array);
                $id_cadastro = $result['id_cadastro'];
                $this->db->where('id_incorporadora', $primary_key)->update('inc_incorporadora',['id_responsavel' => $id_cadastro]);
                /*$historico_log_update = array(
                    "id_proposta" => $primary_key,
                    "status" => $post_array['status'],
                    "data_hora_atualizacao" => date('Y-m-d H:i:s'),
                    "id_cadastro" => $this->session->id_cadastro
                );
                $this->db->insert('cad_proposta_historico',$historico_log_update);*/
                return true;
            });
            
			$output = $crud->render();
			$this->_example_output($output);
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function parceiros()
	{
		try{
		    $this->ini_method();
			$crud = new Custom_Grocery_Crud();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('inc_parceiro');
			$crud->set_subject('Parceiros');
			
		    $crud->set_field_upload_S3('par_logo','comdono/parceiros/logos');
			$crud->required_fields('tipo_atendimento', 'tipo_parceiro', 'par_razao_social');
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$crud->callback_field('tipo_atendimento',function ($value = 0, $primary_key = null) {
                return '
                <select class="form-control" id="tipo_atendimento" name="tipo_atendimento" required="required">
                    <option value="0" >Selecione</option>
                    <option value="1" '.($value==1?'selected':"").'>Painel CS</option>
                    <option value="2" '.($value==2?'selected':"").'>Painel Incorporadora</option>
                </select>
                ';
            })->callback_column('tipo_atendimento',function ($value, $row){
			    $array = ["","Painel CS", "Painel Incorporadora"];
			    return $array[$value]??"";
			});
            
            $crud->callback_field('tipo_parceiro',function ($value = 0, $primary_key = null) {
                return '
                <select name="tipo_parceiro" class="form-control" id="tipo_parceiro" required="required">
                    <option value="0">Selecione</option>
                    <option value="1" '.($value==1?"selected":"").'>House</option>
                    <option value="2" '.($value==2?"selected":"").'>Imobiliária</option>
                </select>
                ';
            })->callback_column('tipo_parceiro',function ($value, $row){
			    $array = ["","House", "Imobiliária"];
			    return $array[$value]??"";
			});
            
			$output = $crud->render();
			$this->_example_output($output);
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function eventos()
	{
		try{
		    $this->ini_method();
			$crud = new Custom_Grocery_Crud();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			$crud->set_table('inc_evento');
			$crud->set_subject('Eventos');
			//$crud->columns('id_evento', 'uuid_evento', 'id_empreendimento', 'id_parceiro', 'nome_evento', 'data_hora', 'local', 'agendamento', 'texto', 'texto_confirmacao', 'logo1', 'logo2', 'video', 'link_itinerario', 'seo_titulo', 'seo_descricao', 'seo_site_url', 'seo_img', 'status');
			$crud->columns('id_evento', 'uuid_evento', 'id_empreendimento', 'nome_evento', 'data_hora', 'seo_site_url');
		    $crud->set_field_upload_S3('logo1','comdono/eventos/images');
		    $crud->set_field_upload_S3('logo2','comdono/eventos/images');
		    $crud->set_field_upload_S3('logo_empreendimento','comdono/eventos/images');
		    $crud->set_field_upload_S3('logo_comdono','comdono/eventos/images');
		    $crud->set_field_upload_S3('video','comdono/eventos/videos');
		    $crud->set_field_upload_S3('seo_img','comdono/eventos/images');
			//$crud->required_fields('tipo_atendimento', 'tipo_parceiro', 'par_razao_social');
			
			$crud->set_relation('id_empreendimento','inc_empreendimento','emp_razao_social');
			$crud->set_relation('id_parceiro','inc_parceiro','par_razao_social');
			
			$crud->callback_field('tag_captura',array($this,'add_field_callback_tag_captura'));
			$crud->callback_field('tag_obrigado',array($this,'add_field_callback_tag_obrigado'));
			
			$stateInfo = $crud->getStateInfo();
			$state     = $crud->getState();
			
			$crud->add_action('Enviar Mensagem','','administrativo/Incorporadora/enviar_msg','fa fa-envelope-o');
			
			$output = $crud->render();
			$this->_example_output($output);
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function enviar_msg($id_evento){
	    
	    $this->ini_method('eventos');
	    
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
			    
		Assets::add_module_js('administrativo',array(
            'evento_enviar_msg',
            
        ));
        
        Assets::add_module_js('atendimento', array(
            'atendimento_geral',
        ));
	    
	    
	    
	    
	    $data['campanhas'] = $this->painel_model->get_campanhas($this->session->perfil);
	    
	    $data['log_whats'] = $this->cad_model->getLogsWhatsapp([['id_evento',$id_evento],['enviado',1]]);
	    
	    $data['evento'] = $this->cad_model->getEvento([['id_evento', $id_evento]]);
	    $id_emp = $data['evento']->id_empreendimento;
	    
	    $data['empreendimento'] = $this->cad_model->getEmpreendimento([['id_empreendimento', $id_emp]]);
	    $uuid_emp = $data['empreendimento']->uuid_empreendimento;
	    
	    $arquivo = $this->cad_model->getArquivo(['nome',$data['evento']->uuid_evento]);
	    $data['log_emails'] = [];
	    if($arquivo != null){
	        $data['log_emails'] = $this->admin_model->get_log_emails([['enviado',1],['id_arquivo',$arquivo->id_arquivo]]);
	    }
	    
	    
	    /*
	    - age_agenda -> status_agenda = 5 -> desistencia

        - cad_captura -> origem_captura: rivie_base_0k921f / link: formConvite
        (não mandar para status_captura = 4 ou 3)
        filtrar aqueles com status 4 que cancelaram cadastro e não vão receber o convite
        
        
        - cad_captura -> origem_captura: rivie_base_0k921f
        (pode mandar para status_captura = 0, 1 ,2 e 4)
        
        rivie_base_0k921f -> exemplo de uuid_empreendimento
        */
        $ids_captura = [];
	    $capturas = [];
	    //Capturas pré-cadastro = status_captura = 0, 1 ou 2
	    
	    $wStatus = [['status_captura', 0],['status_captura', 1],['status_captura', 2]];
	    $wOrigem_captura = ['origem_captura', $uuid_emp];
	    
	    $capturas1 = $this->cad_model->getCapturas([$wStatus, $wOrigem_captura,['link !=', 'formConvite']]);
	    if(!empty($capturas1)){
	        $capturas = array_merge($capturas,$capturas1);
	        foreach($capturas1 as $c1){
	            array_push($ids_captura,$c1->id_captura);
	        }
	    }
	    
	    //Capturas desistencia = status_captura = 4
	    $capturas2 = $this->cad_model->getCapturas([$wOrigem_captura,['status_captura', 4],['link !=', 'formConvite']]);
	    if(!empty($capturas2)){
	        $capturas = array_merge($capturas,$capturas2);
	        foreach($capturas2 as $c2){
	            array_push($ids_captura,$c2->id_captura);
	        }
	    }
	    //Capturas que desistiram no agendamento
	    $capturas3 = [];
	    $capturas_agenda = $this->cad_model->getCapAgendas([['status_agenda', 5],['link !=', 'formConvite']]);
	    foreach($capturas_agenda as $cap){
	        if($cap->origem_captura == $uuid_emp){
	            array_push($capturas3,$cap);
	        }
	    }
	    if(!empty($capturas3)){
	         $capturas = array_merge($capturas,$capturas3);
	         foreach($capturas3 as $c3){
	            array_push($ids_captura,$c3->id_captura);
	         }
	    }
	    //Não mandar para as capturas que foram capturados no convite e desistiram
	    $capturas4 = $this->cad_model->getCapturas([$wOrigem_captura,['link', 'formConvite'],['status_captura !=', 3],['status_captura !=', 4]]);
	    if(!empty($capturas4)){
	         $capturas = array_merge($capturas,$capturas4);
	         foreach($capturas4 as $c4){
	            array_push($ids_captura,$c4->id_captura);
	         }
	    }
	    
	    //Passar pra object porque o json_encode na view da erro na passagem pro ajax, da undefined se for um array
	    $data['capturas'] = (object)$capturas;
        $data['ids_captura'] = (object)$ids_captura;
        
	    Template::set($data);
        Template::set_view('evento_enviar_msg_view');
        Template::render();
	}
    
    function add_field_callback_tag_captura($val="",$id=null)
    {
        return '<textarea id="field-tag_captura" class="form-control" row="4" name="tag_captura">'.$val.'</textarea>';
    }
    
    function add_field_callback_tag_obrigado($val="",$id=null)
    {
        return '<textarea id="field-tag_obrigado" class="form-control" row="4" name="tag_obrigado">'.$val.'</textarea>';
    }
	
	/*
	old
	function simula_dono_incorporadora($id_incorporadora)
	{
	    $this->ini_method('incorporadoras');
	    
	    $incorporadora = $this->admin_model->getIncorporadora([['id_incorporadora',$id_incorporadora]]);
        if($incorporadora == null)
            echo('Incorporadora não encontrada!');
        else{
            
	        $this->session->set_userdata('id_simulado', $incorporadora->id_responsavel);
	        redirect('incorporadora');
        }
        
	}*/
	
	function _sair_simulacao_incorporadora(){
	    $this->session->unset_userdata('id_simulado');
        redirect('administrativo/incorporadora/incorporadoras');
	}
	
	
	public function Planos() 
    {
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('inc_planos');
			$crud->set_subject('Planos'); 
		    
		    $crud->columns(['id_plano', 'plano', 'comissao', 'meses', 'condicao', 'desc_condicao', 'desc_servicos', 'img']);
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function Propostas() 
    {
        try{
		    $this->ini_method();
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();
			$crud->set_theme('bootstrap');
			$crud->set_table('inc_propostas');
			$crud->set_subject('Propostas'); 
			
			$crud->columns(['id_proposta', 'tipo_proposta', 'planos_rel']);
			
			$crud->callback_field('planos_rel',array($this,'add_field_callback_planos_rel'));
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    function add_field_callback_planos_rel()
    {
        return '<textarea id="field-planos_rel" class="form-control" row="4" name="planos_rel"></textarea>';
    }
    
    public function notificacoes() 
    {
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('ntf_msg');
			$crud->set_subject('Notificações'); 
		    
		    $crud->columns(['id_msg','uuid_msg','text','cor','icon','href']);
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function dataTables(){
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            /*'../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',*/
            '../comdono/plugins/dataTables/js/config'
        ));
	}
	
    function pluginsAssets()
    {
        Assets::add_css(array(
            '../comdono/plugins/blueimp/css/jquery.fileupload',
            '../comdono/plugins/blueimp/css/jquery.fileupload-ui',
            '../comdono/plugins/blueimp/css/blueimp-gallery.min',
            '../comdono/plugins/blueimp/css/custom',
            '../comdono/plugins/unitegallery/css/unite-gallery',
            '../comdono/plugins/unitegallery/css/ug-theme-default',
            '../painel/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min',
        ));
        Assets::add_js(array(
            '../comdono/plugins/blueimp/js/jquery.ui.widget',
            '../comdono/plugins/blueimp/js/tmpl.min',
            '../comdono/plugins/blueimp/js/load-image.all.min',
            '../comdono/plugins/blueimp/js/canvas-to-blob.min',
            '../comdono/plugins/blueimp/js/blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.iframe-transport',
            '../comdono/plugins/blueimp/js/jquery.fileupload',
            '../comdono/plugins/blueimp/js/jquery.fileupload-process',
            '../comdono/plugins/blueimp/js/jquery.fileupload-image',
            '../comdono/plugins/blueimp/js/jquery.fileupload-validate',
            '../comdono/plugins/blueimp/js/jquery.fileupload-ui',
            '../comdono/plugins/unitegallery/js/unitegallery.min',
            '../comdono/plugins/unitegallery/js/ug-theme-default',
            '../comdono/plugins/unitegallery/js/imovel',
            '../comdono/plugins/sortable/jquery-sortable.min',
            '../painel/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min',
            '../painel/plugins/bootstrap-colorpicker/js/config',
            '../painel/plugins/ckeditor-4.6.2/ckeditor',
            '../painel/plugins/ckeditor-4.6.2/samples/js/sample',
            '../painel/plugins/ckeditor-4.6.2/adapters/jquery',
            
        ));
    }
}