<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Operacao extends Admin_Controller {
	
	function __construct()
	{
		parent::__construct();
		Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
        
        $this->load->model('administrativo/fluxo_model');
        $this->load->model('administrativo/admin_model');
	}
	
	//---- O P O R T U N I D A D E
	function venda() 
	{
        Assets::add_module_js('administrativo',[
            'main',
            'atendimento',
            'op_venda',
        ]);
        
        //$permissoes = $this->fluxo_model->getPermicoesPerfil();
        
        /*$olxs = [];
        foreach ($permissoes as $k=>$perm)
        {
            $where = [[['status', ''],['status', null]],['is_professional',0] ,  ['bairro', $perm->bairro  ], ['val_public_total >=', $perm->valor_minimo], ['val_public_total <=', $perm->valor_maximo] ];
            $olxs = array_merge($olxs, $this->fluxo_model->randLimit(5)->getOlxs($where));
        }*/
        
        $where = [[['status', ''],['status', null]],['is_professional',0] ];
        $olxs = $this->fluxo_model->randLimit(1)->getOlxs($where);
        
        
        
        $olxsAguradando = $this->fluxo_model->getOlxs([['status','Aguardando'],['id_responsavel',$this->session->id_cadastro]]);
        foreach ($olxsAguradando as $olx)
        {
            $olx->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$olx->id],['tb_origem', 'crawler_olx']]);
            //$olx->id_rel = $olx->id;
            //$olx->tb_origem = 'crawler_olx';
        }
        $olxsFinalizado = $this->fluxo_model->getOlxs([['status !=','Aguardando'],['id_responsavel',$this->session->id_cadastro]]);
        foreach ($olxsFinalizado as $olx)
        {
            $olx->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$olx->id],['tb_origem', 'crawler_olx']]);
            //$olx->id_rel = $olx->id;
            //$olx->tb_origem = 'crawler_olx';
        }
        
        $data['olxs'] = $olxs;
        $data['olxsAguradando'] = $olxsAguradando;
        $data['olxsFinalizado'] = $olxsFinalizado;
        
	    Template::set($data);
		Template::set_view('administrativo/operacao/venda/dashboard_view');
		Template::render();
    }
    
    function ini_operacao($id_ini,$origem)
	{
	    //flx_card
	    //`id_card`, `id_lista`, `id_captura`, `id_cadastro`, `id_imovel`, `data_criacao`, `data_modificado`, `origem`, `nome`, `email`, `telefone`, `cpf`, `titulo`, `tipo_imovel`, `cep`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`
	    //crawler_olx
	    //`id_anuncio`, `titulo`, `quartos`, `val_public_total_metro`, `val_condominio`, `vaga`, `val_public_total`, `val_public_antigo`, `tipo_imovel`, `cidade`, `bairro`, `estado`, `dt_captura`, `url`
	    
	    if($id_ini != null && $origem == 'olx'){
	        $olx = $this->fluxo_model->getOlx([['id',$id_ini]]);
	        
	        $card = [
        	        'id_lista'        => 1,
        	        'id_oportunidade' => $id_ini,
        	        'data_criacao'    => date("Y-m-d H:i:s"),
        	        'origem'          => 'crawler_olx',
        	        'tipo_imovel'     => $olx->tipo_imovel,
        	        'titulo'          => $olx->titulo,
        	        'bairro'          => $olx->bairro,
        	        'cidade'          => $olx->cidade,
        	        'estado'          => $olx->estado,
        	        'id_responsavel'  => $this->session->id_cadastro
    	        ];
    	        
	        $id_card = $this->fluxo_model->insertCard($card);
	        
	        if($id_card)
	            $this->fluxo_model->updateOlx([['id',$id_ini]],['status' => 'Iniciado']);
	        
	        redirect('administrativo/operacao/quadro/1');
	    }
	    redirect('administrativo/operacao/venda');
	}
    
    function quadro2($id_quadro) 
	{
	    Assets::add_js(array(
            //'../painel/plugins/ui/jquery-ui-1.12.1.cupertino/jquery-ui.min', //arrasta_div
            '../painel/plugins/dragscroll/dragscroll.js' //arrasta_scroll
        ));
        Assets::add_module_js('administrativo', [
            //'arrasta_div',
            'op_venda'
        ]);
        
        $quadro = $this->fluxo_model->getQuadro([['id_quadro', $id_quadro]]);
        $data['tiposImovel'] = HBusca::getSelectTiposImovel();
        $data['fotografos'] = $this->cad_model->getCadUsers([['perfil', 6]]);
        //dd($data['fotografos']);
        //var_dump($quadro);
        if($quadro != null)
        {
            $data['quadro'] = $quadro;
            
            $listas = $this->fluxo_model->getListasPerfil($id_quadro);
            
            foreach ($listas as $lista)
            {
                $lista->cards = $this->fluxo_model->getCardsPerfil($lista->id_lista);
                
                foreach ($lista->cards as $card)
                {
                    //$card->cadastro = null;
                    if($card->id_cadastro > 0)
                        $card->cadastro = $this->fluxo_model->getCadastro([['id_cadastro', $card->id_cadastro]]);
                        
                    ///$card->imovel = null;
                    if($card->id_imovel > 0)
                        $card->imovel = $this->fluxo_model->getImovel([['a.id_imovel', $card->id_imovel]]);
                        
                    if($this->session->perfil == 1){
                        if($card->id_responsavel > 0)
                            $card->atendente = $this->fluxo_model->getCadastro([['id_cadastro', $card->id_responsavel]]);
                            
                        if($card->id_fotografo > 0)
                            $card->fotografo = $this->fluxo_model->getCadastro([['id_cadastro', $card->id_fotografo]]);
                    }
                }
            }
            
            $data['listas'] = $listas;
        }
        
	    Template::set($data);
		Template::set_view('administrativo/operacao/venda/quadro2_view');
		Template::render();
    }
    
    
    function quadro($id_quadro) 
	{
	    Assets::add_js(array(
            //'../painel/plugins/ui/jquery-ui-1.12.1.cupertino/jquery-ui.min', //arrasta_div
            '../painel/plugins/dragscroll/dragscroll.js' //arrasta_scroll
        ));
        Assets::add_module_js('administrativo', [
            //'arrasta_div',
            'op_venda'
        ]);
        
        $quadro = $this->fluxo_model->getQuadro([['id_quadro', $id_quadro]]);
        $data['tiposImovel'] = HBusca::getSelectTiposImovel();
        $data['fotografos'] = $this->cad_model->getCadUsers([['perfil', 6]]);
        //dd($data['fotografos']);
        //var_dump($quadro);
        if($quadro != null)
        {
            $data['quadro'] = $quadro;
            
            $listas = $this->fluxo_model->getListasPerfil($id_quadro);
            
            foreach ($listas as $lista)
            {
                $lista->cards = $this->fluxo_model->getCardsPerfil($lista->id_lista);
                
                foreach ($lista->cards as $card)
                {
                    //$card->cadastro = null;
                    if($card->id_cadastro > 0)
                        $card->cadastro = $this->fluxo_model->getCadastro([['id_cadastro', $card->id_cadastro]]);
                        
                    ///$card->imovel = null;
                    if($card->id_imovel > 0)
                        $card->imovel = $this->fluxo_model->getImovel([['a.id_imovel', $card->id_imovel]]);
                        
                    if($this->session->perfil == 1){
                        if($card->id_responsavel > 0)
                            $card->atendente = $this->fluxo_model->getCadastro([['id_cadastro', $card->id_responsavel]]);
                            
                        if($card->id_fotografo > 0)
                            $card->fotografo = $this->fluxo_model->getCadastro([['id_cadastro', $card->id_fotografo]]);
                    }
                    //dd($card);
                }
            }
            //dd($listas);
            $data['listas'] = $listas;
        }
        
	    Template::set($data);
		Template::set_view('administrativo/operacao/venda/quadro_view');
		Template::render();
    }
}