<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
include_once GROCERY_CRUD;

class Propostas extends Grocery{
	
	protected $crud;
	function __construct()
	{
		parent::__construct();
	}
	
	function index()
	{			
		try{
		    $this->ini_method();
			$crud = new Custom_Grocery_Crud();
			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_proposta');
			$crud->set_subject('Propostas');
			
			$crud->columns('id_proposta','incorporadora', 'logo', 'responsavel', 'login', 'senha', 'status', 'data_hora_atualizacao','data_cadastro','acessos','ultimo_acesso');
			
			$this->config->set_item('grocery_crud_file_upload_allow_file_types','logo');
		    $crud->set_field_upload_S3('logo','comdono/lp/venda-inteligente/images/logos');
		    
			$crud->required_fields('incorporadora', 'logo', 'responsavel', 'login', 'senha','status');
			
			$crud->field_type('data_cadastro', 'hidden', date("Y-m-d H:i:s"));
			$crud->field_type('data_hora_atualizacao', 'hidden', date("Y-m-d H:i:s"));
			
			$crud->unset_fields('acessos','ultimo_acesso');
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			if($state == 'edit')
    		{
    		    $crud->unset_fields('data_cadastro','acessos','ultimo_acesso');
    		}
			
    		$crud->callback_after_update(array($this, 'proposta_historico'));
			 $crud->callback_after_insert(array($this, 'proposta_historico'));
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function proposta_historico($post_array,$primary_key)
    {
        $historico_log_update = array(
            "id_proposta" => $primary_key,
            "status" => $post_array['status'],
            "data_hora_atualizacao" => date('Y-m-d H:i:s'),
            "id_cadastro" => $this->session->id_cadastro
        );
     
        $this->db->insert('cad_proposta_historico',$historico_log_update);
     
        return true;
    }
}