<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Seo extends Grocery {

    function __construct() 
    {
        parent::__construct();
		$this->load->model('administrativo/admin_model');
    }
    
    public function Sitemap() 
    {
        
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_sitemap');
			$crud->set_subject('Sitemap - Diversos'); 
            
            $crud->callback_add_field('uri',array($this,'add_field_callback_uri'));
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    function add_field_callback_uri()
    {
        return '
        <div class="row">
        <div class="col-sm-5"><input type="text" name="uri" value="'.base_url().'" class="form-control" readonly="readonly"></div>
        <div class="col-sm-7">
        <input type="text" name="uri" class="form-control">
        </div>
        </div>
        ';
    }
}