<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
include_once GROCERY_CRUD;

class Usuarios extends Grocery{
	
	protected $crud;
	function __construct()
	{
		parent::__construct();
		$this->load->model('minha_conta/conta_model');
		$this->load->model('administrativo/admin_model');
	}
	
	function perfil() 
    {
        $this->ini_method('cadastros')->breadcrumb('perfil');
        
        $id_cadastro = $this->uri->segment(4);
        $id_captura = $this->uri->segment(5);
        
        //Cadastro/Capturas----------------------------------------------
        $cadastro = null;
        $capturas = [];
        $capturado = null;
        if($id_cadastro > 0){
            $cadastro = $this->admin_model->get_cadastro([], $id_cadastro);
            $capturas = $this->admin_model->getCapturas([['email', $cadastro->email]]);
        }
        
        if($id_captura > 0){
            $captura = $this->admin_model->getCaptura([['id_captura', $id_captura]]);
            if($captura != null){
                $capturas = $this->admin_model->getCapturas([['email', $captura->email]]);
                
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
            }
            if($cadastro == null && $captura != null){
                $cadastro = $this->admin_model->get_cadastro([['email', $captura->email]]);
            }
        }
        //Cadastro/Capturas----------------------------------------------
        
        
        //PESQUISAS---------------------------------------------------------
        $pesquisou = [];
        $intencoes_busca = $this->admin_model->getIntencoesBusca([['id_cadastro', $id_cadastro]]);
        foreach ($intencoes_busca as $intencao){
            
            $key = $intencao->pesquisa.$intencao->bairro.$intencao->quartos;
            
            $cont[$key][] = '';
            $pesquisou[$key] = (object)[
                    'pesquisa' => $intencao->pesquisa,
                    'bairro'  => $intencao->bairro,
                    'quartos'  => $intencao->quartos,
                    'cont'    => count($cont[$key]),
                ];
            
        }
        unset($pesquisou['']);
        //PESQUISAS---------------------------------------------------------
        
        //FAVORITOS---------------------------------------------------------
        $favoritos = $this->admin_model->get_favoritos($id_cadastro);
        foreach($favoritos as $fav)
            $where['orwhere'][] = ['a.id_imovel', $fav->id_imovel];
        $where[] = ['a.status', 3];
        $imoveisFavoritos = empty($favoritos)?[]:$this->conta_model->getImoveis($where,[],false);
        //FAVORITOS---------------------------------------------------------
        
        
       
        $imoveis = [];
        $negociacoes_compras = [];
        if($cadastro != null){
            
            //I M O V E I S ---------------------------------------------------------
            $wim[] = ['a.id_cadastro', $id_cadastro];
            $wim[] = ['id_imovel_rel', 0];
            $wim[] = [['a.lixeira <', 2],[['a.lancamento','Sim'],['a.lixeira <', 3]]];
            $imoveis = $this->admin_model->getImoveis($wim);
            //I M O V E I S ---------------------------------------------------------
            
            //N e g o c i a c o e s _ c o m p r a s---------------------------------------------------------
            $this->load->model("comdono/busca_model");
            $this->load->model("minha_conta/chat_model");
            $n_compras = $this->chat_model->getChat([['id_interessado',$id_cadastro]]);
            
            foreach($n_compras as $id_imovel=>$imovel) {
                foreach($imovel->chats as $id_chat=>$chat) {
                    $chat->imovel = $imovel;
                    $negociacoes_compras[$id_chat] = $chat;
                }
            }
            //N e g o c i a c o e s _ c o m p r a s---------------------------------------------------------
            
        }
       
       
       
        //A t e n d i m e n t o s---------------------------------------------------------
        $atendimentos =[];
        $atendimento = $this->admin_model->getAtendimento([['email' ,$cadastro->email??$captura->email]]);
        if($atendimento != null)
            $atendimentos = $this->admin_model->getHistoricoAtendimento([['id_atendimento', $atendimento->id_atendimento]]);
        //A t e n d i m e n t o s---------------------------------------------------------
        
        //Capturas landingpages---------------------------------------------------------
        
        /*if($id_captura > 0){
            $captura = $this->admin_model->getCaptura([['id_captura', $id_captura]]);
            if($captura != null){
                $capturas = $this->admin_model->getCapturas([['email', $captura->email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
            }
            if($cadastro == null && $captura != null){
                $cadastro = $this->admin_model->get_cadastro([['email', $captura->email]]);
            }
        }*/
        
        
        
        /*$origens =['financiamento','interessado_elleven','avaliacao','avaliacao_cep_nao'];
        $atendimento = $this->admin_model->getAtendimento([['email' ,$cadastro->email??$captura->email]]);
        if($atendimento != null)
            $atendimentos = $this->admin_model->getHistoricoAtendimento([['id_atendimento', $atendimento->id_atendimento]]);*/
        
        $interesses = [];
        
        foreach($capturas as $cap){
            $interesse = $this->cad_model->getInteresse([['id_captura',$cap->id_captura]]);
            if($interesse != []){
                $interesse->bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $interesse->id_interesse]]);
                $interesses[] = $interesse;
            }
        }
            
        //Capturas landingpages---------------------------------------------------------
        
        
        //$this->chat_model->getChat([['id_interessado',$this->session->id_cadastro]]);
        
        $data['cadastro']              = $cadastro;
        $data['capturas']              = $capturas;
        $data['capturado']             = $capturado;
        $data['pesquisou']             = $pesquisou;
        $data['favoritos']             = $imoveisFavoritos;
        $data['interesses']            = $interesses;
        
        $data['financiamentos']        = [];
        $data['negociacoes_compras']   = $negociacoes_compras;
       
        $data['imoveis']               = $imoveis;
        $data['negociacoes_vendas']    = [];
        
        $data['atendimentos']          = $atendimentos;
        
        //`id_intencao`, `id_cadastro`, `clique`, `cont_result`, `result`, `pesquisa`, `bairro`, `tipo`, `quartos`, `valor`, `metro_quadrado`, `id_lancamento`, `tipo_busca`, `data_hora_busca`, `timestemp_intencao`, `intencao`
    
        
        Assets::add_css(array(
            '../comdono/plugins/blueimp/css/jquery.fileupload',
            '../comdono/plugins/blueimp/css/jquery.fileupload-ui',
            '../comdono/plugins/blueimp/css/blueimp-gallery.min',
            //'../comdono/plugins/blueimp/css/custom',
            '../comdono/plugins/unitegallery/css/unite-gallery',
            '../comdono/plugins/unitegallery/css/ug-theme-default',
            
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/blueimp/js/jquery.ui.widget',
            '../comdono/plugins/blueimp/js/tmpl.min',
            '../comdono/plugins/blueimp/js/load-image.all.min',
            '../comdono/plugins/blueimp/js/canvas-to-blob.min',
            '../comdono/plugins/blueimp/js/blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.iframe-transport',
            '../comdono/plugins/blueimp/js/jquery.fileupload',
            '../comdono/plugins/blueimp/js/jquery.fileupload-process',
            '../comdono/plugins/blueimp/js/jquery.fileupload-image',
            '../comdono/plugins/blueimp/js/jquery.fileupload-validate',
            '../comdono/plugins/blueimp/js/jquery.fileupload-ui',
            '../comdono/plugins/unitegallery/js/unitegallery.min',
            '../comdono/plugins/unitegallery/js/ug-theme-default',
            '../comdono/plugins/unitegallery/js/imovel',
            
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
        
        Assets::add_module_js('administrativo', [
            'perfil'
            ]);
        
        
	    Template::set($data);
		Template::set_view('administrativo/perfil_view');
		Template::render();
    }
    
	function cadastros()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_cadastro');
			$crud->set_subject('Usuário do Painel');
			
			//`id_cadastro`, `nome`, `telefone`, `email`, `cpf`, `data_nascimento`, `img_perfil_uri`, `img_perfil`, `depoimento_file`, `depoimento_video`, `depoimento_text`, `cep`, `cidade`, `estado`, `vendedor`, `comprador`, `termo_uso`, `etapa`, `tipo_contato`, `bd_comdono`, `agendamento`, `melhor_dia`, `melhor_hora`, `qnt_imovel`, `email_activated`, `celular_activated`, `aviso_curtir`, `img_pj`, `img_pj_uri`, `cnpj`, `nome_fantasia`, `descricao_pj`, `data_hora_cadastro`, `timestamp_cadastro` FROM `cad_cadastro` 
			$crud->display_as('timestamp_cadastro','Ultima edição');
			$crud->columns(['id_cadastro','nome','telefone','email','cpf','etapa','data_hora_cadastro','timestamp_cadastro']);
			
			$crud->add_action('Perfil', '', 'administrativo/usuarios/perfil', 'icon-people');
			$crud->unset_read();
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function pre_cadastros()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_cadastro');
			$crud->where('etapa <', 8);
			$crud->set_subject('Usuários Pré-cadastrados');
			
			
			$crud->display_as('timestamp_cadastro','Ultima edição');
			$crud->columns(['id_cadastro','nome','telefone','email','etapa','data_hora_cadastro','timestamp_cadastro']);
			$crud->add_action('Perfil', '', 'administrativo/usuarios/perfil', 'icon-people');
			$crud->unset_read();
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function bloqueados()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_cadastro');
			$crud->set_relation('id_cadastro','sys_users','banned');
			$crud->where('banned =', 1);
			$crud->set_subject('Usuários Bloqueados');
			$crud->add_action('Perfil', '', 'administrativo/usuarios/perfil', 'icon-people');
			$crud->unset_read();
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function ativos()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_cadastro');
			$crud->set_subject('Usuário do Painel');
			
			$crud->columns(['id_cadastro','nome','telefone','email','cpf','data_hora_cadastro']);
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$crud->add_action('Perfil', '', 'administrativo/usuarios/perfil', 'icon-people');
			$crud->unset_read();
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function inativos()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_cadastro');
			$crud->set_subject('Usuário do Painel');
			
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function anunciantes()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->set_theme('bootstrap');
			
			$crud->set_subject('Anunciantes Pessoa Física com imóvel publicado');
			$crud->set_table('cad_imovel');
			$crud->set_relation('id_cadastro','cad_cadastro','nome');
			$crud->where('status =', 3);
			$crud->where('doc_perfil =', 'cpf');
			
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
}