<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Atendimento_ajax extends Admin_Controller {

	function __construct()
	{
        parent::__construct();
        
        if($this->session->perfil == 0)
        {
	        echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Acesso negado!']);
	        die();
		}
		$this->load->library('form_validation');
		$this->load->model('administrativo/admin_model');
        $this->load->library('newsletter/newsletter');
	}
	
	
	public function atualizarDataCad()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('data_nascimento', 'Data de nascimento', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post['data_nascimento'] = $this->input->post('data_nascimento');
            $id_cadastro = $this->input->post('id_leed');
            
	        $this->admin_model->updateCadastro($id_cadastro, $post);
	        
	        $json = ['valid' => true, 'msg' => 'Sucesso'];
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function novoAtendimento()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            
            if(($post['id_leed']??'') != '' && ($post['origem']??'') != ''){
                
                $proximo_contato = '';
                if(($post['novo_contato']??'') == 'sim')
                    $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+1, date("Y")));
                    
    	        $this->insertAtendimentoRel($post['id_leed'], $post['origem'], $post['observacao'], 'Anunciante ativo',  $proximo_contato);
    	        
    	        $json = ['valid' => true, 'msg' => 'Sucesso'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function insertAtendimentoRel($id_rel, $tb_rel, $observacao, $tipo_interesse = '',  $proximo_contato = '', $proximo_contato_motivo = '')
	{
	    $atend = $this->cad_model->getAtendimento([['id_rel',$id_rel],['tb_origem',$tb_rel]])[0]??null;
        if($atend == null)
            $id_atendimento = $this->cad_model->setAtendimento(['id_rel' => $id_rel, 'tb_origem' => $tb_rel]);
        else
            $id_atendimento = $atend->id_atendimento;
        
        $insertAtendimento = [
                'id_atendimento' => $id_atendimento,
                'id_user' => $this->session->id_cadastro,
                'data_hora' => date("Y-m-d H:i:s"),
                'tipo_interesse' => $tipo_interesse,
                'observacao' => $observacao,
                'proximo_contato' => $proximo_contato,
                'proximo_contato_motivo' => $proximo_contato_motivo,
            
            ];
    	return $this->cad_model->setAtendimentoHistorico($insertAtendimento);
	}
	
	
	//antigo
	public function ini_atendimento()
	{
	    $post = $this->input->post(); 
	    
	    $data['nome']      =  $this->input->post('nome')??'';
	    $data['email']     =  $this->input->post('email')??'';
	    $data['telefone']  =  $this->input->post('telefone')??'';
	    $data['id_rel']    =  $this->input->post('id_rel')??'';
	    $data['tb_origem'] =  $this->input->post('tb_origem')??'';
	    
        if ($data['id_rel'] != '' && $data['tb_origem'] != '') 
        {
            $atend = $this->cad_model->getAtendimento([['id_rel',$data['id_rel']],['tb_origem',$data['tb_origem']]])[0]??null;
            $json = $this->setAtendimento($atend,$data);
            
        }
	    elseif($data['email'] != '')
        {
            $atend = $this->cad_model->getAtendimento([['email', $data['email']]])[0]??null;
            $json = $this->setAtendimento($atend,$data);
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Email Invalido!'];
        }
        echo json_encode($json);
	    
	}
	
	//antigo
	private function setAtendimento($atend,$data)
	{
	        if($atend == null)
                $id_atendimento = $this->cad_model->setAtendimento($data);
            else
                $id_atendimento = $atend->id_atendimento;
            
            if($id_atendimento){
                return ['valid' => true, 'id_atendimento'=> $id_atendimento,'msg' => 'Sucesso!'];
            }
            else{
                return ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
	}
	
	
	public function finaliza_atendimento()
	{
	    $post = $this->input->post(); 
	    
	    $this->form_validation->set_rules('motivo', 'Motivo', 'required|trim');
	    
        if ($this->form_validation->run() != FALSE) 
        {
            $id_captura = $post['id'];
            $this->cad_model->updateCaptura($id_captura, ['status_captura' => 10, 'motivo' => $post['motivo']]);
            Newsletter::removeAllTagsCap($id_captura);
            
            $json = ['valid' => true, 'msg' => 'Sucesso!', 'post' => $post];
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function send_email_again()
	{
	    $post = $this->input->post(); 
	    
	    $email      =  $post['email'];
	    $id_campanha = $post['id_campanha'];
	    unset($post['email']);
	    unset($post['id_campanha']);
        
        if( $this->newsletter->envia($email, $id_campanha, $post) )
        {
            $json = ['valid' => true, 'msg' => 'E-mail reenviado com sucesso!'];
        }
        else
        {
            $json = ['valid' => false, 'msg' => 'Erro ao reenviar e-mail, tente novamente!'];
        }

        echo json_encode($json);
	}
	
	public function ativa_suahouse(){
	    $id_captura = $this->input->post('id_captura');
	    
	    if($id_captura != NULL){
	        $data = ['sua_house' => 1];
	        $up = $this->cad_model->updateCaptura($id_captura, $data);
	        
	        if($up > 0){
	            $retorno = ['valid' => true, 'msg' => 'Adicionado com sucesso!'];
	        }else{
	            $retorno = ['valid' => false, 'msg' => 'Falha de comunicação com o banco de dados, tente novamente!'];
	        }
	    }else{
	        $retorno = ['valid' => false, 'msg' => 'Nenhum cliente foi enviado!'];
	    }

        echo json_encode($retorno);
	}
	
	public function add_atendimento()
	{
	    $post = $this->input->post(); 
	    
	    if($post['observacao'] != '')
        {
            $id_atendimento_historico = $this->cad_model->setAtendimentoHistorico($post);
            
            if($id_atendimento_historico){
                $json = ['valid' => true, 'id_atendimento'=> $id_atendimento_historico,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'campo observação vazio'];
        }
        echo json_encode($json);
	    
	}
	
	public function exemplo()
    {
        $data = $this->input->post(); 
        
        if(!empty($imovel))
        {
            //$data['step'] = (int)$data['step'];
            unset($data['doc_propriedade']);
            unset($data['doc_planilha']);
            unset($data['dn_img']);
            //$data['key_anuncio'] = HImovel::montaKeyAnuncio($data);
            $dtLancamento = $data;
            
            if($this->cad_model->updateImovel($data['id_imovel'],$dtLancamento)){
                
                $this->cad_model->updateImovelRel($data['id_imovel'],$data);
                /*$arrayNew = $this->filtraCamposNovaUnidade($data);
                if(!empty($arrayNew))
                    $this->cad_model->updateImovelRel($data['id_imovel'],$arrayNew);*/
                    
                $json = ['valid' => true, 'data'=> $data,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    
	
	
}