<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Operacao_ajax extends Admin_Controller {

	function __construct()
	{
        parent::__construct();
        
        if($this->session->perfil == 0)
        {
	        echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Acesso negado!']);
	        die();
		}
		
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/fluxo_model');
		$this->load->library('newsletter/newsletter');
        
	}
	
	public function negarAnuncio()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            
            if($post['id_leed'] != null && $post['origem'] == 'olx'){
                
                 
                $this->verificaOportunidade($post['id_leed']);
                
                
    	        $this->fluxo_model->updateOlx([['id',$post['id_leed']]],[
    	                'id_responsavel'=> $this->session->id_cadastro,
                        'data_status'   => date("Y-m-d H:i:s"),  
    	                'status'        => 'Negado', 
    	                'motivo'        => $post['observacao']]);
    	        //
    	        $this->setAtendimento($post['id_leed'], $post['observacao']);
    	        //
    	        $json = ['valid' => true, 'msg' => 'Sucesso'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function verificaOportunidade($id)
	{
	    $getOlx = $this->fluxo_model->getOlx([ ['id',$id ],[['id_responsavel',0],['id_responsavel',$this->session->id_cadastro]]]);
	    
	    if($getOlx == null)
	    {
	       echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Iniciado por outro usuário, atualize a página e tente novamente.']);
	       die();
	    }
	}
	
	public function atenderAnuncio()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            
            if($post['id_leed'] != null && $post['origem'] == 'olx'){
                 
                $this->verificaOportunidade($post['id_leed']);
    	        $this->fluxo_model->updateOlx([['id',$post['id_leed']]],[
    	                'id_responsavel'=> $this->session->id_cadastro,
                        'data_status'   => date("Y-m-d H:i:s"),  
    	                'status' => 'Aguardando', 
    	                'motivo' => $post['observacao']]);
    	        //
                $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+1, date("Y")));
    	        $this->setAtendimento($post['id_leed'], $post['observacao'], $proximo_contato, $post['observacao']);
    	        
    	        $json = ['valid' => true, 'msg' => 'Sucesso'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function aceitarAnuncio()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            
            if($post['id_leed'] != null && $post['origem'] == 'olx'){
                
                $this->verificaOportunidade($post['id_leed']);
    	        $this->fluxo_model->updateOlx([['id',$post['id_leed']]],[
    	                'id_responsavel'=> $this->session->id_cadastro,
                        'data_status'   => date("Y-m-d H:i:s"),  
    	                'status' => 'Iniciado', 
    	                'motivo' => $post['observacao']]);
    	        //
    	        $this->setAtendimento($post['id_leed'], $post['observacao']);
    	        
    	        
    	        $olx = $this->fluxo_model->getOlx([['id',$post['id_leed']]]);
	        
    	        $card = [
            	        'id_lista'        => 1,
            	        'id_oportunidade' => $post['id_leed'],
            	        'data_criacao'    => date("Y-m-d H:i:s"),
            	        'origem'          => 'crawler_olx',
            	        'tipo_imovel'     => $olx->tipo_imovel,
            	        'titulo'          => $olx->titulo,
            	        'bairro'          => $olx->bairro,
            	        'cidade'          => $olx->cidade,
            	        'estado'          => $olx->estado,
            	        'id_responsavel'  => $this->session->id_cadastro
        	        ];
        	        
    	        $id_card = $this->fluxo_model->insertCard($card);
    	        
    	        
    	        //
    	        $json = ['valid' => true, 'msg' => 'Sucesso'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function setAtendimento($id_rel, $observacao, $proximo_contato = '', $proximo_contato_motivo = '', $tipo_interesse = 'Olx')
	{
	    $atend = $this->cad_model->getAtendimento([['id_rel',$id_rel],['tb_origem','crawler_olx']])[0]??null;
        if($atend == null)
            $id_atendimento = $this->cad_model->setAtendimento(['id_rel' => $id_rel, 'tb_origem' => 'crawler_olx']);
        else
            $id_atendimento = $atend->id_atendimento;
        
        $insertAtendimento = [
                'id_atendimento' => $id_atendimento,
                'id_user' => $this->session->id_cadastro,
                'data_hora' => date("Y-m-d H:i:s"),
                'tipo_interesse' => $tipo_interesse,
                'observacao' => $observacao,
                'proximo_contato' => $proximo_contato,
                'proximo_contato_motivo' => $proximo_contato_motivo,
            
            ];
    	return $this->cad_model->setAtendimentoHistorico($insertAtendimento);
	}
	
	
	
	private function _setAtendimento($atend,$data)
	{
	        if($atend == null)
                $id_atendimento = $this->cad_model->setAtendimento($data);
            else
                $id_atendimento = $atend->id_atendimento;
            
            if($id_atendimento){
                return ['valid' => true, 'id_atendimento'=> $id_atendimento,'msg' => 'Sucesso!'];
            }
            else{
                return ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
	}
	
	function _ini_operacao($id_ini,$origem)
	{
	    //flx_card
	    //`id_card`, `id_lista`, `id_captura`, `id_cadastro`, `id_imovel`, `data_criacao`, `data_modificado`, `origem`, `nome`, `email`, `telefone`, `cpf`, `titulo`, `tipo_imovel`, `cep`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`
	    //crawler_olx
	    //`id_anuncio`, `titulo`, `quartos`, `val_public_total_metro`, `val_condominio`, `vaga`, `val_public_total`, `val_public_antigo`, `tipo_imovel`, `cidade`, `bairro`, `estado`, `dt_captura`, `url`
	    
	    if($id_ini != null && $origem == 'olx'){
	        $olx = $this->fluxo_model->getOlx([['id',$id_ini]]);
	        
	        $card = [
        	        'id_lista'        => 1,
        	        'id_oportunidade' => $id_ini,
        	        'data_criacao'    => date("Y-m-d H:i:s"),
        	        'origem'          => 'crawler_olx',
        	        'tipo_imovel'     => $olx->tipo_imovel,
        	        'titulo'          => $olx->titulo,
        	        'bairro'          => $olx->bairro,
        	        'cidade'          => $olx->cidade,
        	        'estado'          => $olx->estado,
        	        'id_responsavel'  => $this->session->id_cadastro
    	        ];
    	        
	        $id_card = $this->fluxo_model->insertCard($card);
	        
	        if($id_card)
	            $this->fluxo_model->updateOlx([['id',$id_ini]],['status' => 'Iniciado']);
	        
	        redirect('administrativo/operacao/quadro/1');
	    }
	    redirect('administrativo/operacao/venda');
	}
	
	
	public function add_card(){
        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('titulo', 'Titulo', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            
            $listas = $this->fluxo_model->getListasPerfil($post['id_quadro']??0);
            if(empty($listas)){
                echo json_encode(['valid' => false, 'msg' => 'Acesso Negado']);
                die();
            }
            
            if($post['id_cadastro'] != '')
            {
                if($this->fluxo_model->getCadastro([['id_cadastro', $post['id_cadastro']]]) == null){
                    echo json_encode(['valid' => false, 'msg' => 'Cadastro não encontrado']);
                    die();
                }
                $card['id_cadastro'] = $post['id_cadastro'];
            }
            if($post['id_imovel'] != '')
            {
                if($this->fluxo_model->getCard([['id_imovel', $post['id_imovel']]]) != null){
                    echo json_encode(['valid' => false, 'msg' => 'Imovel Já cadastrado']);
                    die();
                }
                
                $imovel = $this->fluxo_model->getImovel([['a.id_imovel', $card->id_imovel]]);
                if($imovel == null){
                    echo json_encode(['valid' => false, 'msg' => 'Imovel não encontrado']);
                    die();
                }
                $card['id_imovel'] = $imovel->id_imovel;
                $card['id_cadastro'] = $imovel->id_cadastro;
            }
            
            $card['titulo'] = $post['titulo'];
            
            
            
            $card['id_lista'] = $listas[0]->id_lista;
            $card['data_criacao'] = date("Y-m-d H:i:s");
            $card['origem'] = 'manual';
            $card['id_responsavel'] = $this->session->id_cadastro;
            
    	    $id_card = $this->fluxo_model->insertCard($card);
            
            if($id_card)
            {
                $json = ['valid' => true, 'msg' => 'Sucesso'];
            }
            else
            {
                $json = ['valid' => false, 'msg' => 'Falha de comunicação'];
            }
            
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        
        echo json_encode($json);
	}
	
	public function add_cadastro(){
        
        $dados = $this->input->post('dados');
        
        $posts = ['nome' => $dados['nome'], 'email' => $dados['email'], 'telefone' => $dados['telefone']];
        
        //dd($this->input->post());
        
        $this->load->library('form_validation');
        $this->form_validation->set_data($posts);
        $this->form_validation->set_rules('nome', 'Nome', 'required|trim');
        $this->form_validation->set_rules('telefone', 'Telefone', 'required|trim');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim|valid_email');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post('dados');
            if(empty(Cad_model::getCadastroByEmail($post['email'])))
            {
                $id_card = $this->input->post('id_card');
                
                $senha = $this->gerar_senha(rand(8, 12));
                
                $data['nome']     = $post['nome'];
                $data['email']    = $post['email'];
                $data['telefone'] = $post['telefone'];
                //$data['cpf']      = $post['cpf'];
                $data['password'] = $this->password_hash($senha);
                $data['etapa']    = 1;
                $data['data_hora_cadastro'] = date("Y-m-d H:i:s");
                
                $result = Cad_model::setCadUser($data);  
                
                MFluxo::setHistorico($id_card, 'add_cadastro',$data);
                
                if($result['id_cadastro'] != NULL){
                    
                    $data['senha'] = $senha;
                    
                    $this->newsletter->enviar_email_campanha($data['email'], 48, $data);
                    
                    $cad = $this->fluxo_model->getCadastroByEmail($data['email']);
                    
                    /*$insert['nome']     = $cad->nome;
                    $insert['email']    = $cad->email;
                    $insert['telefone'] = $cad->telefone;
                    //$insert['cpf']      = $cad->cpf;
                    $insert['datetime_captura'] = date("Y-m-d H:i:s");
                    $insert['mensagem'] = 'novocadastroatendimento';
                    $insert['origem_captura'] = 'atendimento';
                    $id_captura = $this->cad_model->insertCaptura($insert);*/
                    
                    $this->fluxo_model->updateCard([['id_card',$id_card]], ['id_cadastro' => $cad->id_cadastro/*,'id_captura' => $id_captura*/]);
                    
                    //HEmail::alerta('Novo Pre Cadastro', $data['email']);
                    
                    $json = ['valid' => true, 'msg' => 'Cadastro Efetuado com sucesso', 'dados' => $cad];
                }else{
                    $json = ['valid' => false, 'msg' => 'Falha de comunicação'];
                }
                
            }else{
                $json = ['valid' => false,'erro' => 2,'msg' => "E-mail já cadastrado!"];
            }
        }else{
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        
        echo json_encode($json);
	}
	
    public function add_imovel(){
        $data = $this->input->post('post');
        //var_dump($data);
        $id_card = $this->input->post('id_card');
        
        $card =  $this->fluxo_model->getCard([['id_card', $id_card]]);
        
        if(!empty($card)){
            
            if($card->id_imovel == 0){
                
                $dono = $this->cad_model->get_cadastro([], $card->id_cadastro);
                
                if(!empty($dono)){
                
                    //Campos com nomes iguais do banco;
                    $imovel = $data;
                    
                    $imovel['id_cadastro'] = $card->id_cadastro;
                    $imovel['doc_perfil'] = 'cpf';
                    $imovel['dn_nome_nomefantasia'] = $dono->nome;
                    $imovel['dn_telefone'] = $dono->telefone;
                    $imovel['dn_email'] = $dono->email;
                    $imovel['dn_cpf_cnpj'] = $dono->cpf;
                    $imovel['dn_img'] = $dono->img_perfil;
                    $imovel['dn_img_uri'] = $dono->img_perfil_uri;
                    
                    $id_imovel = $this->cad_model->insertImovel($imovel);
                    MFluxo::setHistorico($id_card, 'add_imovel',$data);
                    
                    $json = ['valid' => true, 'msg' => 'Imovel cadastrado com sucesso'];
                    
                    
                    $titulo = "[".$id_imovel."] [".$dono->nome."] [".$data['bairro']."] ".$data['endereco'];
                    
                    //Ja INSERE no card todos os dados de endereco padronizado pela COMDONO e etc para facilitar ao fotografo e outros ...
        	        $this->fluxo_model->updateCard([['id_card',$id_card]], ['id_imovel' => $id_imovel, 'cep' => $imovel['cep'], 'endereco' => $imovel['endereco'], 'numero' => $data['numero']]);
                }else{
                    $json = ['valid' => false, 'msg' => 'Não é possivel cadastrar imovel sem dono'];
                }
            }else{
                $json = ['valid' => false, 'msg' => 'Um imovel já foi cadastrado a este atendimento!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
	
	public function verificar_email(){
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim|valid_email');
		
		if ($this->form_validation->run() != FALSE){
	    
    	    $email = $this->input->post('email');
    	    
    	    $id_card = $this->input->post('id_card');
    	    
    	    $cad = $this->fluxo_model->getCadastroByEmail($email);
    	    
    	    if(!empty($cad)){
    	        
               /* $insert['nome']     = $cad->nome;
                $insert['email']    = $cad->email;
                $insert['telefone'] = $cad->telefone;
                $insert['cpf']      = $cad->cpf;
                $insert['datetime_captura'] = date("Y-m-d H:i:s");
                $insert['mensagem'] = 'cadastradoatendimento';
                $insert['origem_captura'] = 'atendimento';
                $id_captura = $this->cad_model->insertCaptura($insert);*/
    
                $json = ['valid' => true, 'tem_cadastro' => true, 'dados' => $cad];
    	        $this->fluxo_model->updateCard([['id_card',$id_card]], ['id_cadastro' => $cad->id_cadastro/*,'id_captura' => $id_captura*/]);
    	        MFluxo::setHistorico($id_card, 'atualizaCard', ['id_cadastro' => $cad->id_cadastro]);
    	    }else{
    	       $json = ['valid' => true, 'tem_cadastro' => false];
    	    }
		}else{
		    $json = ['valid' => false, 'msg' => validation_errors()];
		}
	    
	    echo json_encode($json);
	}
	
	public function next_list(){
        $id_card = $this->input->post('id_card');
        $this->move_card($id_card, +1);
        
    }
    
  	public function prev_list(){
        $id_card = $this->input->post('id_card');
        $this->move_card($id_card, -1);
    }  
    
    public function move_card($id_card, $n){
        $card =  $this->fluxo_model->getCard([['id_card', $id_card]]);
        
        if(!empty($card))
        {
            //$asd = $dsadsd
            
            $lista = $this->fluxo_model->getLista([['id_lista',$card->id_lista]]);
            
            $sequenciaListas = $this->fluxo_model->getSequencia([['a.id_quadro',$lista->id_quadro]]);
            
            $keyLista = array_search($card->id_lista, array_column($sequenciaListas, 'id_lista'));
            
            //So verifica avançando
            if($n == +1){
                $verificacoes_cadastros = $this->verifica_cadastros($card->id_lista,$card);
            }else{
                //Caso voltando não tem verificacao então TRUE para não bugar o if
                $verificacoes_cadastros['valid'] = TRUE;
            }
            
                if($verificacoes_cadastros['valid'] == TRUE){
                
                    $ListaProximo = $sequenciaListas[$keyLista+$n]??$sequenciaListas[$keyLista];
                    
        	        MFluxo::setHistorico($id_card, 'Saiu da lista');
                    if($this->fluxo_model->updateCard([['id_card',$id_card]],['id_lista'=>$ListaProximo->id_lista])){
        	            MFluxo::setHistorico($id_card, 'Entrou na lista');
                        
                        $json = ['valid' => true, 'msg' => 'Sucesso!'];
                    }else{
                        $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                    }
                }else{
                    $json = ['valid' => false, 'msg' => $verificacoes_cadastros['error']];
                }
        }    
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    public function verifica_cadastros($lista, $card){
        
       
        switch ($lista) {
            //Primeira lista não tem validações é so avançar
            case 1:
                $validacao = ['valid' => TRUE];
                break;
            
            //Card sem cadastro de dono
            case 2:
                
                if($card->id_cadastro == 0){
                    $validacao = ['valid' => FALSE, 'error' => 'Não é permitido avançar sem cadastro de um dono'];
                }else{
                    $validacao = ['valid' => TRUE];
                }
                break;
            
            //Card Sem imovel    
            case 3:
                
                if($card->id_imovel == 0){
                    $validacao = ['valid' => FALSE, 'error' => 'Não é permitido avançar sem cadastro de um imovel'];
                }else{
                    $validacao = ['valid' => TRUE];
                }
                break;
            
            //Card de autorização do dono
            case 4:
                
                //So avança em caso SIM de autorizado e com data agendada
                if($card->autorizacao_dono != 'Sim' || $card->data_fotos == '0000-00-00 00:00:00'){
                    $validacao = ['valid' => FALSE, 'error' => 'Não é permitido avançar sem autorização do dono do imovel e/ou sem data'];
                }else{
                    $validacao = ['valid' => TRUE];
                }
                break;
            default:
                $validacao = ['valid' => TRUE];
                break;
            //... fazendo mais com forme mais listas forem criadas
        }
        
        return $validacao;
    }
    
    public function atualizaCard(){
        $id_card = $this->input->post('id_card');
        $post = $this->input->post();
        $card =  $this->fluxo_model->getCard([['id_card', $id_card]]);
        
        if(!empty($card)){
            
            if($post != NULL){
                
                MFluxo::setHistorico($id_card, 'atualizaCard',$post);
                
                if($post['id_fotografo']??false)
                {
                    $this->fluxo_model->removeResponsavel([ ['id_card',$id_card], ['id_cadastro',$post['id_fotografo']] ]);
                    $this->fluxo_model->insertResponsavel(['id_card' => $id_card, 'id_cadastro' =>$post['id_fotografo'], 'perfil' => 6]);
                }
                
                if($card->id_cadastro > 0 && $card->id_imovel > 0 ){
                    $dono   = $this->fluxo_model->getCadastro([['id_cadastro', $card->id_cadastro]]);
                    $imovel = $this->fluxo_model->getImovel([['a.id_imovel', $card->id_imovel]]);
                    
                    $post['titulo'] = "[".$card->id_imovel."] [".$dono->nome."] [".$imovel->bairro."] ".$imovel->endereco;
                }
                
                if($this->fluxo_model->updateCard([['id_card',$id_card]],$post)){
                    
                    $dados = $this->fluxo_model->getCard([['id_card', $id_card]]);
                    $json = ['valid' => true, 'msg' => 'Sucesso!' ,'dados' => $dados];
                    
                }else{
                    $json = ['valid' => false, 'msg' => 'Falha de comunicação com o banco!'];
                }
            }else{
                
                $json = ['valid' => false, 'msg' => 'Error, Campo vazio'];
                
            }
        }else{
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    private function gerar_senha($tamanho = 6, $maiusculas = true, $minusculas = true, $numeros = true, $simbolos = false){
        $ma = "ABCDEFGHIJKLMNOPQRSTUVYXWZ"; // $ma contem as letras maiúsculas
        $mi = "abcdefghijklmnopqrstuvyxwz"; // $mi contem as letras minusculas
        $nu = "0123456789"; // $nu contem os números
        $si = "!@#$%¨&*()_+="; // $si contem os símbolos
        
        $senha = '';
        
        if ($maiusculas){
            // se $maiusculas for "true", a variável $ma é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($ma);
        }
        
        if ($minusculas){
            // se $minusculas for "true", a variável $mi é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($mi);
        }
        
        if ($numeros){
            // se $numeros for "true", a variável $nu é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($nu);
        }
        
        if ($simbolos){
            // se $simbolos for "true", a variável $si é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($si);
        }
        
        // retorna a senha embaralhada com "str_shuffle" com o tamanho definido pela variável $tamanho
        return substr(str_shuffle($senha),0,$tamanho);
    }
	
	private function password_hash($senha){
        // Hash password using phpass
        $hasher = new PasswordHash($this->config->item('phpass_hash_strength', 'tank_auth') , $this->config->item('phpass_hash_portable', 'tank_auth'));
        $senha = $hasher->HashPassword($senha);
        
        return $senha;
    }
	
}