<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_model extends Cad_model
{
    function __construct() {
        parent::__construct();
    }
    
    function mesAtual($campo_data)
	{
        $this->db->where("YEAR($campo_data)",date("Y"));
        $this->db->where("MONTH($campo_data)",date("m"));
	    
	    return $this;
	}
	
    function getProximoParceiro($UUID, $id_empreendimento)
    {
        $parceiros = $this->getParceirosEmpreendimento(['id_empreendimento',$id_empreendimento]);
        if(empty($parceiros))
            return null;
        
        $capturas = $this->getCapturas([['origem_captura', $UUID],['link !=','formConvite']]);
        $keyProximo = count($capturas)%count($parceiros);
        
        return $parceiros[$keyProximo];
    }
    
    function getProximaEquipe($UUID, $id_parceiro, $id_empreendimento)
    {
                   $this->cad_model->inArrayJson('id_empreendimentos', $id_empreendimento);
                   $this->db->join('inc_escala', 'inc_escala.id_equipe = inc_equipe.id_equipe');
                   $this->db->group_by('inc_equipe.id_equipe');
        $equipes = $this->cad_model->getEquipes([['inc_equipe.id_parceiro', $id_parceiro],['status',1]]);

        if(empty($equipes))
            return null;
        
        $capturas = $this->getCapturas([['origem_captura', $UUID],['id_parceiro',$id_parceiro],['link !=','formConvite'],['id_equipe !=',0]]);
        $keyProxima = count($capturas)%count($equipes);
        
        return $equipes[$keyProxima];
    }
    
    function getParceirosIncorporadora($where = [])
    {
        $this->db->join('inc_parceiro_rel_incorporadora', 'inc_parceiro.id_parceiro = inc_parceiro_rel_incorporadora.id_parceiro');
        $this->db->join('inc_incorporadora', 'inc_incorporadora.id_incorporadora = inc_parceiro_rel_incorporadora.id_incorporadora');
        return $this->getParceiros($where);
    }
    
    function getEmpreendimentoParceiro($where)
    { 
       $this->db->select("*, inc_empreendimento.id_incorporadora as id_incorporadora");
       $this->db->join('inc_parceiro_rel_empreendimento', 'inc_empreendimento.id_empreendimento = inc_parceiro_rel_empreendimento.id_empreendimento');
       return $this->getEmpreendimento($where); 
    }
    
    function empreendimentoParceiroDaIncorporadora($id_incorporadora,$id_empreendimento)
    {
       $this->db->select("*, inc_empreendimento.id_incorporadora as id_incorporadora");
       $where[] = ['inc_parceiro_rel_empreendimento.id_incorporadora',$id_incorporadora];    
       //$where[] = ['inc_empreendimento.id_incorporadora',$id_incorporadora];    
       $where[] = ['inc_empreendimento.id_empreendimento',$id_empreendimento];    
       $this->db->join('inc_parceiro_rel_empreendimento', 'inc_empreendimento.id_empreendimento = inc_parceiro_rel_empreendimento.id_empreendimento');
       return $this->getEmpreendimento($where); 
    }
    
    function empreendimentosParceirosDaIncorporadora($id_incorporadora)
    {
       $this->db->select("*, inc_empreendimento.id_incorporadora as id_incorporadora");
       $where[] = ['inc_parceiro_rel_empreendimento.id_incorporadora',$id_incorporadora];    
       $where[] = ['inc_empreendimento.id_incorporadora !=',$id_incorporadora];    
       $this->db->join('inc_parceiro_rel_empreendimento', 'inc_empreendimento.id_empreendimento = inc_parceiro_rel_empreendimento.id_empreendimento');
       return $this->getEmpreendimentos($where); 
    }
    
    function getParceirosEmpreendimento($where = [])
    {
        $this->db->join('inc_parceiro_rel_empreendimento', 'inc_parceiro.id_parceiro = inc_parceiro_rel_empreendimento.id_parceiro');
        //$this->db->join('inc_incorporadora', 'inc_incorporadora.id_incorporadora = inc_parceiro_rel_incorporadora.id_incorporadora');
        return $this->getParceiros($where);
    }
    
    function getParceiroEmpreendimento($where = [])
    {
        $this->db->join('inc_parceiro_rel_empreendimento', 'inc_parceiro.id_parceiro = inc_parceiro_rel_empreendimento.id_parceiro');
        return $this->getParceiro($where);
    }
    //==========================================================================================================
    function getCapturasNaoAtendidas($where = [])
    {
        return $this->getNaoAtendidas('cad_captura', 'id_captura', 'getCapturas', $where);
    }
    function getCapAguardandoRetorno($where = [])
    {
        return $this->getAguardandoRetorno('cad_captura', 'id_captura', 'getCapturas', $where,  null, null, false);
    }
    function getCapturasAtendimentoFinalizado($where = [])
    {
        return $this->getAtendimentoFinalizado('cad_captura', 'id_captura', 'getCapturas', $where);
    }
    
    function getNaoAtendidas($tb_origem, $name_id, $function_get, $where = [],  $tipo_interesse = null, $origem_captura = null)
    {
        if($tb_origem == 'cad_captura' && $name_id == 'email')
        {
            $select = 'email';
            $this->db->where('email !=','');
            $where[] = ['origem_captura', $origem_captura];
        }
        else{
            $select = 'id_rel';
            $this->db->where('tb_origem',$tb_origem);
        }
        
        $this->db->select($select);
        
        if($tipo_interesse != null)
            $this->db->where('tipo_interesse',$tipo_interesse);
            
        $this->db->join('cad_atendimento_historico as b', 'b.id_atendimento = a.id_atendimento');
	    $query = $this->db->get('cad_atendimento as a');
	    
        if ($query->num_rows() > 0){
            $array = [];
            foreach ($query->result() as $row)
               $array[$row->$select] = $row->$select;
               
            $this->db->where_not_in($tb_origem.'.'.$name_id, $array);
        }
        
        return call_user_func([$this,$function_get],$where);
    }
    
    function getAguardandoRetorno($tb_origem, $name_id, $function_get, $where = [],  $tipo_interesse = null, $origem_captura = null, $hoje = true)
    {
        if($tb_origem == 'cad_captura' && $name_id == 'email')
        {
            $select = 'email';
            $this->db->where('c.email !=','');
            $where[] = ['origem_captura',$origem_captura];
        }
        else{
            $select = 'id_rel';
            $where[] = ['tb_origem',$tb_origem];
        }
        
        if($tipo_interesse != null)
            $where[] = ['tipo_interesse',$tipo_interesse];
        
        $this->db->join('cad_atendimento as c', 'c.'.$select.' = '.$tb_origem.'.'.$name_id);
        $this->db->join('cad_atendimento_historico as d', 'd.id_atendimento = c.id_atendimento');
        $this->db->order_by('id_hist_atend','asc');
        
        $result = call_user_func([$this,$function_get],$where);
        
        
        $res = [];
        foreach ($result as $row){
            $res[$row->$name_id] = $row;
        }
        $return = [];
        
        
        foreach ($res as $row){
            
            
            if($hoje && $row->proximo_contato <= date("Y-m-d").' 23:59:59' && $row->proximo_contato >  '0000-00-00 00:00:00'){
                $return[$row->$name_id] = $row;
            }
            elseif(!$hoje && $row->proximo_contato >  '0000-00-00 00:00:00'){
                $return[$row->$name_id] = $row;
            }
        }
        return $return;
    }
    
    function getAtendimentoFinalizado($tb_origem, $name_id, $function_get, $where = [],  $tipo_interesse = null, $origem_captura = null)
    {
        if($tb_origem == 'cad_captura' && $name_id == 'email')
        {
            $select = 'email';
            $this->db->where('c.email !=','');
            $where[] = ['origem_captura',$origem_captura];
        }
        else{
            $select = 'id_rel';
            $where[] = ['tb_origem',$tb_origem];
        }
        
        if($tipo_interesse != null)
            $where[] = ['tipo_interesse',$tipo_interesse];
        
        $this->db->join('cad_atendimento as c', 'c.'.$select.' = '.$tb_origem.'.'.$name_id);
        $this->db->join('cad_atendimento_historico as d', 'd.id_atendimento = c.id_atendimento');
        $this->db->order_by('id_hist_atend','asc');
        
        $result = call_user_func([$this,$function_get],$where);
        
        $res = [];
        foreach ($result as $row){
            $res[$row->$name_id] = $row;
        }
        $return = [];
        foreach ($res as $row){
            if($row->proximo_contato == '0000-00-00 00:00:00' || $row->proximo_contato == 0)
                $return[$row->$name_id] = $row;
        }
        return $return;
    }
    
    
    function getCadsImovel($where) 
    {
        $this->where($where);
        $this->db->join('cad_imovel as b', 'b.id_cadastro = cad_cadastro.id_cadastro');
        $this->db->group_by('cad_cadastro.id_cadastro');
        
        $query = $this->db->get('cad_cadastro');
        
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
    }
    
    function getImoveisCad($where) 
    {
        $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = cad_imovel.id_cadastro');
        return $this->getResult('cad_imovel', $where);
    }
    
    function getCapturas($where = [])
	{
	    $this->db->select('*, cad_captura.nome as nome, cad_captura.email as email, cad_captura.telefone as telefone');
	    
	    $this->db->not_like('cad_captura.email', '@comdono.com', 'before'); 
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
    
    function getNegoviacoes($where = []) 
    {
        //$this->db->select('*, a.id_imovel as id_imovel, m.id_cadastro as id_cadastro', 'm.id_chat as id_chat');
        //$this->config_default_campanhas();
        //$this->db->where('status_msg < ', 4);
        ////////
        
        $this->where($where);
    
        $this->db->join('ngc_msg as m', 'm.id_chat = c.id_chat');
        
        $query = $this->db->get('ngc_chat as c');
        //echo( $this->db->last_query());
        if ($query->num_rows() > 0)
        {
            $result  = $query->result();
            $chats    = [];
            $msgs     = [];
            
            foreach($result as $obj)
            {
                $id =     $obj->id_chat;
                $id_msg =     $obj->id_msg;
                $chats[$id] = self::mGetChat($obj);
                $msgs[$id][$id_msg] = self::mGetMsg($obj);
                
                $chats[$id]->msgs = $msgs[$id];
                
            }
            
            
            return $chats;
        }
        return [];
    }
    
    function getResultadosNegociacao($id_negociacao){
        $this->db->select('*');
        $this->db->join('ngc_proposta as p', 'p.id_negociacao = n.id_negociacao');
        //$this->db->join('ngc_proposta_recibo as r', 'p.id_financeiro = r.id_proposta');
        $this->db->join('ngc_ficha_pfisica as pf', 'pf.id_negociacao = p.id_negociacao');
        //$this->db->join('cad_cadastro as c', 'c.id_cadastro = pf.id_conjuge');
        $this->db->where('n.id_negociacao = '.$id_negociacao);
        $this->db->group_by('n.id_negociacao');
        $query = $this->db->get('ngc_negociacoes as n');
        
        if($query->num_rows() == 1)
            return $query->row();
        return [];
    }
    
    function getResultadoNegociacaoPJ($id_negociacao){
        $this->db->select('*');
        $this->db->join('ngc_proposta as p', 'p.id_negociacao = n.id_negociacao');
        $this->db->join('ngc_ficha_pjuridica as pj', 'pj.id_negociacao = p.id_negociacao');
        $this->db->where('n.id_negociacao = '.$id_negociacao);
        $this->db->group_by('n.id_negociacao');
        $query = $this->db->get('ngc_negociacoes as n');
        
        if($query->num_rows() == 1)
            return $query->row();
        return [];
    }
    
    function getSimulacao($where = [], $like = [], $or_where = [], $or_like = [])//$where = [], $like = [], $or_where = [], $or_like = [], $order_by = [], $config = true
    {
        $this->where($where, $or_where);
        //$this->like($like, $or_like);
        //$this->order_by($order_by);
        
        $query = $this->db->get('fnc_simulacao');
        
        if ($query->num_rows() > 0)
        {
            return $query->row();
        }
        return null;
    }
    
    function getSimulacoes($where = [])
    {
        $this->where($where, []);
        
        $query = $this->db->get('fnc_simulacao');
        
        if ($query->num_rows() > 0)
        {
            return $query->result();
        }
        return [];
    }
    
    function getImoveis($arrayWhere = [], $id_cadastro = null) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        $this->db->where('a.lixeira <', 2);
        $this->db->order_by("a.id_imovel", "desc");
        
        /*if($id_cadastro === null)
            $id_cadastro = $this->session->id_cadastro;
        
        if($id_cadastro !== false)
            $this->db->where('a.id_cadastro', $id_cadastro);
        
        
        foreach ($arrayWhere as $key=>$val){
	        
            if(is_array($val))
            {
                $this->db->group_start();
                foreach($val as $dado_n)
                { 
                    $this->db->or_where($dado_n[0], $dado_n[1]);
                }
                $this->db->group_end();
            }
            else
            {
                $this->db->where($key, $val);
            }
            
        }*/
        
        $this->where($arrayWhere, []);
        
    
        $this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        $this->db->order_by('priority', 'ASC');
        
        $query = $this->db->get('cad_imovel as a');
        
        //echo( $this->db->last_query());
        
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imoveis = [];
            $imagens = [];
            
            foreach($result as $obj)
            {
                $imoveis[$obj->id_imovel] = $obj;
                if( $obj->id_img == '')
                    $imagens[$obj->id_imovel] = [];
                else 
                     $imagens[$obj->id_imovel][] = self::mGetImagem($obj);
                
                $imoveis[$obj->id_imovel]->imagens = $imagens[$obj->id_imovel];
            }
            
            return $imoveis;
        }
            
        return [];
    }
    
    
    function getImovel($where = [], $like = [], $or_where = [], $or_like = []) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        
        $this->where($where, $or_where);
         
    
        $this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        $this->db->order_by('priority', 'ASC');
        $query = $this->db->get('cad_imovel as a');
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imagens = [];
            
            foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                //$obj->val_pretendido += $obj->val_public_total;
                $imovel = self::mGetImovel($obj);
                if( $obj->id_img == '')
                    $imagens[$id] = [];
                else 
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imovel->imagens = $imagens[$id];
            }
            return $imovel;
        }
        return null;
    }
    
    function getCaptura($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
    
    function getIntencoesBusca($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_intencao_busca');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	
	
	function getFavoritos($where)
    {
        $this->where($where);
	    $query = $this->db->get('cad_favoritos');
	    if ($query->num_rows() > 0)
	        return $query->result();
        return [];
    }
    
    //favoritos
    function get_favoritos($id_cadastro)
    {
        if($id_cadastro == null)
            return [];
        
        $this->db->where('id_cadastro',$id_cadastro);
	    $query = $this->db->get('cad_favoritos');
	    if ($query->num_rows() > 0)
	    {
	        $result = $query->result();
	        $favoritos = [];
	        foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                $favoritos[$id] = $obj;
                
            }
            return $favoritos;
        }
	    return [];
    }
    
    
	
	
	function getCapturasOrderBy($where = [])
	{
	    $this->db->order_by('datetime_captura', 'desc');
	    return $this-> getCapturas($where);
	}
	
	
	function getAtendimento($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_atendimento');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	
	function getHistoricoAtendimento($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_atendimento_historico');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	
	function getAtendimentoHistoricoDesc($where = [])
	{
	    $this->db->order_by('data_hora', 'ASC');
	    return $this->getAtendimentoHistorico($where);
	}
	
	function getCadastrosUsers($where = []) 
    {
        $this->where($where,[]);
        $this->db->join('sys_users','sys_users.id_cadastro = cad_cadastro.id_cadastro');
	    $query = $this->db->get('cad_cadastro');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	
	function getCadastros($where = []) 
    {
        $this->where($where,[]);
	    $query = $this->db->get('cad_cadastro');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	
	
    function get_log_emails($where = []) 
    {
        $this->where($where);
        $query = $this->db->get('nwl_log_emails');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
    
    /*function getImovel($arrayWhere = [], $id_cadastro = null) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        $this->db->where('a.lixeira <', 2);
        //$this->db->order_by("a.id_imovel", "desc");
        
        if($id_cadastro === null)
            $id_cadastro = $this->session->id_cadastro;
        
        if($id_cadastro !== false)
            $this->db->where('a.id_cadastro', $id_cadastro);
        
        
        foreach ($arrayWhere as $key=>$val){
	        
            if(is_array($val)){
                $this->db->group_start();
                foreach($val as $dado_n)
                { 
                    $this->db->or_where($dado_n[0], $dado_n[1]);
                }
                $this->db->group_end();
            }else{
                $this->db->where($key, $val);
            }
        } 
    
        $this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        $this->db->order_by('priority', 'ASC');
        $query = $this->db->get('cad_imovel as a');
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imagens = [];
            
            foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                $obj->val_pretendido += $obj->val_public_total;
                $imovel = self::mGetImovel($obj);
                if( $obj->id_img == '')
                    $imagens[$id] = [];
                else 
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imovel->imagens = $imagens[$id];
            }
            return $imovel;
        }
        return null;
    }*/
    
    function getImoveisSimulacao($arrayWhere = []) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        $this->db->where('a.lixeira <', 2);
        $this->db->where('c.step >=', 4);
        
       
        foreach ($arrayWhere as $key=>$val){
	        
            if(is_array($val))
            {
                $this->db->group_start();
                foreach($val as $dado_n)
                { 
                    $this->db->or_where($dado_n[0], $dado_n[1]);
                }
                $this->db->group_end();
            }
            else
            {
                $this->db->where($key, $val);
            }
        } 
        
       //$this->db->join('fnc_simulacao as c', 'c.id_imovel = a.id_imovel');
       //$this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        
        
        $this->db->order_by('priority', 'ASC');
        
        $query = $this->db->get('cad_imovel as a');
        
        //echo( $this->db->last_query());
        
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imoveis = [];
            $imagens = [];
            
            foreach($result as $obj)
            {
                $imoveis[$obj->id_imovel] = $obj;
                if( $obj->id_img == '')
                    $imagens[$obj->id_imovel] = [];
                else 
                     $imagens[$obj->id_imovel][] = $obj;
                
                $imoveis[$obj->id_imovel]->imagens = $imagens[$obj->id_imovel];
            }
            
            return $imoveis;
        }
            
        return [];
    }
    
    
    function get_cadastro($where = [], $id_cadastro = null) 
    {
        if($id_cadastro === null && empty($where))
            return null;
        
        if($id_cadastro !== false && $id_cadastro !=  null)
            $this->db->where('id_cadastro', $id_cadastro);
            
	    $this->where($where, []);
	        
	    $query = $this->db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
    
    public function update_galeria($data)
    {
        $data = self::montaImg($data);
        return $this->insert('cad_img', $data);
    }
    
    function update_galery_by_id($data)
	{
	    //$this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('id_img', $data['id_img']);
	    unset($data['id_img']);
	    return $this->update('cad_img', $data);
	}
	
	function update_galery_rel_by_id($data)
	{
	    //$this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('id_img_rel', $data['id_img']);
	    unset($data['id_img']);
	    return $this->update('cad_img', $data);
	}
    
    function update_image_galery_by_imovel($id_imovel, $data)
	{
	    $this->db->where('id_imovel', $id_imovel);
        $this->db->where('imagem', $data['imagem']);
	    return $this->update('cad_img', $data);
	}
	
	function deleteImovel($where)
	{
	    if($where == null || empty($where) || !is_array($where))
	        return false;
	        
	    $this->where($where);
	    return $this->db->delete('cad_imovel');
	    
	}
	
	
	
	function getImgImovel($where)
	{
	    return $this->getRow('cad_img', $where);
	}
	
	function insertImgImovel($data)
	{
	    return $this->insert('cad_img', $data);
	}
	
	function updateImgImovel($where, $data)
	{
	    $this->where($where);
        return $this->update('cad_img', $data);
	}
	
	function deleteImgImovel($where)
	{
	    if($where == null || empty($where) || !is_array($where))
	        return false;
	        
	    $this->where($where);
	    return $this->db->delete('cad_img');
	}
	
	function getCountTotalInvestimento($id_empreendimento) 
    {
        $this->db->select('SUM(valor) as valor');
        $this->db->where('id_empreendimento', $id_empreendimento);
        $query = $this->db->get('inc_investimento_midias');
        
        if ($query->num_rows() == 1) 
        {
            return $query->row();
        }
        return [];
    }
	
	function getCountTotalCanais($id_empreendimento) 
    {
        $this->db->select('midia, SUM(valor) as valor');
        $this->db->where('id_empreendimento', $id_empreendimento);
        $this->db->group_by('midia'); 
        $query = $this->db->get('inc_investimento_midias');
        
        if ($query->num_rows() > 0) 
        {
            return $query->result();
        }
        return [];
    }
    
    function getPrimeiroVendedor($id_empreendimento, $datahora)
    {
        return $this->getMembrosDisponiveis($id_empreendimento, $datahora, [3,6])[0]??null;
    }
    
    function getProximoVendedorDisponivel($id_empreendimento, $datahora, $id_funcao, $wvd = [])
    {
        $vendedores = $this->getMembrosDisponiveis($id_empreendimento, $datahora, $id_funcao, $wvd);

        foreach ($vendedores as $vendedor)
        {
            $vend = $this->checkAgendaDisponivelVendedor($vendedor,$id_empreendimento,$datahora);
            
            if($vend != null)
                return $vend;
        }
        
        return null;
    }
    
    function getProximoVendedorDisponivelSequencia($id_empreendimento, $datahora, $where = [], $UUID, $id_equipe)
    {
        $capturas = $this->getCapAgendas([['origem_captura', $UUID],['id_equipe', $id_equipe],['link !=','formConvite']]);
        
        $vendedores = $this->getMembrosDisponiveis($id_empreendimento, $datahora, [3,6], $where);
  
        $keyProximo = count($capturas)%count($vendedores);
        
        $vend = NULL;
        $i = 0;
        while($i < count($vendedores))
        {
            $keyProximo = (count($capturas)+$i)%count($vendedores);
            
            $i++;
            $vend = $this->checkAgendaDisponivelVendedor($vendedores[$keyProximo],$id_empreendimento,$datahora);
            if($vend != null)
            {
                $i = count($vendedores);
            }
        }
        
        return $vend;
        
    }
    
    function checkAgendaDisponivelVendedor($vendedor,$id_empreendimento,$datahora)
    {
        $date_ini = date('Y-m-d H:i:s', strtotime($datahora));
        $date_fim = date('Y-m-d H:i:s', strtotime($datahora.' +1 hour'));
        $extract = ['participantes', 'id_responsavel', $vendedor->id_cadastro];
        $where[]   = [['id_destino', $id_empreendimento]];
        $where[]   = ['data_hora_agendamento >=', $date_ini];
        $where[]   = ['data_hora_agendamento <' , $date_fim];
        $agendados = $this->cad_model->JSON($extract)->getAgendas($where);
        
        if(empty($agendados))
            return $vendedor;
        else
            return NULL;
    }
    
    function getMembrosDisponiveis($id_empreendimento, $datahora, $id_funcao, $where = [])
    {
        if($datahora != null){
            $dias = ["domingo","segunda","terca","quarta","quinta","sexta","sabado"];
            $dia_semana = $dias[date('w', strtotime(date($datahora)))];
            $horario    = date('H:i:s', strtotime(date($datahora)));
            $where[] = ['hora_inicio <=',$horario];
            $where[] = ['hora_fim >',$horario];
            $where[] = ['dia_semana',$dia_semana];
        }
        
        $where[] = ['id_empreendimento',$id_empreendimento];
        if(is_array($id_funcao)){
            foreach ($id_funcao as $id)
                $or_where[] = ['id_perfil',$id];
            $where[] = $or_where; 
        }
        else
            $where[] = ['id_perfil',$id_funcao];
        
        $this->db->order_by('priority','asc');
        $this->db->join('inc_escala', 'inc_escala.id_cadastro = inc_membro_rel_acesso.id_cadastro');
        $this->db->group_by('inc_membro_rel_acesso.id_cadastro');
        return $this->getMembros($where); //->inArrayJson('id_empreendimentos',$id_empreendimento)
    }
    
    function getEscalaEquipe($where = [])
    {
        return $this->getResult('inc_escala', $where);
    }
    
    function getCardsVisitas($func, $campo_data, $where = [], $controle, $qtd_reg, $dia = '')
	{
	   
	    $controle = $controle * $qtd_reg;
	    
	    // revisar
	    //$MEMBRO = $this->getMembro([['inc_membro_rel_acesso.id_cadastro',ID_CADASTRO],['tipo', 2],['id_rel',$id_parceiro]]);
	    
	    //essa funcao trouxe outro membro Ricardo
	    //$mem = $this->getMembro();
	    
	    
	    //if($MEMBRO == null)
	    //{
	    //    $incorporadora = $this->getIncorporadora([['id_responsavel',ID_CADASTRO ]]);
    	//    if($incorporadora != null){
    	//        $MEMBRO = (object)[];
    	//        $MEMBRO->id_funcao = 1;
    	//        $MEMBRO->funcao = HMembro::funcao(1);
    	//        $MEMBRO->id_incorporadora = $incorporadora->id_incorporadora;
    	//    }
    	//    else{
    	//        return [];  
    	//    }
	    //}
	    
        $results = [];
        for($i=0;$i<$qtd_reg;$i++) {
            if($dia != ''){
                $date = converte_data($dia, 1);
                $dataSelecionada = strtotime($date.' +'.$i.' day');
            }
            else{
                $dataSelecionada = mktime(date("H"), date("i"), date("s"), date("m"), (date("d") + $controle + $i), date("Y"));
            }
            
            $w = $where;
            $w[] = ["YEAR($campo_data)",date("Y",$dataSelecionada)];
            $w[] = ["MONTH($campo_data)",date("m",$dataSelecionada)];
            $w[] = ["DAY($campo_data)",date("d",$dataSelecionada)];
            
            $obj = (object)[];
            $obj->data = date("Y-m-d H:i:s",$dataSelecionada);
            $obj->diaDaSemana = diaDaSemana(date("Y-m-d H:i:s",$dataSelecionada));
            $obj->diaMes = diaMes(date("Y-m-d H:i:s",$dataSelecionada));
            
            $CI =& get_instance();
            if($CI->getIdPerfil() == 3)
                $this->JSON(['participantes', 'id_responsavel', $this->session->id_cadastro]);
            
            //-------------------------NOVO
            $w[] = ['origem', 4];
            $this->db->join('cad_captura', 'cad_captura.id_captura = age_agenda.id_origem');
            //$this->db->join('inc_empreendimento', 'inc_empreendimento.id_empreendimento = age_agenda.id_destino');
            //$this->db->join('inc_parceiro_rel_empreendimento', 'inc_parceiro_rel_empreendimento.id_parceiro = cad_captura.id_parceiro','left');
            
            //-------------------------NOVO
            
            
            $obj->agendamentos = call_user_func([$this,$func],$w);
            foreach ($obj->agendamentos as $card){
                //$id_incorporadora = $MEMBRO->id_incorporadora;
                
                
                //$card->vendedoresDisponiveis = $this->getMembrosDisponiveis($card->id_destino, $card->data_hora_agendamento, 3, [['inc_escala.id_incorporadora',$id_incorporadora],['inc_escala.id_parceiro',$id_parceiro]]);
                //$card->vendedoresDisponiveis = [];
                
                $card->data_hora_visita = converte_datahora($card->data_hora_agendamento,1);
                $participantes = $card->participantes;
                $card->interessado   = $this->getCadastro(['id_cadastro', $participantes->id_interessado??0]);
                
                $card->empreendimento = $this->getEmpreendimento(['id_empreendimento',$card->id_destino]);
                
                $id_incorporadora = $card->empreendimento->id_incorporadora;
                //$id_parceiro      = $this->empreendimentoParceiroDaIncorporadora($id_incorporadora,$card->id_destino)->id_parceiro??0;
                
                $id_parceiro = $card->id_parceiro;
                
                if($card->id_equipe != 0)
                    $card->vendedoresDisponiveis = $this->getMembrosDisponiveis($card->id_destino, $card->data_hora_agendamento, [3,6], [['inc_escala.id_incorporadora',$id_incorporadora],['inc_escala.id_parceiro',$id_parceiro],['inc_membro_rel_acesso.tipo',2],['inc_escala.id_equipe',$card->id_equipe]]);                
                else
                    $card->vendedoresDisponiveis = $this->getMembrosDisponiveis($card->id_destino, $card->data_hora_agendamento, [3,6], [['inc_escala.id_incorporadora',$id_incorporadora],['inc_membro_rel_acesso.tipo',2],['inc_escala.id_parceiro',$id_parceiro]]);
                
                
                $card->visita            = $this->getVisita(['id_agenda',$card->id_agenda]);
                $card->negociacao        = $this->getNegociacao(['id_visita',$card->visita->id_visita??0]);
                $card->estoqueNegociacao = $this->getEstoqueNegociacao([['id_agenda',$card->id_agenda],['status_negociacao >', 1]]);
                
                $card->parceiro       = $this->getParceiro(['id_parceiro',$id_parceiro]);
                $card->equipe         = $this->getEquipe(['id_equipe',$card->id_equipe]);
                
                $card->responsavel = null;
                if(isset($participantes->id_responsavel)){
                    $id_responsavel      = $participantes->id_responsavel==''?0:$participantes->id_responsavel;
                    $card->responsavel   = $this->getCadastro(['id_cadastro', $id_responsavel]);
                }
                $card->status = HAgenda::status($card->status_agenda);
                if($card->origem == 3) // origem: atendimento
                    $card->captura = $this->getCapturaByAtendimento($card->id_origem);
                if($card->origem == 4) // origem: LP direto, Captura
                    $card->captura = $this->getCaptura(['id_captura', $card->id_origem]);
            }
            $results[$i] = $obj;
        }
        return $results;
	}
	
	function getTotaisVisitas($id_empreendimento)
	{
	    $result = [];
	    $result['agendadas'] = $this->getTotalVisitasAgendadas($id_empreendimento);
	    $result['realizadas'] = $this->getTotalVisitasRealizadas($id_empreendimento);
	    $result['desistencias'] = $this->getTotalVisitasDesistencias($id_empreendimento);
	    return $result;
	}
	
	private function getTotalVisitasAgendadas($id_empreendimento)
	{
	    $query = $this->db->select('COUNT(*) as total')
	    ->from('age_agenda as a')
	    ->group_start()
                ->where('status_agenda', 0)
                ->or_group_start()
                        ->where('status_agenda', 1)
                ->group_end()
        ->group_end()
        ->join('cad_atendimento as b', 'a.id_origem = b.id_atendimento')
        ->join('cad_captura as c', 'b.id_rel = c.id_captura')
        ->join('inc_empreendimento as d', 'c.origem_captura = d.uuid_empreendimento')
	    ->where('b.tb_origem', 'cad_captura')
	    ->where('d.id_empreendimento', $id_empreendimento)
        ->get();
        
        if ($query->num_rows() == 1) 
            return $query->row()->total;
        return 0;
	}
	
	private function getTotalVisitasRealizadas($id_empreendimento)
	{
	    $query = $this->db->select('COUNT(*) as total')
	    ->from('age_visita as v')
	    ->select('COUNT(*) as total')
	    ->join('age_agenda as a', 'a.id_agenda = v.id_agenda')
	    ->join('cad_atendimento as b', 'a.id_origem = b.id_atendimento')
        ->join('cad_captura as c', 'b.id_rel = c.id_captura')
        ->join('inc_empreendimento as d', 'c.origem_captura = d.uuid_empreendimento')
	    ->where('b.tb_origem', 'cad_captura')
	    ->where('v.status', 1)
	    ->where('d.id_empreendimento', $id_empreendimento)
        ->get();
        
        if ($query->num_rows() == 1) 
            return $query->row()->total;
        return 0;
	}

	private function getTotalVisitasDesistencias($id_empreendimento)
	{ 
        $query = $this->db->select('COUNT(*) as total')
	    ->from('age_visita as v')
	    ->select('COUNT(*) as total')
	    ->join('age_agenda as a', 'a.id_agenda = v.id_agenda')
	    ->join('cad_atendimento as b', 'a.id_origem = b.id_atendimento')
        ->join('cad_captura as c', 'b.id_rel = c.id_captura')
        ->join('inc_empreendimento as d', 'c.origem_captura = d.uuid_empreendimento')
	    ->where('b.tb_origem', 'cad_captura')
	    ->where('d.id_empreendimento', $id_empreendimento)
	    ->where('v.status', 0)
	    ->where('v.justificativa !=','')
        ->get();
        
        //echo $this->db->last_query();
        
        if ($query->num_rows() == 1) 
            return $query->row()->total;
        return 0;
	}
	
	function get_Negociacao($id_negociacao, $origem){
        	    
        if($origem == 4){
            $sql = 'JOIN cad_captura as cap ON cap.id_captura = a.id_origem';
        }else{
            $sql = 'JOIN cad_atendimento as ca ON ca.id_atendimento = a.id_origem JOIN cad_captura as cap ON cap.id_captura = ca.id_rel';
        }	    
        	    
        $query = $this->db->query('SELECT *,c.cpf as cpf_cadastro,cap.cpf as cpf_captura FROM ngc_negociacoes as n 
        JOIN age_visita as v ON n.id_visita = v.id_visita 
        JOIN age_agenda as a ON v.id_agenda = a.id_agenda 
        '.$sql.' 
        JOIN cad_cadastro as c ON c.id_cadastro = JSON_UNQUOTE(JSON_EXTRACT(a.participantes, "$.id_interessado")) 
        WHERE n.id_negociacao = '.$id_negociacao);
        
        if ($query->num_rows() == 1) 
            return $query->row();
        return 0;
	}
	
	function get_Negociacao_origem($id_negociacao){
	    $query = $this->db->query('SELECT a.origem as origem FROM ngc_negociacoes as n 
        JOIN age_visita as v ON n.id_visita = v.id_visita 
        JOIN age_agenda as a ON v.id_agenda = a.id_agenda 
        WHERE n.id_negociacao = '.$id_negociacao);
        
        if ($query->num_rows() == 1) 
            return $query->row()->origem;
        return 0;
	}
	
	function insere_documentos($id_negociacao, $patch, $tipo){
        switch ($tipo) {
            case '1':
                $sql = 'JSON_SET(documentos, "$.pf", "'.$patch.'")';
            break;
            
            case 'pv':
                $sql = 'JSON_SET(documentos, "$.pv", "'.$patch.'")';
            break;
            
            case '2':
                $sql = 'JSON_SET(documentos, "$.pj", "'.$patch.'")';
            break;
        }
        
        $this->db->set('documentos',$sql,FALSE);
        $this->db->where('id_negociacao', $id_negociacao);
        return $this->db->update('est_negociacao');
	}
	
	function getAtendimentoDesistencia($where = []){
        	        
        return $this->getAgenda($where);
	}
	
	function getCapNegociacaoByData($where = []){
        
        $where[] = ['age_agenda.origem', 4];
        
        $this->db->join('age_visita', 'ngc_negociacoes.id_visita = age_visita.id_visita');
        $this->db->join('ngc_pre_reserva', 'age_visita.id_visita = ngc_pre_reserva.id_visita');
        $this->db->join('age_agenda', 'age_agenda.id_agenda = age_visita.id_agenda');
        $this->db->join('cad_captura', 'cad_captura.id_captura = age_agenda.id_origem');
        
        return $this->getNegociacoes($where);
	}
	
	function getNegociacaoByData($where = []){
        
        $this->db->join('age_visita as v', 'ngc_negociacoes.id_visita = v.id_visita');
        //$this->db->join('age_agenda as a', 'v.id_agenda = a.id_agenda');
        $this->db->join('ngc_pre_reserva as p', 'v.id_visita = p.id_visita');
        
        return $this->getNegociacoes($where);
	}
	
	function getHistoricosAtendimentoIncorporadoras($id_responsavel, $data = ''){
	    
	    if($data != ''){
	        $this->db->where('date_time >= "'.$data.' 00:00:00"'.' AND date_time <= "'.$data.' 23:59:59"');
	    }
	    
	    $this->db->where('id_responsavel',$id_responsavel);
	    $query = $this->db->get('cad_atendimento_fila_status');
	    
	    if($query->num_rows() > 0){
	        return $query->result();
	    }else{
	        return [];
	    }
	}
	
	function getFilaAtendimento(){
        
        $this->db->where('data_fila > "2020-11-25 00:00:00"');
        $query = $this->db->get('view_atendimento_fila',1);
        
        if($query->num_rows() == 1){    
            return $query->row();
        }else{
            return NULL;
        }
	}
	
	function getFilaAtendimentos(){
        
        $this->db->where('data_fila > "2020-11-25 00:00:00"');
        $query = $this->db->get('view_atendimento_fila');
        
        if($query->num_rows() > 0){    
            return $query->result();
        }else{
            return NULL;
        }
	}
	
	
	function setStatusFila($data){
	    return $this->db->insert('cad_atendimento_fila_status', $data);
	}
	
	function updateFila($id_fila, $data){
	    $this->db->where('id_fila',$id_fila);
	    return $this->db->update('cad_atendimento_fila_status', $data);
	}
	
	function getStatusFila($where){
	    
	    $this->db->where($where);
	    $this->db->order_by('id_fila','ASC');
	    
	    $query = $this->db->get('cad_atendimento_fila_status',1);
	    
	    if($query->num_rows() == 1){    
            return $query->row();
        }else{
            return NULL;
        }
	}
	
	function getFilas($where){
	    
	    $this->db->where($where);
	    
	    $query = $this->db->get('cad_atendimento_fila_status');
	    
	    if($query->num_rows() > 0){    
            return $query->result();
        }else{
            return [];
        }
	}
	
	function getPropostas($where = []){
	    
	    $this->db->where($where);
	    
	    $query = $this->db->get('inc_proposta_new');
	    
	    if($query->num_rows() > 0){    
            return $query->result();
        }else{
            return [];
        }
	}
	
	function getProposta($where = []){
	    
	    $this->db->where($where);
	    
	    $query = $this->db->get('inc_proposta_new');
	    
	    if($query->num_rows() == 1){    
            return $query->row();
        }else{
            return NULL;
        }
	}
	
	function getPlanos($where = []){
	    
	    $this->db->where($where);
	    
	    $query = $this->db->get('inc_planos');
	    
	    if($query->num_rows() > 0){    
            return $query->result();
        }else{
            return [];
        }
	}
	
	function getPlanosNew($where = []){
        $this->db->where($where);
        
        $this->db->join('inc_planos_new','inc_planos_new.id_plano = inc_planos_rel.id_plano');
        
        $query = $this->db->get('inc_planos_rel');
	    
	    if($query->num_rows() > 0){
	        if($query->num_rows() == 1){
                return $query->row();
	        }else{
	            return $query->result();
	        }
        }else{
            return [];
        }
	}
	
	function getGrupoPlanos($where = []){
	    $this->db->where($where);
	    
	    $query = $this->db->get('inc_planos_grupo');
	    
	    if($query->num_rows() > 0){    
            return $query->result();
        }else{
            return [];
        }
	}
	
	function getCondicoes($where = []){
	    $this->db->where($where);
	    
	    $query = $this->db->get('inc_grupo_condicao');
	    
	    if($query->num_rows() > 0){    
            return $query->result();
        }else{
            return [];
        }
	}
	
	function getServicos($where = []){
	    $this->db->where($where);
	    
	    $query = $this->db->get('inc_grupo_servico');
	    
	    if($query->num_rows() > 0){    
            return $query->result();
        }else{
            return [];
        }
	}
	
	function insertPropostas($data){
        return $this->insert('inc_proposta_new', $data);
	}
	
	function insertPlanos($data){
        return $this->insert('inc_planos_new', $data);
	}
	
	function insert_plano_rel($data){
        return $this->insert('inc_planos_rel', $data);
	}
	
	function get_PreReserva($id_pre_reserva){
        $this->db->select('*');
        //$this->db->from('ngc_pre_reserva as p');
        $this->db->join('cad_cadastro as c','p.id_cadastro = c.id_cadastro');
        $this->db->join('cad_imovel as i', 'p.id_unidade = i.id_imovel');
        $this->db->join('cad_captura as cap', 'p.id_captura = cap.id_captura');
        $this->db->where('p.id_pre_reserva = '.$id_pre_reserva);
        
        $query = $this->db->get('ngc_pre_reserva as p');
        
        if ($query->num_rows() == 1) 
            return $query->row();
        return 0;
	}
	
	
	function getPreReservaCompleta($where = []){
	    
        $this->db->join('cad_cadastro as c','ngc_pre_reserva.id_cadastro = c.id_cadastro');
        $this->db->join('cad_imovel as i', 'ngc_pre_reserva.id_unidade = i.id_imovel');
        $this->db->join('cad_captura as cap', 'ngc_pre_reserva.id_captura = cap.id_captura');
        
        return $this->getPreReserva($where);
	}
	
	function getPreReservasCompleta($where = []){
        $this->db->join('cad_cadastro as c','ngc_pre_reserva.id_cadastro = c.id_cadastro');
        $this->db->join('cad_imovel as i', 'ngc_pre_reserva.id_unidade = i.id_imovel');
        $this->db->join('cad_captura as cap', 'ngc_pre_reserva.id_captura = cap.id_captura');
        $this->db->join('ngc_negociacoes as n', 'ngc_pre_reserva.id_visita = n.id_visita');
        $this->db->join('age_visita as v', 'ngc_pre_reserva.id_visita = v.id_visita');
        
        return $this->getPreReservas($where);
	}
	
	function getAgendasCompleta($where = []){
	    $this->db->join('age_agenda as a', 'age_agenda_historico.id_agenda = a.id_agenda');
	    $this->db->join('cad_cadastro as c','JSON_UNQUOTE(JSON_EXTRACT(a.participantes, "$.id_interessado")) = c.id_cadastro');
	    
	    return $this->getAgendaHistorico($where);
	}
	
	function getAgendasRelatorios($where = []){
	    $this->db->select('*, (SELECT nome FROM cad_cadastro WHERE JSON_UNQUOTE(JSON_EXTRACT(age_agenda.participantes, "$.id_responsavel")) = cad_cadastro.id_cadastro) as nome_corretor');
	    $this->db->join('cad_cadastro as c', 'JSON_UNQUOTE(JSON_EXTRACT(age_agenda.participantes, "$.id_interessado")) = c.id_cadastro');
	    
	    return $this->getAgendas($where);
	}
	
	function getUltimaDesistencia($where = []){
	    $this->db->order_by('status_agenda', 'DESC');
	    $this->db->limit(1, 1);
	    
	    return $this->getAgendaHistorico($where);
	}
	
	function getCartaoVipRelatorio($where){
	    $this->db->join('cad_cadastro as c', 'cad_captura.id_cadastro = c.id_cadastro');
	    $this->db->join('age_agenda as a', 'JSON_UNQUOTE(JSON_EXTRACT(a.participantes, "$.id_interessado")) = c.id_cadastro', 'left');
	    $this->db->where('JSON_UNQUOTE(JSON_EXTRACT(a.participantes, "$.id_interessado")) IS NULL');
	    
	    return $this->getCapturas($where);
	}
	
	function get_Unidades($id_imovel){
	    $this->db->where('id_imovel_rel ='.$id_imovel);
	    $query = $this->db->get('cad_imovel');
	    
	    if ($query->num_rows() > 0) 
            return $query->result();
        return 0;
	}
	
	function getCapturaByAtendimento($id_atendimento)
	{
	    $AtendimentoInicial = $this->getAtendimento([['id_atendimento',$id_atendimento]]);

        $tb_origem      = $AtendimentoInicial->tb_origem;
        $id_rel         = $AtendimentoInicial->id_rel;
        $primaryKeyName = $this->getPrimaryKey($tb_origem);

        return $this->getRow($tb_origem, [$primaryKeyName, $id_rel]);
	}
	
	// old -> new getVisitas
	function getSemanaSelecionada($func, $campo_data, $where = [], $semana = 0)
	{
	    $semana *= -1;
	    
        $results = [];
        for($i=0;$i<=6;$i++) {
            $dataSelecionada = mktime(date("H"), date("i"), date("s"), date("m"), (date("d") - (($semana)*7)-7) - (date( "w")-7) + $i, date("Y"));
            
            $w = $where;
            $w[] = ["YEAR($campo_data)",date("Y",$dataSelecionada)];
            $w[] = ["MONTH($campo_data)",date("m",$dataSelecionada)];
            $w[] = ["DAY($campo_data)",date("d",$dataSelecionada)];
            
            $obj = (object)[];
            $obj->data = date("Y-m-d H:i:s",$dataSelecionada);
            $obj->agendamentos = call_user_func([$this,$func],$w);
            
            $results[$i] = $obj;
        }
        return $results;
        //$data = new DateTime(date('Y-m-d', $dataSelecionada));
        //$diaN = date( "w", strtotime($data->format('Y-m-d')));
        //$data->modify('-' . $diaN . ' day');
        //for($i=0;$i<=6;$i++) {
        //    echo $data->format('d/m/Y') . ' - ' .  $translate[$data->format('w')] . "<br>";
        //    $data->modify('+1 day');
        //}
	}
	
	
	
	
	
}