<?php if (in_array($state,['add'])){ ?>
<!--<div class="row">
    <div class="col">
        <a href="<?php e(base_url('administrativo/atendimento/')); ?>" class="btn btn-primary float-right">Voltar</a>
    </div>
</div>-->
<div class="row mt-5">
    <div class="col-lg-12">
        <div class="card">
            <h5 class="card-header">Últimos atendimentos</h5>
            <div class="card-body">
                <?php if($atendimentos??false){ ?>
                <div class="row">
                    <div class="offset-lg-1 col-lg-10">
                        <div id="accordion" role="tablist">
                            <?php $i = 1; foreach($atendimentos as $atendimento){ ?>
                            <div class="card card-accent-info">
                                <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                    <h5 class="mb-0">
                                    <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                        <?php e(date('d/m/Y - H:i:s', strtotime($atendimento->data_hora))); ?>
                                    </a>
                                    </h5>
                                </div>
                                <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion" style="">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Tipo de interesse</label>
                                                    <input type="text" name="tipo_interesse" value="<?php e($atendimento->tipo_interesse); ?>" class="form-control" readonly="readonly">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Fase atual</label>
                                                    <textarea name="fase_atual" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($atendimento->fase_atual)); ?></textarea>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Fase atual - motivo</label>
                                                    <textarea name="fase_atual_motivo" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($atendimento->fase_atual_motivo)); ?></textarea>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Próxima fase</label>
                                                    <textarea name="proxima_fase" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($atendimento->proxima_fase)); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Último contato</label>
                                                    <input type="text" name="ultimo_contato" value="<?php e(($atendimento->ultimo_contato == '0000-00-00 00:00:00') ? "": date('d/m/Y - H:i:s', strtotime($atendimento->ultimo_contato))); ?>" class="form-control" readonly="readonly">
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Último contato - tipo</label>
                                                    <input type="text" name="ultimo_contato_tipo" value="<?php e($atendimento->ultimo_contato_tipo); ?>" class="form-control" readonly="readonly">
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Status da jornada</label>
                                                    <input type="text" name="status_jornada" value="<?php e($atendimento->status_jornada); ?>" class="form-control" readonly="readonly">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Próximo contato</label>
                                                    <input type="text" name="proximo_contato" value="<?php e(($atendimento->proximo_contato == '0000-00-00 00:00:00') ? "": date('d/m/Y - H:i:s', strtotime($atendimento->proximo_contato))); ?>" class="form-control" readonly="readonly">
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Próximo contato - motivo</label>
                                                    <textarea name="proximo_contato_motivo" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($atendimento->proximo_contato_motivo)); ?></textarea>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Observação</label>
                                                    <textarea name="observacao" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($atendimento->observacao)); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $i++; } ?>
                        </div>
                    </div>
                </div>
                <?php }else{ ?>
                <div class="row">
                    <div class="col-sm-9">
                        <p>Ainda não houve atendimento</p>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>