<?php if (in_array($state,['add'])){ ?>
<div class="row mt-5">
    <div class="col-lg-12">
        <div class="card">
            <h5 class="card-header">Últimos atendimentos</h5>
            <div class="card-body">
                <?php if($atendimentos??false){ ?>
                <div class="row">
                    <div class="offset-lg-1 col-lg-10">
                        <div id="accordion" role="tablist">
                            <?php $i = 1; foreach($atendimentos as $atendimento){ ?>
                            <div class="card card-accent-info">
                                <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                    <h5 class="mb-0">
                                    <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                        <?php e(date('d/m/Y - H:i:s', strtotime($atendimento->data_hora))); ?>
                                    </a>
                                    </h5>
                                </div>
                                <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion" style="">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="control-label">Atendente</label>
                                                    <input type="text" name="atendente" value="<?php e($atendimento->atendente); ?>" class="form-control" readonly="readonly">
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label">Tipo de interesse</label>
                                                    <input type="text" name="tipo_interesse" value="<?php e($atendimento->tipo_interesse); ?>" class="form-control" readonly="readonly">
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label">Observação</label>
                                                    <textarea name="observacao" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($atendimento->observacao)); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $i++; } ?>
                        </div>
                    </div>
                </div>
                <?php }else{ ?>
                <div class="row">
                    <div class="col-sm-9">
                        <p>Ainda não houve atendimento</p>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>