<div class="animated fadeIn">
    <!-- /.row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-accent-primary">
                <div class="card-header">
                    <a href="javascript:;" data-toggle="collapse" data-target="#collapsePrecadastros" aria-expanded="false" class="collapsed">
                        <i class="icon-user-follow"></i> Pré-cadastros
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-container table-responsive">
                        <table id="dataTable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Email</th>
                                    <th style="min-width: 85px;">Telefone</th>
                                    <th class="sorting_asc_custom">Data Cadastro</th>
                                    <th>Interesse</th>
                                    <th>Etapa cadastro</th>
                                    <th style="min-width: 130px;">Último atendimento</th>
                                    <th style="min-width: 130px;">Proximo atendimento</th>
                                    <th style="min-width: 70px;" class="hiden-filter"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($cadastros as $id=>$cad) { $captura = $cad ?>
                                <tr id="divImovel_<?php e($id) ?>" class="trData" data-atendimento='<?php e(json_encode($cad)) ?>'>
                                    <td><?php e($cad->nome); ?></td>
                                    <td><?php e($cad->email); ?></td>
                                    <td><?php e($cad->telefone); ?></td>
                                    <td>
                                        <?php 
                                            if(empty($cad->timestamp_cadastro)){
                                                e("");
                                            }
                                            elseif($cad->timestamp_cadastro == '0000-00-00 00:00:00'){
                                                e("Data inválida");
                                            }
                                            else{
                                                e("<span class='d-none'>".$cad->timestamp_cadastro."</span>"); 
                                                e(date('d/m/Y H:i:s',strtotime($cad->timestamp_cadastro))); 
                                            }
                                        ?>
                                    </td>
                                    
                                    <td class="text-center">
                                        <?php e($cad->comprador > 0 ?'<span class="badge badge-success">Comprar</span>':''); ?> <?php e($cad->vendedor > 0 ? '<span class="badge badge-primary">Vender</span>':''); ?>
                                    </td>
                                    
                                    <td class="text-center"><?php e($cad->etapa == 8 ?'<span class="badge badge-success">Completa</span>':$cad->etapa); ?></td>
                                    
                                    <td><p class="resumo-text m-0"><?php e(end($captura->atendimento)->observacao??''); ?></p></td>
                                    
                                                <?php 
                                                    $proximo_contato = end($captura->atendimento)->proximo_contato??'';
                                                    if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00'){
                                                         $proximo_contato = '';
                                                         $alert = '<span class="d-none">z'.$proximo_contato.'</span>';
                                                    }else{
                                                        $alert = '<span class="d-none">a'.$proximo_contato.'</span>'.
                                                                 '<span class="badge badge-danger">'.date("d/m/Y", strtotime($proximo_contato)).'</span>';
                                                    }
                                                    $normal = '<span class="d-none">b'.$proximo_contato.'</span>'.(date("d/m/Y", strtotime($proximo_contato)));
                                                ?>
                                                <td>
                                                    <?php 
                                                    $proximo_contato = end($captura->atendimento)->proximo_contato??'';
                                                    if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00'){
                                                         $proximo_contato = '';
                                                         $alert = '<span class="d-none">z'.$proximo_contato.'</span>';
                                                    }else{
                                                        $alert = '<span class="d-none">a'.$proximo_contato.'</span>'.
                                                                 '<span class="badge badge-danger">'.date("d/m/Y", strtotime($proximo_contato)).'</span>';
                                                    }
                                                    $normal = '<span class="d-none">b'.$proximo_contato.'</span>'.(date("d/m/Y", strtotime($proximo_contato)));
                                                    
                                                    e($proximo_contato <= date("Y-m-d H:i:s") ? $alert:$normal);
                                                    ?>
                                                </td>
                                    <td class="tdAction_<?php e($id) ?>" >
                                        <a href="<?php e(base_url()); ?>administrativo/usuarios/perfil/<?php e($cad->id_cadastro??0)?>/0" target="_blank" class="btn btn-secondary mb-1" data-toggle="tooltip" data-original-title="Visualizar perfil">
                                                <i class="icon-user"></i> 
                                        </a>
                                        <?php if(!empty($cad->atendimento)){ ?>
                                        <a href="<?php e(base_url().'administrativo/atendimento/atendimento_geral/outros/'.$cad->atendimento[0]->id_atendimento); ?>" class="actAtendimento btn btn-success mb-1" data-id="<?php e($id); ?>" data-toggle="tooltip" data-original-title="Visualizar atendimento">
                                            <i class="icon-check"></i>
                                        </a>
                                        <?php }else{ ?>
                                        <a href="javascript:;" class="addAtendimentoGeral btn btn-primary mb-1" data-interesse="outros" data-atendimento='<?php e(json_encode($cad)) ?>' data-toggle="tooltip" data-original-title="Adicionar atendimento">
                                            <i class="icon-plus"></i>
                                        </a>
                                        <?php } ?>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>