<!--proposta-->
<div class="tab-pane fade active show" id="propostaEmpreendimento" role="tabpanel" aria-labelledby="propostaEmpreendimento-tab">
    <div class="card">
        <div class="card-header">Empreendimento</div>
        <div class="card-body">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-sm-6 col-md-4">
                            <div class="card card-accent-primary">
                                <div class="card-header">Proposta<?php e($empreendimento->contrato == 1 ? "/Contrato":""); ?></div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <ul class="list-unstyled">
                                                <li><strong>Data de cadastro:</strong> <?php e(date("d/m/Y", strtotime($empreendimento->emp_data_cadastro))); ?></li>
                                                <li><strong>Status da proposta: </strong> <span class="badge badge-<?php e($empreendimento->pro_status_badge) ?>"><?php e($empreendimento->pro_status) ?></span></li>
                            
                                                <?php if($empreendimento->pro_status == "Aguardando envio"){ ?>
                                                <li>
                                                    <a href="javascript:;" class="btn btn-primary btn-sm btnEnviarAcesso my-1" data-empreendimento ='<?php e(json_encode($empreendimento)); ?>'  data-incorporadora='<?php e(json_encode($incorporadora)); ?>' data-pro_data_envio="<?php e(date("Y-m-d H:i:s")); ?>"> 
                                                        <i class="fa fa-share" aria-hidden="true"></i> Enviar link de acesso
                                                    </a>
                                                </li>
                                                <?php } ?>
                                                
                                                <?php if($empreendimento->pro_status == "Enviada"){ ?>
                                                <li><strong>Data envio proposta: </strong> <?php e(date("d/m/Y", strtotime($empreendimento->pro_data_envio))); ?></li>
                                                <li>
                                                    <a href="javascript:;" class="btn btn-ghost-primary btn-sm btnEnviarAcesso my-1" data-empreendimento ='<?php e(json_encode($empreendimento)); ?>'  data-incorporadora='<?php e(json_encode($incorporadora)); ?>'> 
                                                        <i class="fa fa-share" aria-hidden="true"></i> Reenviar link de acesso
                                                    </a>
                                                </li>
                                                <?php } ?>
                                                
                                                <?php if($empreendimento->pro_status !== "Aceita"){ ?>
                                                <li>
                                                    <form action="" class="formAtualizaempreendimento">
                                                    <strong>Proposta aceita?</strong>
                                                    <div class="form-group">
                                                        <div class="form-check form-check-inline mr-1">
                                                            <input type="radio" name="proAceita" class="form-check-input" id="pro_sim" value="sim">
                                                            <label class="form-check-label" for="pro_sim">Sim</label>
                                                        </div>
                                                        <div class="form-check form-check-inline mr-1">
                                                            <input type="radio" name="proAceita" class="form-check-input" id="pro_nao" value="nao">
                                                            <label class="form-check-label" for="pro_nao">Não</label>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="pro_data_aceite">Data aceite</label>
                                                        <input type="date" name="pro_data_aceite" class="form-control" id="pro_data_aceite" value="<?php e($empreendimento->pro_data_aceite) ?>">
                                                    </div>
                                                    <div class="form-group text-right mt-4 mb-0">
                                                        <button type="button" class="btn btn-success btnAtualizaempreendimento"><i class="fa fa-check"></i> Salvar</button>
                                                    </div>
                                                    </form>
                                                </li>
                                                <?php } ?>
                                                
                                                <?php if($empreendimento->pro_status != "Aguardando envio" && $empreendimento->contrato == 0 && $empreendimento->pro_status == "Aceita"){ ?>
                                                <li>
                                                    <button class="btn btn-success btn-sm my-1" type="button" data-toggle="modal" data-target="#gerarContrato">
                                                        <i class="fa fa-file-pdf-o" aria-hidden="true"></i>&nbsp;Gerar contrato
                                                    </button>
                                                </li>
                                                <?php } ?>
                                                
                                                <?php if($empreendimento->contrato == 1 && $empreendimento->con_status != "Assinado"){ ?>
                                                <li><strong>Status do contrato: </strong> <?php e($empreendimento->con_status); ?></li>
                                                <li><strong>Contrato gerado em:</strong> <?php e(date("d/m/Y", strtotime($empreendimento->con_data))); ?></li>
                                                <li><strong>Link do contrato: </strong> <a href="<?php e($empreendimento->con_link); ?>" target="_blank">Visualizar contrato</a></li>
                                                <li>
                                                    <button class="btn btn-success btn-sm my-1" type="button" data-toggle="modal" data-target="#modalAceitaContrato">
                                                        <i class="fa fa-file-pdf-o" aria-hidden="true"></i>&nbsp;Assinar contrato
                                                    </button>
                                                </li>
                                                <?php } ?>
                                                
                                                <?php if($empreendimento->con_status == "Assinado"){ ?>
                                                <li><strong>Data assinatura contrato: </strong> <?php e(date("d/m/Y", strtotime($empreendimento->con_data_assinatura))); ?></li>
                                                <li><strong>Contrato:</strong> <a class="" href="#"><i class="fa fa-cloud-download" aria-hidden="true"></i> Download</a></li>
                                                <li><strong>Link do contrato: </strong> <a href="<?php e($empreendimento->con_link); ?>" target="_blank">Visualizar contrato</a></li>
                                                <li><strong>Plano: </strong> <?php e($planos[0]->plano); ?></li>
                                                <li><strong>Proposta: </strong> <?php e($proposta->tipo_proposta); ?></li>
                                                <li><strong>Investimento mídia: </strong> <?php e($proposta->pg_midia == 0 ? "Incorporadora":"Comdono"); ?></li>
                                                <?php } ?>
                                                
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="card card-accent-primary">
                                <div class="card-header">Empreendimento</div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <?php if($empreendimento->emp_logo != ""){ ?>
                                            <img src="<?php e($empreendimento->emp_logo); ?>" style="height: 50px;margin-bottom: 13px;">
                                            <?php } else { ?>
                                            <img src="<?php e(base_url("themes/comdono/img/no-image.png")); ?>" style="height: 50px;margin-bottom: 13px;">
                                            <?php } ?>
                                            <ul class="list-unstyled">
                                                <li><strong>Razão social:</strong> <?php e($empreendimento->emp_razao_social) ?></li>
                                                <li><strong>CNPJ:</strong> <?php e($empreendimento->emp_cnpj) ?></li>
                                                <li><strong>Telefone:</strong> <?php e($empreendimento->emp_telefone) ?></li>
                                                <li><strong>E-mail:</strong> <?php e($empreendimento->emp_email) ?></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="card card-accent-primary">
                                <div class="card-header">Responsável</div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <ul class="list-unstyled">
                                                <li><strong>Responsável:</strong> <?php e($empreendimento->res_nome) ?></li>
                                                <li><strong>E-mail:</strong> <?php e($empreendimento->res_email) ?></li>
                                                <li><strong>Telefone:</strong> <?php e($empreendimento->res_telefone) ?></li>
                                                <li><strong>Data de nascimento:</strong> <?php e(date("d/m/Y", strtotime($empreendimento->res_data_nascimento))); ?></li>
                                                <li><strong>Gênero:</strong> <?php e($empreendimento->res_genero) ?></li>
                                                <li><strong>CPF:</strong> <?php e($empreendimento->res_cpf) ?></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--Empreendimento-->
<div class="tab-pane fade" id="cadastroEmpreendimento" role="tabpanel" aria-labelledby="cadastroEmpreendimento-tab">
    <div class="card">
        <div class="card-header">Empreendimento</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-0">
                        <label for="responsavel">Logo</label>
                    </div>
                    <div id="div_emp_logo" class="form-group align-box-img mt-10">
                        <div class="container_upl container_upl_img custom-file  <?php e($empreendimento->emp_logo != "" ? "" : "d-none"); ?>">
                            <div class="box-doc div_img_background" <?php if ($empreendimento->emp_logo != ""){ ?> style="background-image: url('<?php e($empreendimento->emp_logo); ?>');" <?php } ?>></div>
                            <div class="box-ico-text">
                                <div class="text">
                                    <div class="txt">
                                        <i class="material-icons">
                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                            </svg>
                                        </i>
                                        
                                        <div class="box-remover box-remover-logo">
                                            <a href="javascript:;" class="btn_remover_upl">Remover logo</a> 
                                            <a href="javascript:;" class="btn_pergunta_remover_upl d-none">Remover logo ?</a> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> 
                        <div class="container_upl_load box-doc text-center d-none">
                            <label><i class='fa fa-circle-o-notch fa-spin'></i></label>
                        </div>
                        <div class="container_upl container_upl_input custom-file  <?php echo $empreendimento->emp_logo != "" ? "d-none" : ""; ?>">
                            <form action="" class="formAtualizaempreendimento">
                                <input type="file" name="emp_logo" class="custom-file-input" id="emp_logo" data-value="<?php echo $empreendimento->emp_logo; ?>" >
                            </form>
                            <label class="custom-file-label label-img-input" for="customFile">
                                <div class="box-ico-text">
                                    <div class="ico">
                                        <i class="material-icons">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                                <path d="M0 0h24v24H0z" fill="none"/>
                                            </svg>
                                        </i>
                                    </div>
                                    <div class="text">
                                        <div class="txt">
                                        <i class="material-icons">
                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                            </svg>
                                        </i>
                                        <span>Adicionar logo</span>
                                        </div>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>
                <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                <script id="template-download" type="text/x-tmpl"> </script>
                <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                <div class="col-md-8">
                    <form action="" class="formAtualizaempreendimento">
                        <div class="form-group">
                            <label for="emp_razao_social">Razão Social</label>
                            <input type="text" name="emp_razao_social" class="form-control" id="emp_razao_social" value="<?php e($empreendimento->emp_razao_social) ?>">
                        </div>
                         <div class="form-group">
                            <label for="emp_nome_fantasia">Nome fantasia</label>
                            <input type="text" name="emp_nome_fantasia" class="form-control" id="emp_nome_fantasia" value="<?php e($empreendimento->emp_nome_fantasia) ?>">
                        </div>
                        <div class="form-group">
                            <label for="emp_cnpj">CNPJ</label>
                            <input type="text" name="emp_cnpj" class="form-control cnpjMask" id="emp_cnpj" value="<?php e($empreendimento->emp_cnpj) ?>">
                        </div>
                        <div class="form-group">
                            <label for="emp_telefone">Telefone</label>
                            <input type="tel" name="emp_telefone" class="form-control telefoneMask" id="emp_telefone" value="<?php e($empreendimento->emp_telefone) ?>">
                        </div>
                        <div class="form-group">
                            <label for="emp_email">E-mail</label>
                            <input type="email" name="emp_email" class="form-control" id="emp_email" value="<?php e($empreendimento->emp_email) ?>">
                        </div>
                        <div class="msgAtualizaempreendimento"></div>
                        <div class="form-group text-right mt-4 mb-0">
                            <button type="button" class="btn btn-success btnAtualizaempreendimento"><i class="fa fa-check"></i> Salvar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--Endereço-->
<div class="tab-pane fade" id="enderecoEmpreendimento" role="tabpanel" aria-labelledby="enderecoEmpreendimento-tab">
    <div class="card">
        <div class="card-header">Endereço</div>
        <div class="card-body">
            <div class="row">
                <div class="col-lg-5">
                    <form action="" class="formAtualizaempreendimento">
                        <div class="form-group">
                            <label for="cep">CEP*</label>
                            <input type="text" name="cep" class="form-control cep cepMask" id="cep" value="<?php e($empreendimento->cep) ?>">
                            <span class="info-cep"></span>
                        </div>
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label for="endereco">Endereço*</label>
                                    <input type="text" name="endereco" class="form-control" for="endereco" value="<?php e($empreendimento->endereco) ?>">
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-3">
                                <div class="form-group">
                                    <label for="numero">Número*</label>
                                    <input type="text" name="numero" class="form-control" id="numero" value="<?php e($empreendimento->numero) ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="complemento">Complemento*</label>
                                    <input type="text" name="complemento" class="form-control" id="complemento" value="<?php e($empreendimento->complemento) ?>">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="bairro">Bairro*</label>
                                    <input type="text" name="bairro" class="form-control" id="bairro" value="<?php e($empreendimento->bairro) ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="cidade">Cidade*</label>
                                    <input type="text" name="cidade" class="form-control" id="cidade" value="<?php e($empreendimento->cidade) ?>">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="estado">Estado*</label>
                                    <input type="text" name="estado" class="form-control" id="estado" value="<?php e($empreendimento->estado) ?>">
                                </div>
                            </div>
                        </div>
                        <div class="msgAtualizaempreendimento"></div>
                        <div class="form-group text-right mt-4 mb-0">
                            <button type="button" class="btn btn-success btnAtualizaempreendimento"><i class="fa fa-check"></i> Salvar</button>
                        </div>
                        
                    </form>
                </div>
                <div class="col-lg-5 offset-lg-1">
                    <form action="" class="formAtualizaempreendimento">
                    <div class="form-group m-0">
                        <input type="hidden" id="longitude" name="longitude" value="<?php e($empreendimento->longitude??""); ?>" >
                        <input type="hidden" id="latitude" name="latitude" value="<?php e($empreendimento->latitude??""); ?>" >
                        <input type="hidden" name="bairro_lat" value="<?php e($empreendimento->bairro_lat??""); ?>" >
                        <input type="hidden" name="bairro_long" value="<?php e($empreendimento->bairro_long??""); ?>" >
                        <input type="hidden" name="quadra_lat" value="<?php e($empreendimento->quadra_lat??""); ?>" >
                        <input type="hidden" name="quadra_long" value="<?php e($empreendimento->quadra_long??""); ?>" >
                        <input type="hidden" name="conjunto_lat" value="<?php e($empreendimento->conjunto_lat??""); ?>" >
                        <input type="hidden" name="conjunto_long" value="<?php e($empreendimento->conjunto_long??""); ?>" >
                        
                        <input type="hidden" class="confirma_local" name="confirma_local" value="true" >
                        
                        <input type="hidden" id="pac-input" class="controls" type="text" placeholder="">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="container-maps">
                                    <div id="map"></div>
                                    <div class="d-none">
                                        <div class="popup-confirmacao" id="popup-confirmacao">
                                            <div class="txt">O Pin está na localização correta?</div>
                                            <div class="row no-margin">
                                                <div class="col-lg-6">
                                                    <button type="button" class="btn btn-primary confirmar-localizacao" >Confirmar</button>
                                                </div>
                                                <div class="col-lg-6">
                                                    <button type="button" class="btn btn-danger cancelar-localizacao" >Cancelar</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="container-info-mapa bg-green">
                                   Indique a localização de seu imóvel.
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--Responsável-->
<div class="tab-pane fade" id="responsavelEmpreendimento" role="tabpanel" aria-labelledby="responsavelEmpreendimento-tab">
    <div class="card">
        <div class="card-header">Responsável</div>
        <div class="card-body">
            
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-0">
                        <label for="responsavel">Foto</label>
                    </div>
                    
                    <div id="div_res_foto" class="form-group align-box-img mt-10">
                        <div class="container_upl container_upl_img custom-file  <?php e($empreendimento->res_foto != "" ? "" : "d-none"); ?>">
                            <div class="box-doc div_img_background" <?php if ($empreendimento->res_foto != ""){ ?> style="background-image: url('<?php e($empreendimento->res_foto); ?>');" <?php } ?>></div>
                            <div class="box-ico-text">
                                <div class="text">
                                    <div class="txt">
                                        <i class="material-icons">
                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                            </svg>
                                        </i>
                                        
                                        <div class="box-remover box-remover-logo">
                                            <a href="javascript:;" class="btn_remover_upl">Remover logo</a> 
                                            <a href="javascript:;" class="btn_pergunta_remover_upl d-none">Remover logo ?</a> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> 
                        <div class="container_upl_load box-doc text-center d-none">
                            <label><i class='fa fa-circle-o-notch fa-spin'></i></label>
                        </div>
                        <div class="container_upl container_upl_input custom-file  <?php echo $empreendimento->res_foto != "" ? "d-none" : ""; ?>">
                            <form action="" class="formAtualizaempreendimento">
                                <input type="file" name="res_foto" class="custom-file-input" id="res_foto" data-value="<?php echo $empreendimento->res_foto; ?>" >
                            </form>
                            <label class="custom-file-label label-img-input" for="customFile">
                                <div class="box-ico-text">
                                    <div class="ico">
                                        <i class="material-icons">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                                <path d="M0 0h24v24H0z" fill="none"/>
                                            </svg>
                                        </i>
                                    </div>
                                    <div class="text">
                                        <div class="txt">
                                        <i class="material-icons">
                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                            </svg>
                                        </i>
                                        <span>Adicionar foto</span>
                                        </div>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>
               
                <div class="col-md-8">
                    <form action="" class="formAtualizaempreendimento">
                    <div class="form-group">
                        <label for="res_nome">Nome</label>
                        <input type="text" name="res_nome" class="form-control" id="res_nome" value="<?php e($empreendimento->res_nome) ?>">
                    </div>
                    <div class="form-group">
                        <label for="res_telefone">Telefone</label>
                        <input type="tel" name="res_telefone" class="form-control telefoneMask" id="res_telefone" value="<?php e($empreendimento->res_telefone) ?>">
                    </div>
                    <div class="form-group">
                        <label for="res_email">E-mail</label>
                        <input type="email" name="res_email" class="form-control" id="res_email" value="<?php e($empreendimento->res_email) ?>">
                    </div>
                    <div class="form-group">
                        <label for="res_data_nascimento">Data de nascimento</label>
                        <input type="text" name="res_data_nascimento" class="form-control dataMask" id="res_data_nascimento" value="<?php e(date("d/m/Y", strtotime($empreendimento->res_data_nascimento))); ?>">
                    </div>
                    <div class="form-group">
                        <label for="res_genero">Gênero</label>
                        <select class="form-control" id="res_genero" name="res_genero">
                            <option value="">Selecione</option>
                            <option value="Masculino" <?php e(isset($empreendimento->res_genero) && ($empreendimento->res_genero == "Masculino") ? "selected":""); ?>>Masculino</option>
                            <option value="Feminino" <?php e(isset($empreendimento->res_genero) && ($empreendimento->res_genero == "Feminino") ? "selected":""); ?>>Feminino</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="res_cpf">CPF</label>
                        <input type="text" name="res_cpf" class="form-control cpfMask" id="res_cpf" value="<?php e($empreendimento->res_cpf) ?>">
                    </div>
                    <div class="msgAtualizaempreendimento"></div>
                    <div class="form-group text-right mt-4 mb-0">
                        <button type="button" class="btn btn-success btnAtualizaempreendimento"><i class="fa fa-check"></i> Salvar</button>
                    </div>
                    </form>
                </div>
                
            </div>
        </div>
    </div>
</div>

<!--Parceiro-->
<div class="tab-pane fade" id="parceiro" role="tabpanel" aria-labelledby="parceiro-tab">
    <div class="card">
        <div class="card-header">Parceiro: House/Imobiliária</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <form action="" class="formAtualizaParEmp" method="post">
                    <div class="form-group">
                    	<label for="parceiro-add">Parceiros</label>
                    	<select name="parceiros[]" class="form-control basic-multiple" id="id_parceiro-add" multiple="multiple" required="required">
                    		<option value="Todos">Todos</option>
                    		<?php foreach ($parceiros as $key => $par){
                    			e("<option value='[$par->id_parceiro,$par->id_incorporadora]' $par->selected > $par->incorporadora - $par->par_razao_social</option>");
                    		} ?>
                    	</select>
                    </div>
                    <div class="msgAtualizaParEmp"></div>
                    <div class="form-group text-right mt-4 mb-0">
                        <button type="submit" class="btn btn-success btnAtualizaParEmp"><i class="fa fa-check"></i> Salvar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>