<div class="animated fadeIn page-incorporadora">
    
    <input class="incorporadora" type="hidden" data-incorporadora='<?php e(json_encode($incorporadora)); ?>'>
    
    <div class="row">
        <div class="col-md-6 col-lg-4">
            <div class="card">
                <div class="card-header">Incorporadora</div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="div_logo" class="form-group align-box-img mt-10">
                                <div class="container_upl container_upl_img custom-file  <?php e($incorporadora->logo != "" ? "" : "d-none"); ?>">
                                    <div class="box-doc div_img_background" <?php if ($incorporadora->logo != ""){ ?> style="background-image: url('<?php e($incorporadora->logo); ?>');" <?php } ?>></div>
                                    <div class="box-ico-text">
                                        <div class="text">
                                            <div class="txt">
                                                <i class="material-icons">
                                                   <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                       <path fill="none" d="M0 0h24v24H0V0z"/>
                                                       <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                                    </svg>
                                                </i>
                                                
                                                <div class="box-remover box-remover-logo">
                                                    <a href="javascript:;" class="btn_remover_upl">Remover logo</a> 
                                                    <a href="javascript:;" class="btn_pergunta_remover_upl d-none">Remover logo ?</a> 
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> 
                                <div class="container_upl_load box-doc text-center d-none">
                                    <label><i class='fa fa-circle-o-notch fa-spin'></i></label>
                                </div>
                                <div class="container_upl container_upl_input custom-file  <?php echo $incorporadora->logo != "" ? "d-none" : ""; ?>">
                                    <form action="" class="formAtualizaIncorporadora">
                                        <input type="file" name="logo" class="custom-file-input" id="logo" data-value="<?php echo $incorporadora->logo; ?>" >
                                    </form>
                                    
                                    <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                                    <script id="template-download" type="text/x-tmpl"> </script>
                                    <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                                    
                                    <label class="custom-file-label label-img-input" for="customFile">
                                        <div class="box-ico-text">
                                            <div class="ico">
                                                <i class="material-icons">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                        <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                                        <path d="M0 0h24v24H0z" fill="none"/>
                                                    </svg>
                                                </i>
                                            </div>
                                            <div class="text">
                                                <div class="txt">
                                                <i class="material-icons">
                                                   <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                       <path fill="none" d="M0 0h24v24H0V0z"/>
                                                       <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                                    </svg>
                                                </i>
                                                <span>Adicionar logo</span>
                                                </div>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <ul>
                                <li><strong>Incorporadora:</strong> <?php e($incorporadora->incorporadora) ?></li>
                                <li><strong>Razão social: </strong> <?php e($incorporadora->razao_social) ?></li>
                                <li><strong>CNPJ:         </strong> <?php e($incorporadora->cnpj) ?></li>
                                <li><strong>Responsável:  </strong> <?php e($incorporadora->responsavel) ?></li>
                                <li><strong>E-mail:       </strong> <?php e($incorporadora->email) ?></li>
                                <li><strong>Senha:        </strong> <?php e($incorporadora->senha) ?></li>
                                <li><strong>Telefone:     </strong> <?php e($incorporadora->telefone) ?></li>
                                <li><strong>CPF:          </strong> <?php e($incorporadora->cpf) ?></li>
                            </ul>
                            <div class="form-group mt-4">
                                <button class="btn btn-success" type="button" data-toggle="modal" data-target="#atualizarIncorporadora"><i class="fa fa-repeat"></i> &nbsp; Atualizar dados</button></li>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-8">
            <div class="card">
                <div class="card-header">
                    <a href="#" data-toggle="collapse" data-target="#collapseEmpreendimentos" aria-expanded="true">Empreendimentos</a>
                    <div class="card-header-actions">
                        <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseEmpreendimentos" aria-expanded="true">
                            <i class="icon-arrow-up"></i>
                        </a>
                    </div>
                </div>
                <div class="collapse show" id="collapseEmpreendimentos" style="">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12 text-right mb-3">
                            <button class="btn btn-success" type="button" data-toggle="modal" data-target="#addEmpreendimento"><i class="fa fa-plus"></i> &nbsp; Adicionar empreendimento</button>
                        </div>
                    </div>
                    <div class="row">
                        <?php if (empty($empreendimentos)){ ?>
                            <!--Vazio-->
                        <?php } else { foreach (array_reverse($empreendimentos) as $key => $emp){ ?>
                        
                            <?php if($emp->status_empreendimento == 0){ ?>
                            <div class="col-lg-4">
                                <div class="container-info">
                                    <div class="box-img d-flex align-items-center justify-content-center">
                                        <?php if($emp->emp_logo != ""){ ?>
                                        <img src="<?php e($emp->emp_logo) ?>" class="img-fluid">
                                        <?php } else { ?>
                                        <img src="<?php e(base_url("themes/comdono/img/no-image.png")); ?>" class="img-fluid">
                                        <?php } ?>
                                    </div>
                                    <div class="box-text">
                                        <ul>
                                            <li><strong>Chave:</strong> <?php e($emp->uuid_empreendimento) ?></li>
                                            <li><strong>Empreendimento:</strong> <?php e($emp->emp_razao_social) ?></li>
                                            <li><strong>Responsável:</strong> <?php e($emp->res_nome) ?></li>
                                            <li><strong>Data de cadastro:</strong> <?php e(date("d/m/Y", strtotime($emp->emp_data_cadastro))); ?></li>
                                            <li><strong>Status da proposta: </strong> <span class="badge badge-<?php e($emp->pro_status_badge) ?>"><?php e($emp->pro_status) ?></span></li>
                                            
                                            <?php 
                                                $apelido = str_word_count($emp->emp_razao_social, 1);
                                                $apelido = strtolower($apelido[0]);
                                            ?>
                                            
                                            <?php if($emp->pro_status == "Aguardando envio"){ ?>
                                            <li>
                                                <a href="javascript:;" class="btn btn-primary btn-sm btnEnviarAcesso mt-1" data-empreendimento ='<?php e(json_encode($emp)); ?>' data-incorporadora='<?php e(json_encode($incorporadora)); ?>' data-pro_data_envio="<?php e(date("Y-m-d H:i:s")); ?>"> 
                                                    <i class="fa fa-share" aria-hidden="true"></i> Enviar link de acesso
                                                </a>
                                            </li>
                                            <?php } ?>
                                            
                                            <?php if($emp->pro_status == "Enviada"){ ?>
                                            <li><strong>Data envio proposta: </strong> <?php e(date("d/m/Y", strtotime($emp->pro_data_envio))); ?></li>
                                            <li>
                                                <a href="javascript:;" class="btn btn-ghost-primary btn-primary btn-sm btnEnviarAcesso mt-1" data-empreendimento ='<?php e(json_encode($emp)); ?>' data-incorporadora='<?php e(json_encode($incorporadora)); ?>'> 
                                                    <i class="fa fa-share" aria-hidden="true"></i> Reenviar link de acesso
                                                </a>
                                            </li>
                                            <?php } ?>
                                            
                                            <?php if($emp->contrato == 1 && $emp->con_status != "Assinado"){ ?>
                                            <li><strong>Status do contrato:</strong> <?php e($emp->con_status); ?></li>
                                            <li><strong>Contrato gerado em:</strong> <?php e(date("d/m/Y", strtotime($emp->con_data))); ?></li>
                                            <?php } ?>
                                            
                                            <?php if($emp->con_status == "Assinado"){ ?>
                                            <li><strong>Data assinatura contrato: </strong> <?php e(date("d/m/Y", strtotime($emp->con_data_assinatura))); ?></li>
                                            <!--<li><strong>Plano: </strong> <?php e($planos->plano); ?></li>-->
                                            <!--<li><strong>Contrato:</strong> <a class="" href="#"><i class="fa fa-cloud-download" aria-hidden="true"></i> Download</a></li>-->
                                           <!-- <li><strong>Serviço:</strong> (Opção 1) - Tecnologia Comdono</li>-->
                                            <?php } ?>
                                            
                                            <?php if($emp->id_imovel != 0){ ?>
                                            <a href="<?php e(base_url("lancamento/").$emp->id_imovel); ?>" class="badge badge-primary" type="button" target="_blank">
                                                <i class="fa fa-eye"></i> Visualizar LP
                                            </a>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                    
                                    <div class="box-icons">
                                        <div class="row">
                                            <div class="col text-center" title="Editar empreendimento">
                                                <a href="<?php e(base_url("administrativo/incorporadora/empreendimento/".$emp->id_empreendimento)); ?>" class="btn btn-primary">
                                                    <i class="fa fa-gears" aria-hidden="true"></i>&nbsp;Admin empreendimento
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                        <?php } }?>
                    </div>
                </div>
                </div>
            </div>
            
            <?php if (!empty($parceiros)){ ?>
            <div class="card mt-4">
                <div class="card-header">
                    Parceiros - Houses/Imobiliárias
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col text-right mb-4">
                            <a href="#" class="btn btn-success" role="button" data-toggle="collapse" data-target="#collapseParceiros" aria-expanded="false">
                                <i class="fa fa-plus"></i>&nbsp;Adicionar parceiro
                            </a>
                        </div>
                    </div>
                    <div class="collapse" id="collapseParceiros">
                    <div class="table-container table-responsive">
                        <table class="display table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Logo</th>
                                    <th>Razão Social</th>
                                    <th>Tipo parceiro</th>
                                    <th>Tipo atendimento</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach (array_reverse($parceiros) as $key => $par){ ?>
                                <tr class="trData">
                                    <td>
                                        <div class="avatar d-block m-auto">
                                        <?php if($par->par_logo != ""){ ?>
                                        <img src="<?php e($par->par_logo) ?>" class="img-avatar">
                                        <?php } else { ?>
                                        <img src="<?php e(base_url("themes/comdono/img/no-image.png")); ?>" class="img-avatar">
                                        <?php } ?>
                                        </div>
                                    </td>
                                    <td><?php e($par->par_razao_social) ?></td>
                                    <td><?php e($par->tipo_parceiro == 1?"House":"Imobiliária") ?></td>
                                    <td><?php e($par->tipo_atendimento == 1?"Painel CS":"Painel Incorporadora") ?></td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-primary btn-sm btnListAddParceiro" title="clique para adicionar um parceiro">
                                            <i class="icon-plus"></i>
                                        </button>
                                        <button type="button" class="btn btn-success btn-sm actListAddParceiro d-none" data-id_parceiro="<?php e($par->id_parceiro) ?>">Adicionar?</button>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>    
                    </div>
                    <?php if (!empty($meusParceiros)){ ?>
                    <div class="box-title-section my-4">
                        <h5 class="text-primary">Parceiros desta incorporadora</h5>
                        <hr>
                    </div>
                    <?php } ?>
                    
                    <div class="row">
                        <?php if (empty($meusParceiros)){ ?>
                            <!--Vazio-->
                        <?php } else { foreach ($meusParceiros as $key => $par){ ?>
                            <div class="col-lg-4">
                                <div class="container-info">
                                    <div class="box-img d-flex align-items-center justify-content-center">
                                        <?php if($par->par_logo != ""){ ?>
                                        <img src="<?php e($par->par_logo) ?>" class="img-fluid">
                                        <?php } else { ?>
                                        <img src="<?php e(base_url("themes/comdono/img/no-image.png")); ?>" class="img-fluid">
                                        <?php } ?>
                                    </div>
                                    <div class="box-text">
                                        <ul>
                                            <li><strong>Razão social: </strong> <?php e($par->par_razao_social) ?></li>
                                            <li><strong>Telefone:     </strong> <?php e($par->par_telefone) ?></li>
                                            <li><strong>Tipo atendimento:     </strong> <?php e($par->tipo_atendimento == 1?"Painel CS":"Painel Incorporadora") ?></li>
                                            <li><strong>Tipo parceria:     </strong> <?php e($par->tipo_parceiro == 1?"House":"Imobiliária") ?></li>
                                            <li><strong>Cadastro:</strong> <?php e(date("d/m/Y", strtotime($par->par_cadastro))); ?></li>
                                            <li>
                                                <strong>Empreendimentos:</strong> 
                                                <?php if(isset($par_rel_empreendimentos) && $par_rel_empreendimentos != 0){ foreach($par_rel_empreendimentos as $par_emp){ ?>
                                                <a href="<?php e(base_url("administrativo/incorporadora/empreendimento/").$par_emp->id_empreendimento); ?>" class="badge badge-primary" role="button" target="_blank">
                                                    <i class="fa fa-eye"></i> <?php e($par_emp->emp_razao_social); ?>
                                                </a>
                                                <?php }} ?>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="box-icons">
                                        <div class="row">
                                            <div class="col text-center">
                                                <a href="<?php e(base_url("administrativo/Incorporadora/parceiros"))?>" class="btn btn-primary">
                                                    <i class="fa fa-gears" aria-hidden="true"></i>&nbsp;Admin parceiros
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } }?>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>

<div class="modal fade" id="addEmpreendimento" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-primary" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Adicionar empreendimento</h4>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="formAddEmpreendimento" action="" method="post" class="formAddEmpreendimento">
                <div class="modal-body">
                    <div class="form-group mt-2">
                        <h5>Dados da Proposta</h5>
                        <hr>
                    </div>
                    
                    <select class="form-control" id="id_proposta" name="id_proposta" required="required">
                        <option value="">Selecione</option>
                        <?php foreach($propostas as $proposta){ ?>
                        <option value="<?php e($proposta->id_proposta) ?>"><?php e("id".$proposta->id_proposta." - ".$proposta->tipo_proposta." - planos ".$proposta->planos_rel) ?></option>
                        <?php } ?>
                    </select>
                    
                    
                    <div class="form-group mt-2">
                        <h5>Dados do empreendimento</h5>
                        <hr>
                    </div>
                    
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="emp_razao_social">Razão Social*</label>
                                <input type="text" name="emp_razao_social" class="form-control" id="emp_razao_social" value="" required="required">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="emp_nome_fantasia">Nome Fantasia*</label>
                                <input type="text" name="emp_nome_fantasia" class="form-control" id="emp_nome_fantasia" value="" required="required">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="emp_cnpj">CNPJ</label>
                        <input type="text" name="emp_cnpj" class="form-control cnpjMask" id="emp_cnpj" value="">
                    </div>
                   
                    
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="emp_email">E-mail</label>
                                <input type="email" name="emp_email" class="form-control" id="emp_email" value="">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="emp_telefone">Telefone</label>
                                <input type="text" name="emp_telefone" class="form-control telefoneMask" id="emp_telefone" value="">
                            </div>
                        </div>
                    </div>
                    <div class="form-group mt-2">
                        <h5>Dados do responsável</h5>
                        <hr>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="res_nome">Nome*</label>
                                <input type="text" name="res_nome" class="form-control" id="res_nome" value="<?php e($incorporadora->responsavel) ?>" required="required">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="res_email">E-mail*</label>
                                <input type="email" name="res_email" class="form-control" id="res_email" value="<?php e($incorporadora->email) ?>" required="required">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="res_telefone">Telefone*</label>
                                <input type="tel" name="res_telefone" class="form-control telefoneMask" id="res_telefone" value="<?php e($incorporadora->telefone); ?>" required="required">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="res_cpf">CPF</label>
                                <input type="text" name="res_cpf" class="form-control cpfMask" id="res_cpf" value="<?php e($incorporadora->cpf) ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="res_genero">Gênero</label>
                                <select class="form-control" id="res_genero" name="res_genero">
                                    <option value="">Selecione</option>
                                    <option value="Masculino" <?php e(isset($incorporadora->genero) && ($incorporadora->genero == "Masculino") ? "selected":""); ?>>Masculino</option>
                                    <option value="Feminino" <?php e(isset($incorporadora->genero) && ($incorporadora->genero == "Feminino") ? "selected":""); ?>>Feminino</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="res_data_nascimento">Data de nascimento</label>
                                <?php if($incorporadora->data_nascimento !== "0000-00-00"){ $dataNascimento = date("d/m/Y", strtotime($incorporadora->data_nascimento)); } else {$dataNascimento = "";}?>
                                <input type="text" name="res_data_nascimento" class="form-control dataMask" id="res_data_nascimento" value="<?php e($dataNascimento); ?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success btnAddEmpreendimento" type="submit" >Adicionar</button>
                    <button class="btn btn-outline-danger" type="button" data-dismiss="modal">Fechar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="atualizarIncorporadora" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-primary" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Atualizar dados da incorporadora</h4>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <form action="" class="formAtualizaIncorporadora">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="nomeIncprporadora">Incorporadora</label>
                                    <input type="text" name="incorporadora" class="form-control" id="nomeIncprporadora" value="<?php e($incorporadora->incorporadora) ?>">
                                </div>
                            </div>
                            
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="razao_social">Razão Social</label>
                                    <input type="text" name="razao_social" class="form-control" id="razao_social" value="<?php e($incorporadora->razao_social) ?>">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="responsavel">Responsável</label>
                                    <input type="text" name="responsavel" class="form-control" id="responsavel" value="<?php e($incorporadora->responsavel) ?>">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="email">E-mail</label>
                                    <input type="email" name="email" class="form-control" id="email" value="<?php e($incorporadora->email) ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="telefone">Telefone</label>
                                    <input type="tel" name="telefone" class="form-control telefoneMask" id="telefone" value="<?php e($incorporadora->telefone); ?>">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="cpf">CPF</label>
                                    <input type="text" name="cpf" class="form-control cpfMask" id="cpf" value="<?php e($incorporadora->cpf) ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="genero">Gênero</label>
                                    <select class="form-control" id="genero" name="genero">
                                        <option value="">Selecione</option>
                                        <option value="Masculino" <?php e(isset($incorporadora->genero) && ($incorporadora->genero == "Masculino") ? "selected":""); ?>>Masculino</option>
                                        <option value="Feminino" <?php e(isset($incorporadora->genero) && ($incorporadora->genero == "Feminino") ? "selected":""); ?>>Feminino</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="data_nascimento">Data de nascimento</label>
                                    <input type="text" name="data_nascimento" class="form-control dataMask" id="data_nascimento" value="<?php e(date("d/m/Y", strtotime($incorporadora->data_nascimento))); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="cnpj">CNPJ</label>
                                    <input type="text" name="cnpj" class="form-control cnpjMask" id="cnpj" value="<?php e($incorporadora->cnpj) ?>">
                                </div>
                            </div>
                        </div>
                        <div class="form-group mt-2">
                            <h5>Dados para a Página de Captura</h5>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="lpconfig_titulo">Título</label>
                                    <input type="text" name="lpconfig_titulo" class="form-control" id="lpconfig_titulo" value="<?php e($incorporadora->lpconfig_titulo) ?>">
                                </div>
                                <div class="form-group">
                                    <label for="lpconfig_descricao">Descrição</label>
                                    <textarea name="lpconfig_descricao" class="form-control" id="lpconfig_descricao" rows="3"><?php e($incorporadora->lpconfig_descricao) ?></textarea>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="erroAtualizaIncorporadora"></div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-success btnAtualizaIncorporadora" type="button">Atualizar</button>
                <button class="btn btn-outline-danger" type="button" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
<!-- /.fim -->