<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Atendimento extends Grocery {

    function __construct() 
    {
        parent::__construct();
        //$this->load->model('comdono/cad_model');
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		$this->load->model('minha_conta/conta_model');
		
		Assets::add_module_js('comdono', array(
            'main'
        ));
    }
    
    function index()
    {
        $data['module'] = $module = Menu_lib::getModuleByNickname($this->module);
        $this->breadcrumb("<i class='nav-icon $module->icon'></i> $module->name");
        
        Template::set($data);
        Template::set_view('atendimento/dashboard_module_view');
        Template::render();
    }
    
    function atendimento_geral() 
    {
        
	    $this->ini_method('incorporadoras');
	    $data['tipo_interesse']  = $this->uri->segment(4);
		$data['id_atendimento'] = $id_atendimento  = $this->uri->segment(5);
		$data['atendimentoInicial'] = $this->admin_model->getAtendimento([['id_atendimento',$id_atendimento]]);
	
		$this->setObjetoAtendido($data);
		$this->setCasdastro($data);
		$this->setOutrosAtentimentos($data);
		$this->setInteressado($data);
		
		
		if($data['atendimentoInicial']->tb_origem == 'cad_captura' && $this->verificaSeEmpreendimento($data['tipo_interesse'])){
			$data['boxAgendamento'] = true;
			
			$captura = $data['objetoAtendido'];
			
			$parceiro = $this->admin_model->getParceiro(['id_parceiro',$captura->id_parceiro]);
			if($parceiro != null)
			{
			    if($parceiro->tipo_atendimento == 1){
			        //$data['boxAgendamento'] = false;
			    }
			}
			
			$data['empreendimento'] = $empreendimento = $this->admin_model->getEmpreendimento(['uuid_empreendimento', $data['tipo_interesse']]);
			$incorporadora = $this->admin_model->getIncorporadora(['id_incorporadora', $empreendimento->id_incorporadora]);
            $data['id_participantes'] = $incorporadora->id_responsavel;
            $data['id_destino'] = $empreendimento->id_empreendimento??0;
            
            //planos e propostas
            $data['proposta'] = $proposta = $this->cad_model->getProposta(['id_proposta',$empreendimento->id_proposta]);
            $planos_rel = json_decode($proposta->planos_rel);
            $planos = [];
            foreach ($planos_rel as $id_plano)
            {
                $planos[] = $this->cad_model->getPlano(['id_plano',$id_plano]);
            }
            $data['planos'] = $planos;
            
            //dd($data['planos']);
            //dd($data['proposta']);
		}
		
		$data['atendimentos'] = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_atendimento]]);
		foreach($data['atendimentos'] as $atend)
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
    	
		//e($this->db->last_query()); die();
    	
		$data['id_user'] = $this->session->id_cadastro;
		
		
		//Pega os interesses para a lista de interesses
		$interesses = $this->cad_model->getInteresses(['id_captura', $data['objetoAtendido']->id_captura]);
		$hist_interesses=[];
        foreach($interesses as $inter){
            if($inter != []){
                $inter->bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $inter->id_interesse]]);
                $inter->tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $inter->id_interesse]]);
                $hist_interesses[] = $inter;
            }
        }
        $data['interesses']=$hist_interesses;
        
		Assets::add_css(array(
            '../comdono/plugins/datetimepicker/css/bootstrap-datetimepicker.min',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/datetimepicker/js/moment',
            '../comdono/plugins/datetimepicker/js/bootstrap-datetimepicker.min',
            '../comdono/plugins/datetimepicker/js/locale',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
        ));
		
        Assets::add_module_js('atendimento', array(
            'atendimento',
            'date_time',
            'atendimento_geral',
        ));
        
		Template::set($data);
        Template::set_view('atendimento/atendimento_view');
        Template::render();
    }
    
    function verificaSeEmpreendimento($UUID)
    {
        $UUIDs = [];
        $empreendimentos = $this->admin_model->getEmpreendimentos();
        foreach ($empreendimentos  as $empreendimento)
            $UUIDs[] =  $empreendimento->uuid_empreendimento;
        return in_array($UUID, $UUIDs);   
    }
    
    function interesses(){
        try{			
			$this->ini_method();
			/* This is only for the autocompletion */
			$crud = new grocery_CRUD();
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$crud->unset_jquery();
			
            $crud->set_model('interesse_crud_model');
            
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_interesse');
			$crud->set_subject('Interesses');
            /*$crud->where('ativo',1);
            $crud->where('interesse_painel_cs',0);*/
            
			if($state != 'list')
			{
                $crud->set_relation('id_captura','cad_captura','nome');
			}
            //$crud->set_relation('id_interesse','cad_interesse_bairros','bairro');
            
            
            $crud->callback_column('bairros',array($this,'_callback_get_bairros'));
            $crud->callback_column('faixa_preco',array($this,'_callback_get_faixa_preco'));
            $crud->callback_column('tipo_emp_cliente',array($this,'_callback_get_tipo_emp'));
            
            
            //$crud->set_rules('bairros','Bairros','required');
            $crud->set_rules('telefone','Telefone','required');
            $crud->set_rules('nome','Nome','required');
            
            $crud->display_as('id_captura','Nome');
            $crud->display_as('tipo_interesse','Tipo de Interesse');
            $crud->display_as('momento_interesse','Qual o momento do cliente');
            $crud->display_as('tipo_emp_cliente','Tipo de empreendimento do cliente');
            $crud->display_as('faixa_preco','Faixa de Preço');
            $crud->display_as('tipo_imovel','Tipo de Imovel');
            $crud->display_as('datetimeinteresse','Data Hora do Interesse');
            $crud->display_as('faixa_preco_inicio','Faixa de Preço inicial');
            $crud->display_as('faixa_preco_fim','Faixa de Preço final');
            
            $crud->add_fields(array('nome','cpf','tipo_interesse','tipo_imovel','momento_interesse','tipo_emp_cliente','bairros','faixa_preco_inicial','faixa_preco_final','quartos','banheiro','vagas','possui_imovel','descricao'));
            
            $crud->field_type('quartos','enum',array('0','1','2','3', '4 ou +'));
            $crud->field_type('banheiro','enum',array('0','1','2','3', '4 ou +'));
            $crud->field_type('vagas','enum',array('0','1','2','3', '4 ou +'));
            
            $bairros_helper = HBairros::getSelect2()->items;
            
            $select = [];
            $select['Brasília'] = 'Brasília';
            foreach($bairros_helper as $bairro){
                
                $select[$bairro->id] = $bairro->id;
                
            }
            
            $crud->field_type('tipo_emp_cliente','multiselect', array('pronto'=>'Pronto','lancamento'=>'Lançamento','Terreno'=>'Terreno'));
            $crud->field_type('bairros','multiselect', $select);
            
            //$crud->order_by('id_interesse','desc');
            
            $crud->field_type('possui_imovel','true_false',['Não','Sim']);
            
            $crud->unset_edit();
            $crud->unset_read();
            //$crud->unset_delete();
            
            $crud->callback_delete(array($this,'delete_interesse'));
            
            $crud->callback_add_field('tipo_imovel',function () {
                return HBusca::getHtmlSelectTiposImovel();
            });
            $crud->field_type('momento_interesse','enum',array('Não sabe ou indeciso','Em Até um mes','Em Alguns Meses','Em Até 1 Ano','Apos 1 Ano'));
            
            $crud->columns('id_captura','bairros','tipo_emp_cliente','tipo_interesse','momento_interesse','faixa_preco','tipo_imovel','datetimeinteresse');
            
            $crud->callback_insert(array($this,'trata_campos_callback'));
            
            $crud->add_action('Anuncios','','atendimento/atendimento/visualizar_interesse','fa fa-home');
            
            Assets::add_module_js('atendimento', array('interesses'));
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    function cartaoVIP(){
        try{			
			$this->ini_method();
			/* This is only for the autocompletion */
			$crud = new grocery_CRUD();
			
			$crud->unset_jquery();

			$crud->set_theme('bootstrap');
			$crud->set_table('cad_captura');
			$crud->set_subject('Interesses');
            
            $crud->display_as('nome','Nome');
            $crud->display_as('cpf','Cpf');
            $crud->display_as('email','Email');
            $crud->display_as('telefone','Telefone');
            $crud->display_as('possui_conjuje','Possui_conjuge');
            $crud->display_as('origem_captura','Origem da captura');
            
            $crud->order_by('id_captura','desc');
            
            $crud->unset_edit();
            //$crud->unset_read();
            $crud->unset_delete();
            $crud->unset_add();
         
            
            $crud->columns('nome','cpf','email','telefone','possui_conjuje','origem_captura');
            
            
            //Assets::add_module_js('atendimento', array('interesses'));
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function delete_interesse($primary_key){
        return $this->db->update('cad_interesse',array('ativo' => '0'),array('id_interesse' => $primary_key));
    }
    
    function visualizar_interesse($id_interesse){
        
        $this->ini_method('interesses');
        
        $data_interesse = $this->cad_model->getInteresse([['id_interesse', $id_interesse]]);
        
        $data_bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $id_interesse]]);
        //dd($data_bairros);
        //dd($data);
        
        if($data_interesse->quartos == 4){
	        $quartos = 'quartos >=';
	    }
        else{
            $quartos = 'quartos';
        }	    
	    
	    if($data_interesse->banheiro == 4){
	        $banheiros = 'banheiros >=';
	    }
	    else{
	        $banheiros = 'banheiros';
	    }
	    
	    if($data_interesse->vagas == 4){
	        $vaga = 'vaga >=';
	    }
	    else{
	        $vaga = 'vaga';
	    }
        
        $imoveis = [];
        
        foreach($data_bairros as $b){
	        //dd($b);
    	    $where = array(
    	        'status' => 3,
    	        'id_imovel_rel' => 0,
                'tipo_imovel'  => $data_interesse->tipo_imovel,
                'bairro LIKE' => '%'.$b->bairro.'%',
                $quartos => $data_interesse->quartos,
                $banheiros => $data_interesse->banheiro,
                $vaga => $data_interesse->vagas, 
                'val_pretendido >=' => $data_interesse->faixa_preco_inicio,
                'val_pretendido <=' => $data_interesse->faixa_preco_fim,
            );
            
            foreach (array_keys($where) as $w){
                if(($where[$w] == '%%'|| $where[$w] == '' || $where[$w] == '0' || $where[$w] == '%Brasília%') && $w != 'id_imovel_rel'){
    		        unset($where[$w]);
    	        }
            }
            
	     
    	    $imoveis_selecionados = $this->cad_model->getImoveis($where);
    	    if(!empty($imoveis_selecionados)){
                    	        
                $imoveis = array_merge($imoveis,$imoveis_selecionados);
                
                foreach($imoveis as $im) { 
                    $im->val_pretendido = money($im->val_pretendido);
                    $imagens = $this->cad_model->getImgsImovel($im->id_imovel);
                    if(!empty($imagens)){
                        
                        $img = $imagens[0];
                    
                        $foto = $img->uri.$img->imagem;
                        if($img->uri == '' || $img->imagem == ''){
                            $foto = '';
                        }
                    }
                    else{
                        $foto = base_url('themes/comdono/img/no-image.png');
                    }
                    $im->foto = $foto;
                }
    	    }
    	    else{
    	        continue;
    	    }
            if($b->bairro == 'Brasília'){
                break;
            }
	    }
	    
	    if($imoveis != NULL || $imoveis != []){
	        $data['imoveis'] = $imoveis;
	    }else{
	        $data['imoveis'] = [];
	    }
	    
	    $data['captura'] = $this->cad_model->getCaptura([['id_captura',$data_interesse->id_captura]]);
	    $data['interesse'] = $data_interesse;
	    $data['interesse_bairros'] = $data_bairros;
	    
	    Assets::add_module_js('atendimento', array('atendimento_geral','interesses'));
	    
	    Template::set($data);
        Template::set_view('interesse_view');
        Template::render();
    }
    
    function trata_campos_callback($post_array){
        
        if($post_array['bairros'] != NULL){
            
            $w = [];
            
            if($post_array['nome'] != NULL){
                $w[] = ['nome LIKE', '%'.$post_array['nome'].'%'];
            }
            
            if($post_array['telefone'] != NULL){
                $w[] = ['telefone',$post_array['telefone']];
            }
            
            $cadastro = $this->cad_model->getCadastro($w);

            if(!empty($cadastro)){    
                $captura = [
                    'id_cadastro'      => $cadastro->id_cadastro, 
                    'nome'             => $cadastro->nome, 
                    'email'            => $cadastro->email, 
                    'telefone'         => $cadastro->telefone,
                    'origem_captura'   => 'formCadInteresseDash',
                    'datetime_captura' => date('Y-m-d h:i:s')
                    ];
                        
                $captura = $this->cad_model->insertCaptura($captura);
            }else{
                $captura = [
                    'nome'             => $post_array['nome'], 
                    'telefone'         => $post_array['telefone'],
                    'origem_captura'   => 'formCadInteresseDash',
                    'datetime_captura' => date('Y-m-d h:i:s')
                    ];
                    
                $captura = $this->cad_model->insertCaptura($captura);
            }
        
            if($captura > 0){
                
                unset($post_array['email']);
                
                $post_array['id_captura'] = $captura;
                
                $post_array['faixa_preco_inicio'] = $post_array['faixa_preco_inicial'];
                
                $post_array['faixa_preco_fim'] = $post_array['faixa_preco_final'];
                
                $id_interesse = $this->cad_model->insertInteresse($post_array);
                
                foreach($post_array['bairros'] as $bairro){
                    $dados_bairros = ['id_interesse' => $id_interesse, 'bairro' => $bairro];
                    
                    $this->cad_model->insertBairroInteresse($dados_bairros);
                }
                
                foreach($post_array['tipo_emp_cliente'] as $t){
                    $dados_tipo_emp = ['id_interesse' => $id_interesse, 'tipo_emp' => $t];
                    
                    $this->cad_model->insertTipoEmpInteresse($dados_tipo_emp);
                }
                
            }else{
                return false;
            }
        }else{
            return false;
        }
    }    
    
    function funcao_teste($bairro){
        dd($bairro);
    }
    
    function _callback_get_bairros($value, $row){
        $bairros = $this->cad_model->getBairrosInteresse([['id_interesse',$row->id_interesse]]);
        
        $td = '';
        foreach($bairros as $bairro){
            $td .= ' <span class="badge badge-secondary"> '.$bairro->bairro.' </span> ';
        }
        
        return $td;
    }
    
    function _callback_get_faixa_preco($value, $row){
        
        return money($row->faixa_preco_inicio).' a '.money($row->faixa_preco_fim);
    }
   
    function _callback_get_tipo_emp($value, $row){
        $tipos_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse',$row->id_interesse]]);
        
        $td = '';
        foreach($tipos_emp as $t){
            $td .= ' <span class="badge badge-secondary"> '.$t->tipo_emp.' </span> ';
        }
        
        return $td;
    }
    
    function _callback_faixa_preco($value, $row){
        return money($row->faixa_preco_inicio).' a '.money($row->faixa_preco_fim);
    }
    
    function setObjetoAtendido(&$data)
    {
        $AtendimentoInicial = $data['atendimentoInicial'];
        
        $tb_origem      = $AtendimentoInicial->tb_origem;
        $id_rel         = $AtendimentoInicial->id_rel;
		$primaryKeyName = $this->admin_model->getPrimaryKey($tb_origem);
		
		$data['objetoAtendido'] = $this->admin_model->getRow($tb_origem, [$primaryKeyName, $id_rel]);
		$data['objetoAtendido']->tb_origem = $tb_origem;
    }
    
    function setCasdastro(&$data)
    {
        $objetoAtendido = $data['objetoAtendido'];
        
        $cadastro = null;
		if(($objetoAtendido->id_cadastro??false))
		    $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$objetoAtendido->id_cadastro]);
		elseif(($objetoAtendido->id_cad_interessado??false))
		    $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$objetoAtendido->id_cad_interessado]);
		elseif(($objetoAtendido->email??false)){
		    $cadastro =  $this->admin_model->getCadastro(['email',$objetoAtendido->email]);
		    if($cadastro == null)
		    {
		       $id = $this->admin_model->insertCadastro((array)$objetoAtendido);
		      
		       if($data['atendimentoInicial']->tb_origem == 'cad_captura' && $objetoAtendido->id_cadastro == 0)
		            $this->admin_model->updateCaptura($objetoAtendido->id_captura,['id_cadastro' => $id]);
		       $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$id]);
		    }
		}
        $data['cadastro'] = $cadastro;
    }
    
    function setOutrosAtentimentos(&$data)
    {
        $id_atendimento = $data['id_atendimento'];
        $cadastro       = $data['cadastro'];
        $objetoAtendido = $data['objetoAtendido'];
        
        $email       = $cadastro->email??($objetoAtendido->email??null);
        $id_cadastro = $cadastro->id_cadastro??false;
		
		$outroAtendimentos = [];
		$data['capturas'] = $capturas = [];
		if($email??false){
		    $outroAtendimentos      = $this->admin_model->getAtendimentoHistorico([['email',$email],['a.id_atendimento !=',$id_atendimento]]);
		    $data['capturas']       = $capturas       = $this->admin_model->getCapturas(['email',$email]);
		    $atedimentosTemporarios = [];
		    foreach ($capturas as $cap)
		    {
		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','cad_captura'],['id_rel',$cap->id_captura]]);
		        if(!empty($result))
		            $atedimentosTemporarios[] = $result;
		    }
		    
		    $data['contatos']       = $contatos       = $this->admin_model->getContatos(['email',$email]);
            foreach ($contatos as $contato)
		    {
		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','cad_contato'],['id_rel',$contato->id]]);
		        if(!empty($result))
		            $atedimentosTemporarios[] = $result;
		    }
		    
		    if($id_cadastro)
		    {
		        $data['simulacoes'] = $simulacoes = $this->admin_model->getSimulacoes(['id_cad_interessado',$id_cadastro]);
		        foreach ($simulacoes as $simulacao)
    		    {
    		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','fnc_simulacao'],['id_rel',$simulacao->id_simulacao]]);
    		        if(!empty($result))
    		            $atedimentosTemporarios[] = $result;
    		    }
		    }
		    
		    foreach ($atedimentosTemporarios as $result)
		        $outroAtendimentos = array_merge($outroAtendimentos, $result);
		}
		foreach ($outroAtendimentos as $atend)
		{
		    $tipo_interesse = ($atend->tipo_interesse=='')?'Outros':$atend->tipo_interesse;
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
		    $outrosPorAssunto[$tipo_interesse][] = $atend;
		}
		
		$data['outrosPorAssunto'] = $outrosPorAssunto??[];
		
    }
    
    function setInteressado(&$data)
    {
		$cadastro       = $data['cadastro'];
        $objetoAtendido = $data['objetoAtendido'];
		
		$data['interessado'] = (object)[];
		
		$data['interessado']->nome            = $cadastro->nome??($objetoAtendido->nome??'');
		$data['interessado']->email           = $cadastro->email??($objetoAtendido->email??'');
		$data['interessado']->telefone        = $cadastro->telefone??($objetoAtendido->telefone??'');
		$data['interessado']->cpf             = $cadastro->cpf??($objetoAtendido->cpf??'');
		$data['interessado']->data_nascimento = $cadastro->data_nascimento??($objetoAtendido->data_nascimento??'');
		$data['interessado']->comprador       = $cadastro->comprador??($objetoAtendido->comprador??'');
		$data['interessado']->vendedor        = $cadastro->vendedor??($objetoAtendido->comprador??'');
    }
    
    //===================== INCORPORADORAS ==============================
    
    function incorporadoras()
    {
        $this->ini_method();
        
        $empreendimentos = $this->admin_model->getEmpreendimentos([['contrato > ',0]]);
        $notificacoesNaoAtendindas = [];
        $notificacoesAguardandoRetorno = [];
        foreach ($empreendimentos as $emp){
            $imovel = $this->admin_model->getImovel(['a.id_imovel',$emp->id_imovel]);
            
            //0 - Cadastro incompleto, 1 - Cadastro incompleto, 2 - Aguardando moderação, 3 - Publicado, 4 - Recusado, 5 - Bloqueado, 6 - Vendido, 7 - Alugado
            if(!in_array(($imovel->status??4),[4,5])) 
            {
                $res = $this->getNotificacaoEmpreendimentoNaoAtendida($emp);
                //if($res->qnt > 0)
                    $notificacoesNaoAtendindas[] = $res;
                
                $res = $this->getNotificacaoEmpreendimentoAguardandoRetorno($emp);
                if($res->qnt > 0)
                    $notificacoesAguardandoRetorno[] = $res;
            }
            
        }
        
        $this->dataTables();
        Assets::add_module_js('atendimento', array(
            //'atendimento',
            'incorporadora'
        ));
        
        $data['capNaoAtendidas']      = $notificacoesNaoAtendindas;
        $data['capAguardandoRetorno'] = $notificacoesAguardandoRetorno;
        
        Template::set($data);
        Template::set_view('incorporadoras_view');
        Template::render();
    }
    
    private function getNotificacaoEmpreendimentoNaoAtendida($emp)
    {
        $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas('cad_captura', 'id_captura', 'getCapturas', [['origem_captura', $emp->uuid_empreendimento],['tipo_atendimento',0]]);
        return (object)[
                    'UUID'     => $emp->uuid_empreendimento,
                    'name'     => $emp->emp_nome_fantasia,
                    'qnt'      => count($CapturasNaoAtendidas),
                ];
    }
    
    private function getNotificacaoEmpreendimentoAguardandoRetorno($emp)
    {
        $CapturasAtendidas = $this->admin_model->getAguardandoRetorno('cad_captura', 'id_captura', 'getCapturas', [['origem_captura', $emp->uuid_empreendimento],['tipo_atendimento',0]]);
        return (object)[
                    'UUID'     => $emp->uuid_empreendimento,
                    'name'     => $emp->emp_nome_fantasia,
                    'qnt'      => count($CapturasAtendidas),
                ];
    }
    
    
    
    //===========FIM======= INCORPORADORAS ==============================
    

    
    function resumo()
	{
        $this->ini_method();
    
        //===============================================================================
        $naoAguardandoRetorno = [];
        $naoAtendidas = [];
        
        $whereCadsImovel = [['status', 3],['doc_perfil', 'cpf']];
        $whereSimulacoes = [['id_imovel >',0]];//,['step >=', 4]
        
        //$tb_origem, $name_id, $function_get, $where, $tipo_interesse(cad_atendimento_historico), $origem_captura(so se for da cad_captura), $name(titulo), $link
        $configAtendimento = [
                ['fnc_simulacao', 'id_simulacao', 'getSimulacoes', $whereSimulacoes, 'Financiamento',    'xxx', 'Simulações',  'administrativo/atendimento/financiamento_imovel'],
                ['cad_captura', 'email', 'getCapturas', [], 'Financiamento', 'financiamento',         'LP Financiamento', 'administrativo/atendimento/financiamento'],
                ['cad_captura', 'email', 'getCapturas', [], 'Elleven',       'interessado_elleven',   'LP Elleven', 'administrativo/atendimento/elleven'],
                
                /*['cad_captura', 'email', 'getCapturas', [], 'Liberty',       'interessado_liberty',   'LP Liberty', 'administrativo/atendimento/liberty'],
                ['cad_captura', 'email', 'getCapturas', [], 'Signature',       'interessado_signature',   'LP Signature', 'administrativo/atendimento/signature'],
                ['cad_captura', 'email', 'getCapturas', [], 'Exclusive',     'interessado_exclusive', 'LP Exclusive', 'administrativo/atendimento/exclusive'],*/
                
                ['cad_captura', 'email', 'getCapturas', [], 'Avaliação',     'avaliacao',             'LP Avaliação', 'atendimento/atendimento/avaliacao'],
                ['cad_contato', 'id', 'getContatos', [], 'Contato',    'xxx', 'Contatos',  'atendimento/atendimento/contatos'],
                /*['cad_cadastro',  'id_cadastro',  'getCadsImovel', $whereCadsImovel, 'Anunciante ativo', 'xxx', 'Anunciantes', 'administrativo/atendimento/anunciantes'],*/
        ];
        
        foreach ($configAtendimento as $dt)
        {
            $tb_origem      = $dt[0];
            $name_id        = $dt[1];
            $function_get   = $dt[2];
            $where          = $dt[3];
            $tipo_interesse = $dt[4];
            $origem_captura = $dt[5];
            $name           = $dt[6];
            $link           = $dt[7];
            
            $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            //if(!empty($CapturasNaoAtendidas)){
            $naoAtendidas[] = (object)[
                    'key'      => $tb_origem,
                    'name'     => $name,
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => $link,
                ];
            //}
             
            $CapturasAtendidas = $this->admin_model->getAguardandoRetorno($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            if(!empty($CapturasAtendidas)){
                $naoAguardandoRetorno[] = (object)[
                        'key'      => $tb_origem,
                        'name'     => $name,
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => $link,
                    ];
            }
        }
        //===============================================================================
        
        //===============================================================================
        $atendGeral = $this->dash_model->getAtendimentoHistorico_count();
        foreach ($atendGeral as $k=>$atend)
        {
            $w = [];
            $w[] = ['id_user', $atend->id_cadastro];
            
            $atend->dia_atual       = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'dia', $w);
            $atend->dia_anterior    = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'dia', $w);
            
            $atend->semana_atual    = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'semana', $w);
            $atend->semana_anterior = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'semana', $w);
            
            $atend->mes_atual       = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'mes', $w);
            $atend->mes_anterior    = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'mes', $w);
            
            if($atend->mes_atual == 0 && $atend->mes_anterior == 0)
                unset($atendGeral[$k]);
        }
        //===============================================================================
        
        //================I N C O R P O R A D O R A S====================================================================================
        $empreendimentos = $this->admin_model->getEmpreendimentos([['contrato > ',0]]);
        foreach ($empreendimentos as $emp)
            $origens['origens'][] = ['origem_captura', $emp->uuid_empreendimento];
        $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas('cad_captura', 'id_captura', 'getCapturas', $origens);
        $naoAtendidas[] = (object)[
                    'name'     => 'Incorporadoras',
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => 'atendimento/atendimento/incorporadoras',
                ];
        $CapturasAtendidas = $this->admin_model->getAguardandoRetorno('cad_captura', 'id_captura', 'getCapturas', $origens);
        if(!empty($CapturasAtendidas)){
            $naoAguardandoRetorno[] = (object)[
                        'name'     => 'Incorporadoras',
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => 'atendimento/atendimento/incorporadoras',
                ];
        }
        //=======FIM======I N C O R P O R A D O R A S====================================================================================
        $data['atendentes'] = $atendGeral;
        $data['naoAtendidas'] = $naoAtendidas;
        $data['naoAguardandoRetorno'] = $naoAguardandoRetorno;
        
        
        //===============================================================================
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature']]);
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Signature']]);
        }
        
        $data['capturas']      = $capturas;
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','']]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem',''],['status_captura',3]]));
        
        //================================================================================
        
        $this->dataTables();
        
        //var_dump( date("W"));
        
        Assets::add_js(array(
            'js/Chart.min',
        ));
        Assets::add_module_js('administrativo', array(
            'main',
            //'atendimento',
            'dashboard',
            'dashboard_atendimento'
        ));
        
        Template::set($data);
        Template::set_view('atendimento/atend_resumo_view');
        Template::render();
    }
    
    function interessado() 
    {
        $this->ini_method();
        
        $id_cadastro = $this->uri->segment(3);
        $id_captura = $this->uri->segment(4);
        
        //Cadastro/Capturas----------------------------------------------
        $cadastro = null;
        $capturas = [];
        $capturado = null;
        if($id_cadastro > 0){
            $cadastro = $this->admin_model->get_cadastro([], $id_cadastro);
            $capturas = $this->admin_model->getCapturas([['email', $cadastro->email]]);
        }
        if($id_captura > 0){
            $captura = $this->admin_model->getCaptura([['id_captura', $id_captura]]);
            if($captura != null){
                $capturas = $this->admin_model->getCapturas([['email', $captura->email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
            }
            if($cadastro == null && $captura != null){
                $cadastro = $this->admin_model->get_cadastro([['email', $captura->email]]);
            }
        }
        //Cadastro/Capturas----------------------------------------------
        
        
        //PESQUISAS---------------------------------------------------------
        $pesquisou = [];
        $intencoes_busca = $this->admin_model->getIntencoesBusca([['id_cadastro', $id_cadastro]]);
        foreach ($intencoes_busca as $intencao){
            
            $key = $intencao->pesquisa.$intencao->bairro.$intencao->quartos;
            
            $cont[$key][] = '';
            $pesquisou[$key] = (object)[
                    'pesquisa' => $intencao->pesquisa,
                    'bairro'  => $intencao->bairro,
                    'quartos'  => $intencao->quartos,
                    'cont'    => count($cont[$key]),
                ];
            
        }
        unset($pesquisou['']);
        //PESQUISAS---------------------------------------------------------
        
        //FAVORITOS---------------------------------------------------------
        $favoritos = $this->admin_model->get_favoritos($id_cadastro);
        foreach($favoritos as $fav)
            $where['orwhere'][] = ['a.id_imovel', $fav->id_imovel];
        $where[] = ['a.status', 3];
        $imoveisFavoritos = empty($favoritos)?[]:$this->conta_model->getImoveis($where,[],false);
        //FAVORITOS---------------------------------------------------------
        
        
       
        $imoveis = [];
        $negociacoes_compras = [];
        if($cadastro != null){
            
            //I M O V E I S ---------------------------------------------------------
            $wim[] = ['a.id_cadastro', $id_cadastro];
            $wim[] = ['id_imovel_rel', 0];
            $wim[] = [['a.lixeira <', 2],[['a.lancamento','Sim'],['a.lixeira <', 3]]];
            $imoveis = $this->admin_model->getImoveis($wim);
            //I M O V E I S ---------------------------------------------------------
            
            //N e g o c i a c o e s _ c o m p r a s---------------------------------------------------------
            $this->load->model("comdono/busca_model");
            $this->load->model("minha_conta/chat_model");
            $n_compras = $this->chat_model->getChat([['id_interessado',$id_cadastro]]);
            
            foreach($n_compras as $id_imovel=>$imovel) {
                foreach($imovel->chats as $id_chat=>$chat) {
                    $chat->imovel = $imovel;
                    $negociacoes_compras[$id_chat] = $chat;
                }
            }
            //N e g o c i a c o e s _ c o m p r a s---------------------------------------------------------
            
        }
       
       
       
        //A t e n d i m e n t o s---------------------------------------------------------
        $atendimentos =[];
        $atendimento = $this->admin_model->getAtendimento([['email' ,$cadastro->email??$captura->email]]);
        if($atendimento != null)
            $atendimentos = $this->admin_model->getHistoricoAtendimento([['id_atendimento', $atendimento->id_atendimento]]);
        //A t e n d i m e n t o s---------------------------------------------------------
        
        //Capturas landingpages---------------------------------------------------------
        
        /*if($id_captura > 0){
            $captura = $this->admin_model->getCaptura([['id_captura', $id_captura]]);
            if($captura != null){
                $capturas = $this->admin_model->getCapturas([['email', $captura->email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
            }
            if($cadastro == null && $captura != null){
                $cadastro = $this->admin_model->get_cadastro([['email', $captura->email]]);
            }
        }*/
        
        
        
        /*$origens =['financiamento','interessado_elleven','avaliacao','avaliacao_cep_nao'];
        $atendimento = $this->admin_model->getAtendimento([['email' ,$cadastro->email??$captura->email]]);
        if($atendimento != null)
            $atendimentos = $this->admin_model->getHistoricoAtendimento([['id_atendimento', $atendimento->id_atendimento]]);*/
            
            
            
        //Capturas landingpages---------------------------------------------------------
        
        
        //$this->chat_model->getChat([['id_interessado',$this->session->id_cadastro]]);
        
        $data['cadastro']              = $cadastro;
        $data['capturas']              = $capturas;
        $data['capturado']             = $capturado;
        $data['pesquisou']             = $pesquisou;
        $data['favoritos']             = $imoveisFavoritos;
        
        $data['financiamentos']        = [];
        $data['negociacoes_compras']   = $negociacoes_compras;
       
        $data['imoveis']               = $imoveis;
        $data['negociacoes_vendas']    = [];
        
        $data['atendimentos']          = $atendimentos;
        
        //`id_intencao`, `id_cadastro`, `clique`, `cont_result`, `result`, `pesquisa`, `bairro`, `tipo`, `quartos`, `valor`, `metro_quadrado`, `id_lancamento`, `tipo_busca`, `data_hora_busca`, `timestemp_intencao`, `intencao`
    
        
        Assets::add_css(array(
            '../comdono/plugins/blueimp/css/jquery.fileupload',
            '../comdono/plugins/blueimp/css/jquery.fileupload-ui',
            '../comdono/plugins/blueimp/css/blueimp-gallery.min',
            //'../comdono/plugins/blueimp/css/custom',
            '../comdono/plugins/unitegallery/css/unite-gallery',
            '../comdono/plugins/unitegallery/css/ug-theme-default',
            
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
            
            //'../painel/plugins/select2-4.0.3/select2.min'
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/blueimp/js/jquery.ui.widget',
            '../comdono/plugins/blueimp/js/tmpl.min',
            '../comdono/plugins/blueimp/js/load-image.all.min',
            '../comdono/plugins/blueimp/js/canvas-to-blob.min',
            '../comdono/plugins/blueimp/js/blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.iframe-transport',
            '../comdono/plugins/blueimp/js/jquery.fileupload',
            '../comdono/plugins/blueimp/js/jquery.fileupload-process',
            '../comdono/plugins/blueimp/js/jquery.fileupload-image',
            '../comdono/plugins/blueimp/js/jquery.fileupload-validate',
            '../comdono/plugins/blueimp/js/jquery.fileupload-ui',
            '../comdono/plugins/unitegallery/js/unitegallery.min',
            '../comdono/plugins/unitegallery/js/ug-theme-default',
            '../comdono/plugins/unitegallery/js/imovel',
            
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config',
        
            //'../painel/plugins/select2-4.0.3/select2',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
            
            
        ));
        
        Assets::add_module_js('administrativo', [
            'perfil'
        ]);
        
        Assets::add_module_js('atendimento', array(
            'script_select2',
            'atendimento',
        ));
        
	    Template::set($data);
		Template::set_view('atendimento/perfil_view');
		Template::render();
    }
    
    
    
    //== E X E M P L O S   E   L I  X O ===========================================================================================
    
    function EXEMPLOanunciantes()
	{
        $this->ini_method();
        //$result = [];
        
        $w[] = ['status =', 3];
        $w[] = ['doc_perfil', 'cpf'];
        
        $anunciantes = $this->admin_model->getCadsImovel($w);
        
        $data['anunciantesProximoContato'] = [];
        $data['anunciantesFinalizados'] = [];
        foreach ($anunciantes as $k=>$anunciante)
        {
            $w['id'] = ['id_cadastro',$anunciante->id_cadastro];
            $anunciante->imoveis = $this->dash_model->getImoveis($w);
            $anunciante->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$anunciante->id_cadastro],['tb_origem', 'cad_cadastro']]);
            
            if(!empty($anunciante->atendimento))
            {
                $proximo_contato = end($anunciante->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['anunciantesFinalizados'][] = $anunciante;
                }
                else
                {
                    $data['anunciantesProximoContato'][] = $anunciante;
                }
                unset($anunciantes[$k]);
            }
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'anunciantes'
        ));
        
        $data['anunciantes'] = $anunciantes;
        
        Template::set($data);
        Template::set_view('administrativo/anunciantes_view');
        Template::render();
		    
    }
    
    function index2()
	{
        $this->ini_method();
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature']]);
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Signature']]);
        }
        
        $data['capturas']      = $capturas;
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','']]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem',''],['status_captura',3]]));
        
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        Template::set($data);
        Template::set_view('atendimento/atend_resumo_view');
        Template::render();
    }
    
    public function interessado2() 
    {
        $this->ini_method();
		    
	    $data['tipo_interesse']  = $this->uri->segment(3);
		$id_antendimento  = $this->uri->segment(4);
		$data['interessado'] = $this->admin_model->getAtendimento([['id_atendimento',$id_antendimento]]);
		
		$atendimentos = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_antendimento]]);
		
		foreach($atendimentos as $atend)
		{
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
		}
		
		
		$data['atendimentos'] = $atendimentos;
		$data['state'] = 'add';
		
		
		$data['id_bug'] = $id_antendimento;
		$data['id_atendimento'] = $id_antendimento;
		$data['id_user'] = $this->session->id_cadastro;
		$data['data_hora'] = date("Y-m-d H:i:s");
		
		
		Assets::add_module_js('comdono', array(
		    'main'
		    ));
        Assets::add_module_js('administrativo', array(
            'atendimento',
        ));
        
		Template::set($data);
        Template::set_view('atendimento/atend_interessado_view');
        Template::render();
    }
	
	public function dataTables(){
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',
            '../comdono/plugins/dataTables/js/config'
        ));
	}
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
	
    
}