<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Comdono extends Grocery {

    
    function __construct() 
    {
        parent::__construct();
		Assets::add_module_js('comdono', ['main']);
		$this->dataTables();
		
		$this->load->model('comdono/cad_model');
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		
        $instance = parent::get_instance();
        $method = $instance->router->fetch_method();
        Template::set_html_custom($this->setNotificacoes(['tipo_interesse'=> $method]), 'atendimento/blocos/box_atendimentos', 'box_atendimento');
        Template::set_modal([],'atendimento/blocos/modal_atendimento_rapido');
    }
    
    function index()
    {
        $this->ini_method();
        Template::set_view('comdono_view');
        Template::render();
    }
    
    function atendimento_geral() 
    {
	    $this->ini_method('index');
	    $data['tipo_interesse']  = $this->uri->segment(4);
		$data['id_atendimento'] = $id_atendimento  = $this->uri->segment(5);
		$data['atendimentoInicial'] = $this->admin_model->getAtendimento([['id_atendimento',$id_atendimento]]);
	
	
		$this->setObjetoAtendido($data);
		$this->setCasdastro($data);
		$this->setOutrosAtentimentos($data);
		$this->setInteressado($data);
		
		
		$data['atendimentos'] = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_atendimento]]);
		foreach($data['atendimentos'] as $atend)
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
		
            	
		$data['id_user'] = $this->session->id_cadastro;
		
		//Pegar os interesses para o painel
		$wInteresses[] = ['ativo',1];
		$wInteresses[] = ['id_cadastro',$data['objetoAtendido']->id_cadastro];
		$wInteresses[] = ['interesse_painel_cs',0];
		
		$interesses = $this->cad_model->getInteresses($wInteresses);
		
		$hist_interesses=[];
        foreach($interesses as $inter){
            if($inter != []){
                $inter->bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $inter->id_interesse]]);
                $inter->tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $inter->id_interesse]]);
                $hist_interesses[] = $inter;
            }
        }
        $data['interesses']=$hist_interesses;
		
		//Pegar o interesse principal
		$wInteresseP[] = ['principal',1];
		$wInteresseP[] = ['id_cadastro',$data['objetoAtendido']->id_cadastro];
		$interesseP =  $this->cad_model->getInteresse($wInteresseP);
		
	    if(!empty($interesseP)){
	        $interesseP->bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $interesseP->id_interesse]]);
	        $interesseP->tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $interesseP->id_interesse]]);
	    }
		
		$data['interesseP'] = $interesseP??[];
		
		$bairros = [];
		foreach(($data['interesseP']->bairros??[]) as $b){
		    $bairros[] = $b->bairro;
		}
		
		$data['interesseP_bairros'] = $bairros;
		
		$tipo_emp = [];
		foreach(($data['interesseP']->tipo_emp??[]) as $t){
		    $tipo_emp[] = $t->tipo_emp;
		}
		
		$data['interesseP_tipo_emp'] = $tipo_emp;
		
		
		Assets::add_css(array(
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
        ));
        
        Assets::add_js(array(
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
        ));
		
        Assets::add_module_js('atendimento', array(
            'atendimento_geral',
            'atendimento',
        ));
        
		Template::set($data);
        Template::set_view('atendimento/atendimento_view');
        Template::render();
    }
    
    function setObjetoAtendido(&$data)
    {
        $AtendimentoInicial = $data['atendimentoInicial'];
        
        $tb_origem      = $AtendimentoInicial->tb_origem;
        $id_rel         = $AtendimentoInicial->id_rel;
		$primaryKeyName = $this->admin_model->getPrimaryKey($tb_origem);
		
		$data['objetoAtendido'] = $this->admin_model->getRow($tb_origem, [$primaryKeyName, $id_rel]);
		
		
    }
    
    function setCasdastro(&$data)
    {
        $objetoAtendido = $data['objetoAtendido'];
        
        $cadastro = null;
		if($objetoAtendido->id_cadastro??false)
		    $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$objetoAtendido->id_cadastro]);
		elseif($objetoAtendido->id_cad_interessado??false)
		    $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$objetoAtendido->id_cad_interessado]);
		elseif($objetoAtendido->email??false)
		    $cadastro =  $this->admin_model->getCadastro(['email',$objetoAtendido->email]);
        
        $data['cadastro'] = $cadastro;
    }
    
    function setOutrosAtentimentos(&$data)
    {
        $id_atendimento = $data['id_atendimento'];
        $cadastro       = $data['cadastro'];
        $objetoAtendido = $data['objetoAtendido'];
        
        $email       = $cadastro->email??($objetoAtendido->email??null);
        $id_cadastro = $cadastro->id_cadastro??false;
		
		$outroAtendimentos = [];
		$data['capturas'] = $capturas = [];
		if($email??false){
		    $outroAtendimentos      = $this->admin_model->getAtendimentoHistorico([['email',$email],['a.id_atendimento !=',$id_atendimento]]);
		    $data['capturas']       = $capturas       = $this->admin_model->getCapturas(['email',$email]);
		    $atedimentosTemporarios = [];
		    foreach ($capturas as $cap)
		    {
		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','cad_captura'],['id_rel',$cap->id_captura]]);
		        if(!empty($result))
		            $atedimentosTemporarios[] = $result;
		    }
		    
		    $data['contatos']       = $contatos       = $this->admin_model->getContatos(['email',$email]);
            foreach ($contatos as $contato)
		    {
		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','cad_contato'],['id_rel',$contato->id]]);
		        if(!empty($result))
		            $atedimentosTemporarios[] = $result;
		    }
		    
		    if($id_cadastro)
		    {
		        $data['simulacoes'] = $simulacoes = $this->admin_model->getSimulacoes(['id_cad_interessado',$id_cadastro]);
		        foreach ($simulacoes as $simulacao)
    		    {
    		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','fnc_simulacao'],['id_rel',$simulacao->id_simulacao]]);
    		        if(!empty($result))
    		            $atedimentosTemporarios[] = $result;
    		    }
		    }
		    
		    
		    
		    
		    
		    foreach ($atedimentosTemporarios as $result)
		        $outroAtendimentos = array_merge($outroAtendimentos, $result);
		}
		foreach ($outroAtendimentos as $atend)
		{
		    $tipo_interesse = ($atend->tipo_interesse=='')?'Outros':$atend->tipo_interesse;
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
		    $outrosPorAssunto[$tipo_interesse][] = $atend;
		}
		
		$data['outrosPorAssunto'] = $outrosPorAssunto??[];
		
    }
    
    function setInteressado(&$data)
    {
		$cadastro       = $data['cadastro'];
        $objetoAtendido = $data['objetoAtendido'];
		
		$data['interessado'] = (object)[];
		
		$data['interessado']->nome            = $cadastro->nome??($objetoAtendido->nome??'');
		$data['interessado']->email           = $cadastro->email??($objetoAtendido->email??'');
		$data['interessado']->telefone        = $cadastro->telefone??($objetoAtendido->telefone??'');
		$data['interessado']->cpf             = $cadastro->cpf??($objetoAtendido->cpf??'');
		$data['interessado']->data_nascimento = $cadastro->data_nascimento??($objetoAtendido->data_nascimento??'');
		$data['interessado']->comprador       = $cadastro->comprador??($objetoAtendido->comprador??'');
		$data['interessado']->vendedor        = $cadastro->vendedor??($objetoAtendido->comprador??'');
    }
    
    function cadastro_incompleto()
	{
        $this->ini_method('index')->breadcrumb();
        
        
        $cadastros = $this->admin_model->getCadastrosUsers([['etapa <',8]]);
        
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosFinalizados'] = [];
        $data['atendimentosAguardando'] = $cadastros; 
        foreach ($cadastros as $k=>$cad)
        {
            $cad->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cad->id_cadastro],['tb_origem','cad_cadastro'],['tipo_interesse','cadastro_incompleto']]);
            
            if(!empty($cad->atendimento))
            {
                $proximo_contato = end($cad->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cad;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cad;
                }
                //unset($cadastros[$k]);
                unset($data['atendimentosAguardando'][$k]);
            }
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        $data['cadastros'] = $cadastros;
        
        Template::set($data);
        Template::set_view('atendimento/cadastros_view');
        Template::render();
    }
    
    function cadastro_completo()
	{
        $this->ini_method('index')->breadcrumb();
        
        $cadastros = $this->admin_model->getCadastros([['etapa >=',8]]);
        
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosFinalizados'] = [];
        $data['atendimentosAguardando'] = $cadastros; 
        foreach ($cadastros as $k=>$cad)
        {
            $cad->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cad->id_cadastro],['tb_origem','cad_cadastro'],['tipo_interesse','cadastro_completo']]);
            
            if(!empty($cad->atendimento))
            {
                $proximo_contato = end($cad->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cad;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cad;
                }
                //unset($cadastros[$k]);
                unset($data['atendimentosAguardando'][$k]);
            }
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        $data['cadastros'] = $cadastros;
        
        Template::set($data);
        Template::set_view('atendimento/cadastros_view');
        Template::render();
    }
    
    function contato()
	{
        $this->ini_method('index')->breadcrumb();
        
        $contatos = $this->admin_model->getContatos();
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $contatos; 
        foreach ($contatos as $k=>$contato)
        {
            $contato->cadastro  = $this->admin_model->getCadastro([['email',$contato->email]]);
            $contato->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$contato->id],['tb_origem','cad_contato'],['tipo_interesse','contato']]);
            
            
            if(!empty($contato->atendimento))
            {
                $proximo_contato = end($contato->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $contato;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $contato;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
            $contato->data_atendimento = [
                'id_rel'    => $contato->id, 
                'tb_origem' => 'cad_contato',
                'nome'      => $contato->nome,
                'telefone'  => $contato->telefone,
            ];
            
            $contato->id_rel = $contato->id;
            $contato->tb_origem = 'cad_contato';
        }
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        $data['contatos'] = $contatos;
        
        Template::set($data);
        Template::set_view('atendimento/contatos_view');
        Template::render();
    }
    
    function avaliacao()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','avaliacao']]);
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $capturas; 
        foreach ($capturas as $k=>$cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cap->id_captura],['tb_origem', 'cad_captura'],['tipo_interesse','avaliacao']]);
            
            if(!empty($cap->atendimento))
            {
                $proximo_contato = end($cap->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cap;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cap;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
            $w = [];
            $w[] = ['id_campanha', 32];
            $w[] = ['email', $cap->email];
            
            $logs = $this->admin_model->get_log_emails($w);
            
            $cap->abriu_email = 'Não';
            $cap->clicou_email = 'Não';
            
            $logenviado = false;
            foreach ($logs as $log)
            {
                if($log->enviado >= 1)
                    $logenviado = true;
                    
                if($log->abriu > 0)
                    $cap->abriu_email = '<span class="badge badge-success">Sim</span>';
                if($log->clicou > 0)
                    $cap->clicou_email = '<span class="badge badge-success">Sim</span>';
            }
            
            if($logenviado == false)
                    $cap->datetime_captura = '<span class="badge badge-danger">Não enviado</span>';
            
            $cadastro = $this->admin_model->getCadastro([['email',$cap->email]]);
            
            $cap->cadastro = 'Não';
            if($cadastro != NULL)
                $cap->cadastro = '<span class="badge badge-success">Sim</span>';
            
            $cap->especialista = 'Não';
            if($cap->horario != "" && $cap->dia_semana != "")
                $cap->especialista = '<span class="badge badge-success" data-toggle="tooltip" data-html="true" data-original-title="Dia semana: '.$cap->dia_semana.'<br>Horário: '.$cap->horario.'">Sim, veja aqui.</span>';
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento',
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('atendimento/avaliacao_view');
        Template::render();
    }
    
    function questionario_001()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','questionario_001']]);
        
        
        $data['total'] = 0;
        $data['totalCasa'] = 0;
        $data['totalApartamento'] = 0;
        $data['totalIncompleto'] = 0;
        
        
        $data['relatorio'] = [];
        $questoes = $this->getQuestionarioCasaApartamento();
        foreach ($questoes as $k=>$questao)
        {
            $data['relatorio'][$k] = (object)[];

            $data['relatorio'][$k]->respostas = $questao;
            $data['relatorio'][$k]->a = 0;
            $data['relatorio'][$k]->b = 0;
            $data['relatorio'][$k]->total = 0;

        }
	    
	    
  
	$data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $capturas; 
        foreach ($capturas as $k=>$cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cap->id_captura],['tb_origem', 'cad_captura'],['tipo_interesse','questionario_001']]);
            
            if(!empty($cap->atendimento))
            {
                $proximo_contato = end($cap->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cap;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cap;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
            $cadastro = $this->admin_model->getCadastro([['email',$cap->email]]);
            
            $cap->cadastro = 'Não';
            if($cadastro != NULL)
                $cap->cadastro = '<span class="badge badge-success">Sim</span>';
            
            $pesquisa = json_decode($cap->pesquisa);
            $pesquisa = (!is_array($pesquisa))?[]:$pesquisa;
            
            $nRespondido  = 13;
            $casa         = 0;
            $apartamento  = 0;
            foreach ($pesquisa as $res)
            {
                if($res->gabarito == 'casa'){
                    $casa++; $nRespondido--;
                }
                if($res->gabarito == 'apartamento'){
                    $apartamento++; $nRespondido--;
                }
            }
            
            $cap->respostas = "Casa: $casa - Apto: $apartamento";
            
            if($nRespondido > 0 )
                $cap->respostas .= " - Não Resp: $nRespondido";
            
            
            $cap->resultado = "-";
            if($nRespondido > 0)
            {
                $cap->resultado = "Incompleto";
                $data['totalIncompleto']++;
            }
            elseif($casa > $apartamento)
            {
                 $data['totalCasa']++;

                $cap->resultado = "<br>Casa</br>";
            }
            elseif($casa < $apartamento)
            {
                $data['totalApartamento']++;
                $cap->resultado = "<br>Apartamento</br>";
            }
            $data['total']++;


            $pesquisa = json_decode($cap->pesquisa)??[];

            foreach ($pesquisa as $questao)
            {

                $cap->questionario[$questao->numero] = (object)$questoes[$questao->numero];

                $cap->questionario[$questao->numero]->numero = $questao->numero;
                $cap->questionario[$questao->numero]->letra = $questao->letra;
                $cap->questionario[$questao->numero]->resposta = $questao->resposta;
                $cap->questionario[$questao->numero]->gabarito = $questao->gabarito;

                $letra = $questao->letra;

                if($questao->letra == 'a')
                    $data['relatorio'][$questao->numero]->a++;
                if($questao->letra == 'b')    
                    $data['relatorio'][$questao->numero]->b++;

                $data['relatorio'][$questao->numero]->total++;

            }
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento',
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('atendimento/questionario_001_view');
        Template::render();
    }
    
    function questionario_002()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','questionario_002']]);
        
        $data['total'] = 0;
        $data['totalCasa'] = 0;
        $data['totalApartamento'] = 0;
        $data['totalIncompleto'] = 0;
        
        $data['totalTesteA'] = 0;
        $data['totalTesteB'] = 0;
        
        $data['relatorio'] = [];
        $questoes = $this->getQuestionario3ou4quartos();
        foreach ($questoes as $k=>$questao)
        {
            $data['relatorio'][$k] = (object)$questao;
            
            $data['relatorio'][$k]->a = 0;
            $data['relatorio'][$k]->b = 0;
            $data['relatorio'][$k]->total = 0;
            
        }
        
        
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $capturas; 
        foreach ($capturas as $k=>$cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cap->id_captura],['tb_origem', 'cad_captura'],['tipo_interesse','questionario_002']]);
            
            if(!empty($cap->atendimento))
            {
                $proximo_contato = end($cap->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cap;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cap;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
            
            if($cap->link == 'formTesteAB')
                $data['totalTesteB']++;
            else
                $data['totalTesteA']++;
            
            
            $cadastro = $this->admin_model->getCadastro([['email',$cap->email]]);
            
            $cap->cadastro = 'Não';
            if($cadastro != NULL)
                $cap->cadastro = '<span class="badge badge-success">Sim</span>';
            
            $pesquisa = json_decode($cap->pesquisa);
            $pesquisa = (!is_array($pesquisa))?[]:$pesquisa;
            
            $nRespondido  = 15;
            $casa         = 0;
            $apartamento  = 0;
            foreach ($pesquisa as $res)
            {
                if($res->gabarito == '3 quartos'){
                    $casa++; $nRespondido--;
                }
                if($res->gabarito == '4 quartos'){
                    $apartamento++; $nRespondido--;
                }
            }
            
            $cap->respostas = "3 Quartos: $casa - 4 Quartos: $apartamento";
            
            if($nRespondido > 0 )
                $cap->respostas .= " - Não Resp: $nRespondido";
            
            
            $cap->resultado = "-";
            if($nRespondido > 0)
            {
                $cap->resultado = "Incompleto";
                $data['totalIncompleto']++;
            }
            elseif($casa > $apartamento)
            {
                 $data['totalCasa']++;

                $cap->resultado = "<br>3 quartos</br>";
            }
            elseif($casa < $apartamento)
            {
                $data['totalApartamento']++;
                $cap->resultado = "<br>4 quartos</br>";
            }
            $data['total']++;
            
            $questoes = $this->getQuestionario3ou4quartos();
            
            $cap->questionario = [];
            
            
            $pesquisa = json_decode($cap->pesquisa)??[];
            
            foreach ($pesquisa as $questao)
            {
                
                $cap->questionario[$questao->numero] = (object)$questoes[$questao->numero];
                
                $cap->questionario[$questao->numero]->numero = $questao->numero;
                $cap->questionario[$questao->numero]->letra = $questao->letra;
                $cap->questionario[$questao->numero]->resposta = $questao->resposta;
                $cap->questionario[$questao->numero]->gabarito = $questao->gabarito;
                
                $letra = $questao->letra;
                
                if($questao->letra == 'a')
                    $data['relatorio'][$questao->numero]->a++;
                if($questao->letra == 'b')    
                    $data['relatorio'][$questao->numero]->b++;
                    
                $data['relatorio'][$questao->numero]->total++;
                
            }
        }
        
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento',
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('atendimento/questionario_002_view');
        Template::render();
    }
	
    function getQuestionarioCasaApartamento()
    {

	    return [
                1 => [
                    'a' => ['resposta'=>'Varanda','gabarito'=>'apartamento'],
                    'b' => ['resposta'=>'Quintal','gabarito'=>'casa']
                    ],
                2 => [
                    'a' => ['resposta'=>'Localização','gabarito'=>'apartamento'],
                    'b' => ['resposta'=>'Mais espaço','gabarito'=>'casa']
                    ],
                3 => [
                    'a' => ['resposta'=>'Cozinhar para os amigos','gabarito'=>'casa'],
                    'b' => ['resposta'=>'Sair para jantar','gabarito'=>'apartamento']
                    ],
                4 => [
                    'a' => ['resposta'=>'Área verde','gabarito'=>'casa'],
                    'b' => ['resposta'=>'Vista','gabarito'=>'apartamento']
                    ],
                5 => [
                    'a' => ['resposta'=>'Centro da cidade','gabarito'=>'apartamento'],
                    'b' => ['resposta'=>'Tranquilidade ','gabarito'=>'casa']
                    ],
                6 => [
                    'a' => ['resposta'=>'Homeoffice ','gabarito'=>'casa'],
                    'b' => ['resposta'=>'Próximo ao trabalho','gabarito'=>'apartamento']
                    ],
                7 => [
                    'a' => ['resposta'=>'Lazer privativo','gabarito'=>'casa'],
                    'b' => ['resposta'=>'Lazer compartilhado','gabarito'=>'apartamento']
                    ],
                8 => [
                    'a' => ['resposta'=>'Centro da cidade com 80m²','gabarito'=>'apartamento'],
                    'b' => ['resposta'=>'20 minutos do centro com 250m²','gabarito'=>'casa']
                    ],
                9 => [
                    'a' => ['resposta'=>'Se divertir em casa','gabarito'=>'casa'],
                    'b' => ['resposta'=>'Se divertir na cidade','gabarito'=>'apartamento']
                    ],
                10 => [
                    'a' => ['resposta'=>'Ter mais privacidade morando em casa','gabarito'=>'casa'],
                    'b' => ['resposta'=>'Ter mais segurança morando em apartamento','gabarito'=>'apartamento']
                    ],
                11 => [
                    'a' => ['resposta'=>'Mais praticidade no dia a dia','gabarito'=>'apartamento'],
                    'b' => ['resposta'=>'Mais qualidade de vida','gabarito'=>'casa']
                    ],
                12 => [
                    'a' => ['resposta'=>'Encontrar os amigos','gabarito'=>'apartamento'],
                    'b' => ['resposta'=>'Receber os amigos','gabarito'=>'casa']
                    ],
                13 => [
                    'a' => ['resposta'=>'Casa','gabarito'=>'casa'],
                    'b' => ['resposta'=>'Apartamento','gabarito'=>'apartamento']
                    ]
            ];


    }
    
    function getQuestionario3ou4quartos()
    {
       
	    return [
                1 => [
                    'pergunta'  => 'Sua família é de',
                    'respostas' => [
                                    'a' => ['resposta'=>'4 Pessoas no máximo', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Mais de 4 pessoas',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                2 => [
                    'pergunta'  => 'Espaço: Cozinha',
                    'respostas' => [
                                    'a' => ['resposta'=>'Americana/aberta', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Tradicional/fechada',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                3 => [
                    'pergunta'  => 'Espaço: Área de serviços',
                    'respostas' => [
                                    'a' => ['resposta'=>'Sem dependência de empregada', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Com dependência de empregada',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                4 => [
                    'pergunta'  => 'Espaço: Sala',
                    'respostas' => [
                                    'a' => ['resposta'=>'Com varanda', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Sem varanda',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                5 => [
                    'pergunta'  => 'Investimento',
                    'respostas' => [
                                    'a' => ['resposta'=>'De R$ 1.000.000 a R$ 1.300.000', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'De R$ 1.500.000 a R$ 1.800.000', 'gabarito'=>'4 quartos']
                                    ] 
                    ],
                6 => [
                    'pergunta'  => 'Versatilidade',
                    'respostas' => [
                                    'a' => ['resposta'=>'Tirar um quarto para aumentar a sala', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Transformar um quarto em escritório',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                7 => [
                    'pergunta'  => 'Condomínio',
                    'respostas' => [
                                    'a' => ['resposta'=>'R$ 1.400/mês, lazer básico em condomínio fechado', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'R$ 1.900/mês, lazer completo em condomínio fechado',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                8 => [
                    'pergunta'  => 'Acabamento',
                    'respostas' => [
                                    'a' => ['resposta'=>'Elegante - R$ 10.000 m²', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Sofisticado - R$ 12.000 m²',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                9 => [
                    'pergunta'  => 'O que você prefere?',
                    'respostas' => [
                                    'a' => ['resposta'=>'Quarto maior', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Sala maior',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                10 => [
                    'pergunta'  => 'Vagas de garagem',
                    'respostas' => [
                                    'a' => ['resposta'=>'2 vagas', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'3 vagas',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                11 => [
                    'pergunta'  => 'Lazer interno no condomínio',
                    'respostas' => [
                                    'a' => ['resposta'=>'Não faz diferença', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Valorizo',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                12 => [
                    'pergunta'  => 'Escritório',
                    'respostas' => [
                                    'a' => ['resposta'=>'Home office', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Morar próximo ao trabalho',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                13 => [
                    'pergunta'  => 'Conceito',
                    'respostas' => [
                                    'a' => ['resposta'=>'Condomínio fechado', 'gabarito'=>'Lago Norte/Park Sul'],
                                    'b' => ['resposta'=>'Pilotis',   'gabarito'=>'Noroeste/Sudoeste']
                                    ] 
                    ],
                14 => [
                    'pergunta'  => 'Lazer',
                    'respostas' => [
                                    'a' => ['resposta'=>'Lazer/cobertura', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'Lazer/térreo',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                15 => [
                    'pergunta'  => '3 ou 4 quartos?',
                    'respostas' => [
                                    'a' => ['resposta'=>'3 Quartos', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'4 Quartos',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                16 => [
                    'pergunta'  => '',
                    'respostas' => [
                                    'a' => ['resposta'=>'110m²', 'gabarito'=>'3 quartos'],
                                    'b' => ['resposta'=>'130m²',   'gabarito'=>'3 quartos']
                                    ] 
                    ],
                17 => [
                    'pergunta'  => '',
                    'respostas' => [
                                    'a' => ['resposta'=>'140m²', 'gabarito'=>'4 quartos'],
                                    'b' => ['resposta'=>'160m²',   'gabarito'=>'4 quartos']
                                    ] 
                    ],
                
	    ];
	    
	    
    }
    
    
    function interesse_compra()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interesse_compra']]);
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $capturas; 
        
        $data['totalLagoNorte'] = 0;
        $data['totalOutros'] = 0;
        $data['totalLagoNorte'] = 0;
        
        foreach ($capturas as $k=>$cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cap->id_captura],['tb_origem', 'cad_captura'],['tipo_interesse','interesse_compra']]);
            
            if(!empty($cap->atendimento))
            {
                $proximo_contato = end($cap->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cap;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cap;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
            if($cap->link == 'formLpCadInteresseLagoNorte')
                $data['totalLagoNorte']++;
            else
                $data['totalOutros']++;
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento',
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('atendimento/interesse_lago_norte_view');
        Template::render();
    }
    
    function ebookLagoNorte()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','ebookLagoNorte']]);
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $capturas; 
        
        foreach ($capturas as $k=>$cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cap->id_captura],['tb_origem', 'cad_captura'],['tipo_interesse','ebookLagoNorte']]);
            
            if(!empty($cap->atendimento))
            {
                $proximo_contato = end($cap->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cap;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cap;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento',
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('atendimento/ebook_lago_norte_view');
        Template::render();
    }
    
    function prelancamento_premium()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','prelancamento_premium']]);
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $capturas; 
        
        foreach ($capturas as $k=>$cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cap->id_captura],['tb_origem', 'cad_captura'],['tipo_interesse','prelancamento_premium']]);
            
            if(!empty($cap->atendimento))
            {
                $proximo_contato = end($cap->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cap;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cap;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento',
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('atendimento/prelancamento_premium_view');
        Template::render();
    }
    
    function Convites()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['link','formConvite'],['status_captura',3]]);
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $capturas; 
        
        $empreendimentos = [];
        
        foreach ($capturas as $k=>$cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$cap->id_captura],['tb_origem', 'cad_captura'],['tipo_interesse','convites']]);
            
            if(!empty($cap->atendimento))
            {
                $proximo_contato = end($cap->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $cap;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $cap;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
            $cap->evento = $this->cad_model->getEvento([['uuid_evento',$cap->uuid_evento]]);
            
            $cap->empreendimento = $empreendimento = $this->cad_model->getEmpreendimento(['uuid_empreendimento',$cap->origem_captura]);
            
            $empreendimentos[$cap->origem_captura]['empreendimento'] = $empreendimento;
            $empreendimentos[$cap->origem_captura]['eventos'][$cap->evento->uuid_evento??'Outros'][] = $cap->evento;
        }
        
        
        
        $data['resumo'] = [];
        
        foreach ($empreendimentos as $key=>$emp)
        {
            $data['resumo'][$key] = (object)['empreendimento'=>$emp['empreendimento'] ];
            $data['resumo'][$key]->eventos = $emp['eventos'];
            $data['resumo'][$key]->countEmpreendimento = 0;
            foreach ($emp['eventos'] as $key_evento=>$eventos)
                $data['resumo'][$key]->countEmpreendimento += count($eventos);
        }
        
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento',
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('atendimento/convites_view');
        Template::render();
    }
    
    function BK_financiamentos()
	{
        $this->ini_method('index')->breadcrumb();
        
        $simulacoes = $this->admin_model->getSimulacoes([['fnc_simulacao.id_imovel >',0]]);//,['fnc_simulacao.step >=',4]
         
        foreach ($simulacoes as $sim)
        {
            $sim->interessado  = $this->admin_model->get_cadastro([],$sim->id_cad_interessado);
            $sim->dono         = $this->admin_model->get_cadastro([],$sim->id_cad_dono);
            $sim->imovel       = $this->admin_model->getImovel([['a.id_imovel',$sim->id_imovel]]);
            $sim->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$sim->id_simulacao],['tb_origem','fnc_simulacao'],['tipo_interesse','financiamento']]);
            
            $sim->data_atendimento = [
                'id_rel'    => $sim->id_simulacao, 
                'tb_origem' => 'fnc_simulacao',
                'nome'      => $sim->interessado->nome,
                'telefone'  => $sim->interessado->telefone,
            ];
            
            $sim->interessado->id_rel = $sim->id_simulacao;
            $sim->interessado->tb_origem = 'fnc_simulacao';
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array( 
            'financiamento'
        ));
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        $data['simulacoes'] = $simulacoes;
        //$data['tipo_interesse'] = 'financiamentos';
        //Template::load_view('atendimento/blocos/box_atendimentos.php', $this->setNotificacoes($data), '', '', $data['box_atendimento']);
        
        Template::set($data);
        Template::set_view('atendimento/financiamentos_view');
        Template::render();
		    
    }
    
    function financiamento()
	{
        $this->ini_method('index')->breadcrumb();
        
        $simulacoes = $this->admin_model->getSimulacoes(['fnc_simulacao.step <',4]);
        
        $data['atendimentosAguardando'] = $simulacoes; 
        foreach ($simulacoes as $k=>$sim)
        {
            $sim->interessado  = $this->admin_model->get_cadastro([],$sim->id_cad_interessado);
            $sim->dono         = $this->admin_model->get_cadastro([],$sim->id_cad_dono);
            $sim->imovel       = $this->admin_model->getImovel([['a.id_imovel',$sim->id_imovel]]);
            $sim->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$sim->id_simulacao],['tb_origem','fnc_simulacao'],['tipo_interesse','financiamento']]);
            
            if(!empty($sim->atendimento))
            {
                $proximo_contato = end($sim->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $sim;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $sim;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
        }
        
        Assets::add_module_js('administrativo', array( 
            'financiamento'
        ));
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        Template::set($data);
        Template::set_view('atendimento/financiamentos_view');
        Template::render();
		    
    }
    
    function financiamento_cap()
	{
        $this->ini_method('index')->breadcrumb();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','financiamento']]);
        
        $data['contCapturas']  = count($this->admin_model->getCapturasOrderBy([['origem_captura','financiamento']]));
        $data['contVer']       = count($this->admin_model->getCapturasOrderBy([['origem_captura','financiamento'],['mensagem','verimoveis']]));
        $data['contSolicitar'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','financiamento'],['mensagem','solicitarproposta']]));
        $data['contSimulacoes'] = 0;
        
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Financiamento']  ]);
            
         
            $cad = $this->admin_model->get_cadastro([['email',$cap->email]]);
            
            $cap->cadastro      = 'Não';
            $cap->financiamento = 'Não';
            $cap->valor = 0.0;
            if($cad != null){
                $financiamentos = $this->admin_model->getSimulacoes([['id_imovel',0],['id_cad_dono', 0],['id_cad_interessado',$cad->id_cadastro]]);
                
                $cap->simulacao = $financiamentos;
                
                $cap->cadastro = '<span class="badge badge-warning">Incompleto</span>';
                if($cad->etapa >= 8)
                   $cap->cadastro = '<span class="badge badge-success">Completo</span>';
               
                if(!empty($financiamentos))
                {
                    $simulacaoConcluida = false;
                     
                    $cap->financiamento = '<span class="badge badge-warning">Incompleto</span>';
                    $c = 0;
                    foreach ($financiamentos as $simulacao)
                    {
                        if($simulacao->step >= 4)
                        {
                            $c++;
                            $n = ($c>1)?$c.'-':'';
                            $s = ($c>1)?'s':'';
                            
                            $cap->financiamento = '<span class="badge badge-success">'.$n.'Completo'.$s.'</span>';
                            $simulacaoConcluida = true;
                            
                            if($simulacao->val_imovel > $cap->valor)
                                $cap->valor = $simulacao->val_imovel;
                        }
                            
                    }
                    if($simulacaoConcluida)
                        $data['contSimulacoes']++;
                }
            }
        }
        
        
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'financiamento'
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('administrativo/financiamento/dashboard_view');
        Template::render();
		    
    }
    
    function anunciantes()
	{
        $this->ini_method('index')->breadcrumb();
        
        $w[] = ['status =', 3];
        $w[] = ['doc_perfil', 'cpf'];
        
        $anunciantes = $this->admin_model->getCadsImovel($w);
        
        $data['anunciantesProximoContato'] = [];
        $data['anunciantesFinalizados'] = [];
        foreach ($anunciantes as $k=>$anunciante)
        {
            $w['id'] = ['id_cadastro',$anunciante->id_cadastro];
            $anunciante->imoveis = $this->dash_model->getImoveis($w);
            $anunciante->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$anunciante->id_cadastro],['tb_origem', 'cad_cadastro']]);
            
            if(!empty($anunciante->atendimento))
            {
                $proximo_contato = end($anunciante->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['anunciantesFinalizados'][] = $anunciante;
                }
                else
                {
                    $data['anunciantesProximoContato'][] = $anunciante;
                }
                unset($anunciantes[$k]);
            }
        }
        
        
        
        Assets::add_module_js('administrativo', array(
            /*'main',*/
            'anunciantes'
        ));
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        $data['anunciantes'] = $anunciantes;
        
        Template::set($data);
        Template::set_view('anunciantes_pf_view');
        Template::render();
    }
    
	public function migra_atendimento_captura()
    {
       $this->ini_method('index');
        //1 origem_captura, 2 tipo_interesse, 3 UUID
       $chaves = [
           ['avaliacao','Avaliação','avaliacao'],
           ['financiamento','Financiamento','financiamento'],
           //['interessado_signature','Signature','UUID'],
           //['interessado_elleven','Elleven','UUID'],
           ];
           
        foreach ($chaves as $chave)
        {
            $origem_captura = $chave[0];
            $tipo_interesse = $chave[1];
            $UUID           = $chave[2];
            $capturasGeral = $this->admin_model->getCapturasOrderBy([['origem_captura',$origem_captura]]);
            $capturas = [];
            foreach ($capturasGeral as $cap){
                $cap->atendimentos = $this->admin_model->getAtendimentoHistoricoDesc( [['email',$cap->email],['tipo_interesse',$tipo_interesse]   ]);
                $capturas[$cap->email] = $cap;
            }
            foreach ($capturas as $cap)
            {
                $tb_rel = 'cad_captura';
                $id_rel = $cap->id_captura;
                if(!empty($cap->atendimentos))
                {
                    $atend = $this->cad_model->getAtendimento([['id_rel',$id_rel],['tb_origem',$tb_rel]])[0]??null;
                    if($atend == null)
                        $id_atendimento = $this->cad_model->setAtendimento(['id_rel' => $id_rel, 'tb_origem' => $tb_rel]);
                    else
                        $id_atendimento = $atend->id_atendimento;
                        
                    foreach ($cap->atendimentos as $historico)
                    {
                        $historico->id_atendimento = $id_atendimento;
                        $historico->tipo_interesse = $UUID;
                        $this->cad_model->updateAtendimentoHistorico($historico->id_hist_atend, (array)$historico);
                    }
                }
                $this->cad_model->updateCaptura($id_rel, ['origem_captura' => $UUID]);
            }
        }
    }
    
    public function migra_atendimento_cadastro_bug()
    {
       $this->ini_method('index');
       
            $tipo_interesse = 'cadastro_bug';
            
            $cadastrosGeral = $this->admin_model->getCadastros();
            
            $atendimentos = [];
            foreach ($cadastrosGeral as $cad){
                
                if($cad->email != ''){
                    
                    
                    $cad->atendimentos = $this->admin_model->getAtendimentoHistoricoDesc( [ ['email',$cad->email],['tipo_interesse',$tipo_interesse]   ]);
                        if(!empty($cad->atendimentos))
                            $atendimentos[$cad->email] = $cad;
                }
            }
            
            foreach ($atendimentos as $cad)
            {
                if($cad->etapa < 8)
                {
                    $tb_rel = 'cad_cadastro';
                    $id_rel = $cad->id_cadastro;
                    $UUID   = 'cadastro_incompleto';
                }
                else{
                    $tb_rel = 'cad_cadastro';
                    $id_rel = $cad->id_cadastro;
                    $UUID   = 'cadastro_completo';
                }
                
                $atend = $this->cad_model->getAtendimento([['id_rel',$id_rel],['tb_origem',$tb_rel]])[0]??null;
                if($atend == null)
                    $id_atendimento = $this->cad_model->setAtendimento(['id_rel' => $id_rel, 'tb_origem' => $tb_rel]);
                else
                    $id_atendimento = $atend->id_atendimento;
                    
                foreach ($cad->atendimentos as $historico)
                {
                    $historico->id_atendimento = $id_atendimento;
                    $historico->tipo_interesse = $UUID;
                    $this->cad_model->updateAtendimentoHistorico($historico->id_hist_atend, (array)$historico);
                }
                
            }
        
    }
    
    function setNotificacoes($data = [])
    {
        
        $naoAguardandoRetorno = [];
        $naoAtendidas = [];
        
        //===============================RESUMO ATENDIMENTO================================================
        
        $whereSimulacoes       = [['fnc_simulacao.step <',4]];//,['step >=', 4]
        $whereAvaliacao        = [['origem_captura','avaliacao']];
        $whereQuestionario_001 = [['origem_captura','questionario_001']];
        $whereQuestionario_002 = [['origem_captura','questionario_002']];
        $whereInteresseCompra  = [['origem_captura','interesse_compra']];
        $whereEbookLagoNorte  = [['origem_captura','ebookLagoNorte']];
        $wherePreLancamentoPremium  = [['origem_captura','prelancamento_premium']];
        $whereConvite          = [['link','formConvite']];
        $whereCadIncompleto    = [['etapa <',8]];
        $whereCadCompleto      = [['etapa >=',8]];
        //1 - tb_origem / 2 - $name_id / 3 - $function_get / 4 -  $where / 5 - $tipo_interesse(cad_atendimento_historico)  / 6 -  $name(titulo)
        $configAtendimento = [
                ['fnc_simulacao', 'id_simulacao', 'getSimulacoes',     $whereSimulacoes,    'financiamento',       'Financiamentos'],
                ['cad_cadastro',  'id_cadastro',  'getCadastrosUsers', $whereCadIncompleto, 'cadastro_incompleto', 'Cadastros Incompletos'],
                ['cad_cadastro',  'id_cadastro',  'getCadastros',      $whereCadCompleto,   'cadastro_completo',   'Cadastros Completo'],
                ['cad_contato',   'id',           'getContatos',       [],                  'contato',             'Contatos'],
                ['cad_captura',   'id_captura',   'getCapturas',       $whereAvaliacao,     'avaliacao',           'LP Avaliação'],
                ['cad_captura',   'id_captura',   'getCapturas',       $whereQuestionario_001,      'questionario_001',    'Pesquisa - Casa ou Apartamento'],
                ['cad_captura',   'id_captura',   'getCapturas',       $whereQuestionario_002,      'questionario_002',    'Pesquisa - 3 ou 4 Quartos'],
                ['cad_captura',   'id_captura',   'getCapturas',       $whereInteresseCompra,     'interesse_compra',    'Interesse Compra'],
                ['cad_captura',   'id_captura',   'getCapturas',       $whereEbookLagoNorte,     'ebookLagoNorte',    'Ebook Lago Norte'],
                ['cad_captura',   'id_captura',   'getCapturas',       $wherePreLancamentoPremium,     'prelancamento_premium',    'Pré-lançamento Premium'],
                ['cad_captura',   'id_captura',   'getCapturas',       $whereConvite,     'convites',    'Convites'],
                //avaliacao_cep_nao	139
                //capturado LP financiamanto sem Simulacao
        ];
        
        foreach ($configAtendimento as $dt)
        {
            $tb_origem      = $dt[0];
            $name_id        = $dt[1];
            $function_get   = $dt[2];
            $where          = $dt[3];
            $UUID           = $dt[4];
            $name           = $dt[5];
            $link           = $dt[6]??"atendimento/comdono/$UUID";
            
            $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas($tb_origem, $name_id, $function_get, $where, $UUID);
            //if(!empty($CapturasNaoAtendidas)){
            $naoAtendidas[] = (object)[
                    'UUID'     => $UUID,
                    'key'      => $tb_origem,
                    'name'     => $name,
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => "$link#novos",
                ];
            //}
             
            $CapturasAtendidas = $this->admin_model->getAguardandoRetorno($tb_origem, $name_id, $function_get, $where, $UUID);
            if(!empty($CapturasAtendidas)){
                $naoAguardandoRetorno[] = (object)[
                        'UUID'     => $UUID,
                        'key'      => $tb_origem,
                        'name'     => $name,
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => "$link#retornos",
                    ];
            }
        }
        
        $data['naoAtendidas'] = $naoAtendidas;
        $data['naoAguardandoRetorno'] = $naoAguardandoRetorno;
        
        return $data;
    }
    
	public function dataTables()
	{
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',
            '../comdono/plugins/dataTables/js/config'
        ));
	}
	
	
   
   
   
   
   
   
   
   
   
   
   
    
}
