<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Interesse extends Grocery {

    function __construct() 
    {
        parent::__construct();
		//$this->load->model('administrativo/admin_model');
		//$this->load->model('administrativo/dash_model');
		//$this->load->model('minha_conta/conta_model');
		
		Assets::add_module_js('comdono', array(
            'main'
        ));
        $this->dataTables();
    }
    
    function resumo()
    {
        $this->ini_method();
        
        Assets::add_css(array(
            '../comdono/plugins/timeLine/css/style'
        ));
        
        Assets::add_module_js('atendimento', [
            'interesse/interesse'
        ]);
        
        $data['id_responsavel'] = $this->session->id_cadastro;
        
        
        Template::set($data);
        Template::set_view('atendimento/interesse/resumo_view');
        Template::render();
        
    }
    
    function visualizar($id_interesse){
        
        $this->ini_method('resumo');
        
        $data_interesse = $this->cad_model->getInteresse([['id_interesse', $id_interesse]]);
        
        $data_bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $id_interesse]]);
        //dd($data_bairros);
        //dd($data);
        
        if($data_interesse->quartos == 4){
	        $quartos = 'quartos >=';
	    }
        else{
            $quartos = 'quartos';
        }	    
	    
	    if($data_interesse->banheiro == 4){
	        $banheiros = 'banheiros >=';
	    }
	    else{
	        $banheiros = 'banheiros';
	    }
	    
	    if($data_interesse->vagas == 4){
	        $vaga = 'vaga >=';
	    }
	    else{
	        $vaga = 'vaga';
	    }
        
        $imoveis = [];
        
        foreach($data_bairros as $b){
	        //dd($b);
    	    $where = array(
    	        'status' => 3,
    	        'id_imovel_rel' => 0,
                'tipo_imovel'  => $data_interesse->tipo_imovel,
                'bairro LIKE' => '%'.$b->bairro.'%',
                $quartos => $data_interesse->quartos,
                $banheiros => $data_interesse->banheiro,
                $vaga => $data_interesse->vagas, 
                'val_pretendido >=' => $data_interesse->faixa_preco_inicio,
                'val_pretendido <=' => $data_interesse->faixa_preco_fim,
            );
            
            foreach (array_keys($where) as $w){
                if(($where[$w] == '%%'|| $where[$w] == '' || $where[$w] == '0' || $where[$w] == '%Brasília%') && $w != 'id_imovel_rel'){
    		        unset($where[$w]);
    	        }
            }
            
	     
    	    $imoveis_selecionados = $this->cad_model->getImoveis($where);
    	    if(!empty($imoveis_selecionados)){
                    	        
                $imoveis = array_merge($imoveis,$imoveis_selecionados);
                
                foreach($imoveis as $im) { 
                    $im->val_pretendido = money($im->val_pretendido);
                    $imagens = $this->cad_model->getImgsImovel($im->id_imovel);
                    if(!empty($imagens)){
                        
                        $img = $imagens[0];
                    
                        $foto = $img->uri.$img->imagem;
                        if($img->uri == '' || $img->imagem == ''){
                            $foto = '';
                        }
                    }
                    else{
                        $foto = base_url('themes/comdono/img/no-image.png');
                    }
                    $im->foto = $foto;
                }
    	    }
    	    else{
    	        continue;
    	    }
            if($b->bairro == 'Brasília'){
                break;
            }
	    }
	    
	    if($imoveis != NULL || $imoveis != []){
	        $data['imoveis'] = $imoveis;
	    }else{
	        $data['imoveis'] = [];
	    }
	    
	    $data['captura'] = $this->cad_model->getCaptura([['id_captura',$data_interesse->id_captura]]);
	    $data['interesse'] = $data_interesse;
	    $data['interesse_bairros'] = $data_bairros;
	    
	    Assets::add_module_js('atendimento', array('atendimento_geral','interesses'));
	    
	    Template::set($data);
        Template::set_view('interesse_view');
        Template::render();
    }
    
    public function dataTables()
    {
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
            '../comdono/plugins/daterangepicker-v3.14/daterangepicker',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',//diferente
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            /*'../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',*/
            '../comdono/plugins/dataTables/js/config',
            '../comdono/plugins/datetimepicker/js/moment',
            '../comdono/plugins/daterangepicker-v3.14/daterangepicker.min',//diferente
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',//diferente
        ));
	}
	
	
    
    
}