<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Atendimento_ajax extends Admin_Controller {

	function __construct()
	{
        parent::__construct();
        
        if($this->session->perfil == 0)
        {
	        echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Acesso negado!']);
	        die();
		}
		$this->load->library('form_validation');
        $this->load->library('newsletter/newsletter');
        $this->load->library('comdono/notification');
        
        $this->load->helper('incorporadora/incorporadora');
        
        $this->load->model('comdono/cad_model');
		$this->load->model('administrativo/admin_model');
	}
	
	
	public function atendimentoRapido()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
        $this->form_validation->set_rules('id_leed',    'id_leed',    'required|trim');
        $this->form_validation->set_rules('origem',     'origem',     'required|trim');
        $this->form_validation->set_rules('UUID',       'UUID',       'required|trim');
        
        $post = $this->input->post();
		if(($post['dias']??'') == 'personalizado' && ($post['novo_contato']??'') == 'sim')
		    $this->form_validation->set_rules('proximo_contato','Quando?','required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            if(($post['id_leed']??'') != '' && ($post['origem']??'') != ''){
                $post['data_hora'] = date("Y-m-d H:i:s");
                $dias = $post['dias']??1;
                $proximo_contato = '';
                if(($post['novo_contato']??'') == 'sim')
                {
                   if($dias == 'personalizado')
                   {
                       $proximo_contato = $post['proximo_contato'];
                   }
                   else
                   {
                       $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+$dias, date("Y")));
                   }
                }
    	        $this->insertAtendimentoRel($post['id_leed'], $post['origem'], $post['observacao'], $post['UUID'],  $proximo_contato);
    	        $json = ['valid' => true, 'msg' => 'Sucesso'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function add_atendimento()
	{
	    $post = $this->input->post();
	    
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('id_atendimento',    'id_atendimento',    'required|trim');
        $this->form_validation->set_rules('tipo_interesse',     'Interesse',     'required|trim');
        if(($post['agendar_visita']??'') == 'sim')
            $this->form_validation->set_rules('tipo_agendamento',     'Tipo agendamento',     'required|trim');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
        
		if(($post['dias']??'') == 'personalizado' && ($post['novo_contato']??'') == 'sim')
            $this->form_validation->set_rules('proximo_contato','Quando?','required|trim');
        
        if ($this->form_validation->run() != FALSE) 
        {
            $post['data_hora'] = date("Y-m-d H:i:s");
            $dias = $post['dias']??1;
            $proximo_contato = '';
            if(($post['novo_contato']??'') == 'sim')
            {
               if($dias == 'personalizado')
               {
                   $proximo_contato = $post['proximo_contato'];
               }
               else
               {
                   $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+$dias, date("Y")));
               }
            }
            
            $post['id_user'] = $this->session->id_cadastro;
            $post['data_hora'] = date("Y-m-d H:i:s");
            
            if(($post['agendar_visita']??'') == 'sim')
            {
                
                $post['id_responsavel'] = $this->session->id_cadastro;
                $post['data_hora_agendamento'] = converte_datahora($post['data_hora_agendamento'], 2);
                
                //------MODELO
                $AtendimentoInicial = $this->admin_model->getAtendimento([['id_atendimento',$post['id_atendimento'] ]]);
	            $cap = $this->admin_model->getRow('cad_captura', ['id_captura', $AtendimentoInicial->id_rel]);
                $parceiro = $this->cad_model->getParceiro(['id_parceiro', $cap->id_parceiro]);
                
                if($parceiro->distribuicao_leed == 0){
                    $wvd = [['inc_escala.id_parceiro',$post['id_parceiro']]];
                    $vendedor = $this->admin_model->getProximoVendedorDisponivel($post['id_destino'], $post['data_hora_agendamento'],$wvd);
                    if($vendedor == null){
                        $json = ['valid' => false,'msg' => "Nenhum vendedor disponivel para esse horario"];
                        echo json_encode($json);
                        die();
                    }
                    $id_vendedor = $vendedor->id_cadastro;
                }
                else{
                    $wvd[] = ['inc_escala.id_parceiro',$post['id_parceiro']];
                    $vendedores = $this->admin_model->getMembrosDisponiveis($post['id_destino'], $post['data_hora_agendamento'], 3, $wvd); 
                    if(empty($vendedores)){
                        $json = ['valid' => false,'msg' => "Nenhum vendedor disponivel para esse horario"];
                        echo json_encode($json);
                        die();
                    }
                    $id_vendedor = 0;
                }
                //------MODELO
                
                
                
                //-------altera status da captura parar 3, cartao ativado ou visita agendada--------
                $this->cad_model->updateCaptura($cap->id_captura,['status_captura'=> 3]);
                //----------------------------------------------------------------------------------
                
                $participantes['id_responsavel'] = $id_vendedor;
                $participantes['participantes'] = $post['id_participantes'];
                $participantes['id_interessado'] = $post['id_interessado'];
                $post['participantes'] = json_encode($participantes);
                
                $this->cad_model->insertAgenda($post);
                
                Notification::empreendimentoMembro($post['id_destino'], $id_vendedor, 'nv_visita_vendedor');
                //Notification::empreendimentoFuncao($post['id_destino'], 2,                      'nv_visita_diretor');
                Notification::empreendimentoDiretoresParceiro($post['id_destino'], $post['id_parceiro'], 'nv_visita_diretor');
            }
            
            $id_atendimento_historico = $this->cad_model->setAtendimentoHistorico($post);
            
            if($id_atendimento_historico){
                $json = ['valid' => true, 'id_atendimento'=> $id_atendimento_historico,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	    
	}
	
	
	
	public function atualizarDataCad()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('data_nascimento', 'Data de nascimento', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post['data_nascimento'] = $this->input->post('data_nascimento');
            $id_cadastro = $this->input->post('id_leed');
            
	        $this->admin_model->updateCadastro($id_cadastro, $post);
	        
	        $json = ['valid' => true, 'msg' => 'Sucesso'];
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function novoAtendimento()//versao atual -> atendimentoRapido()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            $post['data_hora'] = date("Y-m-d H:i:s");
            
            
            if(($post['id_leed']??'') != '' && ($post['origem']??'') != ''){
                
                $proximo_contato = '';
                if(($post['novo_contato']??'') == 'sim')
                    $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+1, date("Y")));
                    
    	        $this->insertAtendimentoRel($post['id_leed'], $post['origem'], $post['observacao'], 'Anunciante ativo',  $proximo_contato);
    	        
    	        $json = ['valid' => true, 'msg' => 'Sucesso'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function insertAtendimentoRel($id_rel, $tb_rel, $observacao, $tipo_interesse = '',  $proximo_contato = '', $proximo_contato_motivo = '')
	{
	    $atend = $this->cad_model->getAtendimento([['id_rel',$id_rel],['tb_origem',$tb_rel]])[0]??null;
        if($atend == null)
            $id_atendimento = $this->cad_model->setAtendimento(['id_rel' => $id_rel, 'tb_origem' => $tb_rel]);
        else
            $id_atendimento = $atend->id_atendimento;
        
        $insertAtendimento = [
                'id_atendimento' => $id_atendimento,
                'id_user' => $this->session->id_cadastro,
                'data_hora' => date("Y-m-d H:i:s"),
                'tipo_interesse' => $tipo_interesse,
                'observacao' => $observacao,
                'proximo_contato' => $proximo_contato,
                'proximo_contato_motivo' => $proximo_contato_motivo,
            
            ]; 
            
    	return $this->cad_model->setAtendimentoHistorico($insertAtendimento);
	}
	
	
	//antigo
	public function ini_atendimento()
	{
	    $post = $this->input->post(); 
	    
	    $data['nome']      =  $this->input->post('nome')??'';
	    $data['email']     =  $this->input->post('email')??'';
	    $data['telefone']  =  $this->input->post('telefone')??'';
	    $data['id_rel']    =  $this->input->post('id_rel')??'';
	    $data['tb_origem'] =  $this->input->post('tb_origem')??'';
	    
        if ($data['id_rel'] != '' && $data['tb_origem'] != '') 
        {
            $atend = $this->cad_model->getAtendimento([['id_rel',$data['id_rel']],['tb_origem',$data['tb_origem']]])[0]??null;
            $json = $this->setAtendimento($atend,$data);
            
        }
	    elseif($data['email'] != '')
        {
            $atend = $this->cad_model->getAtendimento([['email', $data['email']]])[0]??null;
            $json = $this->setAtendimento($atend,$data);
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Email Invalido!'];
        }
        echo json_encode($json);
	    
	}
	
	//antigo
	private function setAtendimento($atend,$data)
	{
	        if($atend == null)
                $id_atendimento = $this->cad_model->setAtendimento($data);
            else
                $id_atendimento = $atend->id_atendimento;
            
            if($id_atendimento){
                return ['valid' => true, 'id_atendimento'=> $id_atendimento,'msg' => 'Sucesso!'];
            }
            else{
                return ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
	}
	
	
	public function finaliza_atendimento()
	{
	    $post = $this->input->post(); 
	    
	    $this->form_validation->set_rules('motivo', 'Motivo', 'required|trim');
	    
        if ($this->form_validation->run() != FALSE) 
        {
            $id_captura = $post['id'];
            $this->cad_model->updateCaptura($id_captura, ['status_captura' => 10, 'motivo' => $post['motivo']]);
            Newsletter::removeAllTagsCap($id_captura);
            
            $json = ['valid' => true, 'msg' => 'Sucesso!', 'post' => $post];
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function send_email_again()
	{
	    $post = $this->input->post(); 
	    
	    $email      =  $post['email'];
	    $id_campanha = $post['id_campanha'];
	    unset($post['email']);
	    unset($post['id_campanha']);
        
        if( $this->newsletter->envia($email, $id_campanha, $post) )
        {
            $json = ['valid' => true, 'msg' => 'E-mail reenviado com sucesso!'];
        }
        else
        {
            $json = ['valid' => false, 'msg' => 'Erro ao reenviar e-mail, tente novamente!'];
        }

        echo json_encode($json);
	}
	
	public function ativa_suahouse(){
	    $id_captura = $this->input->post('id_captura');
	    
	    if($id_captura != NULL){
	        $data = ['sua_house' => 1];
	        $up = $this->cad_model->updateCaptura($id_captura, $data);
	        
	        if($up > 0){
	            $retorno = ['valid' => true, 'msg' => 'Adicionado com sucesso!'];
	        }else{
	            $retorno = ['valid' => false, 'msg' => 'Falha de comunicação com o banco de dados, tente novamente!'];
	        }
	    }else{
	        $retorno = ['valid' => false, 'msg' => 'Nenhum cliente foi enviado!'];
	    }

        echo json_encode($retorno);
	}
	
	
	public function email_propostas()
    {
        $id_simulacao = $this->input->post('id');
        $simulacao = $this->admin_model->getSimulacaoFinanciamento(['a.id_simulacao'=>$id_simulacao]);
        if(count($simulacao->bancos??[]) > 0){
            
            $data['anexo'] = [];
            foreach ($simulacao->bancos as $banco)
            {
                if($banco->file_url != '')
                    $data['anexo'][] = $banco->file_url;
            }
             
            if(!empty($data['anexo'])){
                
                $cad_interessado = $this->admin_model->getCadastro([['id_cadastro', $simulacao->id_cad_interessado]]);
                
                $data['linkcustom'] = base_url().'minha_conta/minhas_compras/comparativo/'.$id_simulacao;
                $data['nome_comprador'] = primeiroNome($cad_interessado->nome);
                if($this->newsletter->envia($cad_interessado->email, 56, $data))
                {
                    $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+2, date("Y")));
                    $this->insertAtendimentoRel($id_simulacao, 'fnc_simulacao', 'Enviou email propostas', 'financiamento_completo',  $proximo_contato); 
                    
                    
                    $simulacao->email_propostas++;
                    if($simulacao->historico_email != '')
                    {
                        $historico_email = json_decode($simulacao->historico_email);
                        $historico_email[] = ['anexo' => $data['anexo'], 'data'=> date("Y-m-d H:i:s")];
                        $simulacao->historico_email = json_encode($historico_email);
                    }
                    else
                    {
                        $simulacao->historico_email = json_encode([['anexo' => $data['anexo'], 'data'=> date("Y-m-d H:i:s")]]);
                    }
                    
                    $this->admin_model->updateSimulacao($simulacao->id_simulacao,(array)$simulacao);
                    
                    $json = ['valid' => true,'msg' => 'Email enviado com Sucesso!'];
                }
                else{
                    $json = ['valid' => false,'msg' => 'erro!'];
                }
                
            }else
            {
                $json = ['valid' => false,'msg' => 'erro! Nenhum PDF anexo encontrado!'];
            }
                
        }else{
            $json = ['valid' => false,'msg' => 'erro! Nenhum Banco Cadastrado!'];
        }
        
        echo json_encode($json);
    }
	
	
	
	public function linhatempo_capturas(){
	    
	     $post = $this->input->post();
        
        if($post['uuid'] != ''){
            
            $intervalo = explode(' - ',$post['intervalo']);
            $data_inicio = converte_data($intervalo[0],1).' 00:00:00';
            $data_fim = converte_data($intervalo[1],1).' 23:59:59';
            
            $capturas = $this->cad_model->getCapturasOrigem([['origem_captura', $post['uuid']],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim]]);
            
            echo json_encode(['success' => true, 'capturas' => $capturas]);
        }
	    
	}
	
	public function linhatempo_google(){
	    
	     $post = $this->input->post();
        
        if($post['uuid'] != ''){
            
            $intervalo = explode(' - ',$post['intervalo']);
            $data_inicio = converte_data($intervalo[0],1).' 00:00:00';
            $data_fim = converte_data($intervalo[1],1).' 23:59:59';
            
            $capturas = $this->cad_model->getCapturasOrigem([['origem_captura', $post['uuid']],['utm_source','google'],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim]]);
            
            echo json_encode(['success' => true, 'capturas' => $capturas]);
        }
	    
	}
	
	public function linhatempo_facebook(){
	    
	     $post = $this->input->post();
        
        if($post['uuid'] != ''){
            
            $intervalo = explode(' - ',$post['intervalo']);
            $data_inicio = converte_data($intervalo[0],1).' 00:00:00';
            $data_fim = converte_data($intervalo[1],1).' 23:59:59';
            
            $capturas = $this->cad_model->getCapturasOrigem([['origem_captura', $post['uuid']],['utm_source','facebookads'],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim]]);
            
            echo json_encode(['success' => true, 'capturas' => $capturas]);
        }
	    
	}
	
	
    /*public function linhatempo_empreendimento_bk(){
        
        $post = $this->input->post();
        
        if($post['uuid'] != ''){
            
            $empreendimento = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$post['uuid']]]);
            
            $intervalo = explode(' - ',$post['intervalo']);
            $data_inicio = converte_data($intervalo[0],1).' 00:00:00';
            $data_fim = converte_data($intervalo[1],1).' 23:59:59';
            
            $leads = $this->getClientes($empreendimento->id_empreendimento,$data_inicio,$data_fim);
            dd($leads);
            
            $data['capturas'] = $this->cad_model->getCapturas([['origem_captura', $post['uuid']],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim]]);
            
            $data['pre_cadastros'] = $this->cad_model->getCapturas([['origem_captura',$post['uuid']],['status_captura','0'],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim],['email NOT LIKE','%@comdono.com']]);
            $data['cartoes'] = $this->admin_model->getCartaoVipRelatorio([['cad_captura.origem_captura',$post['uuid']],['cad_captura.status_captura', '3'],['cad_captura.datetime_captura >=',$data_inicio],['cad_captura.datetime_captura <=',$data_fim]]);
            $data['visitas'] = $this->admin_model->getAgendasRelatorios([['id_destino',$empreendimento->id_empreendimento],['status_agenda >=','0'],['status_agenda <=','1'],['age_agenda.data_hora_agendamento >=',$data_inicio],['age_agenda.data_hora_agendamento <=',$data_fim]]);
            $data['pre_reservas'] = $this->admin_model->getPreReservasCompleta([['origem_captura',$post['uuid']],['n.step','0'],['ngc_pre_reserva.data_prereserva >=',$data_inicio],['ngc_pre_reserva.data_prereserva <=',$data_fim]]);
            $data['negociacoes'] = $this->admin_model->getPreReservasCompleta([['origem_captura',$post['uuid']],['n.step >=','1'],['n.step <=','2'],['ngc_pre_reserva.data_prereserva >=',$data_inicio],['ngc_pre_reserva.data_prereserva <=',$data_fim]]);
            $data['vendidos'] = $this->admin_model->getPreReservasCompleta([['origem_captura',$post['uuid']],['n.step','3'],['ngc_pre_reserva.data_prereserva >=',$data_inicio],['ngc_pre_reserva.data_prereserva <=',$data_fim]]);
            $desistencias_negociacoes = $this->admin_model->getAgendasCompleta([['id_destino',$empreendimento->id_empreendimento],['age_agenda_historico.status_agenda','5'],['age_agenda_historico.datetime >=',$data_inicio],['age_agenda_historico.datetime <=',$data_fim]]);
            
            $data['desistencias']['negociacao'] = [];
            $data['desistencias']['visitacao'] = [];
            foreach($desistencias_negociacoes as $desistiu){
                $historico = $this->admin_model->getUltimaDesistencia([['id_agenda',$desistiu->id_agenda]]);
                
                foreach ($historico as $k=>$hist){
                    $hist->status   = HAgenda::status($hist->status_agenda);
                    if($k == 0 || end($historicoAgenda)->status_agenda != $hist->status_agenda)
                        $desistiu->ultima_etapa = $hist;
                }
                //Desistiu na negociacao
                if($desistiu->ultima_etapa->status_agenda >= 2 && $desistiu->ultima_etapa->status_agenda <= 4){
                    $visita = $this->cad_model->getVisita([['id_agenda',$desistiu->id_agenda]]);
                    $negociacao = $this->cad_model->getNegociacao([['id_visita',$visita->id_visita]]);
                    
                    if($visita->motivo_desistencia != ''){
                        $desistiu->justificativa_negociacao = $visita->motivo_desistencia??'';
                    }else{
                        $desistiu->justificativa_negociacao = $negociacao->justificativa??'';
                    }
                    
                    $data['desistencias']['negociacao'][] = $desistiu;
                }else{
                    $visita = $this->cad_model->getVisita([['id_agenda',$desistiu->id_agenda]]);
                    $desistiu->justificativa_negociacao = $visita->motivo_desistencia??'';
                    $data['desistencias']['visitacao'][] = $desistiu;
                }
                
            }
            
            $data['desistencias_captura'] = $this->cad_model->getCapturas([['origem_captura',$post['uuid']],['status_captura','10'],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim]]);
            
            Template::load_view('atendimento/linhatempo', $data, '', '', $html);
            
            echo json_encode(['success' => true, 'html' => $html, 'data' => $data]);
        }
    }*/
    
    public function linhatempo_empreendimento(){
        
        $post = $this->input->post();
        
        if($post['uuid'] != ''){
            
            $empreendimento = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$post['uuid']]]);
            
            $intervalo = explode(' - ',$post['intervalo']);
            $data_inicio = converte_data($intervalo[0],1).' 00:00:00';
            $data_fim = converte_data($intervalo[1],1).' 23:59:59';
            
            
            $parceiros = $this->cad_model->getParceirosRelEmpreendimento([['id_empreendimento',$empreendimento->id_empreendimento]]);
            
            $where_parceiro = [];
            if($parceiros != null)
                foreach ($parceiros as $parceiro)
                {
                    $where_parceiro[] = ['id_parceiro', $parceiro->id_parceiro];
                }
                
            $where_pre_cadastros = [['origem_captura',$post['uuid']],['status_captura','0'],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim],['email NOT LIKE','%@comdono.com'],['link !=', 'formConvite']];
            $where_pre_cadastros = array_merge($where_pre_cadastros,$where_parceiro);
            
            $data['pre_cadastros'] = $this->cad_model->getCapturas($where_pre_cadastros);
            
            $data['prim_visita'] = [];
            $data['reagendados'] = [];
            $data['negociacoes'] = [];
            $data['leads_soltos'] = [];
            $data['reservados'] = [];
            $data['em_aprovacao'] = [];
            $data['aprovados'] = [];
            $data['cancelados'] = [];
            $data['desistencias'] = [];
            
            
            $agendas = [];
            
            $whereAgendas = [];
            $whereAgendas[] = ['datetime_captura >=',$data_inicio];
            $whereAgendas[] = ['datetime_captura <=',$data_fim];
            
            foreach ($parceiros as $parceiro)
                $whereAgendas['or_paceiro'][] = ['id_parceiro', $parceiro->id_parceiro];
                
            $agendas = $this->cad_model->order_by(['datetime_captura'=>'DESC'])->getCapAgendas($whereAgendas);
            
            
            foreach($agendas as $agenda){
                //$agenda->interessado = (array)$this->cad_model->getCadastro(['id_cadastro', $agenda->participantes->id_interessado]);
                //$captura = (array)$this->cad_model->getCaptura([['id_cadastro', $agenda->participantes->id_interessado],['origem_captura',$post['uuid']],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim]]);
                $agenda->interessado = $this->cad_model->getCaptura([['id_cadastro', $agenda->participantes->id_interessado],['origem_captura',$post['uuid']]]);
                
                //$agenda->interessado = array_merge($agenda->interessado,$captura);
                //$agenda->interessado = (object)$agenda->interessado;
                if($agenda->interessado != null){
                    $agenda->interessado->data_hora_agendamento = $agenda->data_hora_agendamento;
                    $agenda->interessado->corretor = $this->cad_model->getCadastro(['id_cadastro', $agenda->participantes->id_responsavel]);
                }
                /*if($agenda->interessado == null)
                    continue;*/
                
                /*$teste = $this->getCliente(['id_cadastro', $agenda->interessado->id_cadastro]);
                if($teste == null)
                    continue;*/
                
                $agenda->interessado->negociacao = $this->cad_model->getEstoqueNegociacao([['id_cliente', $agenda->interessado->id_cadastro],['status_negociacao >', 1]]);
                $agenda->interessado->historico = $this->setHistoricoAgenda($agenda->id_agenda);
                if($agenda->interessado->negociacao != null)
                    $agenda->interessado->unidade = $this->cad_model->getEstoqueUnidade(['id_unidade', $agenda->interessado->negociacao->id_unidade]);
                
                
                if(!empty($agenda))
                    switch($agenda->status_agenda){
                        case 0:
                            $data['prim_visita'][] = $agenda->interessado;
                            break;
                        case 1:
                            $data['reagendados'][] = $agenda->interessado;
                            break;
                        case 3:
                            $data['reservados'][] = $agenda->interessado;
                            break;
                        case 4:
                            $data['negociacoes'][] = $agenda->interessado;
                            break;
                        case 5:
                            $data['desistencias'][] = $agenda->interessado;
                            break;
                        case 7:
                            $data['aprovados'][] = $agenda->interessado;
                            break;
                        case 9:
                            $agenda->interessado->negociacao = $this->cad_model->getEstoqueNegociacaoCancelada([['id_cliente', $agenda->interessado->id_cadastro],['status_negociacao', 0]]);
                            if($agenda->interessado->negociacao != null)
                                $agenda->interessado->unidade = $this->cad_model->getEstoqueUnidade(['id_unidade', $agenda->interessado->negociacao->id_unidade]);
                            $data['cancelados'][] = $agenda->interessado;
                            break;
                        case 10:
                            $data['negociacoes'][] = $agenda->interessado;
                            break;
                        case 11:
                            $data['reservados'][] = $agenda->interessado;
                            break;
                        case 12:
                            $data['em_aprovacao'][] = $agenda->interessado;
                            break;
                        case 13:
                            $data['aprovados'][] = $agenda->interessado;
                            break;
                        default:
                            $data['leads_soltos'][] = $agenda->interessado;
                            break;
                    }
                    
                    
            }
            
            //$data['desistencias_captura'] = $this->cad_model->getCapturas([['origem_captura',$post['uuid']],['status_captura','10'],['datetime_captura >=',$data_inicio],['datetime_captura <=',$data_fim]]);
            
            
            Template::load_view('atendimento/linhatempo', $data, '', '', $html);
            
            echo json_encode(['success' => true, 'html' => $html, 'data' => $data]);
        }
    }
    
    private function setHistoricoAgenda($id_agenda)
    {
        $historico = $this->admin_model->getAgendaHistorico(['id_agenda', $id_agenda]);
        
        $historicoAgenda = [];
        foreach ($historico as $k=>$hist){
            $hist->status   = HAgenda::status($hist->status_agenda);
            
            if($hist->data_hora_agendamento == '0000-00-00 00:00:00')
                $hist->data_hora_agendamento = false;
            else{
                if($hist->status_agenda == 0)
                    $hist->data_hora_agendamento = dataHora($hist->data_hora_agendamento);
                else
                    $hist->data_hora_agendamento = dataHora($hist->datetime);
            }
                
            
            if($k == 0 || end($historicoAgenda)->status_agenda != $hist->status_agenda){
                $historicoAgenda[] = $hist;
            }
        }
        return $historicoAgenda;
    }
    
	
}