<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Incorporadora_ajax extends Admin_Controller {

	function __construct()
	{
        parent::__construct();
        require APPPATH . 'libraries/vendor/autoload.php';
        
        if(($this->session->perfil??0) == 0)
        {
	        echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Acesso negado!']);
	        die();
		}
		
        $this->load->model('comdono/cad_model');
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
        $this->load->library('newsletter/newsletter');
        $this->load->library('comdono/notification');
	}
	
	
	public function atendimentoRapido()
	{
	    $this->load->library('form_validation');
        $this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            
            if(($post['id_leed']??'') != '' && ($post['origem']??'') != ''){
                
                $proximo_contato = '';
                if(($post['novo_contato']??'') == 'sim')
                    $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+1, date("Y")));
                    
    	        $this->insertAtendimentoRel($post['id_leed'], $post['origem'], $post['observacao'], $post['UUID'],  $proximo_contato);
    	        
    	        $json = ['valid' => true, 'msg' => 'Sucesso'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	}
	
	public function insertAtendimentoRel($id_rel, $tb_rel, $observacao, $tipo_interesse = '',  $proximo_contato = '', $proximo_contato_motivo = '')
	{
	    $atend = $this->cad_model->getAtendimento([['id_rel',$id_rel],['tb_origem',$tb_rel]])[0]??null;
        if($atend == null)
            $id_atendimento = $this->cad_model->setAtendimento(['id_rel' => $id_rel, 'tb_origem' => $tb_rel]);
        else
            $id_atendimento = $atend->id_atendimento;
        
        $insertAtendimento = [
                'id_atendimento' => $id_atendimento,
                'id_user' => $this->session->id_cadastro,
                'data_hora' => date("Y-m-d H:i:s"),
                'tipo_interesse' => $tipo_interesse,
                'observacao' => $observacao,
                'proximo_contato' => $proximo_contato,
                'proximo_contato_motivo' => $proximo_contato_motivo,
            
            ];
    	return $this->cad_model->setAtendimentoHistorico($insertAtendimento);
	}
	
	public function adiaAtendimento(){
	    $data = $this->input->post();
	    
	    $data['status'] = 3;
	    
	    $post['id_fila'] = $data['id_fila'];
	    
	    unset($data['id_fila']);
	    
	    $adiar = $this->admin_model->updateFila($post['id_fila'],$data);
	    
	    if($adiar != FALSE){
            $json = ['success' => true, 'link' => base_url('atendimento/incorporadoras')];
        }else{
            $json = ['success' => false, 'msg' => 'Falha de Comunicação!'];
        }
        
        echo json_encode($json);
	}
	
	public function remarcarAgenda(){
	    $post = $this->input->post();
	    
	    if($post['id_agenda'] != NULL){
	        if($this->cad_model->updateAgenda($post['id_agenda'],['status_agenda'=>1])){
	            $json = ['success' => true];
	        }else{
	            $json = ['success' => false, 'msg' => 'Falha de Comunicação!'];
	        }
	    }else{
	        $json = ['success' => false, 'msg' => 'Agenda não encotrada!'];
        }
        
        echo json_encode($json);
	}
	
	public function cancelaAgenda(){
        $post = $this->input->post();
        
        if($post['id_agenda'] != NULL){
            if($this->cad_model->updateAgenda($post['id_agenda'],['status_agenda'=>9])){
                $json = ['success' => true];
            }else{
                $json = ['success' => false, 'msg' => 'Falha de Comunicação!'];
            }
        }else{
            $json = ['success' => false, 'msg' => 'Agenda não encotrada!'];
        }
        
        echo json_encode($json);
	}
	
	public function getCapturasNaoAtendidas()
    {
        $UUID = $this->input->post('UUID');
        
        $capturas = $this->admin_model->getCapturasNaoAtendidas([['origem_captura', $UUID],['tipo_atendimento',0]]);
        foreach ($capturas as $k=>$captura)
        {
            $captura = $this->montaRowCapturaIncorporadora($captura);
        }
        echo json_encode($capturas);
    }
	
	public function getCapAguardandoRetorno()
    {
        $UUID = $this->input->post('UUID');
        
            
        $capturas = $this->admin_model->getCapAguardandoRetorno([['origem_captura', $UUID],['tipo_atendimento',0]]);
        foreach ($capturas as $k=>$captura)
        {
            $captura = $this->montaRowCapturaIncorporadora($captura);
        }
        echo json_encode($capturas);
    }
    
	public function getCapturasAtendimentoFinalizado()
    {
        $UUID = $this->input->post('UUID');
        
        $capturas = $this->admin_model->getCapturasAtendimentoFinalizado([['origem_captura', $UUID],['tipo_atendimento',0]]);
        foreach ($capturas as $k=>$captura)
        {
            $captura = $this->montaRowCapturaIncorporadora($captura);
        }
        echo json_encode($capturas);
    }
	
	function montaRowCapturaIncorporadora($captura)
	{
	    
	   $id = $captura->id_captura; 
	    
	   $captura->empreendimento = 'asd';
	   
	   $nenv = '<span class="d-none">000000000</span>'.'<span class="badge badge-danger">Não enviado</span>'; 
       $denv = '<span class="d-none">'.$captura->datetime_captura.'</span>'.(date("d/m/Y H:i:s", strtotime($captura->datetime_captura)));
	   $captura->datetime_captura = $captura->datetime_captura == 0 ? $nenv:$denv;
	   
	   $captura->nome = '<span class="d-none">'.$captura->datetime_captura.'</span>'.$captura->nome;
	   
	   //$captura->situacao = HCaptura::lp('empreendimento')->captura($captura)->bgStatus() ;
	   
	   $captura->ultimo_atendimento  = $captura->observacao??'';
	   $captura->proximo_contato     = $captura->proximo_contato??'';
	   $captura->situacao = HCaptura::lp('empreendimento')->captura($captura)->bgStatus();
	   
	   $parceiro = $this->cad_model->getParceiro(['id_parceiro', $captura->id_parceiro]);
	   
	   $captura->parceiro            = $parceiro->par_razao_social??'';
	   
	   if($parceiro != null)
	   {
            if($parceiro->tipo_atendimento == 1 && $captura->status_captura == 3){
                $captura->situacao = '<span class="badge badge-success">Ativado</span>';
            }
            
	   }
	   
	   //addAtendimentoGeral
	   $captura->actions = '<button class="btn btn-sm btn-primary mr-1 set_leed" data-id="'.$id.'" data-toggle="modal" data-target="#atendimentoRapidoModal" data-toggle="tooltip" data-original-title="Atendimento rápido">
            <i class="icon-plus"></i>
        </button>';
	   
	   $captura->actions .= '<button class="btn btn-sm btn-outline-success mr-1 addAtendimentoIncorporadora set_leed" data-id="'.$id.'" data-toggle="tooltip" data-original-title="Atendimento completo">
            <i class="icon-check"></i>
        </button>';
	   
	   /*$captura->actions .= '<button class="btn btn-sm btn-outline-danger mr-1 set_leed" data-id="'.$id.'" type="button" data-toggle="modal" data-target="#finalizarAtendimentoModal" data-toggle="tooltip" data-original-title="Finalizar Atendimento">
                <i class="icon-dislike"></i>
            </button>';*/
        
           
	   return $captura; 
	}
	
    public function troca_atendimento(){
        
        $post = $this->input->post();
        
        if($post != NULL){
           $captura = $this->cad_model->getCaptura([['id_captura',$post['id_captura']]]);
           
            if($captura != NULL){
                $atendimento = $this->admin_model->getStatusFila('id_origem = '.$captura->id_captura.' AND origem = 2');
                
                if($atendimento != NULL){
                    $json = ['success' => true, 'link' => base_url('atendimento/incorporadoras/atendimento/agendamento/'.$captura->id_captura)];
                }else{
                    $status = ['origem' => 2, 'id_origem' => $captura->id_captura, 'id_responsavel' => $this->session->id_cadastro, 'status' => 1];
                    
                    if($this->admin_model->setStatusFila($status)){
                        $json = ['success' => true, 'link' => base_url('atendimento/incorporadoras/atendimento/agendamento/'.$captura->id_captura)];
                    }else{
                        $json = ['success' => false, 'msg' => 'Falha de Comunicação!'];
                    }
                }
            }else{
                $json = ['success' => false, 'msg' => 'Falha de Comunicação!'];
            }
        }else{
            $json = ['success' => false, 'msg' => 'Falha de Comunicação!'];
        }
        
        echo json_encode($json);
        
    }
	
	public function getAgenda(){
	    try{
            
            $data = $this->input->post();
            
            
            if($data['uuid_empreendimento'] == 'todos'){
                $empreendimentos = $this->cad_model->getEmpreendimentos([['emp_status',4]]);
                
                foreach ($empreendimentos as $emp){
                    $where['groupDestino'][] = [['id_destino', $emp->id_empreendimento]];
                    $where['groupDestino'][] = [['id_destino', $emp->id_empreendimento]];
                }    
            }
            else{
                
                $empreendimento = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$data['uuid_empreendimento']]]);
                
                $where['groupDestino'][] = [['id_destino', $empreendimento->id_empreendimento]];
                /*if($incorporadora->id_incorporadora == $empreendimento->id_incorporadora)
                    $where['groupDestino'][] = [['id_destino', $empreendimento->id_empreendimento],['id_parceiro', 0]];*/
            }
                
            
            $where[] = ['destino', 1];
            $where[] = [['tipo_agendamento', 1],['tipo_agendamento', 2]];
            
            /*$MEMBRO = $this->cad_model->getMembro(['inc_membros.id_cadastro',$this->session->id_cadastro]);
            if($MEMBRO->id_funcao == 3)
                $this->cad_model->JSON(['participantes', 'id_responsavel', $this->session->id_cadastro]);*/
            
            
            $capturas = $this->cad_model->getCapAgendas($where);
            
            $agendas = [];
            $leg = [];
            foreach($capturas as $captura){
                $captura->empreendimento = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$captura->origem_captura]]);
                
                if(!isset($leg[$captura->empreendimento->uuid_empreendimento])){
                    $leg[$captura->empreendimento->uuid_empreendimento] = ['color' => $this->random_color(), 'nome' => $captura->empreendimento->emp_nome_fantasia];
                }
                
                $captura->empreendimento->bg_calendar = $leg[$captura->empreendimento->uuid_empreendimento];
                $agendas[] = $captura; 
            }
            
            echo(json_encode(['agendas' => $agendas, 'legendas' => $leg]));
            
        }catch(Exception $e) {
                echo json_encode(['valid' => false, 'msg' => $e->getMessage()]);
        } 
	}
	
	function random_color() {
        return str_pad(dechex(mt_rand(0,255)), 2, '0', STR_PAD_LEFT) . str_pad(dechex(mt_rand(0,255)), 2, '0', STR_PAD_LEFT) . str_pad(dechex(mt_rand(0,255)), 2, '0', STR_PAD_LEFT);
    }
	
	public function getFilaAtentimento(){
        
        $id_resposavel = $this->session->id_cadastro;
        
        $this->ordena_fila();
        
        if($id_resposavel != NULL){
            
            $atendimento = $this->admin_model->getStatusFila('id_responsavel = '.$id_resposavel.' AND status < 2');
            
            if($atendimento == NULL){
                $data['fila'] = $this->admin_model->getFilaAtendimento();
                
                if($data['fila'] != NULL){
                    echo json_encode(['valid' => true, 'fila' => $this->getHtmlFila($data['fila'])]);
                }else{
                    echo json_encode(['valid' => true, 'fila' => 'A Fila está Vazia']);
                }
            }else{
                $fila = $this->continua_atendimento($atendimento);
                if($fila !== NULL){
                    $data['fila'] = $fila;
                    echo json_encode(['valid' => true, 'fila' => $data['fila']]);
                }
                else
                {
                    $data = [
                        'status' => 2,
                        'id_responsavel' => $id_resposavel,
                        'origem' => $atendimento->origem,
                        'id_origem' => $atendimento->id_origem
                    ];
	    
	                $atualiza = $this->admin_model->updateFila($atendimento->id_fila, $data);
	                
	                $this->getFilaAtentimento();
                }
                    //echo json_encode(['valid' => false, 'fila' => 'Falha ao carregar a fila.']);    
                
            }
           
        }else{
            echo json_encode(['valid' => true, 'fila' => 'Falha ao carregar a fila realize novo Login']);
        }
        
	}
	
	public function proxFilaAtendimento(){
        
        $post = $this->input->post();
        
        if($post != NULL){
            
            if($post['origem'] == 'desistencia'){
                $origem = 1;
            }else{
                $origem = 2;
            }
            
            $where = 'id_origem = '.$post['id_origem'].' AND origem = '.$origem.' AND id_responsavel != '.$this->session->id_cadastro;
            
            $atendido = $this->admin_model->getStatusFila($where);
            
            if($atendido == NULL){
                
                $where = 'id_origem = '.$post['id_origem'].' AND origem = '.$origem.' AND id_responsavel = '.$this->session->id_cadastro.' AND status != 2';
                $atendimento = $this->admin_model->getStatusFila($where);
                
                if($atendimento == NULL){
                    $status = ['origem' => $origem, 'id_origem' => $post['id_origem'], 'id_responsavel' => $this->session->id_cadastro, 'status' => 1];
                    
                    if($this->admin_model->setStatusFila($status)){
                        $json = ['valid' => true, 'link' => base_url('atendimento/incorporadoras/atendimento/'.$post['origem'].'/'.$post['id_origem'])];
                    }else{
                        $json = ['valid' => false, 'msg' => 'Falha de Comunicação!'];
                    }
                }else{
                    $json = ['valid' => true, 'link' => base_url('atendimento/incorporadoras/atendimento/'.$post['origem'].'/'.$post['id_origem'])];
                }
                
            }else{
                
                $responsavel = $this->cad_model->getCadastro([['id_cadastro', $atendido->id_responsavel]]);
                
                $json = ['valid' => false, 'msg' => 'O lead ja está em atendimento com '.$responsavel->nome];
            }
        }else{
            $json = ['valid' => false, 'msg' => 'Falha de Comunicação!'];
        }
        
        echo json_encode($json);
	}
	
    public function continua_atendimento($fila){
        
        $btn = $fila->origem == '1' ? 'Desistencia' : 'Primeiro Atendimento';
        $tipo = $fila->origem == '1' ? 'desistencia' : 'agendamento';
        $id = $fila->id_origem;
        
        if($fila->origem == '1'){
            $agenda = $this->cad_model->getAgenda([['id_agenda', $fila->id_origem]]);
            $cad = $this->cad_model->getCadastro([['id_cadastro',$agenda->participantes->id_interessado]]);
            $captura = $this->cad_model->getCaptura([['id_captura',$agenda->id_origem]]);
            if($agenda->origem != 4){
                $origem = "Sem origem encontrada";
            }
            else{
                $captura = $this->cad_model->getCaptura([['id_captura',$agenda->id_origem]]);
                $origem = $this->cad_model->getCapturaOrigem([['id_result',$captura->id_captura],['tb_result', 'cad_captura']])->utm_source??'Sem origem encontrada';
            }
            
        }else{
            $captura = $this->cad_model->getCaptura([['id_captura',$fila->id_origem]]);
            if(!isset($captura->id_cadastro)) // tratamento para não quebrar atendimento qdo a captura tiver sido excluida manualmente da tabela
                return NULL;
            $cadastro = $this->cad_model->getCadastro([['id_cadastro',$captura->id_cadastro]]);
            $dados_temporarios = array_merge((array)$captura,(array)$cadastro);
            $cad = (object)$dados_temporarios;
            $origem = $this->cad_model->getCapturaOrigem([['id_result',$cad->id_captura],['tb_result', 'cad_captura']])->utm_source??'Sem origem encontrada';
        }
        
        $emp = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$captura->origem_captura]]);
        
        if($cad->etapa != 8){
            $status = '<div class="text-warning mb-1">
                            <b class="text-muted">Status de cadastro:</b> Incompleto - '.$cad->etapa.'/8
                        </div>';
        }
        else{
            $status = '<div class="text-success mb-1">
                            <b class="text-muted">Status de cadastro:</b> Completo
                        </div>';
        }
        
        if($captura->status_captura < 3){
            $status_captura = '<div class="text-warning mb-1">
                                    <b class="text-muted">Status de Cartão VIP:</b> Não Ativado
                                </div>';
        }else{
            $status_captura = '<div class="text-success mb-1">
                                    <b class="text-muted">Status de Cartão VIP:</b> Ativado
                                </div>';
        }
        
        
        return '<div class="card-header"><h5 class="mb-0">Fila de atendimento</h5></div>
        <div class="card-body">

                    <div class="card text-center w-100" style=" height: 60px;">
                         <img class="my-auto h-100" style="width: auto; object-fit: contain;" src="'.$emp->emp_logo.'">
                    </div>
                    <div class="text-muted mb-1">
                        <b>Nome:</b> '.$cad->nome.'
                    </div>
                    <div class="text-muted mb-1">
                        <b>Data de entrada:</b> '.substr(converte_datahora($fila->date_time,1),0,-3).'
                    </div>
                    '.$status_captura.'
                    <div class="text-muted mb-1">
                        <b>Origem do Lead:</b> '.$origem.'
                    </div>
                    '.$status.'
                    <div class="text-muted mb-3">
                        <b>Momento:</b> '.$btn.'
                    </div>                     
          
            <button data-id_origem="'.$id.'" data-origem="'.$tipo.'" class="btn btn-success btn-lg btn-start-atendimento font-weight-bold btn-block" onclick="startFilaAtendimento(\''.$tipo.'\',\''.$id.'\')">Atender próximo</button>
        </div>';
    }
    /* !!! REVISAR  !!!!*/
    public function getHtmlFila($fila){
        
        $btn = $fila->status_agenda == '5' ? 'Desistencia' : 'Primeiro atendimento';
        $tipo = $fila->status_agenda == '5' ? 'desistencia' : 'agendamento';
        $id = $fila->status_agenda == '5' ? $fila->id_agenda : $fila->id_captura;
        $fila->origem = $fila->id_agenda == '' && $fila->id_captura != '' ? '2' : '1';
        /*$captura = $this->cad_model->getCaptura([['id_captura',$fila->id_captura]]);
        $cadastro = $this->cad_model->getCadastro([['id_cadastro',@$captura->id_cadastro]]);*/
            
        if($fila->origem == '1'){
            $agenda = $this->cad_model->getAgenda([['id_agenda', $fila->id_agenda]]);
            $cad = $this->cad_model->getCadastro([['id_cadastro',$agenda->participantes->id_interessado]]);
            $captura = $this->cad_model->getCaptura([['id_captura',$agenda->id_origem]]);
            if($agenda->origem != 4){
                $origem = "Sem origem encontrada";
            }
            else{
                $captura = $this->cad_model->getCaptura([['id_captura',$agenda->id_origem]]);
                $origem = $this->cad_model->getCapturaOrigem([['id_result',$captura->id_captura],['tb_result', 'cad_captura']])->utm_source??'Sem origem encontrada';
            }
            
        }else{
            $captura = $this->cad_model->getCaptura([['id_captura',$fila->id_captura]]);
            $cadastro = $this->cad_model->getCadastro([['id_cadastro',$captura->id_cadastro]]);
            $dados_temporarios = array_merge((array)$captura,(array)$cadastro);
            $cad = (object)$dados_temporarios;
            $origem = $this->cad_model->getCapturaOrigem([['id_result',$cad->id_captura],['tb_result', 'cad_captura']])->utm_source??'Sem origem encontrada';

        }
        
        $emp = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$captura->origem_captura]]);
        
        if($cad->etapa != 8){
            $status = '<div class="text-warning mb-3">
                            <b class="text-muted">Cadastro:</b> Incompleto - '.$cad->etapa.'/8
                        </div>';
        }
        else{
            $status = '<div class="text-success mb-3">
                            <b class="text-muted">Cadastro:</b> Completo
                        </div>';
        }
        
        if($captura->status_captura < 3){
            $status_captura = '<div class="text-warning mb-1">
                                    <b class="text-muted">Cartão VIP: Não Ativado</b>
                                </div>';
        }else{
            $status_captura = '<div class="text-success mb-1">
                                    <b class="text-muted">Cartão VIP: Ativado</b>
                                </div>';
        }
        
        //return Template::getView('atendimento/blocos/card_view', $data);
        
        return '<div class="card-header bg-success text-white"><h5 class="mb-0">Próximo Atendimento</h5></div>
        <div class="card-body">
            <div class="card text-center w-100" style=" height: 100px;">
              <img class="my-auto h-100" style="width: auto; object-fit: contain;" src="'.$emp->emp_logo.'">
            </div>
            <div class="card">
                <div class="card-text p-2">
                        <div class="text-muted mb-1">
                            <b>Nome:</b> '.$fila->nome.'
                        </div>
                        <div class="text-muted mb-1">
                            <b>Data de entrada:</b> '.substr(converte_datahora($fila->data_fila,1),0,-3).'
                        </div>
                        '.$status_captura.'
                        <div class="text-muted mb-1">
                            <b>Origem do Lead:</b> '.$origem.'
                        </div>
                        '.$status.'
                        <div class="card font-weight-bold text-center border-primary w-100 mb-2" style=" height: 35px;">
                            <div class="card-text text-primary my-auto">'.$btn.'</div>
                        </div>
                </div>
            </div>
            <button data-id_origem="'.$id.'" data-origem="'.$tipo.'" class="btn btn-success btn-lg btn-start-atendimento btn-block" onclick="startFilaAtendimento(\''.$tipo.'\',\''.$id.'\')">Iniciar Atendimento</button>
        </div>';
    }
	
	public function modeloAjax()
	{
	    try{
            
            $post = $this->input->post();
            
            if(true)
                throw new Exception("Mensagem de erro");
            
    	    
    	    echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'update' => $post ]);
            
        }catch(Exception $e) {
                echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
	}
	
	public function proximo_contato()
	{
	    
	    $this->load->library('form_validation');
        //$this->form_validation->set_rules('id_atendimento',    'id_atendimento',    'required|trim');
        $this->form_validation->set_rules('tipo_interesse',     'tipo_interesse',     'required|trim');
        //$this->form_validation->set_rules('observacao', 'Observação', 'required|trim');
        
        $post = $this->input->post();
        
		if(($post['dias']??'') == 'personalizado' && ($post['novo_contato']??'') == 'sim')
		    $this->form_validation->set_rules('proximo_contato','Quando?','required|trim');    
        	        
	    if ($this->form_validation->run() != FALSE) 
        {
            $post['data_hora'] = date("Y-m-d H:i:s");
            $dias = $post['dias']??1;
            $proximo_contato = '';
            if(($post['novo_contato']??'') == 'sim')
            {
               if($dias == 'personalizado')
               {
                   $proximo_contato = $post['proximo_contato'];
               }
               else
               {
                   $proximo_contato = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s"), date("m") , date("d")+$dias, date("Y")));
               }
            }
            
            $post['id_user'] = $this->session->id_cadastro;
            $post['data_hora'] = date("Y-m-d H:i:s");
            
            $id_atendimento_historico = $this->cad_model->setAtendimentoHistorico($post);
            
            if($id_atendimento_historico){
                $json = ['valid' => true, 'id_atendimento'=> $id_atendimento_historico,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
	    
	}
	
	
	//Código da aba reportar reclamação
	public function enviaReclamacao()
	{
	    
	    $this->load->library('form_validation');
	    $this->form_validation->set_rules('reclamacao', 'Reclamação', 'required');
	    $this->form_validation->set_rules('area_reclamacao', 'Área', 'required');
	    
	    
	    if($this->form_validation->run() == FALSE)
	    {
	        $json = ['success'=>false,'txt'=>validation_errors()];
	    }
	    else{
	        
    	    $data = $this->input->post();
    	        
    	        	    
    	    $reclamacao = $this->cad_model->insertReclamacao($data);
    	    
    	    if($reclamacao > 0)
    	    {
    	        $json = ['success'=>true,'txt'=>"Reclamacao enviada"];
    	    }
    	    else{
    	        $json = ['success'=>false,'txt'=>"Ocorreu um erro ao enviar a reclamacao"];
    	    }
	    }

	    
	    echo json_encode($json);
	    
	}
	
	//Salva os dados do interesse do Informações do Atendimento
	public function enviaInteresse(){
	    
	    $post = $this->input->post();
	    $post['interesse_painel_cs'] = 1;
	    
	    
	    if($this->cad_model->updateCaptura($post['id_captura'],$post)){
	        if(empty($post['id_interesse'])){
	            $interesse = $this->cad_model->insertInteresse($post);
	            
	            if($interesse > 0){
	                $json = ['success'=>true,'txt'=>"Interesse enviada"];
    	        }else{
    	            $json = ['success'=>false,'txt'=>"Ocorreu um erro ao enviar a Interesse"];
	            }
	        }
	        else{
	            $interesse = $this->cad_model->updateInteresse($post['id_interesse'],$post);
	            
	            if($interesse == true){
	                $json = ['success'=>true,'txt'=>"Interesse atualizado"];
	            }
	            else{
	                $json = ['success'=>false,'txt'=>"Ocorreu um erro ao atualizar o Interesse"];
	            }
	        }
	        
	        
	        
	    }else{
	        $json = ['success'=>false,'txt'=>"Ocorreu um erro ao enviar a Interesse"];
	    }
	    
	    echo json_encode($json);
	}
	
	//Código da modal editar cartão vip
	public function editaCartaoVip(){
	    
	    $this->load->library('form_validation');
	    $this->form_validation->set_rules('nome', 'Nome', 'required');
	    $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
	    $this->form_validation->set_rules('telefone', 'Telefone', 'required');
	    $this->form_validation->set_rules('emp_nome_fantasia', 'Emp_nome_fantasia', 'required');
	    $this->form_validation->set_rules('unidade', 'Unidade', 'required');
	    $this->form_validation->set_rules('possui_conjuje', 'Possui_conjuje', 'required');
	    $this->form_validation->set_rules('cpf', 'Cpf','required');
	    
	    if($this->form_validation->run() == FALSE)
	    {
	        $json = ['success'=>false,'txt'=>validation_errors()];
	    }
	    else{	
	        
	        $data = $this->input->post();
	        
	        $data['datetime_captura'] = date("Y-m-d H:i:s");
	        
	        $valida = valida_cpf($data['cpf']);
    	        	    
            if($valida == false){
                
                $json = ['success'=>false,'txt'=>'Cpf digitado é inválido'];
                
            }	
            else{
            
                $cartaoVIP = $this->cad_model->updateCadastro($data['id_cadastro'],$data);
        	    
        	    if($cartaoVIP > 0)
        	    {
        	        $this->cad_model->updateCaptura($data['id_captura'],$data);
        	        
        	        $json = ['success'=>true,'txt'=>"Cartão VIP atualizado"];
        	    }
        	    else{
        	        $json = ['success'=>false,'txt'=>"Ocorreu um erro ao tentar atualizar o cartão"];
        	    }
            }
	    }
	    
	    echo json_encode($json);
	}
	
	
	//Código da modal novo cartão vip
	public function addCartaoVip(){
	    
	    $this->load->library('form_validation');
	    $this->form_validation->set_rules('nome', 'Nome', 'required');
	    $this->form_validation->set_rules('cpf', 'Cpf', 'required');
	    $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
	    $this->form_validation->set_rules('telefone', 'Telefone', 'required');
	    $this->form_validation->set_rules('possui_conjuje', 'Possui_conjuje', 'required');
	    $this->form_validation->set_rules('emp_nome_fantasia', 'Empreendimento', 'required');
    	$this->form_validation->set_rules('unidade', 'Unidade', 'required');
    	
	    if($this->form_validation->run() == FALSE)
	    {
	        $json = ['success'=>false,'txt'=>validation_errors()];
	    }
	    else{
	    
	        $data = $this->input->post();
	        
	        $data['tipo_imovel']=$data['unidade'];
	        $data['datetime_captura'] = date("Y-m-d H:i:s");
	        
	        $valida = valida_cpf($data['cpf']);
	        
            if($valida == false){
                
                $json = ['success'=>false,'txt'=>'Cpf digitado é inválido'];
                
            }
            else{
                
                
        	    $uuid_emp = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['emp_nome_fantasia']]])->uuid_empreendimento;
    	        $cadastro = $this->cad_model->getCadastroByEmail($data['email']);
    	        $verifica_cpf_emp = $this->cad_model->getCaptura(['cpf',$data['cpf'],['origem_captura',$uuid_emp]]);
        	    
        	    //VERIFICA SE UM CPF NÃO ESTÁ LINKADO AO MESMO EMPREENDIMENTO
        	    if(empty($verifica_cpf_emp)){
            	    //dd('entro no if');
                	if(empty($cadastro))
                	{
                	    
                	    $data['id_cadastro'] = $this->cad_model->insertCadastro($data);
                	        
                	}
                	else{
                	    $data['id_cadastro'] = $cadastro->id_cadastro;
                	        
                	}
                	
                	$data['origem_captura'] = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['emp_nome_fantasia']]])->uuid_empreendimento;
                	
                	$captura = $this->cad_model->insertCaptura($data);
                	
                	$id_captura = $captura;
                	
            //Gerando chave de captura--------------------------------------------------------    	
                	
            
                	
                	$key_captura = $id_captura.$this->gerar_senha(3,false,true,true,false);
                    $update = [
                        'key_captura'     => $key_captura,
                        //'status_captura'  => 3,
                        ];
                    
                    $this->cad_model->updateCaptura($id_captura,$update);
                    $data['key_captura'] = $key_captura;
                    
                    $empreendimento = $this->cad_model->getEmpreendimento(['uuid_empreendimento',$data['origem_captura']]);
                    $origem = $this->session->origem??NULL;
                    if($origem !== NULL)
                    {
        	            $origem = array_merge($origem,[
        	                'click_action'=>'Captura Cartao Vip',
        	                'id_cad'=>$this->session->id_cadastro??0,
        	                'tb_result'=>'cad_captura',
        	                'id_result'=>$id_captura,
        	                'conta_nova'=>0,
        	                'date_time'=>date('Y-m-d H:i:s')
        	                ]);
                        $this->cad_model->insertCapturaOrigem($origem);
                    }
                    
                    $config = $this->cad_model->getLpConfig(['id_imovel', $empreendimento->id_imovel]);
                    $parceiro = $this->admin_model->getProximoParceiro($data['origem_captura'], $empreendimento->id_empreendimento);
                    $linkCartaoVip     = base_url('landingpage/resultado/codigovip/'.$data['origem_captura'].'/'.$key_captura) ;//ATIVACAO DO CARTAO VIP
                    $linkAgendarVisita = base_url('landingpage/resultado/confirmacao/'.$data['origem_captura'].'/'.$key_captura) ;//AGENDAMENTO DE VISITA
                    
                    
                     $dt = [
                            'key_captura'  => $key_captura,
                            'uuid'         => $data['origem_captura'],
                            'nome'         => $data['nome'],
                            'tipo_imovel'  => $data['unidade'],
                        ];
                    
                    if($parceiro != null)
                    {
                        $this->cad_model->updateCaptura($id_captura,['id_parceiro' => $parceiro->id_parceiro]);
                        //tipo_atendimento - 1 - Painel CS / 2 - Painel Incorporadora
                        if($parceiro->tipo_atendimento == 1)
                        {
                            if($config->tag_cv_precad != ''){
                                Newsletter::setTagRelCap($config->tag_cv_precad, $id_captura);
                                Envia::email($data['email'], $config->tag_cv_precad, $dt);
                            }
                            $redirect = $linkCartaoVip;//ATIVACAO DO CARTAO VIP
                        }
                        if($parceiro->tipo_atendimento == 2 )
                        {
                            if($config->tag_ag_precad != ''){
                                Newsletter::setTagRelCap($config->tag_ag_precad, $id_captura);
                                Envia::email($data['email'], $config->tag_ag_precad, $dt);
                            }
                            $redirect = $linkAgendarVisita;//AGENDAMENTO DE VISITA
                        }
                    }
                    else
                    {
                        if($config->pagina_tipo == 1)
                        {
                            if($config->tag_ag_precad != ''){
                                Newsletter::setTagRelCap($config->tag_ag_precad, $id_captura);
                                Envia::email($data['email'], $config->tag_ag_precad, $dt);
                            }else{
                            
                                $this->rd_lib->rds_key_update($id_captura, $data['link']);
                            }
                            $redirect = $linkAgendarVisita;
                        }
                        else
                        {
                            if($config->tag_cv_precad != ''){
                                Newsletter::setTagRelCap($config->tag_cv_precad, $id_captura);
                                Envia::email($data['email'], $config->tag_cv_precad, $dt);
                            }
                            else{
                                $this->rd_lib->rds_key_update($id_captura, $data['link']);
                            }
                            $redirect = $linkCartaoVip;
                        }
                    }
                    
                    HEmail::alerta($empreendimento->emp_nome_fantasia, $data);
                	
                	
                	
            //-------------------------------------------------------------------------------
                	
                	
                	
                	
                	if($captura > 0)
                	{
                	    $json = ['success'=>true,'txt'=>"Novo Cartão VIP criado"];
                	}
                	else{
                	    $json = ['success'=>false,'txt'=>"Ocorreu um erro ao tentar criar um novo cartão"];
                	} 
        	    }
        	    else{
        	        //dd('entro else');
        	        $json = ['success'=>false,'txt'=>"Usuário já cadastrado"];
        	    }
        	   
            }
            
	    
	    }

	    echo json_encode($json);
	}
	
	public function concluirAtendimento(){
	    
	    $post = $this->input->post();
	    $post['id_cadastro'] = $this->session->id_cadastro;
	    
	    $sugestao = $post;
	    unset($sugestao['id_fila']);
	    
	    $data = ['status' => 2];
	    
	    $atualiza = $this->admin_model->updateFila($post['id_fila'], $data);
	    
	    if($atualiza != FALSE){
	        
	        if($post['sugestao'] != '' || $post['experiencia'] != ''){
	            $this->cad_model->insertSugestao($sugestao);
	        }
	        
	        $json = ['success'=>true,'txt'=>"Atendimento Concluido com sucesso. Redirecionando ... ", 'link' => base_url('atendimento/incorporadoras')];
	    }else{
            $json = ['success'=>false,'txt'=>"Ocorreu um erro ao finalizar atendimento tente novamente."];
	    }
	    
	    echo json_encode($json);
	}
	
	private function get_method_proximo_vendedor($id_equipe,$id_empreendimento)
    {
        if($id_equipe != 0)
        {
            $equipe = $this->cad_model->getEquipe(['id_equipe', $id_equipe]);
            
            if(!empty($equipe->configuracoes)) {
                $equipe->configuracoes = (array)json_decode($equipe->configuracoes);
                $configuracoes = $equipe->configuracoes[$id_empreendimento]??[];
                
                if(!empty($configuracoes))
                {
                    if($configuracoes->distribuicaoManual == 1)
                    {
                        return ['tipo'=>'distribuicaoManual','method'=>'getMembrosDisponiveis'];
                    }
                    elseif($configuracoes->distribuicaoAutomatica == 1)
                    {
                        if($configuracoes->distribuicaoSequencial == 1)
                        {
                            return ['tipo'=>'distribuicaoSequencial','method'=>'getProximoVendedorDisponivelSequencia'];
                        }
                        elseif($configuracoes->distribuicaoPorPrioridade == 1)
                        {
                            return ['tipo'=>'distribuicaoPorPrioridade','method'=>'getProximoVendedorDisponivel']; 
                        }
                    }
                }
            }
        }
        
        return ['tipo'=>'distribuicaoManual','method'=>'getMembrosDisponiveis']; 
    }
	
	//Código da modal adicionar visita
	public function addAgenda(){
	    
	    $post = $this->input->post();
	    
        $post['id_responsavel'] = $this->session->id_cadastro;
        
        if(!empty($post['data_hora_agendamento'])){
                
           
            $wvd = [['inc_escala.id_parceiro',$post['id_parceiro']]];
            
            $cap = $this->admin_model->getRow('cad_captura', ['id_captura', $post['id_origem']]);
            if($cap->id_equipe != 0)
                $wvd[] = ['inc_escala.id_equipe',$cap->id_equipe];
            
            $vendedor = $this->admin_model->getProximoVendedorDisponivel($post['id_destino'], $post['data_hora_agendamento'],[3,6],$wvd);
            //$vendedor = $this->admin_model->getProximoVendedorDisponivel($post['id_destino'], $post['data_hora_agendamento']);
            if($vendedor == null)
            {
                $json = ['success' => false,'msg' => "Selecione um horário disponível"];
                echo json_encode($json);
                die();
            }
            
            //-------altera status da captura parar 3, cartao ativado ou visita agendada--------
            //$AtendimentoInicial = $this->admin_model->getAtendimento([['id_atendimento',$post['id_atendimento'] ]]);
            //$cap = $this->admin_model->getRow('cad_captura', ['id_captura', $AtendimentoInicial->id_rel]);
            $this->cad_model->updateCaptura($post['id_origem'],['status_captura'=> 3]);//pegar id_captura
            //----------------------------------------------------------------------------------
            
            
            //------MODELO
                    
            $cap = $this->admin_model->getRow('cad_captura', ['id_captura', $post['id_origem']]);
            $parceiro = $this->cad_model->getParceiro(['id_parceiro', $cap->id_parceiro]);
                    
            $config = $this->get_method_proximo_vendedor($cap->id_equipe,$post['id_destino']); 
            
            if($config['tipo'] == 'distribuicaoSequencial')
            {
                $wvd[] = ['inc_escala.id_parceiro',$post['id_parceiro']];
                if($cap->id_equipe != 0)
                    $wvd[] = ['inc_escala.id_equipe',$cap->id_equipe];
                
                $vendedor = $this->admin_model->getProximoVendedorDisponivelSequencia($post['id_destino'], $post['data_hora_agendamento'], $wvd, $cap->origem_captura, $cap->id_equipe); 
                if(empty($vendedor)){
                    $json = ['valid' => false,'msg' => "Nenhum vendedor disponivel para esse horario"];
                    echo json_encode($json);
                    die();
                }
                $id_vendedor = $vendedor->id_cadastro;
            }
            elseif($config['tipo'] == 'distribuicaoPorPrioridade')
            {
                if($captura->id_equipe != 0)
                    $wvd[] = ['inc_escala.id_equipe',$captura->id_equipe];
                $wvd[] = ['inc_escala.id_parceiro',$post['id_parceiro']];
                $vendedor = $this->admin_model->getProximoVendedorDisponivel($post['id_destino'], $post['data_hora_agendamento'], [3,6],$wvd);
                if(empty($vendedor)){
                    $json = ['valid' => false,'msg' => "Nenhum vendedor disponivel para esse horario"];
                    echo json_encode($json);
                    die();
                }
                $id_vendedor = $vendedor->id_cadastro;
            }            
            else // ($config['tipo'] == 'distribuicaoManual')
            {
                $wvd[] = ['inc_escala.id_parceiro',$post['id_parceiro']];
                $vendedores = $this->admin_model->getMembrosDisponiveis($post['id_destino'], $post['data_hora_agendamento'], [3,6], $wvd); 
                if(empty($vendedores)){
                    $json = ['valid' => false,'msg' => "Nenhum vendedor disponivel para esse horario"];
                    echo json_encode($json);
                    die();
                }
                $id_vendedor = 0;
            }        
                    
                    /*if($parceiro->distribuicao_leed == 0){
                        $wvd = [['inc_escala.id_parceiro',$post['id_parceiro']]];
                        $vendedor = $this->admin_model->getProximoVendedorDisponivel($post['id_destino'], $post['data_hora_agendamento'],$wvd);
                        if($vendedor == null){
                            $json = ['valid' => false,'msg' => "Nenhum vendedor disponivel para esse horario"];
                            echo json_encode($json);
                            die();
                        }
                        $id_vendedor = $vendedor->id_cadastro;
                    }
                    else{
                        $wvd[] = ['inc_escala.id_parceiro',$post['id_parceiro']];
                        $vendedores = $this->admin_model->getMembrosDisponiveis($post['id_destino'], $post['data_hora_agendamento'], 3, $wvd); 
                        if(empty($vendedores)){
                            $json = ['valid' => false,'msg' => "Nenhum vendedor disponivel para esse horario"];
                            echo json_encode($json);
                            die();
                        }
                        $id_vendedor = 0;
                    }*/
                    //------MODELO
            
            
            $participantes['id_responsavel'] = $id_vendedor;
            $participantes['participantes'] = $post['id_participantes'];
            $participantes['id_interessado'] = $post['id_interessado'];
            $post['participantes'] = json_encode($participantes);
            //Insere no banco o agendamento
            
            $result = $this->cad_model->insertAgenda($post);
            
            //Trata os dados para envio de email
            if($post['tipo_agendamento']==1){
                $email['tipo_agendamento']='Presencial';
            }
            else{
                $email['tipo_agendamento']='Online';
            }
            $email['data_hora_agendamento']=$post['data_hora_agendamento'];
            $email['responsavel'] = $this->cad_model->getCadastro([['id_cadastro',$post['id_responsavel']]])->nome;
            $dia = date("l", strtotime($email['data_hora_agendamento']));
    	        switch($dia){
                    case 'Sunday':
                        $dia = 'Domingo';
                        break;
                    case 'Monday':
                        $dia = 'Segunda-Feira';
                        break;
                    case 'Tuesday':
                        $dia = 'Terça-Feira';
                        break;
                    case 'Wednesday':
                        $dia = 'Quarta-Feira';
                        break;
                    case 'Thursday':
                        $dia = 'Quinta-Feira';
                        break;
                    case 'Friday':
                        $dia = 'Sexta-Feira';
                        break;
                    case 'Saturday':
                        $dia = 'Sábado';
                        break;
                }    
            $email['dia_semana'] = $dia;   
                
            $email_final = array(
    	        "campanha" => 'Visita agendada',
                "mensagem" => '',
                "subject" => 'Agendamento de visita Comdono'
            );
            
    	    $empreendimento = $this->cad_model->getEmpreendimento(['id_empreendimento',$post['id_destino']]);
    	    $lpConfig =  $this->cad_model->getLpConfig([['id_imovel',$empreendimento->id_imovel]]);
    	    
    	    $email['endereco_stand'] = $lpConfig->endereco_stand;
    	    $email['localizacao_stand'] =  $lpConfig->localizacao_stand;
    	    
    	    $email_final['mensagem'] = Template::getView('atendimento/blocos/box_agendar_visita_view', $email);
    	   	
    	   
    	   	//Enviar o email
    	   	$email_envio =  $this->cad_model->getCadastro([['id_cadastro',$post['id_interessado']]])->email;
    	   	
    	    //$this->newsletter->enviar_email_campanha($email_envio, 88, $email_final);
            Envia::email($email_envio, 'agenda_visita_interessado', $email_final);
            
            if($result > 0){
                Notification::empreendimentoMembro($post['id_destino'], $vendedor->id_cadastro, 'nv_visita_vendedor');
                //Notification::empreendimentoFuncao($post['id_destino'], 2, 'nv_visita_diretor');
                Notification::empreendimentoDiretoresParceiro($post['id_destino'], $post['id_parceiro'], 'nv_visita_diretor');        
                $json = ['success' => true,'msg' => "Agendamento efetuado com sucesso"];
                
            }
            else{
                $json = ['success' => false,'msg' => "Erro ao agendar"];
            }
        }
        else{
            $json = ['success' => false,'msg' => "Selecione um horário disponível"];
        }
        echo json_encode($json);
        
	}
	
	//Código auxiliar do select do novo cartão vip
	public function getUnidade(){
	    
	    $data = $this->input->post();
	    
	    $id_imovel = $this->cad_model->getEmpreendimento(['id_empreendimento', $data['id_emp']])->id_imovel;
	    $lpConfig =  $this->admin_model->getLpConfig([['id_imovel',$id_imovel]]);
        
        if($lpConfig != null){
            $data['unidades'] = $this->admin_model->getUnidades([['id_config',$lpConfig->id_config]]);
        }
        
        if($data['unidades'] != null)
        {
            
            $select_unit = $this->getSelect($data['unidades']);
            $json = ['valid' => true, 'html' => $select_unit];
            
        }
        else{
            $data['unidades'] = [];
            $select_unit = $this->getSelect($data['unidades']);
            $json = ['valid' => false, 'html' => $select_unit];
        }
        
        echo json_encode($json);
	}
	
	
	//Código auxiliar do select do novo cartão vip
	private function getSelect($unidades)
	{
	    
	    if(empty($unidades)){
    	    return '<div class="form-group">
                        <label for="exampleFormControlSelect2">Unidade escolhida:</label>
                            <select class="form-control select_unit_add_cartao" name="unidade" id="exampleFormControlSelect2">
                                <option value="">Sem Unidades Cadastradas</option>
                            </select>
                    </div>
                    
    	    ';    
	    }
	    else{
	        
	        $html = '';
	        
    	    foreach($unidades as $unit) {
    	        if(!empty($unit->tipo)){
    	            $html .= '<option value="'.$unit->tipo.'">'.$unit->tipo.'</option>';
    	        }
            }

    	    return '<div class="form-group">
                        <label for="exampleFormControlSelect2">Unidade escolhida:</label>
                            <select class="form-control select_unit_add_cartao" name="unidade" id="exampleFormControlSelect2">
                                <option value="">Selecione</option>
                                '.$html.'
                            </select>
                    </div>
                    
    	    ';
	    }
	    
	}
	
	
	//Código para a modal criar conta comdono
	public function addContaComdono(){
	    
	    
	    $this->load->library('form_validation');
	    
	    $this->form_validation->set_rules('nome', 'Nome', 'required');
	    $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
	    $this->form_validation->set_rules('telefone', 'Telefone', 'required');
	    
	    if($this->form_validation->run() == FALSE)
	    {
	        $json = ['success'=>false,'erro' => 1,'msg'=>validation_errors()];
	    }
	    else{
	        
	        $post = $this->input->post();
	        
	        $cadastro = $this->cad_model->getCadastroByEmail($post['email']);
	        
	        if(empty($cadastro))
            {
                
                $senha = $this->gerar_senha(rand(8, 12));
                $data['nome']     = $post['nome'];
                $data['email']    = $post['email'];
                $data['telefone'] = $post['telefone'];
                //$data['cpf']      = $post['cpf'];
                $data['password'] = $this->password_hash($senha);
                $data['etapa']    = 1;
                $data['data_hora_cadastro'] = date("Y-m-d H:i:s");
                
                $result = Cad_model::setCadUser($data);  
                
                if($result['id_cadastro'] != NULL){
                    
                    $data['senha'] = $senha;
                    
                    $this->newsletter->enviar_email_campanha($data['email'], 48, $data);
                    
                    $json = ['success' => true, 'msg' => 'Cadastro Efetuado com sucesso'];
                }else{
                    $json = ['success' => false, 'msg' => 'Falha de comunicação'];
                }
                
                
            }else{
                $json = ['success' => false,'erro' => 2,'msg' => "E-mail já cadastrado!"];
            }
	        
	        
	    }
	    
	    
	    echo json_encode($json);
	    
	}
	
	//Código auxiliar do criar conta comdono de gerar senha aleatória
	private function gerar_senha($tamanho = 6, $maiusculas = true, $minusculas = true, $numeros = true, $simbolos = false){
        $ma = "ABCDEFGHIJKLMNOPQRSTUVYXWZ"; // $ma contem as letras maiúsculas
        $mi = "abcdefghijklmnopqrstuvyxwz"; // $mi contem as letras minusculas
        $nu = "0123456789"; // $nu contem os números
        $si = "!@#$%¨&*()_+="; // $si contem os símbolos
        
        $senha = '';
        
        if ($maiusculas){
            // se $maiusculas for "true", a variável $ma é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($ma);
        }
        
        if ($minusculas){
            // se $minusculas for "true", a variável $mi é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($mi);
        }
        
        if ($numeros){
            // se $numeros for "true", a variável $nu é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($nu);
        }
        
        if ($simbolos){
            // se $simbolos for "true", a variável $si é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($si);
        }
        
        // retorna a senha embaralhada com "str_shuffle" com o tamanho definido pela variável $tamanho
        return substr(str_shuffle($senha),0,$tamanho);
    }
	
	//Código auxiliar do criar conta comdono de criptografar senha
	private function password_hash($senha){
        // Hash password using phpass
        $hasher = new PasswordHash($this->config->item('phpass_hash_strength', 'tank_auth') , $this->config->item('phpass_hash_portable', 'tank_auth'));
        $senha = $hasher->HashPassword($senha);
        
        return $senha;
    }
    
    
    private function ordena_fila(){
        
        $where = 'status = 3 AND date_prorrogado < "'.date('Y-m-d H:i:s').'"';
        $filas = $this->admin_model->getFilas($where);
        
        foreach($filas as $fila){
            $data = ['status' => 1];
            $this->admin_model->updateFila($fila->id_fila,$data);
        }
    }
    /*Funções apagadas de filtrar o historico do lead
    public function filtrar_historico_lead(){
        
        $data = $this->input->post();
        
        $capturas = $this->admin_model->getCapturas([['email', $data['email']],['datetime_captura',$data['date']]]);
        
        if(!empty($capturas))
        {
            $historico = $this->getFiltrosLead($capturas);
            $json = ['success' => true, 'html' => $historico];
            
        }
        else{
            $json = ['success' => false, 'html' => 'Sem dados no histórico'];
        }
        
        echo json_encode($json);
        
        
    }
	
    private function getFiltrosLead($capturas)
	{
	    $html = '';
	    foreach($capturas as $caps) { 
            $html .= 
            '<tr>
                <td>'.$caps->origem_captura.'</td>
                <td>'.converte_datahora($caps->datetime_captura,1).'</td>
                <td>'.$caps->nome.'</td>
                <td>'.$caps->email.'</td>
                <td>'.$caps->telefone.'</td>
                <td>'.$caps->cpf.'</td>
            </tr>';
        }

	    return $html;
	}
	*/
	
	public function novoip_ligar(){
        $post = $this->input->post();
        
        $telefone = $this->cad_model->getCadastro([['id_cadastro',$post['id_cadastro']]])->telefone;
        $tel_responsavel = $this->cad_model->getCadastro([['id_cadastro',$post['id_responsavel']]])->nvoip;
        
        if($tel_responsavel == NULL){
            $json = ['success' => false, 'status' => 1];
        }else{
        
            $this->load->library('atendimento/nvoip');
            $voip = $this->nvoip->ligar('30107001',$telefone);
            
            if($voip == NULL || $voip == FALSE){
                $json = ['success' => false, 'status' => 2, 'msg' => 'Não foi possivel efetuar a ligação', 'dados' => $voip];
            }else{
                $json = ['success' => true, 'msg' => 'Ligação sendo efetuada', 'dados' => $voip];
            }
            
        }
        echo json_encode($json);
	}
	
	/*public function addNovoipid(){
	    $post = $this->input->post();
	    dd($post);
	}*/
	
	public function novoip_desligar(){
	    $post = $this->input->post();
	    
	    $this->load->library('atendimento/nvoip');
        $this->nvoip->desligar($post['callid']);
        
        echo json_encode(['success' => true, 'dados' => $voip]);
	}
	
	/** * Função editar o interesse
    * @access public 
    * @param -
    * @return Mensagem de sucesso do update
    */
	public function setEditInteresse()
	{
	    try {
            $data = $this->input->post();
            
            $idCadastro = $data['id_cadastro'];
            
            $interesse = $this->cad_model->getInteresse([['id_cadastro',$idCadastro],['principal',1]]);
            if($interesse == null)
            {
                $data['principal'] = 1;
                $data['id_responsavel'] = $this->session->id_cadastro;
                $data['datahora_cadastro'] = date("Y-m-d H:i:s");
                $id_interesse = $this->cad_model->insertInteresse($data);	
                
                $this->insertBairros($id_interesse, ($data['bairro']??[]));
	            $this->insertTiposEmp($id_interesse, ($data['tipo_emp_cliente']??[]));
            }
            else
            {
                $id_interesse = $interesse->id_interesse;
                $this->cad_model->updateInteresse($id_interesse, $data);
                
                $this->insertBairros($id_interesse, ($data['bairro']??[]));
	            $this->insertTiposEmp($id_interesse, ($data['tipo_emp_cliente']??[]));
            }
            
            echo json_encode(['success' => true,'msg' => 'Interesse salvo com sucesso','id_interesse' => $id_interesse]);
                    	
        } catch(Exception $e) {
            echo json_encode(['success' => false,'msg' => $e->getMessage()]);
        }
	}
	
	/** * Função para limpar e inserir os bairros dos campos do salvar interesse
    * @access private 
    * @param $id_interesse = id do interesse, $bairros = array de bairros
    * @return -
    */
	private function insertBairros($id_interesse, $bairros = [])
	{
	    $this->cad_model->deleteInteresseBairros([['id_interesse', $id_interesse]]);
	    foreach($bairros as $bairro){
            $this->cad_model->insertBairroInteresse([
                'id_interesse' => $id_interesse,
                'bairro' => $bairro
                ]);
        }
	}
	
	/** * Função para limpar e inserir os tipos de empreendimento dos campos do salvar interesse
    * @access private 
    * @param $id_interesse = id do interesse, $tipos = array de tipos de empreendimento
    * @return -
    */
	private function insertTiposEmp($id_interesse, $tipos = [])
	{
	    $this->cad_model->deleteTipoEmpInteresse([['id_interesse', $id_interesse]]);
	    foreach($tipos as $tipo){
    	            $this->cad_model->insertTipoEmpInteresse([
    	                'id_interesse' => $id_interesse,
    	                'tipo_emp' => $tipo
    	                ]);
	    }
	}
	
	
	
	function getSugestoesImoveis()
	{
	    try {
	        $data = $this->input->post();
            
            if(array_key_exists('bairro',$data) != true){
    	        $data['bairro'] = array("0" => '');
    	    }
    
    	    if($data['quartos'] == 4){
    	        $quartos = 'quartos >=';
    	    }
            else{
                $quartos = 'quartos';
            }	    
    	    
    	    if($data['banheiro'] == 4){
    	        $banheiros = 'banheiros >=';
    	    }
    	    else{
    	        $banheiros = 'banheiros';
    	    }
    	    
    	    if($data['vagas'] == 4){
    	        $vaga = 'vaga >=';
    	    }
    	    else{
    	        $vaga = 'vaga';
    	    }
    	    //'status' => 3 -> anuncios publicados somente
                
            $imoveis = [];
    	    foreach($data['bairro'] as $b){
    	        if(isset($data['tipo_emp_cliente'])){
    	            foreach($data['tipo_emp_cliente'] as $t){
    	                
    	                if($t == 'Terreno'){
    	                    
    	                    $where = array(
                	        'status' => 3,
                	        'id_imovel_rel' => 0,
                            'tipo_imovel'  => $t,
                            'bairro LIKE' => '%'.$b.'%',
                            $quartos => $data['quartos'],
                            $banheiros => $data['banheiro'],
                            $vaga => $data['vagas'], 
                            'val_pretendido >=' => $data['faixa_preco_inicio'],
                            'val_pretendido <=' => $data['faixa_preco_fim'],
                            );
    	                }
    	                else{
    	                    if($t == 'lancamento'){
    	                        
    	                        $where = array(
                    	        'status' => 3,
                    	        'id_imovel_rel' => 0,
                                'tipo_imovel'  => $data['tipo_imovel'],
                                'bairro LIKE' => '%'.$b.'%',
                                'tipo_empreendimento !=' => 'pronto',
                                $quartos => $data['quartos'],
                                $banheiros => $data['banheiro'],
                                $vaga => $data['vagas'], 
                                'val_pretendido >=' => $data['faixa_preco_inicio'],
                                'val_pretendido <=' => $data['faixa_preco_fim'],
                                );
    	                    }
    	                    else{
        	                    $where = array(
                    	        'status' => 3,
                    	        'id_imovel_rel' => 0,
                                'tipo_imovel'  => $data['tipo_imovel'],
                                'bairro LIKE' => '%'.$b.'%',
                                'tipo_empreendimento' => $t,
                                $quartos => $data['quartos'],
                                $banheiros => $data['banheiro'],
                                $vaga => $data['vagas'], 
                                'val_pretendido >=' => $data['faixa_preco_inicio'],
                                'val_pretendido <=' => $data['faixa_preco_fim'],
                                );    
    	                    }
    	                }
                        
                        foreach (array_keys($where) as $w){
                            if(($where[$w] == '%%'|| $where[$w] == '' || $where[$w] == '0' || $where[$w] == '%Brasília%') && $w != 'id_imovel_rel'){
                		        unset($where[$w]);
                	        }
                        }
                        
            	     
                        
                	    $imoveis_selecionados = $this->cad_model->getImoveis($where);
                	    if(!empty($imoveis_selecionados)){
                	        $imoveis = array_merge($imoveis,$imoveis_selecionados);
                	    }
                	    else{
                	        continue;
                	    }
    	            }
    	        }
    	        else{
    	            $where = array(
            	        'status' => 3,
            	        'id_imovel_rel' => 0,
                        'tipo_imovel'  => $data['tipo_imovel'],
                        'bairro LIKE' => '%'.$b.'%',
                        $quartos => $data['quartos'],
                        $banheiros => $data['banheiro'],
                        $vaga => $data['vagas'], 
                        'val_pretendido >=' => $data['faixa_preco_inicio'],
                        'val_pretendido <=' => $data['faixa_preco_fim'],
                    );
                    
                    foreach (array_keys($where) as $w){
                        if(($where[$w] == '%%'|| $where[$w] == '' || $where[$w] == '0' || $where[$w] == '%Brasília%') && $w != 'id_imovel_rel'){
            		        unset($where[$w]);
            	        }
                    }
                    
        	     
                    
            	    $imoveis_selecionados = $this->cad_model->getImoveis($where);
            	    if(!empty($imoveis_selecionados)){
            	        $imoveis = array_merge($imoveis,$imoveis_selecionados);
            	    }
            	    else{
            	        continue;
            	    }
                    if($b == 'Brasília'){
                        break;
                    }
    	        }
    	        
    	    }
    	    
    	    if(empty($imoveis))
                throw new Exception("Sem sujestões para esse interesse");
                    
            $sujestao = $this->getSujestoes($imoveis);
                
            
            $json = ['success' => true, 'html' => $sujestao['html'], 'cont' => $sujestao['cont'], 'msg' => 'Sugestões encontradas'];
            echo json_encode($json);
            
        } catch(Exception $e) {
            echo json_encode(['success' => false,'msg' => $e->getMessage()]);
        }
	}
	
	
	/*Funcao apagada de enviar sugestao do concluir atendimento
	public function enviarSugestao(){
	    
	    $this->load->library('form_validation');
	     
	    $this->form_validation->set_rules('experiencia', 'Experiencia', 'required');
	    $this->form_validation->set_rules('sugestao', 'Sugestao', 'required');
	    
	    $data = $this->input->post();
	    
	    $data['id_cadastro'] = $this->session->id_cadastro;
	    
	    if ($this->form_validation->run() != FALSE){
	       
	        if(!empty($data)){
	        
	            $this->cad_model->insertSugestao($data);
	            $json = ['success' => true, 'txt' => 'Sugestão enviada com sucesso'];
	        }
    	    else{
    	        $json = ['success' => false, 'txt' => 'Erro nos dados a serem enviados'];
    	    }   
	    }
        else{
            $json = ['success' => false,'erro' => 1,'txt' => validation_errors()];
        }

	    
	    echo json_encode($json);
	    
	}*/
	//Ação acionada ao clicar no botao salvar interesse/ atualiza com os imoveis no card/ envia email se tiver imoveis
	public function salvaInteresse(){
	    
	    $data = $this->input->post();
        
        
	    if(array_key_exists('bairro',$data) != true){
	        $data['bairro'] = array("0" => '');
	    }

	    if($data['quartos'] == 4){
	        $quartos = 'quartos >=';
	    }
        else{
            $quartos = 'quartos';
        }	    
	    
	    if($data['banheiro'] == 4){
	        $banheiros = 'banheiros >=';
	    }
	    else{
	        $banheiros = 'banheiros';
	    }
	    
	    if($data['vagas'] == 4){
	        $vaga = 'vaga >=';
	    }
	    else{
	        $vaga = 'vaga';
	    }
	    //'status' => 3 -> anuncios publicados somente
	    
	    $imoveis = [];
	    foreach($data['bairro'] as $b){
	        if(isset($data['tipo_emp_cliente'])){
	            foreach($data['tipo_emp_cliente'] as $t){
	                
	                if($t == 'Terreno'){
	                    
	                    $where = array(
            	        'status' => 3,
            	        'id_imovel_rel' => 0,
                        'tipo_imovel'  => $t,
                        'bairro LIKE' => '%'.$b.'%',
                        $quartos => $data['quartos'],
                        $banheiros => $data['banheiro'],
                        $vaga => $data['vagas'], 
                        'val_pretendido >=' => $data['faixa_preco_inicio'],
                        'val_pretendido <=' => $data['faixa_preco_fim'],
                        );
	                }
	                else{
	                    if($t == 'lancamento'){
	                        
	                        $where = array(
                	        'status' => 3,
                	        'id_imovel_rel' => 0,
                            'tipo_imovel'  => $data['tipo_imovel'],
                            'bairro LIKE' => '%'.$b.'%',
                            'tipo_empreendimento !=' => 'pronto',
                            $quartos => $data['quartos'],
                            $banheiros => $data['banheiro'],
                            $vaga => $data['vagas'], 
                            'val_pretendido >=' => $data['faixa_preco_inicio'],
                            'val_pretendido <=' => $data['faixa_preco_fim'],
                            );
	                    }
	                    else{
    	                    $where = array(
                	        'status' => 3,
                	        'id_imovel_rel' => 0,
                            'tipo_imovel'  => $data['tipo_imovel'],
                            'bairro LIKE' => '%'.$b.'%',
                            'tipo_empreendimento' => $t,
                            $quartos => $data['quartos'],
                            $banheiros => $data['banheiro'],
                            $vaga => $data['vagas'], 
                            'val_pretendido >=' => $data['faixa_preco_inicio'],
                            'val_pretendido <=' => $data['faixa_preco_fim'],
                            );    
	                    }
	                }
                    
                    foreach (array_keys($where) as $w){
                        if(($where[$w] == '%%'|| $where[$w] == '' || $where[$w] == '0' || $where[$w] == '%Brasília%') && $w != 'id_imovel_rel'){
            		        unset($where[$w]);
            	        }
                    }
                    
        	     
                    
            	    $imoveis_selecionados = $this->cad_model->getImoveis($where);
            	    if(!empty($imoveis_selecionados)){
            	        $imoveis = array_merge($imoveis,$imoveis_selecionados);
            	    }
            	    else{
            	        continue;
            	    }
	            }
	        }
	        else{
	            $where = array(
        	        'status' => 3,
        	        'id_imovel_rel' => 0,
                    'tipo_imovel'  => $data['tipo_imovel'],
                    'bairro LIKE' => '%'.$b.'%',
                    $quartos => $data['quartos'],
                    $banheiros => $data['banheiro'],
                    $vaga => $data['vagas'], 
                    'val_pretendido >=' => $data['faixa_preco_inicio'],
                    'val_pretendido <=' => $data['faixa_preco_fim'],
                );
                
                foreach (array_keys($where) as $w){
                    if(($where[$w] == '%%'|| $where[$w] == '' || $where[$w] == '0' || $where[$w] == '%Brasília%') && $w != 'id_imovel_rel'){
        		        unset($where[$w]);
        	        }
                }
                
    	     
                
        	    $imoveis_selecionados = $this->cad_model->getImoveis($where);
        	    if(!empty($imoveis_selecionados)){
        	        $imoveis = array_merge($imoveis,$imoveis_selecionados);
        	    }
        	    else{
        	        continue;
        	    }
                if($b == 'Brasília'){
                    break;
                }
	        }
	        
	    }
	    
	    if(!empty($data) && $data['id_cadastro'] != ''){
	        
	        $data_bairros = $data['bairro'];
	        unset($data['bairro']);
	        
	        if(isset($data['tipo_emp_cliente'])){
	            $data_tipo_emp = $data['tipo_emp_cliente'];
	            unset($data['tipo_emp_cliente']);
	        }
	        
	        $data['datahora_cadastro'] = date("Y-m-d H:i:s");
	        
	        $id_interesse = $this->cad_model->insertInteresse($data);
	        
	        if($id_interesse > 0){
	            
	            if(!empty($data_bairros)){
    	            
    	            foreach($data_bairros as $d){
        	            $insert_data = array(
        	                'id_interesse' => $id_interesse,
        	                'bairro' => $d
        	                );
        	            $this->cad_model->insertBairroInteresse($insert_data);
    	            }
	            }
	            
	            if(isset($data_tipo_emp)){
	                
    	            foreach($data_tipo_emp as $t){
        	            $insert_data = array(
        	                'id_interesse' => $id_interesse,
        	                'tipo_emp' => $t
        	                );
        	            $this->cad_model->insertTipoEmpInteresse($insert_data);
    	            }
	            }
	            
	            /*//Da update da origem da captura
	            $captura = [
                    'origem_captura'   => 'formCadInteressePainelCS'
                ];
                    
                $captura = $this->cad_model->updateCaptura($data['id_captura'],$captura);*/
                
        	    if(!empty($imoveis))
                {
                    
                    $sujestao = $this->getSujestoes($imoveis);
                    
                    //Linhas que tratavam do checkbox do Salvar Interesse
                    /*$email_final = array(
        	            "campanha" => 'Sugestões de Imóveis',
                        "mensagem" => '',
                        "subject" => 'Sugestões de imóveis do seu interesse'
                     );
                     
                    if(!empty($sujestao)){
                        $email_final['mensagem'].=$sujestao['email'];
    	                //$this->newsletter->enviar_email_campanha($data['email'], 87, $email_final);
    	                //$data['email'];
                        //$this->newsletter->enviar_email_campanha('matheus@comdono.com', 87, $email_final);	    
                        if($data['deseja_enviar_email_anunciar_inter'] == 1){
                            //Envia::email('matheus@comdono.com', 'sugestao_imovel_interessado', $email_final);
                            $json = ['success' => true, 'html' => $sujestao['html'], 'cont' => $sujestao['cont'], 'msg' => 'Interesse salvo / Email enviado']; 
                        }
                        else{
                            $json = ['success' => true, 'html' => $sujestao['html'], 'cont' => $sujestao['cont'], 'msg' => 'Interesse salvo / Email não enviado']; 
                        }
                          
                    }*/
                   
                    $json = ['success' => true, 'html' => $sujestao['html'], 'cont' => $sujestao['cont'], 'msg' => 'Interesse salvo'];
                    
                    //$json = ['success' => true, 'html' => $sujestao['html'], 'cont' => $sujestao['cont'], 'msg' => 'Interesse salvo / Email enviado']; 
                }
                else{
                    
                    $json = ['success' => true, 'html' => '', 'cont' => 0, 'msg' => 'Interesse salvo'];
                }
	        }
	        else{
	            $json = ['success' => false, 'html' => '', 'cont' => 0, 'msg' => 'Erro'];
	        }
            
	    }
    	else{
    	    $json = ['success' => false, 'html' => '', 'msg' => 'Erro, Não possui cadastro'];
    	}   
    	
    	
    	
    	
	  
	    echo json_encode($json);
	    
	}
	
	
	public function enviaEmailSugestoes(){
	    
	    $posts = $this->input->post();
	    
	    $empty_posts = $posts;
	    unset($empty_posts['email']);
	    
	    if(!empty($empty_posts)){
	        
    	    $imoveis =[];
    
    	    for($i = 0; $i <= $posts['qtd_sugestoes'];$i++){
    	        $imoveis_selecionados = $this->cad_model->getImoveis(['id_imovel' => $posts['id_imovel'.$i]]);
    	        
    	        if(!empty($imoveis_selecionados) || $imoveis_selecionados != NULL){
    	            $imoveis = array_merge($imoveis,$imoveis_selecionados);
    	        }
    	    }
            if(!empty($imoveis))
            {
                $cont=$posts['qtd_sugestoes'];
        	    $selecoes=0;
        	    $index=0;
        	    $imoveis_selecionados = [];
        	    for ($index=0; $index<=$cont; $index++){
        	        if($posts["checkbox_sugestao$index"] == 'on'){
        	            $envio["key_anuncio"]=$posts['key_anuncio'.$index];
        	            $envio["foto"]=$posts['foto'.$index];
        	            $envio["endereco"]=$posts['endereco'.$index];
        	            $envio["bairro"]=$posts['bairro'.$index];
        	            $envio["cidade"]=$posts['cidade'.$index];
        	            $envio["estado"]=$posts['estado'.$index];
        	            $envio["quartos"]=$posts['quartos'.$index];
        	            $envio["banheiros"]=$posts['banheiros'.$index];
        	            $envio["vaga"]=$posts['vaga'.$index];
        	            $envio["id_imovel"]=$posts['id_imovel'.$index];
        	            $envio["tipo_empreendimento"]=$posts['tipo_empreendimento'.$index];
        	            $envio["lancamento"]=$posts['lancamento'.$index];
        	            $imoveis_selecionados[$selecoes]=$envio;
        	            $selecoes++;
        	        }
        	    }
        	    
        	    
        	    if(!empty($imoveis_selecionados)){
        	        
        	        $email_corpo="";
        	        $dados['cont']=0;
	                foreach($imoveis_selecionados as $im) { 
            	        $imagens = $this->cad_model->getImgsImovel($im['id_imovel']);
            	        if(!empty($imagens)){
            	            
            	            
            	            $img = $imagens[0];
            	        
            	            $foto = $img->uri.$img->imagem;
            	            if($img->uri == '' || $img->imagem == ''){
            	                $foto = '';
            	            }
            	            
            	        }
            	        else{
            	             $foto = base_url('themes/comdono/img/no-image.png');
            	             //se um imovel nao tiver foto -> continue; se quiser excluir ele da lista
            	        }
            	        $dados['foto']=$foto;
            	        $dados['im']=$im;
            	        
            	        $dados['link'] = $im['lancamento'] == 'Sim'?base_url("lancamento/").$im['id_imovel']."/".$im['key_anuncio']:base_url("imovel/").$im['id_imovel']."/".$im['key_anuncio'];
            	        
            	        $email_corpo .= Template::getView('atendimento/blocos/box_sugestoes_todas_cadastro_interesse_view', $dados);
                        
                        $dados['cont']++;
                    
                    }
                
                    $retorno['email']='<div class="text-muted"> <p>Foram encontrados <b>'.$dados['cont'].' Imóveis</b> no seu Interesse </p> <br> </div> <div class="pr-2"  > ';
                    $retorno['email'].=$email_corpo;
                    $retorno['email'].=' </div>';
        	        
        	        $email_final = array(
        	            "campanha" => 'Sugestões de Imóveis',
                        "mensagem" => '',
                        "subject" => 'Sugestões de imóveis do seu interesse'
                    );
                    
        	        $email_final['mensagem'].=$retorno['email'];
        	        //$posts['email']
        	        Envia::email($posts['email'], 'sugestao_imovel_interessado', $email_final);
        	        
        	        $json = ['success' => true, 'html' => '', 'cont' => '', 'msg' => 'Email enviado']; 
        	    }
        	    else{
        	        $json = ['success' => false, 'msg' => 'Selecione um imóvel para enviar o Email'];
        	    }
        	    
                /*$sujestao = $this->getSujestoes($imoveis);
                
                $email_final = array(
    	            "campanha" => 'Sugestões de Imóveis',
                    "mensagem" => '',
                    "subject" => 'Sugestões de imóveis do seu interesse'
                 );
                 
                if(!empty($sujestao)){
                    $email_final['mensagem'].=$sujestao['email'];
                    //$this->newsletter->enviar_email_campanha($data['email'], 87, $email_final);
                    //$data['email'];
                    Envia::email($posts['email'], 'sugestao_imovel_interessado', $email_final);
                    
                    //$this->newsletter->enviar_email_campanha('robson@comdono.com', 87, $email_final);	    
                
                      
                 }
               
                $json = ['success' => true, 'html' => $sujestao['html'], 'cont' => $sujestao['cont'], 'msg' => 'Email enviado']; 
            */
            
                
            }
            else{
                
                $json = ['success' => false, 'html' => '', 'cont' => 0, 'msg' => 'Erro, sem imóveis'];
            }
	    }
	    else{
	        $json = ['success' => false, 'html' => '', 'cont' => 0, 'msg' => 'Sem imóveis para enviar'];
	    }
        
        echo json_encode($json);
	}
	
	//Pega os imoveis e monta o html para enviar por email e para o card a direita do interesse
	public function getSujestoes($imoveis)
	{
	    $retorno = array(
            "cont" => 0,
            "html" => '',
            "email" =>''
        );
        $dados['cont']=$retorno['cont'];
        $email_corpo="";
	    //$html = '';
	    foreach($imoveis as $im) { 
	        $im->val_pretendido = money($im->val_pretendido);
	        $imagens = $this->cad_model->getImgsImovel($im->id_imovel);
	        if(!empty($imagens)){
	            
	            
	            $img = $imagens[0];
	        
	            $foto = $img->uri.$img->imagem;
	            if($img->uri == '' || $img->imagem == ''){
	                $foto = '';
	            }
	            
	        }
	        else{
	             $foto = base_url('themes/comdono/img/no-image.png');
	             //se um imovel nao tiver foto -> continue; se quiser excluir ele da lista
	        }
	        
	        $dados['foto']=$foto;
	        $dados['im']=$im;
	        
	        $dados['link'] = $im->lancamento == 'Sim'?base_url("lancamento/").$im->id_imovel."/".$im->key_anuncio:base_url("imovel/").$im->id_imovel."/".$im->key_anuncio;
	        
	        $email_corpo .= Template::getView('atendimento/blocos/box_sugestoes_todas_view', $dados);
	   
            $retorno['html'] .= Template::getView('atendimento/blocos/box_sugestoes_interesses_view', $dados);
            
            $dados['cont']++;
            
        }
        
        $retorno['cont']=$dados['cont'];
        $retorno['email']='<div class="text-muted"> <p>Foram encontrados <b>'.$dados['cont'].' Imóveis</b> no seu Interesse </p> <br> </div> <div class="pr-2"  > ';
        $retorno['email'].=$email_corpo;
        $retorno['email'].=' </div>';
        
        
	    return $retorno;
	}
	
	//Funcao para enviar por whatsapp aqueles interesses selecionados
	//A partir de 100 imoveis achados ele apresenta um erro de captura dos imoveis da view/ limite de 100
	/*public function enviaSugestoes(){
	    $this->load->library('atendimento/zapi_whatsapp');
	    $data = $this->input->post();
	    $telefone = str_replace("(" , "", $data['telefone']);
	    $telefone = str_replace(")" , "", $telefone);
	    $telefone = str_replace(" " , "", $telefone);
	    $telefone = str_replace("-" , "", $telefone);
	    $telefone = "55".$telefone;
	    
	    $empty_data = $data;
	    
	    unset($empty_data['telefone']);
	    
	    if(!empty($empty_data)){
    	        
    	    
    	    if(!empty($data)){
    	        
    	    
        	    $cont=$data['qtd_sugestoes'];
        	    $selecoes=0;
        	    $index=0;
        	    $imoveis_selecionados = [];
        	    for ($index=0; $index<=$cont; $index++){
        	        if($data["checkbox_sugestao$index"] == 'on'){
        	            $envio["key_anuncio"]=$data['key_anuncio'.$index];
        	            $envio["foto"]=$data['foto'.$index];
        	            $envio["endereco"]=$data['endereco'.$index];
        	            $envio["bairro"]=$data['bairro'.$index];
        	            $envio["cidade"]=$data['cidade'.$index];
        	            $envio["estado"]=$data['estado'.$index];
        	            $envio["quartos"]=$data['quartos'.$index];
        	            $envio["banheiros"]=$data['banheiros'.$index];
        	            $envio["vaga"]=$data['vaga'.$index];
        	            $envio["id_imovel"]=$data['id_imovel'.$index];
        	            $envio["tipo_empreendimento"]=$data['tipo_empreendimento'.$index];
        	            $envio["lancamento"]=$data['lancamento'.$index];
        	            $imoveis_selecionados[$selecoes]=$envio;
        	            $selecoes++;
        	        }
        	    }
        	    
        	    
        	    if(!empty($imoveis_selecionados)){
            	        
            	    $flag_erro_msg=0;
            	    
            	    $return_msg_titulo = $this->zapi_whatsapp->sendMessage($telefone, '*Sugestões de Imóveis do seu Interesse:*');
            	    
            	    foreach($imoveis_selecionados as $im_sel){
            	        
            	        $link_imovel = $im_sel['lancamento'] == 'Sim'?base_url("lancamento/").$im_sel['id_imovel']."/".str_replace(" " , "-", $im_sel['key_anuncio']):base_url("imovel/").$im_sel['id_imovel']."/".str_replace(" " , "-", $im_sel['key_anuncio']);
            	        $mensagem_descricao = '*'.$im_sel['key_anuncio'].'*
    '.$im_sel['endereco'].'
    '.$im_sel['bairro'].', '.$im_sel['cidade'].' - '.$im_sel['estado'].'
    '.$im_sel['quartos'].' Quarto(s) | '.$im_sel['banheiros'].' Banheiro(s) | '.$im_sel['vaga'].' Vaga(s)
    *Imóvel*: '.$link_imovel;
            //$data['linkRedict'] = $imovel->lancamento == 'Sim'?base_url('lancamento/'.$imovel->id_imovel):base_url('imovel/'.$imovel->id_imovel);
            
            	        $return_msg = $this->zapi_whatsapp->sendImage($telefone, $im_sel['foto'], $mensagem_descricao);
            	        
            	        if($return_msg == FALSE || $return_msg_titulo == FALSE){
            	            $flag_erro_msg=1;
            	        }
            	    }
            	    
                	    
            	        if($flag_erro_msg == 1){
                            $json = ['success' => false, 'msg' => 'Ocorreu um erro no envio'];
                        }else{
                            $json = ['success' => true, 'msg' => 'A mensagem está sendo enviada'];
                        }
            	    // $this->load->library('atendimento/zapi_whatsapp');
                    //    $return_msg = $this->zapi_whatsapp->sendMessage('5561996849576','Mensagem teste api');
                    //    
                    //    if($return_msg == FALSE){
                    //        $json = ['success' => false, 'status' => 2, 'msg' => 'Não foi possivel efetuar o envio de mensagem', 'dados' => $voip];
                    //    }else{
                    //       $json = ['success' => true, 'msg' => 'Mensagem sendo enviada', 'dados' => $voip];
                    //    }
        	    }
        	    else{
        	        $json = ['success' => false, 'msg' => 'Selecione um imóvel para enviar a mensagem'];
        	    }
    	    }
    	    else{
    	        $json = ['success' => false, 'msg' => 'Nenhum imóvel para selecionar / Salvar interesse antes'];
    	    }
	    }
	    else{
	        $json = ['success' => false, 'msg' => 'Sem imóveis para enviar'];
	    }
        echo json_encode($json);    
	}*/
	
    public function getFiltroHistorico(){
	   $post = $this->input->post(); 
	   
	   $post['data'] = converte_data(substr($post['data'],0,-6),1);
	   
	   $historicos = $this->admin_model->getHistoricosAtendimentoIncorporadoras($this->session->id_cadastro, $post['data']);
	   
	   $data['historicos'] = [];
	   
	   
	   
	   foreach($historicos as $hist){
	       
	       if($post['empreendimento'] == 'todos'){
	           $w1 = [['id_agenda',$hist->id_origem]];
    	       $w2 = [['id_captura',$hist->id_origem]];
    	   }else{
    	       $w1 = [['id_agenda',$hist->id_origem],['origem_captura',$post['empreendimento']]];
	           $w2 = [['id_captura',$hist->id_origem],['origem_captura',$post['empreendimento']]];
    	   }
	       
            if($hist->origem == 1){
                $cap = $this->cad_model->getCapAgenda($w1);
                
                if($cap != NULL){
                    $cad = $this->cad_model->getCadastro([['id_cadastro', $cap->id_cadastro]]);
                    $uri = 'desistencia';
                }else{
                    continue;
                }
            }else{
                $cap = $this->cad_model->getCaptura($w2);
                
                if($cap != NULL){
                    $cad = $this->cad_model->getCadastro([['id_cadastro', $cap->id_cadastro]]);
                    $uri = 'atendimento';
                }else{
                    continue;
                }
            }
            
            //STATUS VAO AUMENTAR FAZER SWITCH CASE
            if($hist->status == 1){
                $hist->status_formatado = '<span class="badge badge-warning">Em Atendimento</span>';
            }elseif($hist->status == 2){
                $hist->status_formatado = '<span class="badge badge-success">Finalizado</span>';
            }elseif($hist->status == 3){
                $hist->status_formatado = '<span class="badge badge-info">Adiado</span>';
            }
            
            $hist->captura = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$cap->origem_captura]])->emp_nome_fantasia;
            $hist->uri_atend = $uri.'/'.$hist->id_origem;
            
            $data['historicos'][] = (object)array_merge((array)$hist, (array)$cad, (array)$cap);
        }
        
        $html = Template::getView('atendimento/blocos/box_table_filtro', $data);
        
        if($html != ''){
            echo json_encode(['valid' => true, 'tb' => $html]);
        }else{
            echo json_encode(['valid' => true, 'tb' => '<p>Sem Dados Cadastrados!</p>']);
        }
        
	}
	
	public function enviaInfoEmail(){
	    
	    $post = $this->input->post();
	    
	    //funcao para verificar se os elementos do formulario estao vazios // tirando o input hidden
	    $data = (array)$post;
	    unset($data['email']);
	    unset($data['emp_envia_info_empreendimento']);
	    unset($data['id_empreendimento']);
	    $data = array_filter($data);
	    
	    if(empty($data)){
	        
	        $json = ['success' => false, 'msg' => 'Selecione alguma opção ou mensagem para enviar por email'];
	        
	    }
	    else{
	        
	        if($post['emp_envia_info_empreendimento'] != ''){
	            
    	        $empreendimento = $this->cad_model->getEmpreendimento(['uuid_empreendimento',$post['emp_envia_info_empreendimento']]);
    	        $lpConfig =  $this->cad_model->getLpConfig([['id_imovel',$empreendimento->id_imovel]]);   
    	        $envio['nome_empreendimento_escolhido'] = $empreendimento->emp_nome_fantasia;
    	        if(!isset($empreendimento->emp_nome_fantasia)){
    	            $envio['nome_empreendimento_escolhido'] = '';
    	        }
	        }
	        else{
	            $envio['nome_empreendimento_escolhido'] = '';
	        }
	        
	        $eventos = $this->cad_model->getEventos([['inc_evento.id_empreendimento', $post['id_empreendimento']],['data_hora >', date("Y-m-d H:i:s")]]);
	        
	        
	        $temp_date = '9999-99-99 99:99:99';
	        foreach($eventos as $e){
	            if($e->data_hora < $temp_date){
	                $evento = $e;
	                $temp_date = $e->data_hora;
	            }
	        }
	        
	        
	        //verificar se algum campo de retorno está vazio do $lpConfig
	        $envio['pagina_at_ebook_file']='';
	        $envio['pagina_at_ebook_img']='';
	        $envio['seo_site_url']='';
	        $envio['localizacao_stand']='';
	        $envio['envia_info_text_area']='';
	        $envio['localizacao_comdono']='';
	        $envio['localizacao_emp']='';
	        $envio['apresentacao_comdono']='';
	        $envio['convite_comdono']='';
	        $envio['convite_comdono_nome_evento'] ='';
            $envio['convite_comdono_data_hora'] ='';
            $envio['convite_comdono_localizacao']='';
            $envio['flag_evento'] = false;
	        foreach(array_keys($post) as $p){
	            if($post[$p] == 'on'){ 
	                switch ($p){
	                    case 'emp_envia_info_book_digital':
	                        $envio['pagina_at_ebook_file']=$lpConfig->pagina_at_ebook_file;
	                        $envio['pagina_at_ebook_img']=$lpConfig->pagina_at_ebook_img;
	                        break;
	                    case 'emp_envia_info_landing_page':
	                        $envio['seo_site_url']=$lpConfig->seo_site_url;
	                        break;
	                    case 'emp_envia_info_localizacao_stand':
	                        $envio['localizacao_stand']=$lpConfig->localizacao_stand;
	                        break;
	                    case 'emp_envia_info_localizacao_emp':
	                        $envio['localizacao_emp']='https://www.google.com/maps/search/?api=1&query='.$empreendimento->latitude.','.$empreendimento->longitude;
	                        break;
	                    case 'envia_info_mensagem':
	                        $envio['envia_info_text_area']=$post['envia_info_text_area'];
	                        break;
	                    case 'comdono_envia_info_localizacao_comdono':
	                        $envio['localizacao_comdono']='https://goo.gl/maps/Thx5k6VCt4nvkV5s6';
	                        break;
	                    case 'comdono_envia_info_apresentacao_comdono':
	                        $envio['apresentacao_comdono']='https://youtu.be/hxzsHbsfa90';
	                        break;
	                    case 'comdono_envia_info_convite_comdono':
	                        if(isset($evento)){
	                            $envio['flag_evento'] = true;
	                            $envio['convite_comdono_nome_evento'] = $evento->nome_evento;
	                            $envio['convite_comdono_data_hora'] = $evento->data_hora;
	                            $envio['convite_comdono_localizacao']='https://www.google.com/maps/search/?api=1&query='.$evento->latitude.','.$evento->longitude;
	                        }
	                        break;
	                    default:
	                        break;
	                }
	            }
	        }
	        $teste_vazio = $envio;
	        unset($teste_vazio['nome_empreendimento_escolhido']);
	        $flag_teste = 0;
	        foreach ($teste_vazio as $t){
	            if(!empty($t)){
	                $flag_teste = 1;
	            }
	        }
	        
	        if($flag_teste == 0 && !empty($data)){
	            
	            $json = ['success' => false, 'msg' => 'O(s) dado(s) selecionados ainda nao foram publicados'];
	            
	        }
	        else{
    	        
    	        $email_corpo = Template::getView('atendimento/blocos/box_informacoes_email_view', $envio);
    	        
    	        $email_final='<div class="text-muted"> <p>Foram selecionadas algumas informações para sua visualização </p> <br> </div> <div class="pr-2"  > ';
                $email_final.=$email_corpo;
                $email_final.=' </div>';
    	        
    	        
    	        $email = array(
        	            "campanha" => 'Informações',
                        "mensagem" => $email_final,
                        "subject" => 'Informações que podem ser do seu interesse'
                );
    	        
    	        //$post['email'];
    	        $retorno = Envia::email($post['email'], 'envia_informacao_lead', $email);
    	        
    	        if($retorno == true){
    	            $json = ['success' => true, 'msg' => 'Email enviado com sucesso'];
    	        }
    	        else{
    	            $json = ['success' => false, 'msg' => 'Falha ao enviar o email'];
    	        }	            
	        }
	        

	    }
	    
	    echo json_encode($json);
	
	}
	/*	
	public function enviaInfoWhats(){
	    
	    $this->load->library('atendimento/zapi_whatsapp');
	    $post = $this->input->post();
	    unset($post['email']);
	    
	    //funcao para verificar se os elementos do formulario estao vazios // tirando o input hidden
	    $data = (array)$post;
	    
	    unset($data['emp_envia_info_empreendimento']);
	    $data = array_filter($data);
	    
	    if(empty($data)){
	        
	        $json = ['success' => false, 'msg' => 'Selecione alguma opção ou mensagem para enviar por email'];
	        
	    }
	    else{
	        
	        //verificar quem ta on, e formatar o envio
	        if($post['emp_envia_info_empreendimento'] != ''){
	            $empreendimento = $this->cad_model->getEmpreendimento(['uuid_empreendimento',$post['emp_envia_info_empreendimento']]);
	            $lpConfig =  $this->cad_model->getLpConfig([['id_imovel',$empreendimento->id_imovel]]);
	            $envio['emp_nome_fantasia']=$empreendimento->emp_nome_fantasia;
	        }
	        $eventos = $this->cad_model->getEventos();
	        //dd($eventos);
	        
	        
	        //verificar se algum campo de retorno está vazio do $lpConfig
	        $envio['pagina_at_ebook_file']='';
	        $envio['pagina_at_ebook_img']='';
	        $envio['seo_site_url']='';
	        $envio['localizacao_stand']='';
	        $envio['envia_info_text_area']='';
	        $envio['localizacao_comdono']='';
	        $envio['localizacao_emp']='';
	        $envio['apresentacao_comdono']='';
	        $envio['convite_comdono']='';
	        foreach(array_keys($post) as $p){
	            if($post[$p] == 'on'){
	                switch ($p){
	                    case 'emp_envia_info_book_digital':
	                        $envio['pagina_at_ebook_file']=$lpConfig->pagina_at_ebook_file;
	                        $envio['pagina_at_ebook_img']=$lpConfig->pagina_at_ebook_img;
	                        break;
	                    case 'emp_envia_info_landing_page':
	                        $envio['seo_site_url']=$lpConfig->seo_site_url;
	                        break;
	                    case 'emp_envia_info_localizacao_stand':
	                        $envio['localizacao_stand']=$lpConfig->localizacao_stand;
	                        break;
	                    case 'emp_envia_info_localizacao_emp':
	                        $envio['localizacao_emp']='https://www.google.com/maps/search/?api=1&query='.$empreendimento->latitude.','.$empreendimento->longitude;
	                        break;
	                    case 'envia_info_mensagem':
	                        $envio['envia_info_text_area']=$post['envia_info_text_area'];
	                        break;
	                    case 'comdono_envia_info_localizacao_comdono':
	                        $envio['localizacao_comdono']='https://goo.gl/maps/Thx5k6VCt4nvkV5s6';
	                        break;
	                    case 'comdono_envia_info_apresentacao_comdono':
	                        $envio['apresentacao_comdono']='https://youtu.be/hxzsHbsfa90';
	                        break;
	                    case 'comdono_envia_info_convite_comdono':
	                        $envio['convite_comdono']='Convite Comdono';
	                        break;
	                    default:
	                        break;
	                }
	            }
	        }
	        
	        $mensagem =  Template::getView('atendimento/blocos/box_informacoes_whats_view', $envio);
	        $mensagem = trim($mensagem);
            
            if(!empty($mensagem)){
                
	        $return_msg = $this->zapi_whatsapp->sendMessage('5561996849576', $mensagem);
    	        
    	        
    	        if($return_msg == false || empty($return_msg)){
    	           $json = ['success' => false, 'msg' => 'Erro ao enviar a mensagem'];
    	        }
    	        else{
    	           $json = ['success' => true, 'msg' => 'Mensagem enviada com sucesso'];
    	        }
            }
            else{
                $json = ['success' => false, 'msg' => 'Erro nos dados para envio, contactar o suporte'];
            }
	        
	        
	        
	    }
	    echo json_encode($json);
	}
	*/
	public function enviaDescricao(){
	    $data = $this->input->post();
	    //dd($data);
	    
	    if(!empty($data)){
	        //insert
	        $retorno = $this->cad_model->insertAtendDescricao($data);
	        if($retorno > 0){
    	        $json = ['success'=>true,'txt'=>"Descrição salva"];
    	    }
    	    else{
    	        $json = ['success'=>false,'txt'=>"Erro ao salvar"];
    	    }
	    }
	    
	    echo json_encode($json);
	}
	
	public function excluirInteresse(){
	    $data = $this->input->post();
	    $id_interesse = $data['id_interesse'];
	    $data['ativo'] = 0;
	    unset($data['id_interesse']);
	    $return = $this->cad_model->updateInteresse($id_interesse,$data);
	    
	    if($return == true){
	        $json = ['success'=>true];
	    }
	    else{
	        $json = ['success'=>false];
	    }
	    echo json_encode($json);
	}
	
	public function editarInteresse(){
	    $data = $this->input->post();
	    
	    $existe_bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $data['id_interesse']]]);
	    $existe_tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $data['id_interesse']]]);
	    
	    if(!empty($existe_bairros) || !empty($existe_tipo_emp)){
	       //tem bairros no banco
	       //deletar os bairros e atualizar
	       //isset($data['bairro'])
	       
	       $return_delete_b = $this->cad_model->deleteInteresseBairros([['id_interesse', $data['id_interesse']]]);
	       $return_delete_t = $this->cad_model->deleteTipoEmpInteresse([['id_interesse', $data['id_interesse']]]);
	       
	       if($return_delete_b == true || $return_delete_t == true){
	            
    	        if(isset($data['bairro'])){
	                $data_bairros = $data['bairro'];
    	            unset($data['bairro']);    
	            }
	            if(isset($data['tipo_emp_cliente'])){
	                $data_tipo_emp = $data['tipo_emp_cliente'];
    	            unset($data['tipo_emp_cliente']);    
	            }
    	        
    	        $return_update = $this->cad_model->updateInteresse($data['id_interesse'],$data);
    	        
    	        if($return_update == true && isset($data_bairros)){
    	            
    	        
    	            foreach($data_bairros as $d){
        	            $insert_data_b = array(
        	                'id_interesse' => $data['id_interesse'],
        	                'bairro' => $d
        	                );
        	            $this->cad_model->insertBairroInteresse($insert_data_b);
    	            }
    	        }
    	        
    	        if($return_update == true && isset($data_tipo_emp)){
    	            
    	        
    	            foreach($data_tipo_emp as $t){
        	            $insert_data_t = array(
        	                'id_interesse' => $data['id_interesse'],
        	                'tipo_emp' => $t
        	                );
        	            $this->cad_model->insertTipoEmpInteresse($insert_data_t);
    	            }
    	        }
    	        
    	        
    	        $json = ['success' => true, 'msg' => 'Interesse modificado'];
	        }
	        else{
	            //erro ao deletar do banco os bairros
	            $json = ['success' => false, 'msg' => 'Erro de delete no banco'];
	        }
	    }
	    else{
	       //não tem bairros no banco 
	       //somente atualizar
	       //isset($data['bairro'])
	            
	            if(isset($data['bairro'])){
	                $data_bairros = $data['bairro'];
    	            unset($data['bairro']);    
	            }
	            
    	        $id_interesse = $this->cad_model->updateInteresse($data['id_interesse'],$data);
    	        
    	        if($id_interesse == true && isset($data_bairros)){
    	            
    	        
    	            foreach($data_bairros as $d){
        	            $insert_data = array(
        	                'id_interesse' => $data['id_interesse'],
        	                'bairro' => $d
        	                );
        	            $this->cad_model->insertBairroInteresse($insert_data);
    	            }
    	        }
    	        
    	        $json = ['success' => true, 'msg' => 'Interesse modificado'];
	    }
	    
	    echo json_encode($json);
	}
	
	public function anunciarImovel(){
	    $data = $this->input->post();
	    
	    $imovel['id_cadastro'] = $data['id_cadastro'];
	    $imovel['id_imovel_rel'] = 0;
	    $imovel['lancamento'] = 'Não';
	    $imovel['step'] = 1;
	    $imovel['status'] = 1;
	    $imovel['doc_perfil'] = 'cpf';
	    $imovel['dn_nome_nomefantasia'] = $data['nome'];
	    $imovel['telefone'] = $data['telefone'];
	    $imovel['dn_email'] = $data['email'];
	    $imovel['dn_cpf_cnpj'] = $data['cpf'];
	    $imovel['dn_img'] = $data['img_perfil'];
	    
	    if(!empty($data)){
	        
	        $id_imovel = $this->cad_model->insertImovel($imovel);
	        if($id_imovel > 0){
	            $json = ['success' => true, 'link' => base_url('administrativo/braco_direito/edit_imovel_cs/'.$id_imovel)];    
	        }
	        else{
	            $json = ['success' => false, 'link' => ''];    
	        }
	        
	        
	    }    
	    else{
	        $json = ['success' => false, 'link' => ''];
	    }
	    echo json_encode($json);
	}
	
	public function addNovoUsuario(){
	    
	    $this->load->library('form_validation');
	    $data = $this->input->post();
	    
	    $data['data_nascimento'] = converte_data($data['data_nascimento'],1);
	    if(!isset($data['unidade'])){
	        $data['unidade']='';
	    }
	    
	    $data['tipo_imovel']=$data['unidade'];
	    
	    $data['datetime_captura'] = date("Y-m-d H:i:s");
    	    
    	    $this->form_validation->set_rules('emp_nome_fantasia', 'Empreendimento', 'required');
    	    //$this->form_validation->set_rules('unidade', 'Unidade', 'required');
    	    $this->form_validation->set_rules('nome', 'Nome', 'required');
    	    //$this->form_validation->set_rules('cpf', 'Cpf', 'required');
    	    $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
    	    $this->form_validation->set_rules('telefone', 'Telefone', 'required');
    	    //$this->form_validation->set_rules('possui_conjuje', 'Possui_conjuje', 'required');
    	    //$this->form_validation->set_rules('data_nascimento', 'Data de Nascimento', 'required');
    	    //$this->form_validation->set_rules('renda_familiar', 'Renda familiar', 'required');
    	    
    	    if($this->form_validation->run() == FALSE)
    	    {
    	        $json = ['success'=>false,'txt'=>validation_errors()];
    	    }
    	    else{
    	    
    	        $valida = valida_cpf($data['cpf']);
    	        
    	        if(empty($data['cpf'])){
    	            $valida = true;
    	        }
    	        
                if($valida == false){
                    
                    $json = ['success'=>false,'txt'=>'Cpf digitado é inválido'];
                    
                }
                else{
                    
            	    $uuid_emp = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['emp_nome_fantasia']]])->uuid_empreendimento;
            	    $cadastro = $this->cad_model->getCadastroByEmail($data['email']);
            	    $verifica_email_emp = $this->cad_model->getCaptura(['email',$data['email'],['origem_captura',$uuid_emp]]);
            	    
            	    
            	    //VERIFICA SE UM EMAIL NÃO ESTÁ LINKADO A UM MESMO EMPREENDIMENTO
            	    if(empty($verifica_email_emp)){
            	    
                	    
                    	if(empty($cadastro))
                    	{
                    	    
                    	    $data['id_cadastro'] = $this->cad_model->insertCadastro($data);
                    	        
                    	}
                    	else{
                    	    $data['id_cadastro'] = $cadastro->id_cadastro;
                    	        
                    	}
                    	
                    	$data['origem_captura'] = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['emp_nome_fantasia']]])->uuid_empreendimento;
                    	
                    	$captura = $this->cad_model->insertCaptura($data);
                    	
                    	$data['id_captura']=$captura;
                    	
                    	$id_captura = $captura;
                    	
                //Gerando chave de captura--------------------------------------------------------    	
                    	
                
                    	
                    	$key_captura = $id_captura.$this->gerar_senha(3,false,true,true,false);
                        $update = [
                            'key_captura'     => $key_captura,
                            //'status_captura'  => 3,
                            ];
                        
                        $this->cad_model->updateCaptura($id_captura,$update);
                        $data['key_captura'] = $key_captura;
                        
                        $empreendimento = $this->cad_model->getEmpreendimento(['uuid_empreendimento',$data['origem_captura']]);
                        $origem = $this->session->origem??NULL;
                        if($origem !== NULL)
                        {
            	            $origem = array_merge($origem,[
            	                'click_action'=>'Captura Cartao Vip',
            	                'id_cad'=>$this->session->id_cadastro??0,
            	                'tb_result'=>'cad_captura',
            	                'id_result'=>$id_captura,
            	                'conta_nova'=>0,
            	                'date_time'=>date('Y-m-d H:i:s')
            	                ]);
                            $this->cad_model->insertCapturaOrigem($origem);
                        }
                        
                        $config = $this->cad_model->getLpConfig(['id_imovel', $empreendimento->id_imovel]);
                        $parceiro = $this->admin_model->getProximoParceiro($data['origem_captura'], $empreendimento->id_empreendimento);
                        $linkCartaoVip     = base_url('landingpage/resultado/codigovip/'.$data['origem_captura'].'/'.$key_captura) ;//ATIVACAO DO CARTAO VIP
                        $linkAgendarVisita = base_url('landingpage/resultado/confirmacao/'.$data['origem_captura'].'/'.$key_captura) ;//AGENDAMENTO DE VISITA
                        
                        
                         $dt = [
                                'key_captura'  => $key_captura,
                                'uuid'         => $data['origem_captura'],
                                'nome'         => $data['nome'],
                                'tipo_imovel'  => $data['unidade'],
                            ];
                        
                        if($parceiro != null)
                        {
                            $this->cad_model->updateCaptura($id_captura,['id_parceiro' => $parceiro->id_parceiro]);
                            //tipo_atendimento - 1 - Painel CS / 2 - Painel Incorporadora
                            if($parceiro->tipo_atendimento == 1)
                            {
                                if($config->tag_cv_precad != ''){
                                    Newsletter::setTagRelCap($config->tag_cv_precad, $id_captura);
                                    Envia::email($data['email'], $config->tag_cv_precad, $dt);
                                }
                                $redirect = $linkCartaoVip;//ATIVACAO DO CARTAO VIP
                            }
                            if($parceiro->tipo_atendimento == 2 )
                            {
                                if($config->tag_ag_precad != ''){
                                    Newsletter::setTagRelCap($config->tag_ag_precad, $id_captura);
                                    Envia::email($data['email'], $config->tag_ag_precad, $dt);
                                }
                                $redirect = $linkAgendarVisita;//AGENDAMENTO DE VISITA
                            }
                        }
                        else
                        {
                            if($config->pagina_tipo == 1)
                            {
                                if($config->tag_ag_precad != ''){
                                    Newsletter::setTagRelCap($config->tag_ag_precad, $id_captura);
                                    Envia::email($data['email'], $config->tag_ag_precad, $dt);
                                }else{
                                
                                    $this->rd_lib->rds_key_update($id_captura, $data['link']);
                                }
                                $redirect = $linkAgendarVisita;
                            }
                            else
                            {
                                if($config->tag_cv_precad != ''){
                                    Newsletter::setTagRelCap($config->tag_cv_precad, $id_captura);
                                    Envia::email($data['email'], $config->tag_cv_precad, $dt);
                                }
                                else{
                                    $this->rd_lib->rds_key_update($id_captura, $data['link']);
                                }
                                $redirect = $linkCartaoVip;
                            }
                        }
                        
                        HEmail::alerta($empreendimento->emp_nome_fantasia, $data);
                    	
                    	
                    	
                //-------------------------------------------------------------------------------
                    	
                    	
                    	
                    	
                    	if($captura > 0)
                    	{
                    	    $update_fila = array(
                    	        "origem" => 2,
                                "id_origem" => $data['id_captura'],
                                "id_responsavel" => $this->session->id_cadastro,
                                "status" => 1
                            );
                    	    $this->admin_model->setStatusFila($update_fila);
                    	    $json = ['success'=>true,'txt'=>"Novo usuário adicionado",'url'=>base_url('atendimento/incorporadoras/atendimento/agendamento/'.$data['id_captura'])];
                    	}
                    	else{
                    	    $json = ['success'=>false,'txt'=>"Ocorreu um erro ao tentar criar um novo Usuário"];
                    	} 
            	   }
            	   else{
            	        $json = ['success'=>false,'txt'=>"Usuário já possui cadastro no Empreendimento"];
            	   }
                
                    
                }
            
	        }
	        
            echo json_encode($json);
	}
	
	public function preCadastroAvaliarImovel(){
	    
	    $data = $this->input->post();
	    
	    $this->load->library('form_validation');
	    
	    //$this->form_validation->set_rules('email', 'Email', 'required|valid_email');
    	$this->form_validation->set_rules('cep', 'CEP', 'required');
        //$this->form_validation->set_rules('nome', 'Nome', 'required');
    	
    	    
	    if($this->form_validation->run() == FALSE)
	    {
	        $json = ['success'=>false,'erro' => 1,'msg'=>validation_errors()];
	    }
	    else{
	        
	         
	        $data['datetime_captura'] = date("Y-m-d H:i:s");
                
            $end = $this->buscar_cep($data['cep']);
            
            $data['endereco'] = $end['endereco'];
            $data['bairro']   = $end['bairro'];
            $data['cidade']   = $end['cidade'];
            $data['estado']   = $end['uf'];
                
                if(HAvaliacao::getBairroPermitido($data['bairro']))
                {
                    $data['id_captura'] = $this->cad_model->insertCaptura($data);
                    //Newsletter::addTagRelCap(1,$data['id_captura']);
                    $msg = "Precisamos saber mais sobre o Imóvel!";
                    
                    
                    if($data['id_captura']){
                        $json = ['success' => true, 'msg' => $msg,'cap' => $data, 'id_captura' => $data['id_captura']]; 
                    }
                    else{    
                        $json = ['success' => false,'erro' => 2,'msg' => "Erro!"];
                    }
                }
                else
                {
                    //$data['status_captura'] = 1;
                    //$data['origem_captura'] = 'avaliacao_cep_nao';
                    //$data['id_captura']   = $this->cad_model->insertCaptura($data);
                    //Newsletter::addTagRelCap(15,$data['id_captura']);
                    
                    $msg = "Ops! Ainda não atendemos essa região.";
                    
                    $json = ['success' => false , 'validCep' => false,'erro' => 3, 'msg' => $msg,'cap' => $data]; 
                }
                
            /*$id_captura = $data['id_captura'];
            
            $origem = $this->session->origem??NULL;
            if($origem !== NULL)
            {   
	            $origem = array_merge($origem,['click_action'=>'Avalie agora','id_cad'=>0,'tb_result'=>'cad_captura','id_result'=>$id_captura,'conta_nova'=>0,'date_time'=>date('Y-m-d H:i:s')]);
                $this->cad_model->insertCapturaOrigem($origem);
                $this->session->unset_userdata('origem');
            }*/
	    }
            
        echo json_encode($json);
	
	    
	}
	
	public function atualizarAvaliarImovel(){
	    
	    $data = $this->input->post();
	    
	    $this->load->library('form_validation');
	    
	    $this->form_validation->set_rules('tipo_imovel', 'Tipo de imóvel', 'required');
	    $this->form_validation->set_rules('idade_imovel', 'Idade do imóvel', 'required');
        $this->form_validation->set_rules('tipo_captura', 'Padrão do Imóvel', 'required');
        $this->form_validation->set_rules('area_total', 'Área total', 'required');
        //$this->form_validation->set_rules('andar', 'Andar', 'required|trim');
        //$this->form_validation->set_rules('quartos', 'Quartos', 'required|trim');
        //$this->form_validation->set_rules('banheiros', 'Banheiros', 'required|trim');
        $this->form_validation->set_rules('numero', 'Número', 'required');
        $this->form_validation->set_rules('complemento', 'Complemento', 'required');
        $this->form_validation->set_rules('telefone', 'Telefone', 'required');
		
    	    
	    if($this->form_validation->run() == FALSE)
	    {
	        $json = ['success'=>false,'erro' => 1,'msg'=>validation_errors()];
	    }
	    else{
            
            $id_captura = $data['id_captura'];
            $key_captura = $id_captura.$this->gerar_senha(7,false,true,true,false);
            $update = [
                'key_captura'     => $key_captura,
                'status_captura'  => 1,
                'tipo_imovel'     => $data['tipo_imovel'],
                'tipo_captura'    => $data['tipo_captura'],
                'andar'           => $data['andar'],
                'quartos'         => $data['quartos'],
                'vaga'            => $data['vaga'],
                'banheiros'       => $data['banheiros'],
                'area_total'      => (int)$data['area_total'],
                'numero'          => $data['numero'],
                'complemento'     => $data['complemento'],
                'telefone'        => $data['telefone'],
                ];
            
            $cap = $this->cad_model->getCaptura([['id_captura', $id_captura]]);
            
            if($cap != null)
            {
                if($this->cad_model->updateCaptura($id_captura,$update)){
                    
                    $cap = $this->cad_model->getCaptura([['id_captura', $id_captura]]);
                    
                    /*$dt = [
                            'nome'         => strtok($cap->nome, " "),
                            'linkcustom'   => base_url().'avaliacao/resultado/'.$key_captura,
                        ];
                    $this->newsletter->envia($cap->email, [32,6], $dt);
                    */
                    Newsletter::nextTagRelCap(1,6,$cap->id_captura);
                    
                    //HEmail::alerta('Nova Captura', ((array)$cap));
                    
                    $json = ['success' => true,'msg' => "Avaliação salva com Sucesso!",'link' => base_url().'avaliacao/resultado/'.$key_captura,'cap' => $update]; 
                }
                else{    
                    $json = ['success' => false,'erro' => 3,'msg' => "Erro!"];
                }
            }else{
                $json = ['success' => false,'erro' => 2,'msg' => "Erro!"];
            }
        
	    }
	    
        echo json_encode($json);
        
	}
	
	public function enviarEmailAvaliacao(){
	    $data = $this->input->post();
	    
	    
	    $dt = [
            'nome'         => strtok($data['nome'], " "),
            'linkcustom'   => base_url().'avaliacao/resultado/'.$data['key_captura'],
        ];
        //$data['email']
        $return = $this->newsletter->envia($data['email'], [32,6], $dt);
	    
	    if($return == true){
	        $json = ['success'=>true];
	    }
	    else{
	        $json = ['success'=>false];
	    }
	    echo json_encode($json);
	}
	
	public function buscar_cep($cep)
	{
	    $vazio = [
                    'latitude' => '',
                    'cep' => '',
                    'endereco' => '',
                    'bairro' => '',
                    'cidade' => '',
                    'estado' => '',
                    'uf'     => ''
                ]; 
	    
	    if($cep == NULL || $cep == '')
           return $vazio;
	    
        $cep = preg_replace("/[^0-9]/", "", $cep);
        
        $end = $this->cad_model->getEndereco($cep);
        
        if (empty($end))
            return $vazio;
        else{
            $end = (array)$end;
            $end['latitude'] = '';
            $end['endereco'] = $end['logradouro'];
            return $end;
        }
	}
	
	/*public function listarLeadsWimoveis(){
	    
	    $this->load->library('marketing/Wimoveis_lib');
	    
	    $data['leads'] = $this->wimoveis_lib->get_all_msg();
	    $qtd = count($data['leads']);
	    $html = Template::getView('atendimento/blocos/box_leads_wimoveis_view', $data);
	    
	    $json = ['success' => true, 'html' => $html, 'qtd' => $qtd];
	    
	    
	    echo json_encode($json);
	    
	}*/
	

	
	    
    
}