<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Interesse_ajax extends Admin_Controller {

	function __construct()
	{
        parent::__construct();
        require APPPATH . 'libraries/vendor/autoload.php';
        
        if(($this->session->perfil??0) == 0)
        {
	        echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Acesso negado!']);
	        die();
		}
		
        //this->load->model('comdono/cad_model');
		//$this->load->model('administrativo/admin_model');
		//$this->load->model('administrativo/dash_model');
        //$this->load->library('newsletter/newsletter');
        //$this->load->library('comdono/notification');
	}
	
	/** * Função pegar/atualizar tabela de interesses
    * @access public 
    * @param -
    * @return $interesses -> variável com os interesses
    */
	public function getTbInteresses()
	{
	    
	    try {
            $post = $this->input->post();
            //01/01/0001 - 26/04/2021
            if(($post['daterange']??'') != '')
            {
                $datas = explode(" - ",$post['daterange']);
                //$data = implode('-', array_reverse(explode('/', "15/12/2018")));
                $dataIni = DateTime::createFromFormat('d/m/Y', $datas[0])->format("Y-m-d 00:00:00");
                $dataFim = DateTime::createFromFormat('d/m/Y', $datas[1])->format("Y-m-d 23:59:59");
                
                $where[] = ['datahora_cadastro >=',$dataIni];
                $where[] = ['datahora_cadastro <=',$dataFim];
            }
            
            if(($post['tipo_interesse']??'todos') != 'todos')
            {
                $where[] = [['tipo_interesse',$post['tipo_interesse']], ['tipo_interesse','comprar e vender']];
            }
            
            if(($post['origem']??'') != '')
            {
                if($post['origem'] == 'painel')
                    $where[] = ['principal',1];
                if($post['origem'] == 'externo')
                    $where[] = ['principal',0];
            }
            
            
            $where[] = ['id_cadastro >',0];
            $where[] = ['ativo',1];
            $where[] = ['interesse_painel_cs',0];
            
            //PEGA A QNT DE INTERESSES CADASTRADOS
            $interesses = $this->cad_model->getInteresses($where);
           
            foreach($interesses as $k=>$row){
            
                 
                    $row->bairros = [];
                    $row->bairrosBadge = '';
                    if(($post['bairro']??'') != '')
                    {
                        $bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $row->id_interesse],['bairro', $post['bairro']]]);
                        if(empty($bairros)){
                            unset($interesses[$k]);
                            continue;
                        }
                    }
                    else{
                       $bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $row->id_interesse]]); 
                    }
                    
                    foreach ($bairros as $bairro){
                        $row->bairros[] = $bairro->bairro;
                        $row->bairrosBadge .= '<span class="badge badge-secondary mr-1">'.$bairro->bairro.'</span>';
                    }
               //--------BAIRROS----------------
               //$row->bairros = [];
               //$row->bairrosBadge = '';
               //$bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $row->id_interesse]]);
               //foreach ($bairros as $bairro){
               //    $row->bairros[] = $bairro->bairro;
               //    $row->bairrosBadge .= '<span class="badge badge-secondary mr-1">'.$bairro->bairro.'</span>';
               //}
               //---fim--BAIRROS----------------
                $row->cadastro = $this->cad_model->getCadastro([['id_cadastro', $row->id_cadastro]]);
                //--------TIPO EMPREENDIMENTO----  
                $row->tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $row->id_interesse]]);   
                $row->tipos_emp = [];
                foreach ($row->tipo_emp as $tipo)
                    $row->tipos_emp[] = $tipo->tipo_emp;
                //---fim--TIPO EMPREENDIMENTO----    
                    
                $row->data = '<span class="d-none">'.$row->datahora_cadastro.'</span>'.diaMesAno($row->datahora_cadastro);
                
                $row->action = '<a class="btn btn-primary" href="'.base_url('atendimento/interesse/visualizar/').$row->id_interesse.'">
                                    <i class="fa fa-eye" aria-hidden="true"></i>
                                </a>
                                <a class="btn btn-warning btnEditarInteresse" data-id="'.$row->id_interesse.'" href="#" data-toggle="tooltip" data-original-title="Editar">
                                    <i class="fa fa-pencil" aria-hidden="true"></i>
                                </a>
                                <a class="btn btn-danger btnExcluirInteresse" data-id="'.$row->id_interesse.'" href="#" data-toggle="tooltip" data-original-title="Excluir">
                                    <i class="fa fa-trash" aria-hidden="true"></i>
                                </a>';
                
            }
            
            echo json_encode($interesses);
                    	
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'msg' => $e->getMessage()]);
        }
	}
	
	
	
	/** * Função excluir o interesse
    * @access public 
    * @param -
    * @return Mensagem de sucesso da exclusão
    */
	public function excluirInteresse()
	{
	    try {
            if(false)
            	throw new Exception("Erro");
            	
            $id_interesse = $this->input->post('id_interesse');
            
    	    $data['ativo'] = 0;
    	    
    	    $return = $this->cad_model->updateInteresse($id_interesse,$data);
    	    
    	    if($return == true){
    	        $json = ['success'=>true];
    	    }
    	    else{
    	        $json = ['success'=>false];
	        }
            
            echo json_encode($json);
                    	
        } catch(Exception $e) {
            echo json_encode(['success' => false,'msg' => $e->getMessage()]);
        }
	}
	
	/** * Função de exemplo
    * @access public 
    * @param -
    * @return -
    */
	public function exemplo()
	{
	    try {
            if(false)
            	throw new Exception("Erro");
            	
            echo json_encode([]);
                    	
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'msg' => $e->getMessage()]);
        }
	}
	
	/** * Função editar o interesse
    * @access public 
    * @param -
    * @return Mensagem de sucesso do update
    */
	public function editarInteresse()
	{
	    
	    try {
            if(false)
            	throw new Exception("Erro");
            	
    	    $data = $this->input->post();
    	    
    	    $existe_bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $data['id_interesse']]]);
    	    $existe_tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $data['id_interesse']]]);
    	    
    	    if(!empty($existe_bairros) || !empty($existe_tipo_emp)){
    	       //tem bairros no banco
    	       //deletar os bairros e atualizar
    	       //isset($data['bairro'])
    	       
    	       $return_delete_b = $this->cad_model->deleteInteresseBairros([['id_interesse', $data['id_interesse']]]);
    	       $return_delete_t = $this->cad_model->deleteTipoEmpInteresse([['id_interesse', $data['id_interesse']]]);
    	       
    	       if($return_delete_b == true || $return_delete_t == true){
    	            
        	        if(isset($data['bairro'])){
    	                $data_bairros = $data['bairro'];
        	            unset($data['bairro']);    
    	            }
    	            if(isset($data['tipo_emp_cliente'])){
    	                $data_tipo_emp = $data['tipo_emp_cliente'];
        	            unset($data['tipo_emp_cliente']);    
    	            }
        	        
        	        $return_update = $this->cad_model->updateInteresse($data['id_interesse'],$data);
        	        
        	        if($return_update == true && isset($data_bairros)){
        	            
        	        
        	            foreach($data_bairros as $d){
            	            $insert_data_b = array(
            	                'id_interesse' => $data['id_interesse'],
            	                'bairro' => $d
            	                );
            	            $this->cad_model->insertBairroInteresse($insert_data_b);
        	            }
        	        }
        	        
        	        if($return_update == true && isset($data_tipo_emp)){
        	            
        	        
        	            foreach($data_tipo_emp as $t){
            	            $insert_data_t = array(
            	                'id_interesse' => $data['id_interesse'],
            	                'tipo_emp' => $t
            	                );
            	            $this->cad_model->insertTipoEmpInteresse($insert_data_t);
        	            }
        	        }
        	        
        	        
        	        $json = ['success' => true, 'msg' => 'Interesse modificado'];
    	        }
    	        else{
    	            //erro ao deletar do banco os bairros
    	            $json = ['success' => false, 'msg' => 'Erro de delete no banco'];
    	        }
    	    }
    	    else{
    	       //não tem bairros no banco 
    	       //somente atualizar
    	       //isset($data['bairro'])
    	            
    	            if(isset($data['bairro'])){
    	                $data_bairros = $data['bairro'];
        	            unset($data['bairro']);    
    	            }
    	            
        	        $id_interesse = $this->cad_model->updateInteresse($data['id_interesse'],$data);
        	        
        	        if($id_interesse == true && isset($data_bairros)){
        	            
        	        
        	            foreach($data_bairros as $d){
            	            $insert_data = array(
            	                'id_interesse' => $data['id_interesse'],
            	                'bairro' => $d
            	                );
            	            $this->cad_model->insertBairroInteresse($insert_data);
        	            }
        	        }
        	        
        	        $json = ['success' => true, 'msg' => 'Interesse modificado'];
	    }
	    
	        echo json_encode($json);
	        
	    } catch(Exception $e) {
            echo json_encode(['success' => false,'msg' => $e->getMessage()]);
        }
	}
	
	/** * Função de pesquisar o lead do cadastro de interesse
    * @access public 
    * @param -
    * @return id cadastro e captura do lead
    */
	public function avaliaCadInteresse()
	{
	    try {
	        
            $data = $this->input->post();
            
            //Tem E-mail
            //SIM
            if(!empty($data['email']))
            {
                if(!validaEmail($data['email']))
                    throw new Exception("Email Inválido");
                
                $cadastro = $this->cad_model->getCadastroByEmail($data['email']);
                
                //Tem cadastro por esse email? 
                //SIM
                if(!empty($cadastro))
                {
                    $json = ['valid' => true,'msg' => 'Cadastro encontrado', 'cadastro' => $cadastro];
                }
                else//NAO
                {
                    if($data['telefone'] != ''){
                        $cad_pelo_telefone = $this->cad_model->getCadastro(['telefone',$data['telefone']]);
                        if($cad_pelo_telefone == null)
                        {
                            $capturaAleatoria = $this->cad_model->getCaptura(['telefone', $data['telefone']]);
                            if($capturaAleatoria != null)
                            {
                                $cad_pelo_telefone = $this->cad_model->getCadastro(['id_cadastro',$capturaAleatoria->id_cadastro]);
                            }
                        }
                    }
                    
                    
                    
                    //Tem cadastro pelo telefone? 
                    //SIM
                    if(($cad_pelo_telefone??null) != null)
                    {
                        $json = ['valid' => true,'msg' => 'Cadastro encontrado', 'cadastro' => $cad_pelo_telefone];
                    }
                    else//NAO
                    {
                        if($data['nome'] == ''){
                         
                             echo json_encode(['valid' => false, 'validForm' => true, 'msg' => "insira NOME para um novo cadastro"]); 
                             die();
                        }
                        
                        //cadastrar um novo e retornar o id_cadastro
                        $cadastro = [
                            'nome' => $data['nome'],
                            'telefone' => $data['telefone'],
                            'email' => $data['email'],
                            'cpf' => $data['cpf'],
                            //'origem_lead' => $data['origem_lead'],
                            //'origem_captura' => 'interesse_painel'
                            ];
                        
                        $id_cadastro = $this->cad_model->insertCadastro($cadastro);
                        
                        $cadastro = $this->cad_model->getCadastro(['id_cadastro', $id_cadastro]);
                        
                        
                        $json = ['valid' => true,'msg' => 'Cadastro não encontrado, novo cadastro criado!', 'cadastro' => $cadastro];
                        
                       
                    }
                    
                }
            }
            else//NAO
            {
                if($data['telefone'] == '')
                    throw new Exception("O campo TELEFONE ou EMAIL deve ser preenchido");
                    
                    
                
                $cad_pelo_telefone = $this->cad_model->getCadastro(['telefone',$data['telefone']]);
                if($cad_pelo_telefone == null)
                {
                    $capturaAleatoria = $this->cad_model->getCaptura(['telefone', $data['telefone']]);
                    if($capturaAleatoria != null)
                    {
                        $cad_pelo_telefone = $this->cad_model->getCadastro(['id_cadastro',$capturaAleatoria->id_cadastro]);
                    }
                }
                    
                //Tem cadastro pelo telefone? 
                //SIM
                if($cad_pelo_telefone != null)
                {
                    $json = ['valid' => true,'msg' => 'Cadastro encontrado pelo telefone', 'cadastro' => $cad_pelo_telefone];
                    
                }
                else//NAO
                {
                    throw new Exception("Nao foi encontrado um usuario com este telefone, insira um EMAIL para um novo cadastro");
                    
                }  
            }
            
            //$json = ['valid' => true,'msg' => 'teste'];
            echo json_encode($json);
                    	
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'msg' => $e->getMessage()]);
        }
	}
	
	/** * Função para salvar o interesse
    * @access public 
    * @param -
    * @return resposta do cadastro do interesse
    */
	public function salvarInteresse()
	{
	    try {
            $data = $this->input->post();
            dd($data);
            $cadastro = Cad_model::getCadastroByEmail($data['email']);
            if(empty($cadastro))
                $data['id_cadastro'] = $this->cad_model->insertCadastro($data);
            else
                $data['id_cadastro'] = $cadastro->id_cadastro;
            
            $data['origem_captura'] = 'interesse_painel';
            $data['datetime_captura'] = date("Y-m-d H:i:s");
            
            $id_captura = $this->cad_model->insertCaptura($data);
            $key_captura = $id_captura.gerar_senha(3,false,true,true,false);
            $this->cad_model->updateCaptura($id_captura,['key_captura'=> $key_captura]);
            
            
            $data['id_captura'] = $id_captura;
            $data['id_responsavel'] = $this->session->id_cadastro;
            $data['datahora_cadastro'] = date("Y-m-d H:i:s");
            
            $id_interesse = $this->cad_model->insertInteresse($data);
            
	        
	        if($id_interesse > 0)
	        {
	            if(isset($data['bairro'])){
    	            
    	            foreach($data['bairro'] as $b){
        	            $insert_data = array(
        	                'id_interesse' => $id_interesse,
        	                'bairro' => $b
        	                );
        	            $this->cad_model->insertBairroInteresse($insert_data);
    	            }
	            }
	            
	            if(isset($data['tipo_emp_cliente'])){
	                
    	            foreach($data['tipo_emp_cliente'] as $t){
        	            $insert_data = array(
        	                'id_interesse' => $id_interesse,
        	                'tipo_emp' => $t
        	                );
        	            $this->cad_model->insertTipoEmpInteresse($insert_data);
    	            }
	            }
	            
	            $json = ['valid' => true,'msg' => 'Interesse salvo'];
	        }
	        else
	        {
	            throw new Exception('Erro ao salvar');
	        }
	        
	        
            echo json_encode($json);
                    	
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'msg' => $e->getMessage()]);
        }
	}
	
}