<!---Dashboard Incorporadora--->

<div class="row">
    <!--Cabeçalho-->
    <div class="col-md-12">
        <div class="d-flex">
            <label class="my-auto text-value-lg text-primary">Dashboard de Atendimento</label>
        </div>
        <hr>
    </div>
    
    <!--CONTINUAR ATENDIMENTO-->
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <button class="btn btn-primary btn-lg btn-novo-usuario font-weight-bold btn-block mb-3 d-flex align-items-center" data-toggle="modal" data-target="#usuarioNovo">Adicionar Novo Usuário<span class="font-weight-bold ml-auto h1">+</span></button>
                <hr>
                <div class="card filaatendimento"></div>
            </div>
            <div class="col-md-8">
                <div class="row">
                    <div class="col-3">
                        <div class="card text-white bg-success w-100 mr-1 mb-2 h-100">
                            <div class="card-body d-flex flex-column">
                                <div class="d-flex justify-content-between w-100 h1">
                                    <span><?php e($atendimentos_em_andamento); ?></span>
                                    <div class="text-muted text-right">
                                        <i class="icon-people"></i>
                                    </div>
                                </div>
                                <div class="mt-auto">Total de <b>Atendimentos ativos</b></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="card text-white bg-warning w-100 mr-1 mb-2 h-100">
                            <div class="card-body d-flex flex-column">
                                <div class="d-flex justify-content-between w-100 h1">
                                    <span><?php e($atendimentos_pendentes); ?></span>
                                    <div class="text-muted text-right">
                                        <i class="icon-list"></i> 
                                    </div>
                                </div>
                                <div class="mt-auto">Total de <b>Atendimentos aguardando</b> na fila</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="card text-white bg-primary w-100 mr-1 mb-2 h-100">
                            <div class="card-body d-flex flex-column">
                                <div class="d-flex justify-content-between w-100 h1">
                                    <span><?php e($atendimentos_fu); ?></span>
                                    <div class="text-muted text-right">
                                        <i class="icon-calendar"></i>
                                    </div>
                                </div>
                                <div class="mt-auto">Total de <b>Atendimentos no Follow-UP</b></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="card text-white bg-secondary w-100 mr-1 mb-2 h-100">
                            <div class="card-body d-flex flex-column">
                                <div class="d-flex justify-content-between w-100 h1">
                                    <span><?php e($atendimentos_concluidos); ?></span>
                                    <div class="text-muted text-right">
                                        <i class="icon-check"></i>
                                    </div>
                                </div>
                                <div class="mt-auto">Total de <b>Atendimentos concluídos</b></div>
                                <div class="progress progress-white progress-xs mt-3">
                                    <div class="progress-bar" role="progressbar" style="width: <?php e(round(($atendimentos_concluidos/$atendimentos_total)*100)); ?>%" aria-valuenow="<?php e(round(($atendimentos_concluidos/$atendimentos_total)*100)); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>     
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-12">
                        <div class="card-group d-flex flex-grow w-100 h-100">
                        <div class="card" style="min-width: 130px;">
                          <div class="card-body">
                            <div class="d-flex">  
                                <div class="text-muted f-20" ><?php e($negociacoes_andamento); ?></div><!--<span class="ml-1 text-success" title="Negociações Hoje">+<?php e($novas_negociacoes); ?></span>-->
                            </div>
                            <p class="card-text text-danger"><b class="font-weight-bold text-muted">Negociações</b><br>Em andamento</p>
                            <hr>
                            <div class="d-flex">  
                                <div class="text-muted f-20" ><?php e($negociacoes_concluida); ?></div><!--<span class="ml-1 text-success">+<?php e($novas_negociacoes_concluida); ?></span>-->
                            </div>
                            <p class="card-text text-success"><b class="font-weight-bold text-muted">Negociações</b><br>Convertidas</p>
                          </div>
                        </div>
                        <div class="card">
                          <div class="card-body">
                            <div class="d-flex">  
                                <div class="text-muted f-20" ><?php e($reunioes_age); ?></div><!-- <span class="ml-1 text-success">+0</span> -->
                            </div>
                            <p class="card-text text-danger"><b class="font-weight-bold text-muted">Reuniões</b><br>Agendadas</p>
                            <hr>
                            <div class="d-flex">  
                                <div class="text-muted f-20" ><?php e($reunioes_real); ?></div><!-- <span class="ml-1 text-success">+0</span> -->
                            </div>
                            <p class="card-text text-success"><b class="font-weight-bold text-muted">Reuniões</b><br>Realizadas</p>
                          </div>
                        </div>
                        <div class="card" >
                          <div class="card-body">
                            <div class="d-flex">  
                                <div class="text-muted f-20" >0</div><!-- <span class="ml-1 text-danger">-0</span> -->
                            </div>
                            <p class="card-text text-danger"><b class="font-weight-bold text-muted">Interesses</b><br>Incompletos</p>
                            <hr>
                            <div class="d-flex">  
                                <div class="text-muted f-20" ><?php e($interesses_cont); ?></div><!-- <span class="ml-1 text-danger">-0</span> -->
                            </div>
                            <p class="card-text text-success"><b class="font-weight-bold text-muted">Interesses</b><br>Cadastrados</p>
                          </div>
                        </div>
                        <div class="card">
                          <div class="card-body">
                            <div class="d-flex">  
                                <div class="text-muted f-20" >0</div><!-- <span class="ml-1 text-danger">-0</span> -->
                            </div>
                            <p class="card-text text-muted"><b class="font-weight-bold text-muted">Créditos</b><br>Em andamento</p>
                            <hr>
                            <div class="d-flex">  
                                <div class="text-muted f-20" >0</div><!-- <span class="ml-1 text-danger">-0</span> -->
                            </div>
                            <p class="card-text text-success"><b class="font-weight-bold text-muted">Créditos</b><br>Aprovados</p>
                          </div>
                        </div>
                    </div>                           
                    </div>
                </div>
            </div>
        </div>   
    </div>

    <!--PORTAIS-->
    <div class="col-md-12">
        <hr>
        <div class="d-flex flex-wrap flex-xl-nowrap justify-content-center">
        
            <!--Wimóveis-->
            <div class="card mr-1 w-100" style="min-width: 270px;">
                
                <div class="card-header font-weight-bold bg-light content-center">
                    
                    <img src="https://img10.naventcdn.com/home/RPHOMv2.25.3-RC1/images/logo-wimoveis.png" class="img-fluid" style="max-height: 23px;" alt="Responsive image">
                    
                    <span class="badge badge-pill badge-danger qtd_lead_wimoveis"><?php e($qtd_leads_wimoveis) ?></span>
                    <div class="card-header-actions">
                        <button class="btn btn-block btn-primary btn_listar_lead_wimoveis" type="button" data-toggle="modal" data-target="#leads_wimoveis">Lista de Leads</button>
                    </div>
                </div>
                  
                <div class="card-body row text-center" style="font-weight: 500!important;">
                    
                    <div class="col-6 pr-1 mb-2" >  
                      <button class="btn btn-block btn-danger" style="min-height: 79px;">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase">Pendentes</div>
                      </button>
                    </div>  
                    
                    
                    <div class="col-6 pl-1 mb-2">  
                        <div class="card border-danger text-danger p-1 mb-0">
                            <div class="text-value">0 Dia<br>00:00:00</div>
                            <div>
                                <i class="fa fa-bullhorn"></i>
                            </div>
                        </div>                   
                    </div>
                    <div class="col-6 pr-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg ">N/A</div>
                            <div class="text-uppercase text-muted">Atendidos</div>
                      </div>
                    </div>                   
                    <div class="col-6 pl-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase  text-muted">Convertidos</div>
                      </div>
                    </div>                   
                        
                </div>
                
            </div>
            <!--Zap-->
            <div class="card mx-1 w-100" style="min-width: 270px;">
                
                <div class="card-header font-weight-bold bg-light content-center">
                    <img src="https://logodownload.org/wp-content/uploads/2018/08/zap-imoveis-logo.png" class="img-fluid" style="max-height: 30px;" alt="Responsive image">
                    <span class="badge badge-pill badge-danger"><?php e($qtd_leads_zap) ?></span>
                    <div class="card-header-actions">
                        <button class="btn btn-block btn-primary btn_listar_lead_zap" type="button" data-toggle="modal" data-target="#leads_zap">Lista de Leads</button>
                    </div>
                </div>
                
                <div class="card-body row text-center" style="font-weight: 500!important;">
                    
                    <div class="col-6 pr-1 mb-2">  
                      <button class="btn btn-block btn-outline-secondary disabled" style="min-height: 79px;">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase">Pendentes</div>
                      </button>
                    </div>  
                    <div class="col-6 pl-1 mb-2">  
                        <div class="card border-secondary text-secondary p-1 mb-0">
                            <div class="text-value">0 Dia<br>00:00:00</div>
                            <div>
                                <i class="fa fa-bullhorn"></i>
                            </div>
                        </div>                   
                    </div>
                    <div class="col-6 pr-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg ">N/A</div>
                            <div class="text-uppercase text-muted">Atendidos</div>
                      </div>
                    </div>                   
                    <div class="col-6 pl-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase  text-muted">Convertidos</div>
                      </div>
                    </div>                   
                     
                </div>
                
            </div>
            <!--Viva Real-->
            <div class="card mx-1 w-100" style="min-width: 270px;">
    
                <div class="card-header font-weight-bold bg-light content-center">
                    <img src="https://d1.awsstatic.com/case-studies/LATAM/logo-vivareal-azul-claro-min-1.e29ca11ed519734dabe2a7fd14cb6588e4a95c8c.png" class="img-fluid" style="max-height: 35px;" alt="Responsive image">
                    <span class="badge badge-pill badge-danger"><?php e($qtd_leads_vivareal) ?></span>
                    <div class="card-header-actions">
                        <button class="btn btn-block btn-primary btn_listar_lead_vivareal" type="button" data-toggle="modal" data-target="#leads_vivareal">Lista de Leads</button>
                    </div>
                </div>
                
                <div class="card-body row text-center" style="font-weight: 500!important;">
                    
                    <div class="col-6 pr-1 mb-2">  
                      <button class="btn btn-block btn-outline-secondary disabled" style="min-height: 79px;">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase">Pendentes</div>
                      </button>
                    </div>  
                    <div class="col-6 pl-1 mb-2">  
                        <div class="card border-secondary text-secondary p-1 mb-0">
                            <div class="text-value">0 Dia<br>00:00:00</div>
                            <div>
                                <i class="fa fa-bullhorn"></i>
                            </div>
                        </div>                   
                    </div>
                    <div class="col-6 pr-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg ">N/A</div>
                            <div class="text-uppercase text-muted">Atendidos</div>
                      </div>
                    </div>                   
                    <div class="col-6 pl-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase  text-muted">Convertidos</div>
                      </div>
                    </div>                   
                        
                </div>
                
            </div>
            <!--GrupoZAP-->
            <div class="card mx-1 w-100" style="min-width: 270px;">
    
                <div class="card-header font-weight-bold bg-light content-center">
                    <img src="https://www.galeriapix.com.br/media/avatar/logo_949_avatar.png" class="img-fluid" style="max-height: 30px;" alt="Responsive image">
                    <span class="badge badge-pill badge-danger"><?php e($qtd_leads_grupozap) ?></span>
                    <div class="card-header-actions">
                        <button class="btn btn-block btn-primary" type="button" data-toggle="modal" data-target="#leads_grupozap">Lista de Leads</button>
                    </div>
                </div>
                
                <div class="card-body row text-center" style="font-weight: 500!important;">
                    
                    <div class="col-6 pr-1 mb-2 text-secondary">  
                      <button class="btn btn-block btn-outline-secondary disabled" style="min-height: 79px;">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase">Pendentes</div>
                      </button>
                    </div>  
                    <div class="col-6 pl-1 mb-2">  
                        <div class="card border-secondary text-secondary p-1 mb-0">
                            <div class="text-value">0 Dia<br>00:00:00</div>
                            <div>
                                <i class="fa fa-bullhorn"></i>
                            </div>
                        </div>                   
                    </div>
                    <div class="col-6 pr-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg ">N/A</div>
                            <div class="text-uppercase text-muted">Atendidos</div>
                      </div>
                    </div>                   
                    <div class="col-6 pl-1 mb-1">  
                      <div class="card border-success text-success p-1 mb-0">
                            <div class="text-value-lg">N/A</div>
                            <div class="text-uppercase  text-muted">Convertidos</div>
                      </div>
                    </div>                   
                                     
                     
                </div>
                
            </div>          
            
        </div>
    </div>
    
    <!--LISTAS-->
    <div class="col-md-12 mb-bottom">
        <hr>
        <div class="card-body p-0">
            <!--TABNAV-->
            
            <ul class="nav nav-tabs" id="myTab1" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home-aba" role="tab" aria-controls="home" aria-selected="true">Agenda</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile-aba" role="tab" aria-controls="profile" aria-selected="false">Histórico</a>
                </li>
                <!--<li class="nav-item">
                    <a class="nav-link" id="interesse-tab" data-toggle="tab" href="#interesse-aba" role="tab" aria-controls="interesse" aria-selected="false">Lista de interesses</a>
                </li>-->
            </ul>
            
            <div class="tab-content" id="myTab1Content">
                <!--TAB 1-->
                <div class="tab-pane fade show active" id="home-aba" role="tabpanel" aria-labelledby="home-tab">
                    <!--Filtro-->
                    <div class="row">
                        <div class="col-12 d-flex justify-content-between">
                            <form class="form-inline justify-content-end form-busca-agenda-geral">
                                <label class="font-weight-normal mr-2" for="inputEmpreendimento">Por Empreendimento:</label>
                                
                                <div class="form-group mr-2">
                                    <select class="form-control" style="min-width: 120px;" id="inputEmpreendimento" name="uuid_empreendimento">
                                        <option value="todos">Todos</option>
                                        <?php foreach($empreendimentos as $empreendimento){ ?>
                                            <option value="<?php e($empreendimento->uuid_empreendimento) ?>"><?php e($empreendimento->emp_nome_fantasia) ?></option>  
                                        <?php } ?>
                                    </select>
                                </div>
                            
                                <!--<label class="font-weight-normal mr-2" for="inputEmpreendimento">Por Data e Hora:</label>
                              
                                <div class="input-group date dateTimeAgenda mr-2" style="min-width: 120px;">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text input-group-addon">
                                          <i class="fa fa-calendar" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <input type="text" class="form-control" id="dataHistorico" name="intervalo" placeholder="dd/mm/ano">
                                 </div>
                                 -->
                                 
                                <button type="button" class="btn btn-primary my-auto btn-buscar-agenda">Filtrar</button>
                            </form>                            
                        </div>
                    </div>
                    <hr>
                    <!--Calendario-->
                    <div id='calendar'></div>
                    <hr>
                    <div class="row">
                        <div class="col-12">
                            <div class="card mb-0">
                                <div class="card-body">
                                    <div class="leg-calendar"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!--TAB 2-->
                <div class="tab-pane fade" id="profile-aba" role="tabpanel" aria-labelledby="profile-tab">
                    <!--Filtro-->
                    <div class="row">
                        <div class="col-12 d-flex justify-content-between">
                            <form class="form-inline justify-content-end form-busca-agenda-geral">
                                <label class="font-weight-normal mr-2" for="inputEmpreendimento">Por Empreendimento:</label>
                                <div class="form-group mr-2">
                                    <select class="form-control" style="min-width: 120px;" id="inputEmpreendimento" name="empreendimento">
                                        <option value="todos">Todos</option>
                                        <?php foreach($empreendimentos as $empreendimento){ ?>
                                            <option value="<?php e($empreendimento->uuid_empreendimento) ?>"><?php e($empreendimento->emp_nome_fantasia) ?></option>  
                                        <?php } ?>
                                    </select>
                                </div>
                                <label class="font-weight-normal mr-2" for="inputEmpreendimento">Por Data e Hora:</label>
                                <div class="input-group date dateTimeAgenda mr-2" style="min-width: 120px;">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text input-group-addon">
                                          <i class="fa fa-calendar" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <input type="text" class="form-control" id="dataHistorico" name="intervalo" placeholder="dd/mm/ano">
                                </div>
                                <button type="button" class="btn btn-primary my-auto btn-buscar-agenda">Filtrar</button>
                                <button type="button" class="btn btn-danger my-auto btn-limpar-filtros" style="display:none;">Limpar Filtros</button>
                            </form>                            
                        </div>
                    </div>                    

                    <hr>
                    <!--LISTAS-->
                    <span class="tb-original">
                        <table class="display table table-hover table-striped table-bordered table-responsive-x">
                            
                          <thead>
                            <tr>
                              <th scope="col">#</th>
                              <th scope="col">Nome</th>
                              <th scope="col">Email</th>
                              <th scope="col">Data de entrada</th>
                              <th scope="col">Último Atendimento</th>
                              <th scope="col">Origem</th>
                              <th scope="col">Status</th>
                              <th scope="col">Ações</th>
                            </tr>
                          </thead>
                          
                          <tbody class="tb-result">
                            <?php foreach($historicos as $hist){ ?>    
                                <tr>
                                  <th scope="row"><?php e($hist->id_fila); ?></th>
                                  <td><?php e($hist->nome) ?></td>
                                  <td><?php e($hist->email) ?></td>
                                  <td><?php e(converte_datahora($hist->datetime_captura,1)) ?></td>
                                  <td><?php e(converte_datahora($hist->date_time,1)) ?></td>
                                  <td><?php e($hist->captura) ?></td>
                                  <td><?php e($hist->status_formatado) ?></td>
                                  <td><a class="btn btn-sm btn-primary mr-1" href="<?php e(base_url('atendimento/incorporadoras/atendimento/'.$hist->uri_atend)) ?>" target="_blank" data-original-title="Atendimento rápido"><i class="icon-plus"></i></a>
                                  </td>
                                </tr>
                            <?php } ?>
                          </tbody>
                          
                        </table>
                    </span>
                    <span class="tb-paraguay" style="display:none;">
                        
                    </span>
                </div>
                
                <!--TAB 3-->
                <div class="tab-pane fade" id="interesse-aba" role="tabpanel" aria-labelledby="interesse-tab">
                    <!--Filtro-->
                    
                    <!--<div class="row">
                        <div class="col-12 d-flex justify-content-between">
                            <form id="form-busca-lista-interesse" class="form-inline justify-content-end form-busca-lista-interesse">
                                <div class="d-flex">
                                    <h4 class="my-auto text-primary">Linha do tempo</h4>
                                    
                                    <input id="daterange" type="text" name="daterange" />
                                    
                                    <button type="button" class="btn btn-info btn-pesquisar-data-interesse">Pesquisar</button>
                                </div>
                            </form>                            
                        </div>
                    </div>
                    <hr>-->
                    <!--LISTAS-->
                    <table id="historico_interesse_table" class="display table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Interesse em</th>
                                <th>Tipo de imovel</th>
                                <th>Tipo de empreendimento</th>
                                <th>Faixa de Preço</th>
                                <th>Momento</th>
                                <th>Bairros</th>
                                <th>Quartos</th>
                                <th>Descrição</th>
                                <th>Data do interesse</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($interesses as $inter) { ?>
                            <?php if($inter->ativo == 1 && $inter->interesse_painel_cs == 0) { ?>
                            <tr class="trData" >
                              <td><?php e($inter->pessoa->nome??'') ?></td>
                              <td><?php e($inter->tipo_interesse??'') ?></td>
                              <td><?php e($inter->tipo_imovel??'') ?></td>
                              <td><?php foreach($inter->tipo_emp as $tipo_emp){ ?><span class="badge badge-secondary"><?php echo $tipo_emp->tipo_emp; ?></span> <?php } ?></td>
                              <td><?php e(money($inter->faixa_preco_inicio??'') . ' a ' . money($inter->faixa_preco_fim??'')) ?></td>
                              <td><?php e($inter->momento_interesse) ?></td>
                              <td><?php foreach($inter->bairros as $bairro){ ?><span class="badge badge-secondary"><?php echo $bairro->bairro; ?></span> <?php } ?></td>
                              <td><?php e($inter->quartos??'') ?></td>
                              <td><?php e($inter->descricao??'') ?></td>
                              <td><?php e(substr(converte_datahora($inter->datetimeinteresse,1),0,-11)) ?></td>
                              <td>
                                  <a href="<?php e(base_url('atendimento/atendimento/visualizar_interesse/'.$inter->id_interesse)) ?>" target="_blank" class="btn btn-outline-primary" data-toggle="tooltip" data-original-title="Visualizar"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                  <a href="#" class="btn btn-outline-warning btn_editar_interesse" data-toggle="tooltip" data-original-title="Editar" data-interesse='<?php e(json_encode($inter)); ?>'><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                  <a href="#" class="btn btn-outline-danger btn_excluir_interesse" data-toggle="tooltip" data-original-title="Excluir" data-interesse="<?php e($inter->id_interesse); ?>"><i class="fa fa-times" aria-hidden="true"></i></a>
                              </td>
                            </tr>
                            <?php } } ?>
                        </tbody>
                    </table>
                    <!--Calendario-->
                    <div id='calendar'></div>
                    <hr>
                    <div class="row">
                        <div class="col-12">
                            <div class="card mb-0">
                                <div class="card-body">
                                    <div class="leg-calendar"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>        
    </div>
    
</div>


<!-- Modal -->
<div class="modal fade" id="modalAgendaGeral" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel"></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
            <label for="exampleFormControlInput1">Nome:</label>
            <input type="text" name="nome" class="form-control" id="exampleFormControlInput1" readonly>
        </div>
        <div class="form-group">
            <label for="exampleFormControlInput1">Empreendimento:</label>
            <input type="text" name="origem_captura" class="form-control" id="exampleFormControlInput1" readonly>
        </div>
        <div class="form-group">
            <label for="exampleFormControlInput1">Tipo de Imovel:</label>
            <input type="text" name="tipo_imovel" class="form-control" id="exampleFormControlInput1" readonly>
        </div>
        <!--<div class="form-group">
            <label for="exampleFormControlInput1">Data e Hora da Visita:</label>
            <input type="dt_hr" class="form-control" id="exampleFormControlInput1" readonly>
        </div>-->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
        <a type="button" class="btn btn-primary btn-calendar-continue-atend">Atendimento</a>
      </div>
    </div>
  </div>
</div>
<!-- Modal --> 
<div class="modal fade" id="editInteresseModal" tabindex="-1" role="dialog" aria-labelledby="editInteresseModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 800px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="exampleModalLabel">Editar Interesse</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <div class="row">
        <div class="col">
            <form class="text-dark form-edit-interesse">
                
                <input class="edit_interesse_id_captura" type="hidden" name="id_captura">
                <input class="edit_interesse_id_interesse" type="hidden" name="id_interesse">
                <input class="edit_interesse_id_cadastro" type="hidden" name="id_cadastro">
                <input type="hidden" name="id_responsavel" value="<?php e($id_responsavel); ?>">
                
                <div class="form-group row">
                    <div class="col-6">
                       <label for="interessadoEM">Interessado em:</label>
                        <select name="tipo_interesse" class="form-control interForm edit_interesse_tipo_interesse" id="interessado90">
                          <option value="compra">Comprar</option>
                          <option value="venda">Vender</option>
                          <option value="comprar e vender">Comprar e vender</option>
                        </select> 
                    </div>
                  <div class="col-6">
                        <label for="interesse1">Tipo de imóvel</label>
                        <select name="tipo_imovel" id="tipo_imovel" class="form-control edit_interesse_tipo_imovel">
                            <option value="">Todos</option>
                            <optgroup label="Apartamento">
                                <option value="Apartamento Padrão">Padrão</option>
                                <option value="Kitnet">Kitnet</option>
                                <option value="Studio">Studio</option>
                                <option value="Loft">Loft</option>
                                <option value="Flat">Flat</option>
                                <option value="Cobertura">Cobertura</option>
                                <option value="Duplex">Duplex</option>
                                <option value="Triplex">Triplex</option>
                            </optgroup>
                            <optgroup label="Casa">
                                <option value="Casa Padrão">Padrão</option>
                                <option value="Casa de Condomínio">Casa de Condomínio</option>
                                <option value="Casa de Vila">Casa de Vila</option>
                            </optgroup>
                            <optgroup label="Outros">
                                <option value="Comercial">Comercial</option>
                                <option value="Rural">Rural</option>
                                <option value="Terreno">Terreno</option>
                                <option value="Vaga de Garagem">Vaga de Garagem</option>
                                </optgroup>
                        </select>
                  </div>
                    
                </div>
                <div class="form-group row">
                    <div class="col-4">
                        <label for="interesse2">Quartos</label>
                        <select name="quartos" class="form-control interForm edit_interesse_quartos" id="interesse91">
                          <option value="0">0</option>
                          <option value="1">1</option>
                          <option value="2">2</option>
                          <option value="3">3</option>
                          <option value="4">4 ou +</option>
                        </select>
                    </div>
                    <div class="col-4">
                        <label for="interesse3" class="col-form-label">Banheiros:</label>
                        <select name="banheiro" class="form-control interForm edit_interesse_banheiro" id="interesse92">
                          <option value="0">0</option>
                          <option value="1">1</option>
                          <option value="2">2</option>
                          <option value="3">3</option>
                          <option value="4">4 ou +</option>
                        </select>                                
                    </div>  
                    <div class="col-4">
                        <label for="interesse4" class="col-form-label">Vagas:</label>
                        <select name="vagas" class="form-control interForm edit_interesse_vagas" id="interesse93">
                          <option value="0">0</option>
                          <option value="1">1</option>
                          <option value="2">2</option>
                          <option value="3">3</option>
                          <option value="4">4 ou +</option>
                        </select>                                    
                    </div> 
                </div>
                <div class="form-group">
                    <label for="interesse97" class="col-form-label">Tipo de empreendimento:</label>
                    <select class="form-control interForm tipo_emp_editar_interesse" name="tipo_emp_cliente[]" multiple="multiple" id="interesse97">
                      <option value="pronto">Pronto</option>
                      <option value="lancamento">Lançamento</option>
                      <option value="Terreno">Terreno</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="interesse5" class="col-form-label">Bairro:</label>
                    <?php $bairros = HBairros::getSelect2()->items;  ?>
                    <select class="form-control interForm bairro_editar_interesse edit_interesse_bairro" name="bairro[]" multiple="multiple" id="interesse94">
                      <option value="Brasília">Brasília</option>
                      <?php
                        foreach($bairros as $b){
                            ?><option value="<?php e($b->id) ?>"><?php e($b->text) ?></option> <?php
                        }
                      ?>
                    </select>
                </div>  
                <div class="form-group">
                    <label for="interesse95" class="col-form-label">Faixa de preço:</label>
                    <div class="row">
                        <div class="col-6 d-flex align-items-center pr-2">
                            De
                            <input name="faixa_preco_inicio" type="text" class="form-control ml-2 interForm faixa_preco_anunciar_interesse edit_interesse_faixa_preco_inicio" id="interesse95">
                        </div>
                        <div class="col-6 d-flex align-items-center pl-0">
                            até
                            <input name="faixa_preco_fim" type="text" class="form-control ml-2 interForm faixa_preco_anunciar_interesse edit_interesse_faixa_preco_fim" id="interesse95">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea96">Descrição</label>
                    <textarea name="descricao" class="form-control interForm edit_interesse_descricao" style="resize: none;" id="exampleFormControlTextarea96" rows="2"></textarea>
                </div>
                <button type="button" class="btn btn-block btn-outline-success editInteresse">Salvar</button>
                
                <div class="result_edit_interesse"></div>
            </form>
        </div>
        
    </div>  
  </div>
</div>
</div>
</div>
<!-- Modal -->
<div class="modal fade" id="usuarioNovo" tabindex="-1" role="dialog" aria-labelledby="usuarioNovo" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Adicionar novo usuário</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-adicionar-usuario">
                   
                    <div class="form-group row">
                        <div class="col-6">
                              <div class="form-group">
                                <label for="exampleFormControlSelect1">Empreendimento escolhido:</label>
                                <select class="form-control novo_select_emp_add_cartao" name="emp_nome_fantasia" id="novo_emp_nome_fantasia">
                                    <option value="">Selecione</option>
                                    <?php foreach($empreendimentos as $emp) { ?>
                                        <option value="<?php e($emp->id_empreendimento) ?>"><?php e($emp->emp_nome_fantasia) ?></option>
                                    <?php } ?>
                                </select>
                              </div>
                        </div>
                        <div class="col-6 novo_result_unidades">
                            
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="nomeVIP">Nome completo:</label>
                            <input name="nome" type="text" class="form-control vipForm" id="novo_nome">
                        </div>
                        <div class="col-4">
                            <label for="cpfVIP">CPF:</label>
                            <input name="cpf" type="text" class="form-control vipForm" id="novo_cpf">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-7">
                            <label for="emailVIP">Email:</label>
                            <input name="email" type="text" class="form-control vipForm" id="novo_email">
                        </div>
                        <div class="col-5">
                            <label for="telefoneVIP">Telefone / Whatsapp:</label>
                            <input name="telefone" type="text" class="form-control vipForm" id="novo_telefone">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="origem_lead">Origem do Lead:</label>
                            <input name="origem_lead" type="text" class="form-control vipForm" id="origem_lead">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-5">
                            <label for="novo_data_nascimento" class="col-form-label">Data de nascimento:</label>
                            <input type="text" name="data_nascimento" class="form-control" id="novo_data_nascimento">
                        </div>
                        <div class="col-5">
                            <label for="novo_renda_familiar" class="col-form-label">Renda Familiar:</label>
                            <input name="renda_familiar" type="text" class="form-control vipForm" id="novo_renda_familiar">
                        </div>
                    </div>
                    <div class="form-group row ">
                        <div class="col-4">
                            <label for="novo_conjuje">Possui cônjuge?</label>
                            <div class="form-inline checkbox_novo_possui_conjuje">
                                <div class="form-check form-check-inline mr-5">
                                    <input class="form-check-input vipForm" id="inline-radio1" type="radio" value="Sim" name="possui_conjuje">
                                    <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                </div>
                                <div class="form-check form-check-inline mr-2">
                                    <input class="form-check-input vipForm novo_possui_conjuje_no" id="inline-radio2" type="radio" value="Não" name="possui_conjuje" checked="true">
                                    <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                </div>
                            </div>
                        </div>
    
                    </div>
                    <div class="form-group row" id="novo-usuario-conjuje">
                        <div class="col-8">
                            <label for="novo_nomeconj" class="col-form-label">Nome completo do cônjuge:</label>
                            <input name="nome_conjuje" type="text" class="form-control vipForm" id="novo_nomeconj">                                    
                        </div>                    
                        <div class="col-6">
                            <label for="novo_cpfconj" class="col-form-label">CPF do cônjuge:</label>
                            <input name="cpf_conjuje" type="text" class="form-control vipForm" id="novo_cpfconj">
                        </div>
                        <div class="col-6">
                            <label for="novo_telefoneconj" class="col-form-label">Telefone do cônjuge:</label>
                            <input name="telefone_conjuge" type="text" class="form-control vipForm" id="novo_telefoneconj">
                        </div> 
                    </div>
                    
                    <div class="form-group row">
                        <div class="col-4">
                            <label for="novo_vender_imovel">Deseja vender um imóvel também?</label>
                            <div class="form-inline">
                                <div class="form-check form-check-inline mr-5">
                                    <input class="form-check-input vipForm" id="inline-radio3" type="radio" value="1" name="imovel_venda">
                                    <label class="form-check-label font-weight-normal" for="inline-radio3">Sim</label>
                                </div>
                                <div class="form-check form-check-inline mr-2">
                                    <input class="form-check-input vipForm" id="inline-radio4" type="radio" value="0" name="imovel_venda" checked="true">
                                    <label class="form-check-label font-weight-normal" for="inline-radio4">Não</label>
                                </div>
                            </div>
                        </div>
    
                    </div>
                    
                                              

                   <div class="resultado_novo_usuario"></div>
                   
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-block btn-outline-success btn-adicionar-novo-usuario">Salvar</button>
              </div>
            </div>
          </div>
</div>

<!-- Modal LISTA DE LEADS WIMOVEIS --> 
<div class="modal fade" id="leads_wimoveis" tabindex="-1" role="dialog" aria-labelledby="leads_wimoveis_modal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 1200px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="leads_wimoveis_modal_label">Leads do Portal:</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
      <div class="card">
        <h5 class="card-header">Leads que enviaram mensagem no Wimóveis</h5>
        <div class="card-body" >
            <!--<div class="row">
                <div class="col-lg-12">
                    <div id="accordion" role="tablist">
                        <?php $i = 1; foreach($leads_wimoveis as $l){ ?>
                        <div class="card card-accent-info">
                            <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                <h5 class="mb-0">
                                <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                    <?php e($l['nome'] == '' ? '(Sem nome identificador)' : $l['nome']) ?> - <?php e(substr(converte_datahora($l['datetime_captura'],1),0,-11)) ?>
                                </a>
                                </h5>
                            </div>
                            <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion" style="">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label class="control-label">Título do imóvel interessado</label>
                                                <input type="text" name="titulo_wimoveis" value="<?php e($l['imovel_interesse']['titulo']); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Telefone</label>
                                                <input type="text" name="tel_wimoveis" value="<?php e($l['telefone']); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">E-mail</label>
                                                <input type="text" name="email_wimoveis" value="<?php e($l['email']); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Mensagem</label>
                                                <textarea name="observacao_wimoveis" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($l['mensagem'])); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php $i++; } ?>
                    </div>
                </div>
            </div>-->
            <table id="lista_leads_wimoveis" class="display table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Data</th>
                        <th>Imóvel Interessado</th>
                        <th>E-mail</th>
                        <th>Telefone</th>
                        <th>Mensagem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($leads_wimoveis as $l) { ?>
                    <tr class="trData" >
                      <td><?php e($l['nome'] == '' ? '(Sem nome identificador)' : $l['nome']) ?></td>
                      <td><?php e(substr(converte_datahora($l['datetime_captura'],1),0,-11)) ?></td>
                      <td><?php e($l['imovel_interesse']['titulo']); ?></td>
                      <td><?php e($l['email']); ?></td>
                      <td class="telefone_wimoveis"><?php e($l['telefone']); ?></td>
                      <td><?php e(strip_tags($l['mensagem'])); ?></td>
                      
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
       </div>  
  </div>
</div>
</div>
</div>
<!-- Modal LISTA DE LEADS VIVAREAL --> 

<div class="modal fade" id="leads_vivareal" tabindex="-1" role="dialog" aria-labelledby="leads_vivareal_modal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 1200px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="leads_vivareal_modal_label">Leads do Portal:</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
      <div class="card">
        <h5 class="card-header">Leads que enviaram mensagem no VivaReal</h5>
        <div class="card-body" >
            <!--<div class="row">
                <div class="col-lg-12">
                    <div id="accordion" role="tablist">
                        <?php $i = 1; foreach($leads_vivareal as $l){ ?>
                        <div class="card card-accent-info">
                            <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                <h5 class="mb-0">
                                <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                    <?php e($l->nome == '' ? '(Sem nome identificador)' : $l->nome) ?> - <?php e(substr(converte_datahora($l->datetime_captura,1),0,-11)) ?>
                                </a>
                                </h5>
                            </div>
                            <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion" style="">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label class="control-label">Título do imóvel interessado</label>
                                                <input type="text" name="atendente" value="<?php e($l->imovel_interesse == '' ? '' : ucwords(str_replace ("-" , " ", $l->imovel_interesse->key_anuncio))); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Telefone</label>
                                                <input type="text" name="atendente" value="<?php e($l->telefone); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">E-mail</label>
                                                <input type="text" name="atendente" value="<?php e($l->email); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Mensagem</label>
                                                <textarea name="observacao" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($l->mensagem)); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php $i++; } ?>
                    </div>
                </div>
            </div>-->
            <table id="lista_leads_vivareal" class="display table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Data</th>
                        <th>Imóvel Interessado</th>
                        <th>Telefone</th>
                        <th>E-mail</th>
                        <th>Mensagem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($leads_vivareal as $l) { ?>
                    <tr class="trData" >
                      <td><?php e($l->nome == '' ? '(Sem nome identificador)' : $l->nome) ?></td>
                      <td><?php e(substr(converte_datahora($l->datetime_captura,1),0,-11)) ?></td>
                      <td><?php e($l->imovel_interesse == '' ? '' : ucwords(str_replace ("-" , " ", $l->imovel_interesse->key_anuncio))); ?></td>
                      <td class="telefone_vivareal"><?php e($l->telefone); ?></td>
                      <td><?php e($l->email); ?></td>
                      <td><?php e(strip_tags($l->mensagem)); ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
      </div>  
  </div>
</div>
</div>
</div>

<!-- Modal LISTA DE LEADS ZAP --> 

<div class="modal fade" id="leads_zap" tabindex="-1" role="dialog" aria-labelledby="leads_zap_modal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 1200px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="leads_zap_modal_label">Leads do Portal:</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
      <div class="card">
        <h5 class="card-header">Leads que enviaram mensagem no Zap</h5>
        <div class="card-body" >
            <!--<div class="row">
                <div class="col-lg-12">
                    <div id="accordion" role="tablist">
                        <?php $i = 1; foreach($leads_zap as $l){ ?>
                        <div class="card card-accent-info">
                            <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                <h5 class="mb-0">
                                <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                    <?php e($l->nome == '' ? '(Sem nome identificador)' : $l->nome) ?> - <?php e(substr(converte_datahora($l->datetime_captura,1),0,-11)) ?>
                                </a>
                                </h5>
                            </div>
                            <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion" style="">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label class="control-label">Título do imóvel interessado</label>
                                                <input type="text" name="atendente" value="<?php e($l->imovel_interesse == '' ? '' : ucwords(str_replace ("-" , " ", $l->imovel_interesse->key_anuncio))); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Telefone</label>
                                                <input type="text" name="atendente" value="<?php e($l->telefone); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">E-mail</label>
                                                <input type="text" name="atendente" value="<?php e($l->email); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Mensagem</label>
                                                <textarea name="observacao" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($l->mensagem)); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php $i++; } ?>
                    </div>
                </div>
            </div>-->
        
            <table id="lista_leads_zap" class="display table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Data</th>
                        <th>Imóvel Interessado</th>
                        <th>Telefone</th>
                        <th>E-mail</th>
                        <th>Mensagem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($leads_zap as $l) { ?>
                    <tr class="trData" >
                      <td><?php e($l->nome == '' ? '(Sem nome identificador)' : $l->nome) ?></td>
                      <td><?php e(substr(converte_datahora($l->datetime_captura,1),0,-11)) ?></td>
                      <td><?php e($l->imovel_interesse == '' ? '' : ucwords(str_replace ("-" , " ", $l->imovel_interesse->key_anuncio))); ?></td>
                      <td class="telefone_zap"><?php e($l->telefone); ?></td>
                      <td><?php e($l->email); ?></td>
                      <td><?php e(strip_tags($l->mensagem)); ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
      </div>  
  </div>
</div>
</div>
</div>

<!-- Modal LISTA DE LEADS GRUPOZAP --> 

<div class="modal fade" id="leads_grupozap" tabindex="-1" role="dialog" aria-labelledby="leads_grupozap_modal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 1200px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="leads_grupozap_modal_label">Leads do Portal:</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
      <div class="card">
        <h5 class="card-header">Leads que enviaram mensagem no GrupoZap</h5>
        <div class="card-body" >
            <!--<div class="row">
                <div class="col-lg-12">
                    <div id="accordion" role="tablist">
                        <?php $i = 1; foreach($leads_grupozap as $l){ ?>
                        <div class="card card-accent-info">
                            <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                <h5 class="mb-0">
                                <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                    <?php e($l->nome == '' ? '(Sem nome identificador)' : $l->nome) ?> - <?php e(substr(converte_datahora($l->datetime_captura,1),0,-11)) ?>
                                </a>
                                </h5>
                            </div>
                            <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion" style="">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label class="control-label">Título do imóvel interessado</label>
                                                <input type="text" name="atendente" value="<?php e($l->imovel_interesse == '' ? '' : ucwords(str_replace ("-" , " ", $l->imovel_interesse->key_anuncio))); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Telefone</label>
                                                <input type="text" name="atendente" value="<?php e($l->telefone); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">E-mail</label>
                                                <input type="text" name="atendente" value="<?php e($l->email); ?>" class="form-control" readonly="readonly">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Mensagem</label>
                                                <textarea name="observacao" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($l->mensagem)); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php $i++; } ?>
                    </div>
                </div>
            </div>-->
        
            <table id="lista_leads_grupozap" class="display table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Data</th>
                        <th>Imóvel Interessado</th>
                        <th>Telefone</th>
                        <th>E-mail</th>
                        <th>Mensagem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($leads_grupozap as $l) { ?>
                    <tr class="trData" >
                      <td><?php e($l->nome == '' ? '(Sem nome identificador)' : $l->nome) ?></td>
                      <td><?php e(substr(converte_datahora($l->datetime_captura,1),0,-11)) ?></td>
                      <td><?php e($l->imovel_interesse == '' ? '' : ucwords(str_replace ("-" , " ", $l->imovel_interesse->key_anuncio))); ?></td>
                      <td class="telefone_grupozap"><?php e($l->telefone); ?></td>
                      <td><?php e($l->email); ?></td>
                      <td><?php e(strip_tags($l->mensagem)); ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
      </div>  
  </div>
</div>
</div>
</div>