<?php 

e($box_atendimento); 

$tabelas = [
        (object)['id_titulo' => 'novos','titulo_section' => 'Novos','atendimentos' => $atendimentosAguardando??[]],
        (object)['id_titulo' => 'retornos','titulo_section' => 'Retornos','atendimentos' => $atendimentosProximoContato??[]],
        (object)['id_titulo' => 'finalizados','titulo_section' => 'Finalizados','atendimentos' => $atendimentosFinalizados??[]],
    ]
?>

<div class="animated fadeIn">
    <div class="row">
        <div class="col-lg-12 my-5">
            <ul id="myTab" class="nav nav-tabs" role="tablist">
                <?php foreach($tabelas as $key=>$tabela){ ?>
                <li class="nav-item">
                    <a class="nav-link <?php e($key == 0?"active show":"") ?>" data-toggle="tab" href="#<?php e($tabela->id_titulo) ?>" role="tab" aria-controls="<?php e($tabela->titulo_section) ?>" aria-selected="<?php e($key == 0?"true":"false") ?>">
                        <?php e($tabela->titulo_section) ?>
                        <span class="badge badge-pill badge-danger"><?php e(count($tabela->atendimentos)) ?></span>
                    </a>
                </li>
                <?php } ?>
            </ul>
            <div class="tab-content">
                <?php foreach($tabelas as $key=>$tabela){ ?>
                <div class="tab-pane <?php e($key == 0?"active show":"") ?>" id="<?php e($tabela->id_titulo) ?>" role="tabpanel">
                    <div class="table-container table-responsive">
                        <table class="display table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Bairro imóvel</th>
                                    <th>Dono(a)</th>
                                    <th>Interessado(a)</th>
                                    <th>E-mail interessado</th>
                                    <th>Tel interessado</th>
                                    <th class="sorting_asc_custom">Data simulação</th>
                                    <th>Valor simulação</th>
                                    <th>Simulação</th>
                                    <th style="min-width: 130px;">Último atendimento</th>
                                    <th style="min-width: 130px;">Proximo atendimento</th>
                                    <th style="min-width: 130px;" class="hiden-filter">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($tabela->atendimentos as $row) { $id = $row->id_simulacao; ?>
                                <tr id="divImovel_<?php e($id) ?>" class="trData" data-atendimento='<?php e(json_encode($row->atendimento)) ?>'>
                                    <td><?php e($row->imovel->bairro??$row->bairro); ?></td>
                                    <td><?php e($row->dono->nome??''); ?></td>
                                    <td><?php e($row->interessado->nome); ?></td>
                                    <td><?php e($row->interessado->email); ?></td>
                                    <td><?php e($row->interessado->telefone); ?></td>
                                    <?php 
                                        $nenv = '<span class="d-none">000000000</span>'.'<span class="badge badge-danger">Não enviado</span>'; 
                                        $denv = '<span class="d-none">'.$row->data_simulacao.'</span>'.(date("d/m/Y H:i:s", strtotime($row->data_simulacao)));
                                    ?>
                                    <td><?php e($row->data_simulacao == 0 ? $nenv:$denv); ?></td>
                                    <td><?php e(money($row->val_total)); ?></td>
                                    <td><?php e($row->step >= 4 ? '<span class="badge badge-success">Completo</span>':'<span class="badge badge-warning">Incompleto</span>'); ?></td>
                                    
                                    <td><p class="resumo-text m-0"><?php e(end($row->atendimento)->observacao??''); ?></p></td>
                                   
                                    <td>
                                        <?php 
                                        $proximo_contato = end($row->atendimento)->proximo_contato??'';
                                        if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00'){
                                             $proximo_contato = '';
                                             $alert = '<span class="d-none">z'.$proximo_contato.'</span>';
                                        }else{
                                            $alert = '<span class="d-none">a'.$proximo_contato.'</span>'.
                                                     '<span class="badge badge-danger">'.date("d/m/Y", strtotime($proximo_contato)).'</span>';
                                        }
                                        $normal = '<span class="d-none">b'.$proximo_contato.'</span>'.(date("d/m/Y", strtotime($proximo_contato)));
                                        
                                        e($proximo_contato <= date("Y-m-d 23:59:59") ? $alert:$normal);
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                            foreach ($row->actions??[] as $action){
                                                e($action);
                                            } 
                                        ?>
                                        <button class="btn btn-sm btn-primary set_leed" data-id="<?php e($id); ?>" data-toggle="modal" data-target="#atendimentoRapidoModal" data-toggle="tooltip" data-original-title="Atendimento rápido">
                                        <i class="icon-plus"></i>
                                        </button>
                                        
                                        <button class="btn btn-sm btn-outline-success mr-1 addAtendimentoComdono set_leed" data-id="<?php e($id); ?>" data-toggle="tooltip" data-original-title="Atendimento completo">
                                            <i class="icon-check"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>



<!--        ACTIONS ANTIGOS         -->

<!--<td class="tdAction_<?php e($id) ?>" >
    <span class='d-none'><?php e(empty($row->atendimento) ? 0 : 1); ?></span>
    <?php if($this->session->perfil != '7'){ ?>
    <a href="<?php e(base_url()); ?>administrativo/usuarios/perfil/<?php e($row->interessado->id_cadastro??0)?>/0" target="_blank" class="btn btn-secondary mb-1" data-toggle="tooltip" data-original-title="Visualizar perfil">
            <i class="icon-user"></i> 
    </a>
    <?php } ?>
    <?php if((isset($row->step) && $row->step >= 4)){ ?>
    <a href="<?php e(base_url()); ?>administrativo/financiamentos/bancos/<?php e($row->id_simulacao)?>/0" target="_blank" class="btn btn-secondary mb-1" data-interesse="financiamento-imovel" data-atendimento='' data-toggle="tooltip" data-original-title="Visualizar financiamento">
        <i class="fa fa fa-credit-card"></i>
    </a>
    <?php } else{ ?>
    <a href="javascript:;" class="btn btn-danger mb-1" data-toggle="tooltip" data-original-title="Simulação inválida">
        <i class="fa fa fa-credit-card"></i>
    </a>
    <?php } ?>
    <?php if($this->session->perfil != '7'){ ?>
        <?php if(!empty($row->atendimento)){ ?>
        <a href="<?php e(base_url().'administrativo/atendimento/atendimento_geral/financiamento/'.$row->atendimento[0]->id_atendimento); ?>" class="actAtendimento btn btn-success mb-1" data-id="<?php e($id); ?>" data-toggle="tooltip" data-original-title="Visualizar atendimento">
            <i class="icon-check"></i>
        </a>
        <?php }else{ ?>
        <a href="javascript:;" class="addAtendimentoGeral btn btn-primary mb-1" data-interesse="financiamento" data-atendimento='<?php e(json_encode($row->data_atendimento)) ?>' data-toggle="tooltip" data-original-title="Adicionar atendimento">
            <i class="icon-plus"></i>
        </a>
        <?php } ?>
    <?php } ?>
</td>-->