<?php 
    e($box_atendimento); 
    
    $tabelas = [
        (object)['id_titulo' => 'novos','titulo_section' => 'Novos','atendimentos' => $atendimentosAguardando??[]],
        (object)['id_titulo' => 'retornos','titulo_section' => 'Retornos','atendimentos' => $atendimentosProximoContato??[]],
        (object)['id_titulo' => 'finalizados','titulo_section' => 'Finalizados','atendimentos' => $atendimentosFinalizados??[]],
    ]
?>

<div class="animated fadeIn">
    <div class="row">
        <div class="col-lg-12 my-5">
            <ul class="nav nav-tabs" role="tablist">
                <?php foreach($tabelas as $key=>$tabela){ ?>
                <li class="nav-item">
                    <a class="nav-link <?php e($key == 0?"active show":"") ?>" data-toggle="tab" href="#<?php e($tabela->id_titulo) ?>" role="tab" aria-controls="<?php e($tabela->titulo_section) ?>" aria-selected="<?php e($key == 0?"true":"false") ?>">
                        <?php e($tabela->titulo_section) ?>
                        <span class="badge badge-pill badge-danger"><?php e(count($tabela->atendimentos)) ?></span>
                    </a>
                </li>
                <?php } ?>
            </ul>
            <div class="tab-content">
                
                <?php foreach($tabelas as $key=>$tabela){ ?>
                
                <div class="tab-pane <?php e($key == 0?"active show":"") ?>" id="<?php e($tabela->id_titulo) ?>" role="tabpanel">
                    <div class="table-container table-responsive">
                        <table class="display table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Id cadastro</th>
                                    <th style="min-width: 130px;">Nome</th>
                                    <th style="min-width: 130px;">E-mail</th>
                                    <th style="min-width: 85px;">Telefone</th>
                                    <th class="sorting_asc_custom sorting_desc">Data de nascimento</th>
                                    <th>Imóveis</th>
                                    <th style="min-width: 130px;">Último atendimento</th>
                                    <th style="min-width: 130px;">Proximo atendimento</th>
                                    <th style="min-width: 115px; width: 115px;">Ação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($tabela->atendimentos as $id=>$row) { ?>
                                
                                
                                <tr id="divImovel_<?php e($id) ?>" class="trData" data-atendimento='<?php e(json_encode($row->atendimento)) ?>'>
                                    <td><?php e($row->id_cadastro); ?></td>
                                    <td><?php e($row->nome); ?></td>
                                    <td><?php e($row->email); ?></td>
                                    <td><?php e($row->telefone); ?></td>
                                    <td><?php e($row->data_nascimento); ?></td>
                                    <td>
                                        <a href="<?php e(base_url().'administrativo/dashboard/imovel/'.$row->id_imovel); ?>" target="_blank">
                                            Imóvel <?php e($row->id_imovel); ?>
                                        </a>    
                                    </td>
                                    
                                    <td><p class="resumo-text m-0"><?php e(end($row->atendimento)->observacao??''); ?></p></td>
                                    <?php 
                                        $proximo_contato = end($row->atendimento)->proximo_contato??'';
                                        if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00'){
                                             $proximo_contato = '';
                                             $alert = '<span class="d-none">z'.$proximo_contato.'</span>';
                                        }else{
                                            $alert = '<span class="d-none">a'.$proximo_contato.'</span>'.
                                                     '<span class="badge badge-danger">'.date("d/m/Y", strtotime($proximo_contato)).'</span>';
                                        }
                                        $normal = '<span class="d-none">b'.$proximo_contato.'</span>'.(date("d/m/Y", strtotime($proximo_contato)));
                                    ?>
                                    <td>
                                        <?php 
                                        $proximo_contato = end($row->atendimento)->proximo_contato??'';
                                        if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00'){
                                             $proximo_contato = '';
                                             $alert = '<span class="d-none">z'.$proximo_contato.'</span>';
                                        }else{
                                            $alert = '<span class="d-none">a'.$proximo_contato.'</span>'.
                                                     '<span class="badge badge-danger">'.date("d/m/Y", strtotime($proximo_contato)).'</span>';
                                        }
                                        $normal = '<span class="d-none">b'.$proximo_contato.'</span>'.(date("d/m/Y", strtotime($proximo_contato)));
                                        
                                        e($proximo_contato <= date("Y-m-d H:i:s") ? $alert:$normal);
                                        ?>
                                    </td>
                                   
                                    <td class="tdAction_<?php e($id) ?>" >
                                        
                                        <button class="btn btn-sm btn-primary set_leed" data-id="<?php e($row->id_imovel); ?>" data-toggle="modal" data-target="#atendimentoRapidoModal" data-toggle="tooltip" data-original-title="Atendimento rápido">
                                            <i class="icon-plus"></i>
                                        </button>
                                        
                                        <button class="btn btn-sm btn-outline-success mr-1 addAtendimentoComdono set_leed" data-id="<?php e($row->id_imovel); ?>" data-toggle="tooltip" data-original-title="Atendimento completo">
                                            <i class="icon-check"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- ACTION USER 

<a href="<?php e(base_url()); ?>administrativo/usuarios/perfil/<?php e($anunciante->id_cadastro??0)?>/<?php e($anunciante->id_captura??0)?>" target="_blank" class="btn btn-sm btn-secondary mr-1" data-toggle="tooltip" data-original-title="Visualizar perfil">
    <i class="icon-user"></i> 
</a>-->