<div class="card bg-light">
    <div class="card-header">
        <div class="d-flex justify-content-between">
            <h4>Dados de interesse</h4>
        </div>
    </div>
    <div class="card-body">
        <!-- Atendimento -->
        <div class="row">
            <div class="col-lg-5">
                <!--Dados do lead-->
                <div class="card">
                    <div class="card-body">
                        <!--Dados-->
                        <div class="d-flex text-muted mb-4">
                            <img src="https://cdn.pixabay.com/photo/2016/08/08/09/17/avatar-1577909_1280.png" class="rounded img-fluid" style="width: 85px; height: 85px; object-fit: cover;" alt="...">
                            <div class="ml-3">
                                <div>
                                    <b>Nome:</b> <?php e($captura->nome) ?>
                                </div>
                                <div>
                                    <b>Email:</b> <?php e($captura->email) ?>
                                </div>
                                <div>
                                    <b>Telefone:</b> <?php e($captura->telefone) ?>
                                </div>
                            </div>
                        </div>
                        <!--Cartão VIP-->
                        <div class="card bg-light text-muted">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <span>Dados do interesse: </span>
                                </div>
                            </div>
                            <div class="card-body">
                                <ul class="list-unstyled mb-0">
                                  <li><b>Interesse em:</b> <?php e($interesse->tipo_interesse) ?></li>
                                  <li><b>Tipo de imovel:</b> <?php e($interesse->tipo_imovel) ?></li>
                                  <li><b>Faixa de Preço:</b> <?php e(money($interesse->faixa_preco_inicio)) ?> a <?php e(money($interesse->faixa_preco_fim)) ?></li>
                                  <li><b>Momento:</b> <?php e($interesse->momento_interesse) ?></li>
                                  <li><b>Bairros:</b> 
                                  <?php foreach($interesse_bairros as $bairro){ ?><span class="badge badge-secondary"><?php echo $bairro->bairro; ?></span> <?php } ?></li>
                                  <li><b>Vagas:</b> <?php e($interesse->vagas) ?></li>
                                  <li><b>Quartos:</b> <?php e($interesse->quartos) ?></li>
                                  <li><b>Banheiros:</b> <?php e($interesse->banheiro) ?></li>
                                  <li><b>Descrição:</b> <?php e($interesse->descricao) ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-7">
                
                <!--Informações de Atendimento do Lead-->
                <div class="card">
                    <div class="card-header">
                        <h5>Sugestões de imóveis</h5>
                        <p>Foram encontrados <?php e(count($imoveis)); ?> imoveis</p>
                        <div class="float-right">
                            <label for="checkbox_sugestoes_imoveis_todos">Selecionar Todos</label>
                            <input type="checkbox" class="checkbox_sugestoes_imoveis_todos" >
                        </div>
                    </div>
                    <div class="card-body text-muted" style="overflow-y: auto; max-height: 400px;">
                        
                        <?php $cont=0; foreach($imoveis as $im){ ?>
                        <div class="card mb-3 card-scroll ">
                            <form class="form-sugestoes-anunciar-interesse">
                                <div class="row no-gutters">
                                    <div class="col-md-4">
                                        <div class="profile" style="max-height: 300px;">
                                            <a href="<?php e($im->lancamento == 'Sim'?base_url("lancamento/").$im->id_imovel."/".$im->key_anuncio:base_url("imovel/").$im->id_imovel."/".$im->key_anuncio) ?>" target="_blank">
                                                <img src="<?php e($im->foto)?>" style="height: 150px; width: 100%; object-fit: cover;" alt="...">                                            
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                          <div class="card-body">
                                            <input type="checkbox" name="checkbox_sugestao<?php e($cont) ?>" class="float-right checkbox_sugestoes_imoveis" aria-label="Checkbox for following text input">
                                            <a href="<?php e($im->lancamento == 'Sim'?base_url("lancamento/").$im->id_imovel."/".$im->key_anuncio:base_url("imovel/").$im->id_imovel."/".$im->key_anuncio) ?>" target="_blank">
                                                <h6 class="card-title1 mb-1 text-primary"><?php e(ucwords(str_replace ("-" , " ", $im->key_anuncio))) ?></h6>
                                            </a>
                                            <p class="card-text mb-1"><?php e($im->endereco) ?><br><?php e($im->bairro) ?>, <?php e($im->cidade) ?> - <?php e($im->estado) ?></p>
                                            <p class="card-text mb-1 text-primary"><?php e($im->val_pretendido) ?></p>
                                            <p class="card-text"><small class="text-muted"><?php e($im->quartos) ?> Quarto(s) | <?php e($im->banheiros) ?> Banheiro(s) | <?php e($im->vaga) ?> Vaga(s)</small></p>
                                          </div>
                                    </div>
                                    
                                        <input type="hidden" name="qtd_sugestoes" value="<?php e($cont) ?>">
                                        <input type="hidden" name="id_imovel<?php e($cont) ?>" value="<?php e($im->id_imovel) ?>">
                                        <input type="hidden" name="tipo_empreendimento<?php e($cont) ?>" value="<?php e($im->tipo_empreendimento) ?>">
                                        <input type="hidden" name="lancamento<?php e($cont) ?>" value="<?php e($im->lancamento) ?>">
                                        <input type="hidden" name="foto<?php e($cont) ?>" value="<?php e($im->foto) ?>">
                                        <input type="hidden" name="key_anuncio<?php e($cont) ?>" value="<?php e(ucwords(str_replace ("-" , " ", $im->key_anuncio))) ?>">
                                        <input type="hidden" name="endereco<?php e($cont) ?>" value="<?php e($im->endereco) ?>">
                                        <input type="hidden" name="bairro<?php e($cont) ?>" value="<?php e($im->bairro) ?>">
                                        <input type="hidden" name="cidade<?php e($cont) ?>" value="<?php e($im->cidade) ?>">
                                        <input type="hidden" name="estado<?php e($cont) ?>" value="<?php e($im->estado) ?>">
                                        <input type="hidden" name="quartos<?php e($cont) ?>" value="<?php e($im->quartos) ?>">
                                        <input type="hidden" name="banheiros<?php e($cont) ?>" value="<?php e($im->banheiros) ?>">
                                        <input type="hidden" name="vaga<?php e($cont) ?>" value="<?php e($im->vaga) ?>">
                                
                                </div>
                            </form>
                        </div>
                        <?php $cont++;} ?>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn-block btn-success btn-enviar-whats-anunciar-interesse" type="button" data-telefone="<?php e($captura->telefone); ?>" data-toggle="tooltip" data-placement="top" title="Contactar a TI para Liberar a Função">Enviar whatsapp</button>
                        <button class="btn btn-block btn-primary btn-envia-email-sugestao" type="button" data-email="<?php e($captura->email); ?>">Enviar E-mail</button>
                    </div>
                        
                    <div class="result_envia_whats_interesse"></div>
                </div>
            </div>
        </div>
    </div>
</div>