<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Ajuda extends Builder_Controller {
	function __construct()
	{
		parent::__construct();
		
		Assets::add_module_js('comdono', array(
            'ajuda',
            'contato'
        ));
        
		$this->load->model('site_model');
	}
	
	public function index()
    {
        $idPergUri = $this->uri->segment(2);
        $key_uri = $this->uri->segment(3);
        
        if(base_url() == "https://dev.comdono.com/" && $idPergUri == 39)
            redirect("https://comdono.com/ajuda/39/termos-de-uso-e-relacionamento");
           
        
        $categorias = $this->site_model->get_faqs();
        $resposta = $this->site_model->get_resposta($idPergUri);
        
        if($resposta !== null){
            
            //var_dump($resposta);
            
            $titulo =  trim(str_replace(['<p><meta charset="utf-8" />','</p>'], '', $resposta->pergunta) );
            $key = convertAccentsAndSpecialToNormal(strtolower($titulo));
            
            if($key_uri == null){
               
                redirect('ajuda/'.$resposta->id_perg.'/'.$key);
            }
            
            if($key != $key_uri)        redirect('ajuda/'.$resposta->id_perg.'/'.$key);
            
            
            foreach($categorias  as $idCat=>$cat)
            {
                $categorias[$idCat]->expanded = false;
                foreach($cat->perguntas as $idPerg=>$perg)
                {
                    $categorias[$idCat]->perguntas[$idPerg]->active = false;
                    if($perg->id_perg == $idPergUri){
                        $categorias[$idCat]->expanded = "true";
                        $categorias[$idCat]->perguntas[$idPerg]->active = true;
                    }
                }
            }
        }
        else{
            $ic = 0;
            $ip = 0;
            foreach($categorias  as $idCat=>$cat)
            {
                $cat->expanded = false;
                if($ic == 0)
                    $cat->expanded = "true";
                
                //dd($cat);
                foreach($cat->perguntas as $idPerg=>$perg)
                {
                    $perg->active = false;
                    if($ip == 0)
                        $perg->active = true;
                    $ip++;
                }
                $ic++;
            }
        }
        
        $data['faqs'] = $categorias;
        
        Template::set_modal($data,[
            'comdono/modal/contato_view'
        ]);
        
        Template::set($data);
        Template::set_view('ajuda_view');
        Template::render();
    }
    
    public function termos()
    {
        $data["termos"] = true;
        Template::set($data);
        Template::set_view('doc_page_view');
        Template::render();
    }
    
    public function politica()
    {
        $data["politica"] = true;
        Template::set($data);
        Template::set_view('doc_page_view');
        Template::render();
    }
    
}