<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Design_system extends Builder_Controller {
	function __construct()
	{
		parent::__construct();
		
		Assets::add_module_js('comdono', array(
            'ajuda',
        ));
        
		$this->load->model('site_model');
	}
	
	public function index()
    {
        Assets::add_css(array(
            'plugins/lolight-1.4.0/lolight'
        ));
        
        Assets::add_js(array(
            'plugins/lolight-1.4.0/lolight.min'
        ));
        
        $idConteudoUri = $this->uri->segment(2);
        $key_uri = $this->uri->segment(3);
        
        $categorias = $this->site_model->get_conteudos();
        $conteudo = $this->site_model->get_conteudo($idConteudoUri);
        if($categorias == null)
            redirect()->to(base_url());
        
        if($conteudo !== null){
            $titulo =  trim(str_replace(['<p><meta charset="utf-8" />','</p>'], '', $conteudo->titulo) );
            $key = convertAccentsAndSpecialToNormal(strtolower($titulo));
            
            if($key_uri == null || $key != $key_uri)
                redirect('design_system/'.$conteudo->id_conteudo.'/'.$key);
            
            foreach($categorias  as $idCat=>$cat)
            {
                $categorias[$idCat]->expanded = false;
                foreach($cat->conteudos as $idConteudo=>$cont)
                {
                    $categorias[$idCat]->conteudos[$idConteudo]->active = false;
                    if($cont->id_conteudo == $idConteudoUri){
                        $categorias[$idCat]->expanded = "true";
                        $categorias[$idCat]->conteudos[$idConteudo]->active = true;
                    }
                }
            }
        }
        else{
            $ic = 0;
            $ip = 0;
            
            foreach($categorias  as $idCat=>$cat)
            {
                $cat->expanded = false;
                if($ic == 0)
                    $cat->expanded = "true";
                    
                foreach($cat->conteudos as $idConteudo=>$cont)
                {
                    $cont->codigo_fonte = str_replace('<','&lt;',str_replace('>','&gt;',$cont->codigo));
                    
                    $cont->active = false;
                    if($ip == 0)
                        $cont->active = true;
                    $ip++;
                }
                $ic++;
            }
        }
        
        $data['conteudos'] = $categorias;
       
        
        
        Template::set($data);
        Template::set_view('design_system_view');
        Template::render();
    }
    
}