<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


//require_once(APPPATH.'modules/comdono/controllers/Facebook.php');

class Login extends Builder_Controller {

	function __construct()
	{
	    parent::__construct();
	    
	    Assets::add_css(array(
            'plugins/cb-slideshow/css/style1',
            //'css/style'
        ));
        
        Assets::add_js(array(
            'plugins/cb-slideshow/js/modernizr'
        ));
	}
	
	public function index()
    {
        Template::unset(['topnav','footer']);
        
        $this->session->set_userdata('login_redirect', $this->get_http_referer());
        
        if($this->tank_auth->is_logged_in())
            redirect();
        
        Assets::add_module_css('comdono', array(
            'login'
        ));
        Assets::add_module_js('comdono', array(
            'login'
        ));
        
        $data['email_anunciar'] = $this->session->flashdata('email_anunciar');
        $data["page"] = 2;
        
        $data['url'] = $this->loginUrl();
        
        $referer_login = $this->refRedirect();
        $this->session->set_userdata('referer_login', $referer_login);
        
        
        
        $data['gcaptcha'] = $this->session->gcaptcha;
        $data['public_key'] = $this->db->where('name','captcha_public_key')->get('sys_config')->row()->value;
        
        Template::load_view('login_view', $data, '', '', $data['view']);
        
        Template::set($data);
        Template::set_view('modern_view');
        Template::render();
    }
    
    public function recuperar_senha()
    {
        Template::unset(['topnav','footer']);
        
        $this->session->set_userdata('login_redirect', $this->get_http_referer());
        
        if($this->tank_auth->is_logged_in())
            redirect();
        
        $data['troca_senha'] = $troca_senha = $this->session->userdata('troca_senha');
        
        Assets::add_module_css('comdono', array(
            'login'
        ));
        Assets::add_module_js('comdono', array(
            'login',
            'forca_senha'
        ));
        
        $data["page"] = 2;
        
        Template::load_view('recuperar_senha_view', $data, '', '', $data['view']);
        
        Template::set($data);
        Template::set_view('modern_view');
        Template::render();
    }
    
    public function nova_senha()
    {
        Template::unset(['topnav','footer']);
        
        $this->session->set_userdata('login_redirect', $this->get_http_referer());
        
        if($this->tank_auth->is_logged_in())
            redirect();
        
        $data['page'] = $data['troca_senha'] == NULL ? 3 : 4;
        
        Assets::add_module_css('comdono', array(
            'login'
        ));
        Assets::add_module_js('comdono', array(
            'login'
        ));
        
        Template::set($data);
        Template::set_view('home_view');
        Template::render();
    }
    
    public function new_password() 
    { 
        $key_concat = $this->uri->segment(4);
        $this->load->model('sistema/usuario_model');
        $user = $this->usuario_model->get_user_by_key($key_concat);

        if ($user !== NULL) 
        {
            $this->load->library('session');
            $this->session->set_userdata('troca_senha', $user);
            $this->session->mark_as_temp('troca_senha', 300);
            //$this->session->set_flashdata('modal_troca_senha', $user);
            //$this->session->set_flashdata('key_concat', $key_concat);
        }
        redirect(base_url('recuperar-senha'));
    }
    
    public function logout()
	{
	    $dev_admin = $this->session->dev_admin;
	    
	    // $this->load->library('tank_auth');
        $this->delete_autologin();

		// See http://codeigniter.com/forums/viewreply/662369/ as the reason for the next line
		$this->session->set_userdata(array('user_id' => '', 'username' => '', 'status' => ''));

		$this->session->sess_destroy();
		
		if($dev_admin == true){
            redirect('sistema/session/admin');
        }
		
		if(isset($_SERVER["HTTP_REFERER"]))
        {
            $referer = $_SERVER["HTTP_REFERER"];
            $pos = strpos($referer, base_url());
            if (!$pos) {
                redirect($referer);
            }
        }
        redirect();    
	}
	
	private function delete_autologin()
	{
		$this->load->helper('cookie');
		if ($cookie = get_cookie($this->config->item('autologin_cookie_name', 'tank_auth'), TRUE)) {

			$data = unserialize($cookie);

			$this->load->model('auth/user_autologin');
			$this->user_autologin->delete($data['user_id'], md5($data['key']));

			delete_cookie($this->config->item('autologin_cookie_name', 'tank_auth'));
		}
	}
    
}